/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.exstorage.path;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.exstorage.SJctrExsSummaryModel;
import sanproject.sn2.controller.topwindow.exstorage.path.SJctrExsExtPathsActionMenuModel;
import sanproject.sn2.controller.topwindow.exstorage.path.SJctrExsExtPathsTableModel;
import sanproject.sn2.controller.wizard.uvm.discnctextpaths.SJctrDiscnctExtPathsSubWizard;
import sanproject.sn2.controller.wizard.uvm.discnctextpaths.SJctrDisconnectExtiSCSIPathsSubWizard;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrEditExtWwnsSubWizard;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrEditExtiSCSITargetSubWizard;
import sanproject.sn2.controller.wizard.uvm.editpolicy.SJctrEditPolicyDC;
import sanproject.sn2.controller.wizard.uvm.editpolicy.SJctrExdPolicyData;
import sanproject.sn2.controller.wizard.uvm.recnctextpaths.SJctrRecnctExtPathsSubWizard;
import sanproject.sn2.controller.wizard.uvm.recnctextpaths.SJctrRecnctExtiSCSIPathsSubWizard;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;

public class SJctrExsExtPathsDC
extends SJctrDataController {
    public static final int DISP_ID = 4098;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    public SJctrExdPolicyData policyData = null;

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrExsSummaryModel());
        SJctrExsExtPathsTableModel tableModel = new SJctrExsExtPathsTableModel();
        this.addDataObjectModel(KEY_TABLE, tableModel);
        this.addDataObjectModel(KEY_ACTION_MENU, new SJctrExsExtPathsActionMenuModel());
    }

    public SJctrExsExtPathsDC() throws SJcException {
        super(4098);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public void construct() throws SJcException {
        if (this.policyData == null) {
            this.policyData = new SJctrExdPolicyData(this.getOwner());
        }
        super.construct();
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPathGroupInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdVolumeInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initListener() {
        this.addMessageEventListener(EXT_PATHS_NOTIFY_STATE.MAKE_DISCONNECTEXTPATH, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrExsExtPathsDC.this.makeDisconnectPaths(event, dstModel);
            }
        });
        this.addMessageEventListener(EXT_PATHS_NOTIFY_STATE.MAKE_RECONNECTEXTPATH, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrExsExtPathsDC.this.makeReconnectPaths(event, dstModel);
            }
        });
        this.addMessageEventListener(EXT_PATHS_NOTIFY_STATE.MAKE_EDIT_EXT_WWNS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrExsExtPathsDC.this.makeEditExtWwns(event, dstModel);
            }
        });
        this.addMessageEventListener(EXT_PATHS_NOTIFY_STATE.MAKE_EDIT_EXT_ISCSITARGETS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrExsExtPathsDC.this.makeEditExtiSCSITargets(event, dstModel);
            }
        });
        this.addMessageEventListener(EXT_PATHS_NOTIFY_STATE.MAKE_EDIT_POLICY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrExsExtPathsDC.this.makeEditPolicy(event, dstModel);
            }
        });
    }

    private void makeDisconnectPaths(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRelatedDispDataObject wizardRelated;
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        this.getLogUty().putlog("makeDisconnectPaths", "Selected row = " + selectedRowList.size());
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeDisconnectPaths", "not selected");
            return;
        }
        HashMap param = new HashMap();
        param.put(SJctrDiscnctExtPathsSubWizard.DISCNCT_EXT_PATHS_DATA, selectedRowList);
        List<SJmoPortDetail> portDtlList = this.getModelData(SJmoGetPortDetail.class);
        boolean hasFibre = false;
        boolean hasiSCSI = false;
        for (Object selRow : selectedRowList) {
            SJmoExdPhysicalPathInfo phsicalPathInfo = (SJmoExdPhysicalPathInfo)selRow;
            SJmoPortDetail portDtl = SJctrExtUtility.getPortDtlFromPhysicalPathInfo(phsicalPathInfo, portDtlList);
            boolean isiSCSI = SJctrPortUtility.isIscsiPort(portDtl);
            hasFibre |= !isiSCSI;
            hasiSCSI |= isiSCSI;
        }
        if (hasFibre && hasiSCSI) {
            SJctrError err = new SJctrError(6, 22, 205149);
            SJcException exp = err.createException();
            throw exp;
        }
        if (hasFibre) {
            wizardRelated = this.createWizard(SJctrDiscnctExtPathsSubWizard.class, param);
        } else if (hasiSCSI) {
            wizardRelated = this.createWizard(SJctrDisconnectExtiSCSIPathsSubWizard.class, param);
        } else {
            return;
        }
        this.addUpdateDisp(wizardRelated);
    }

    private void makeReconnectPaths(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRelatedDispDataObject wizardRelated;
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        this.getLogUty().putlog("makeReconnectPaths", "Selected row = " + selectedRowList.size());
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeReconnectPaths", "not selected");
            return;
        }
        HashMap param = new HashMap();
        param.put(SJctrRecnctExtPathsSubWizard.RECNCT_EXT_PATHS_DATA, selectedRowList);
        List<SJmoPortDetail> portDtlList = this.getModelData(SJmoGetPortDetail.class);
        boolean hasFibre = false;
        boolean hasiSCSI = false;
        for (Object selRow : selectedRowList) {
            SJmoExdPhysicalPathInfo phsicalPathInfo = (SJmoExdPhysicalPathInfo)selRow;
            SJmoPortDetail portDtl = SJctrExtUtility.getPortDtlFromPhysicalPathInfo(phsicalPathInfo, portDtlList);
            boolean isiSCSI = SJctrPortUtility.isIscsiPort(portDtl);
            hasFibre |= !isiSCSI;
            hasiSCSI |= isiSCSI;
        }
        if (hasFibre && hasiSCSI) {
            SJctrError err = new SJctrError(6, 22, 205149);
            SJcException exp = err.createException();
            throw exp;
        }
        if (hasFibre) {
            wizardRelated = this.createWizard(SJctrRecnctExtPathsSubWizard.class, param);
        } else if (hasiSCSI) {
            wizardRelated = this.createWizard(SJctrRecnctExtiSCSIPathsSubWizard.class, param);
        } else {
            return;
        }
        this.addUpdateDisp(wizardRelated);
    }

    private void makeEditExtWwns(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        this.getLogUty().putlog("makeEditExtWwns", "Selected row = " + selectedRowList.size());
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeEditExtWwns", "not selected");
            return;
        }
        HashMap param = new HashMap();
        param.put(SJctrEditExtWwnsSubWizard.EDIT_EXT_WWNS_DATA, selectedRowList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrEditExtWwnsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeEditExtiSCSITargets(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        this.getLogUty().putlog("makeEditExtiSCSITargets", "Selected row = " + selectedRowList.size());
        if (selectedRowList.isEmpty()) {
            this.getLogUty().putlog("makeEditExtiSCSITargets", "not selected");
            return;
        }
        HashMap param = new HashMap();
        param.put(SJctrEditExtWwnsSubWizard.EDIT_EXT_WWNS_DATA, selectedRowList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrEditExtiSCSITargetSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeEditPolicy(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRelatedDispDataObject relatedDisp = this.createDialog(SJctrEditPolicyDC.class, null);
        this.addUpdateDisp(relatedDisp);
    }

    public static enum EXT_PATHS_NOTIFY_STATE implements SJctrNotifyState
    {
        MAKE_DISCONNECTEXTPATH,
        MAKE_RECONNECTEXTPATH,
        MAKE_EDIT_EXT_WWNS,
        MAKE_EDIT_EXT_ISCSITARGETS,
        MAKE_EDIT_POLICY;

    }
}

