/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrPortSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_UNI_PT_NUM = "COM_UNIV_PT_NUM";
    public static final String KEY_TGT_PT_NUM = "COM_TGT_PT_NUM";
    public static final String KEY_RCTGT_PT_NUM = "COM_RCTGT_PT_NUM";
    public static final String KEY_EXT_PT_NUM = "COM_EXT_PT_NUM";
    public static final String KEY_INT_PT_NUM = "COM_INT_PT_NUM";
    public static final String KEY_TOTAL_PT_NUM = "COM_TOTAL_PT_NUM";

    @Override
    public void makeDataObject() {
        boolean rsgFlg;
        short sPort;
        int portIndex;
        boolean rsgHgFlg;
        List<?> rsgDetailList;
        List<SJmoGetPortAttributeInfo> portSummary = this.getBasicDataList(SJmoGetPortAttributeInfo.class);
        SJctrDataController dc = this.getDataController();
        SJctrUserController uc = dc.getOwner();
        List<?> ptHgInfoList = dc.getModelData(SJmoGetPortHostGroupInfo.class);
        List<?> ptItInfoList = dc.getModelData(SJmoGetPortIscsiTargetInfo.class);
        boolean FibreFlg = false;
        boolean IscsiFlg = false;
        if (ptHgInfoList != null) {
            FibreFlg = true;
        }
        if (ptItInfoList != null) {
            IscsiFlg = true;
        }
        if ((rsgDetailList = dc.getModelData(SJmoGetRSGgetAllRsgs.class)) == null) {
            return;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJctrPortUtility portUtil = this.getComUtility().getPortUtility();
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        ArrayList<SJmoPortAttributeInfo> rsgPortSummary = new ArrayList<SJmoPortAttributeInfo>(SJctrPortUtility.PORT_MAX);
        for (SJmoPortAttributeInfo sJmoPortAttributeInfo : portSummary) {
            int rsgId;
            rsgHgFlg = false;
            portIndex = Collections.binarySearch(ptHgInfoList, (Object)sJmoPortAttributeInfo);
            if (portIndex < 0) continue;
            SJmoPortHostGroupInfo ptHgInfo = (SJmoPortHostGroupInfo)ptHgInfoList.get(portIndex);
            sPort = ptHgInfo.getSPort();
            hgIndex.setSPort(sPort);
            for (short hgindex = 0; hgindex < SJctrPortUtility.PORT_HOSTGROUP_MAX; hgindex = (short)(hgindex + 1)) {
                hgIndex.setSHostGroup(hgindex);
                rsgHgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                if (rsgHgFlg) break;
            }
            if (!rsgHgFlg && !(rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId = rsgUtil.getRsgId(sJmoPortAttributeInfo), rsgUtil))) continue;
            rsgPortSummary.add(sJmoPortAttributeInfo);
        }
        if (IscsiFlg) {
            for (SJmoPortAttributeInfo sJmoPortAttributeInfo : portSummary) {
                int rsgId;
                rsgHgFlg = false;
                portIndex = Collections.binarySearch(ptItInfoList, (Object)sJmoPortAttributeInfo);
                if (portIndex < 0) continue;
                SJmoPortIscsiTargetInfo ptItInfo = (SJmoPortIscsiTargetInfo)ptItInfoList.get(portIndex);
                sPort = ptItInfo.getSPort();
                hgIndex.setSPort(sPort);
                for (short itindex = 0; itindex < SJctrPortUtility.PORT_ISCSITARGET_MAX; itindex = (short)(itindex + 1)) {
                    hgIndex.setSHostGroup(itindex);
                    rsgHgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                    if (rsgHgFlg) break;
                }
                if (!rsgHgFlg && !(rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId = rsgUtil.getRsgId(sJmoPortAttributeInfo), rsgUtil))) continue;
                rsgPortSummary.add(sJmoPortAttributeInfo);
            }
        }
        this.makeSummary(rsgPortSummary);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetPortAttributeInfo kind = new SJmoGetPortAttributeInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    protected void makeSummary(List<?> portSummary) {
        int uni_pt = 0;
        int tgt_pt = 0;
        int rctgt_pt = 0;
        int inte_pt = 0;
        int ext_pt = 0;
        int total = 0;
        if (portSummary.size() > 0) {
            for (SJmoPortAttributeInfo portattribute : portSummary) {
                switch (portattribute.getByPortKind()) {
                    case 9: {
                        ++uni_pt;
                        break;
                    }
                    case 3: {
                        ++tgt_pt;
                        break;
                    }
                    case 4: {
                        ++rctgt_pt;
                        break;
                    }
                    case 5: {
                        ++inte_pt;
                        break;
                    }
                    case 6: {
                        ++ext_pt;
                        break;
                    }
                }
            }
            total = uni_pt + tgt_pt + rctgt_pt + ext_pt + inte_pt;
        }
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_UNI_PT_NUM, SJctrComUtility.toDecString(uni_pt));
        ((SJctrDataObject)summaryData).setData(KEY_TGT_PT_NUM, SJctrComUtility.toDecString(tgt_pt));
        ((SJctrDataObject)summaryData).setData(KEY_RCTGT_PT_NUM, SJctrComUtility.toDecString(rctgt_pt));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_PT_NUM, SJctrComUtility.toDecString(ext_pt));
        ((SJctrDataObject)summaryData).setData(KEY_INT_PT_NUM, SJctrComUtility.toDecString(inte_pt));
        ((SJctrDataObject)summaryData).setData(KEY_TOTAL_PT_NUM, SJctrComUtility.toDecString(total));
    }
}

