/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.replication.journals;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTG;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrJournalsJnlsSummaryModel
extends SJctrSimpleDataModel {
    private static final String COM_JNL_OPEN = "COM_NUM_OF_JNL_OPEN";
    private static final String COM_JNL_MAINFRAME = "COM_NUM_OF_JNL_MAINFRAME";
    private static final String COM_JNL_TOTAL = "COM_NUM_OF_JNL_TOTAL";
    private static final String COM_NUM_OF_EXCTG = "COM_NUM_OF_EXCTG";

    @Override
    protected void makeModelDirect() {
        super.makeModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorEXCTGMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    public void makeDataObject() {
        int iOpen = 0;
        int iMainFrame = 0;
        int iTotal = 0;
        String maxAllowed = "";
        boolean errFlg = false;
        List<?> jnlGrpList = this.getBasicDataMap().get(SJmoGetUniversalReplicatorJnlGrpMgr.class);
        SJmoUniversalReplicatorJnlGrpMgr jnlGrpMgr = null;
        SJmoUniversalReplicatorJnlGrp[] jnlInfoList = null;
        if (null == jnlGrpList) {
            this.logUty.putlog("makeDataObject", "Information of SJmoUniversalReplicatorJnlGrpMgr data list is null.");
            errFlg = true;
        } else if (0 == jnlGrpList.size()) {
            this.logUty.putlog("makeDataObject", "Size of SJmoUniversalReplicatorJnlGrpMgr data list is zero.");
            errFlg = true;
        } else {
            jnlGrpMgr = (SJmoUniversalReplicatorJnlGrpMgr)jnlGrpList.get(0);
            if (null == jnlGrpMgr) {
                this.logUty.putlog("makeDataObject", "Information of SJmoUniversalReplicatorJnlGrpMgr is null.");
                errFlg = true;
            } else {
                jnlInfoList = jnlGrpMgr.getJnlGroupList();
            }
        }
        List<?> rsgList = this.getBasicDataMap().get(SJmoGetRSGgetAllRsgs.class);
        SJmoRSGgetAllRsgs rsgInfo = null;
        if (null == rsgList) {
            this.logUty.putlog("makeDataObject", "Information of SJmoRSGgetAllRsgs data list is null.");
            errFlg = true;
        } else if (0 == rsgList.size()) {
            this.logUty.putlog("makeDataObject", "Size of SJmoRSGgetAllRsgs data list is zero.");
            errFlg = true;
        } else {
            rsgInfo = (SJmoRSGgetAllRsgs)rsgList.get(0);
            if (null == rsgInfo) {
                this.logUty.putlog("makeDataObject", "Information of SJmoRSGgetAllRsgs is null.");
                errFlg = true;
            }
        }
        String jnlMaxNumStr = "?";
        if (null == jnlInfoList || null == rsgInfo) {
            this.logUty.putlog("makeDataObject", "Information of SJmoUniversalReplicatorJnlGrp or SJmoRSGgetAllRsgs is null.");
            errFlg = true;
        } else {
            SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(this.getDataController().getOwner(), rsgInfo);
            jnlMaxNumStr = SJctrRemoteReplicationUtility.getAuthorizedMaxJnlNumString(jnlGrpMgr, rsgUty);
            for (SJmoUniversalReplicatorJnlGrp jnlInfo : jnlInfoList) {
                if (null == jnlInfo) continue;
                if (!SJctrRemoteReplicationUtility.hasTopJnlVolRs(jnlInfo, rsgUty)) {
                    this.logUty.putlog("makeDataObject", "Not authorized journal: " + jnlInfo.getIJnlGroupId());
                    continue;
                }
                if (1 == jnlInfo.getValidty()) {
                    ++iOpen;
                    continue;
                }
                if (2 != jnlInfo.getValidty()) continue;
                ++iMainFrame;
            }
            iTotal = iOpen + iMainFrame;
        }
        SJctrRemoteReplicationUtility util = this.getComUtility().getRemoteReplicationUtility();
        maxAllowed = util.getMaxAllowedString(jnlMaxNumStr);
        Object summaryData = this.getManageData();
        if (errFlg) {
            ((SJctrDataObject)summaryData).setData(COM_JNL_OPEN, "?");
            ((SJctrDataObject)summaryData).setData(COM_JNL_MAINFRAME, "?");
            ((SJctrDataObject)summaryData).setData(COM_JNL_TOTAL, "? " + maxAllowed);
        } else {
            ((SJctrDataObject)summaryData).setData(COM_JNL_OPEN, Integer.toString(iOpen));
            ((SJctrDataObject)summaryData).setData(COM_JNL_MAINFRAME, Integer.toString(iMainFrame));
            ((SJctrDataObject)summaryData).setData(COM_JNL_TOTAL, Integer.toString(iTotal) + " " + maxAllowed);
        }
        ((SJctrDataObject)summaryData).setData(COM_NUM_OF_EXCTG, this.getNumOfExctgs());
    }

    private String getNumOfExctgs() {
        SJctrRemoteReplicationUtility util = this.getComUtility().getRemoteReplicationUtility();
        String numOfExctgs = "? " + util.getMaxAllowedString("?");
        List<?> exctgDataList = this.getBasicDataMap().get(SJmoGetUniversalReplicatorEXCTGMgr.class);
        if (null == exctgDataList) {
            this.logUty.putlog("getNumOfExctgs", "Information of SJmoUniversalReplicatorEXCTGMgr data list is null.");
            return numOfExctgs;
        }
        if (0 == exctgDataList.size()) {
            this.logUty.putlog("getNumOfExctgs", "Size of SJmoUniversalReplicatorEXCTGMgr data list is zero.");
            return numOfExctgs;
        }
        SJmoUniversalReplicatorEXCTGMgr exctgData = (SJmoUniversalReplicatorEXCTGMgr)exctgDataList.get(0);
        if (null == exctgData) {
            this.logUty.putlog("getNumOfExctgs", "Information of SJmoUniversalReplicatorEXCTGMgr is null.");
            return numOfExctgs;
        }
        SJmoUniversalReplicatorEXCTG[] exctgInfoList = exctgData.getExCtGroupList();
        int maxExctgNum = 0;
        int registExctg = 0;
        if (null != exctgInfoList) {
            maxExctgNum = exctgInfoList.length;
            for (SJmoUniversalReplicatorEXCTG exctgInfo : exctgInfoList) {
                boolean rtn;
                int used;
                if (null == exctgInfo || 0 >= (used = exctgInfo.getUsed()) || !(rtn = SJctrRemoteReplicationDataMacro.EXCTG_PERMISSION_STATUS.contains(exctgInfo.getAttribute()))) continue;
                ++registExctg;
            }
        } else {
            this.logUty.putlog("getNumOfExctgs", "Information of SJmoUniversalReplicatorEXCTG is null.");
            return numOfExctgs;
        }
        numOfExctgs = Integer.toString(registExctg) + " " + util.getMaxAllowedString(Integer.toString(maxExctgNum));
        return numOfExctgs;
    }
}

