/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.tasks;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.topwindow.tasks.com.SJctrTaskUtility;

public class SJctrDispTaskInfo
implements Comparable {
    protected String mId;
    protected String mName;
    protected String mType;
    protected String mUserId;
    protected long mWizardStartTime;
    protected long mSubmitTime;
    protected long mApplyStartTime;
    protected long mApplyEndTime;
    protected int mProgress;
    protected int mStatus;
    protected boolean mAutoDeleteProtection;
    protected SJctrTask mTaskInst;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJctrDispTaskInfo(SJctrTask task, SJctrComUtility com) {
        SJctrTask sJctrTask = task;
        synchronized (sJctrTask) {
            this.mId = task.getId();
            this.mName = task.getName();
            SJctrTaskUtility taskutil = new SJctrTaskUtility(com);
            this.mType = taskutil.getTaskName(task.getActionGuidance(), 0, task.getType());
            this.mUserId = task.getUserId();
            this.mWizardStartTime = task.getWizardStartTime();
            this.mSubmitTime = task.getSubmitTime();
            this.mApplyStartTime = task.getApplyStartTime();
            this.mApplyEndTime = task.getApplyEndTime();
            this.mProgress = task.getProgress();
            this.mStatus = task.getStatus();
            this.mAutoDeleteProtection = task.isProtection();
            this.mTaskInst = task;
        }
    }

    public String toString() {
        String str = this.mId;
        return str;
    }

    public String chgLongToDate(long lSource) {
        if (lSource == 0L) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(lSource));
        String sRet = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(cal.getTime());
        return sRet;
    }

    void addDummyData() {
        Long sTime = System.currentTimeMillis();
        Long time = System.currentTimeMillis() - sTime;
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getType() {
        return this.mType;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public String getWizardStartTime() {
        return this.chgLongToDate(this.mWizardStartTime);
    }

    public String getSubmitTime() {
        return this.chgLongToDate(this.mSubmitTime);
    }

    public String getApplyStartTime() {
        return this.chgLongToDate(this.mApplyStartTime);
    }

    public String getApplyEndTime() {
        return this.chgLongToDate(this.mApplyEndTime);
    }

    public int getProgress() {
        return this.mProgress;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public boolean isAutoDeleteProtection() {
        return this.mAutoDeleteProtection;
    }

    public SJctrTask getTaskInst() {
        return this.mTaskInst;
    }

    public int compareTo(Object arg0) {
        SJctrDispTaskInfo tsk = (SJctrDispTaskInfo)arg0;
        return this.mId.compareTo(tsk.getId());
    }
}

