/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.changepwd;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.changepwd.SJctrChangePwdCurrentPwdDataModel;
import sanproject.sn2.controller.wizard.account.changepwd.SJctrChangePwdData;
import sanproject.sn2.controller.wizard.account.changepwd.SJctrChangePwdNewPwdDataModel;
import sanproject.sn2.controller.wizard.account.changepwd.SJctrChangePwdReEntPwdDataModel;
import sanproject.sn2.controller.wizard.account.changepwd.SJctrChangePwdSelectData;
import sanproject.sn2.controller.wizard.account.changepwd.SJctrChangePwdUserIDDataModel;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrTextLabelDataModel;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;

public class SJctrChangePwdDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17828129;
    private static final String COM_USER_ID = "COM_USER_ID";
    private static final String COM_PW = "COM_PW";
    private static final String COM_NEW_PW = "COM_NEW_PW";
    private static final String COM_NEW_PW_RE = "COM_NEW_PW_RE";
    public static final String TITLE = "CHANGE_PASSWORD";

    public SJctrChangePwdDC() throws SJcException {
        super(17828129);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(COM_USER_ID, new SJctrChangePwdUserIDDataModel());
        this.addDataObjectModel(COM_PW, new SJctrChangePwdCurrentPwdDataModel());
        this.addDataObjectModel(COM_NEW_PW, new SJctrChangePwdNewPwdDataModel());
        this.addDataObjectModel(COM_NEW_PW_RE, new SJctrChangePwdReEntPwdDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_CHANGEPASSWORD_SELECT_DATA);
        if (!this.checkContactData(dat)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrChangePwdSelectData changePwdSelectData = (SJctrChangePwdSelectData)dat.get(0);
        SJctrUserInfoDetail userInfoDetail = changePwdSelectData.getUserInfoDetail();
        if (userInfoDetail == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    @Override
    public boolean checkEndData() {
        String strLogSubTitle = "checkEndData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrChangePwdUserIDDataModel userIDDataModel = (SJctrChangePwdUserIDDataModel)this.getDataObjectModel(COM_USER_ID);
        SJctrTextLabelDataModel userIDTextLabel = (SJctrTextLabelDataModel)userIDDataModel.getDataModel(COM_USER_ID);
        SJctrChangePwdCurrentPwdDataModel currentPwdDataModel = (SJctrChangePwdCurrentPwdDataModel)this.getDataObjectModel(COM_PW);
        SJctrTextBoxDataModel currentPwdTextBox = (SJctrTextBoxDataModel)currentPwdDataModel.getDataModel(COM_PW);
        SJctrChangePwdNewPwdDataModel newPwdDataModel = (SJctrChangePwdNewPwdDataModel)this.getDataObjectModel(COM_NEW_PW);
        SJctrTextBoxDataModel newPwdTextBox = (SJctrTextBoxDataModel)newPwdDataModel.getDataModel(COM_NEW_PW);
        SJctrChangePwdReEntPwdDataModel reEntPwdDataModel = (SJctrChangePwdReEntPwdDataModel)this.getDataObjectModel(COM_NEW_PW_RE);
        SJctrTextBoxDataModel reEntPwdTextBox = (SJctrTextBoxDataModel)reEntPwdDataModel.getDataModel(COM_NEW_PW_RE);
        String userID = ((SJctrSelectableDataObject)userIDTextLabel.getManageData()).label();
        String currentPwd = currentPwdTextBox.getValue().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        String newPwd = newPwdTextBox.getValue().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        String reEntPwd = reEntPwdTextBox.getValue().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_CHANGEPASSWORD_SELECT_DATA);
        if (!this.checkContactData(dat)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrChangePwdSelectData changePwdSelectData = (SJctrChangePwdSelectData)dat.get(0);
        boolean bRet = false;
        boolean bTargetUser = changePwdSelectData.isTargetUser();
        if (bTargetUser) {
            // empty if block
        }
        try {
            SJcAccountChkUty.chkPassword(newPwd);
        }
        catch (SJcParamErrorException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]illegal Password String", null, 40000);
            SJctrError err = new SJctrError(2, 22, 105219);
            SJcException exception = err.createException();
            throw exception;
        }
        try {
            bRet = SJcUserInfoUty.checkPassword(userID, newPwd);
        }
        catch (SJcException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]checkPassword() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        if (bRet) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]illegal Password.", null, 40000);
            SJctrError err = new SJctrError(2, 22, 105218);
            SJcException exception = err.createException();
            throw exception;
        }
        if (!newPwd.equals(reEntPwd)) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]illegal Re-enter Password", null, 40000);
            SJctrError err = new SJctrError(2, 22, 105220);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrUserInfoDetail beforeUserInfoDetail = new SJctrUserInfoDetail();
        SJctrUserInfoDetail afterUserInfoDetail = new SJctrUserInfoDetail();
        beforeUserInfoDetail.setUserName(userID);
        beforeUserInfoDetail.setPassword(currentPwd);
        afterUserInfoDetail.setUserName(userID);
        afterUserInfoDetail.setPassword(reEntPwd);
        SJctrChangePwdData changePwdData = new SJctrChangePwdData();
        changePwdData.setBeforeUserInfoDetail(beforeUserInfoDetail);
        changePwdData.setAfterUserInfoDetail(afterUserInfoDetail);
        changePwdData.setTargetUser(bTargetUser);
        ArrayList<SJctrChangePwdData> list = new ArrayList<SJctrChangePwdData>();
        list.add(changePwdData);
        this.putCache(SJctrAccountDataMacro.WIZARD_CHANGEPASSWORD_DATA, list);
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkContactData(List<?> dat) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_CHANGEPASSWORD_SELECT_DATA.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!(obj instanceof SJctrChangePwdSelectData)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }
}

