/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.com;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcRoleInfoUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.com.utility.account.SJcRoleInfoContainer;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainerforGroup;
import sanproject.sn2.com.utility.account.SJcUserGroupInfoContainer;
import sanproject.sn2.com.utility.account.SJcUserInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundUserException;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrRoleInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrRoleResourceInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoUtility;

public class SJctrAccountInfoUty {
    private SJctrAccountInfoUty() {
    }

    public static Map<String, SJctrUserInfoDetail> getUserInfoDetailList(String[] userNames, SJctrDataController dc) throws SJcException, SJcCommunicationErrorException {
        HashMap<String, SJctrUserInfoDetail> ret = new HashMap<String, SJctrUserInfoDetail>();
        if (userNames == null || userNames.length <= 0) {
            throw new SJcParamErrorException();
        }
        SJcUserInfoContainer[] userInfo = null;
        userInfo = dc != null ? SJctrUserInfoUtility.getUserInfo(userNames, dc) : SJcUserInfoUty.getUserInfo(userNames);
        List<Object> list = new ArrayList();
        SJbaseUserSessionManager userSessionMgr = (SJbaseUserSessionManager)SJcSingletonManagerUty.getSingleton(SJctrAccountDataMacro.CLASS_USER_SESSION_MNGR);
        if (userSessionMgr != null) {
            list = userSessionMgr.getAllUserSession();
        }
        int iLoginNum = 0;
        for (int i = 0; i < userNames.length; ++i) {
            iLoginNum = 0;
            SJctrUserInfoDetail userInfoDetail = null;
            if (userInfo[i] != null) {
                userInfoDetail = new SJctrUserInfoDetail(userInfo[i]);
                if (!list.isEmpty()) {
                    for (SJbaseUserSessionInterface sJbaseUserSessionInterface : list) {
                        if (sJbaseUserSessionInterface == null || !userInfoDetail.getUserName().equals(sJbaseUserSessionInterface.getUserName())) continue;
                        ++iLoginNum;
                    }
                    userInfoDetail.setLoginUserNum(iLoginNum);
                }
            }
            ret.put(userNames[i], userInfoDetail);
        }
        return ret;
    }

    public static Map<String, SJctrUserInfoDetail> getUserInfoDetailList(String[] userNames) throws SJcException, SJcCommunicationErrorException {
        return SJctrAccountInfoUty.getUserInfoDetailList(userNames, null);
    }

    public static Map<String, SJctrUserGrpInfoDetail> getUserGrpInfoDetailList(String[] userGrpNames, SJctrDataController dc) {
        HashMap<String, SJctrUserGrpInfoDetail> ret = new HashMap<String, SJctrUserGrpInfoDetail>();
        if (userGrpNames == null || userGrpNames.length <= 0) {
            throw new SJcParamErrorException();
        }
        SJcUserGroupInfoContainer[] userGrpInfo = null;
        userGrpInfo = dc != null ? SJctrUserInfoUtility.getUserGroupInfo(userGrpNames, dc) : SJcUserGroupInfoUty.getUserGroupInfo(userGrpNames);
        SJcRoleResourceContainer roleResourceContainer = SJcUserGroupInfoUty.getUserGroupObject(userGrpNames);
        Map<String, SJctrRoleResourceInfoDetail> roleResourceMap = null;
        roleResourceMap = roleResourceContainer != null ? SJctrAccountInfoUty.getRoleResourceInfoDetailList(roleResourceContainer) : new HashMap<String, SJctrRoleResourceInfoDetail>();
        ArrayList<Object> usersInGroupList = null;
        try {
            usersInGroupList = dc != null ? SJctrUserInfoUtility.getUserInUserGroup(userGrpNames, dc) : SJcUserGroupInfoUty.getUserInUserGroup(userGrpNames);
        }
        catch (SJcNotFoundUserException e) {
            usersInGroupList = new ArrayList();
        }
        for (int i = 0; i < userGrpInfo.length; ++i) {
            SJctrRoleResourceInfoDetail roleResource = null;
            roleResource = roleResourceMap.get(userGrpNames[i]);
            SJctrUserGrpInfoDetail userGrpInfoDetail = null;
            if (userGrpInfo[i] != null) {
                userGrpInfoDetail = new SJctrUserGrpInfoDetail(userGrpInfo[i]);
                userGrpInfoDetail.setRoleResourceInfo(roleResource);
                String[] usersInGroup = (String[])usersInGroupList.get(i);
                if (usersInGroup != null) {
                    userGrpInfoDetail.setUserNum(usersInGroup.length);
                } else {
                    userGrpInfoDetail.setUserNum(0);
                }
            }
            ret.put(userGrpNames[i], userGrpInfoDetail);
        }
        return ret;
    }

    public static Map<String, SJctrUserGrpInfoDetail> getUserGrpInfoDetailList(String[] userGrpNames) {
        return SJctrAccountInfoUty.getUserGrpInfoDetailList(userGrpNames, null);
    }

    public static Map<String, SJctrRoleInfoDetail> getRoleInfoDetailList(String[] roles, SJctrDataController dc) {
        HashMap<String, SJctrRoleInfoDetail> ret = new HashMap<String, SJctrRoleInfoDetail>();
        if (roles == null) {
            throw new SJcParamErrorException();
        }
        SJcRoleInfoContainer[] roleInfo = null;
        roleInfo = dc != null ? SJctrUserInfoUtility.getRoleInfo(roles, dc) : SJcRoleInfoUty.getRoleInfo(roles);
        for (int i = 0; i < roleInfo.length; ++i) {
            SJctrRoleInfoDetail roleInfoDetail = null;
            if (roleInfo[i] != null) {
                roleInfoDetail = new SJctrRoleInfoDetail(roleInfo[i]);
            }
            ret.put(roles[i], roleInfoDetail);
        }
        return ret;
    }

    public static Map<String, SJctrRoleResourceInfoDetail> getRoleResourceInfoDetailList(SJcRoleResourceContainer roleResource) {
        HashMap<String, SJctrRoleResourceInfoDetail> ret = new HashMap<String, SJctrRoleResourceInfoDetail>();
        if (roleResource == null) {
            throw new SJcParamErrorException();
        }
        HashMap<String, SJcRoleResourceContainerforGroup> roleResourceMap = roleResource.getContainerforGroup();
        Set userGrpNameSet = roleResourceMap.keySet();
        for (String strGrpName : userGrpNameSet) {
            SJcRoleResourceContainerforGroup roleResourceforGroup = (SJcRoleResourceContainerforGroup)roleResourceMap.get(strGrpName);
            SJctrRoleResourceInfoDetail roleResourceInfoDetail = null;
            if (roleResourceforGroup != null) {
                roleResourceInfoDetail = new SJctrRoleResourceInfoDetail(roleResourceforGroup);
            }
            ret.put(strGrpName, roleResourceInfoDetail);
        }
        return ret;
    }

    public static SJctrRelatedDispDataObject createOkMsgDialog(int errorCode, SJctrItemSelectListener listener, SJctrDataController dc, String[] msgArg, String[] meanArg) {
        if (dc == null) {
            throw new SJcParamErrorException();
        }
        SJctrRelatedDispDataObject related = SJctrAccountInfoUty.getMessageDataObject(errorCode, dc, msgArg, meanArg);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)dc.getOwner().getDataController(related);
        if (listener == null) {
            msgDC.addButton(SJctrMessageDataController.MD_OK);
        } else {
            msgDC.addButton(SJctrMessageDataController.MD_OK, listener);
        }
        return related;
    }

    public static SJctrRelatedDispDataObject getMessageDataObject(int errorCode, SJctrDataController dc, String[] msgArg, String[] meanArg) {
        if (dc == null) {
            throw new SJcParamErrorException();
        }
        String strFuncID = Integer.toString(2);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(errorCode);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID, msgArg, meanArg);
        SJctrRelatedDispDataObject related = dc.createMsgDialog(msg);
        return related;
    }
}

