/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.editvirtualmng;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.HUVMsetVirtualLdev;
import sanproject.serverux.dataimpl.HUVMsetVirtualLdev_IN;
import sanproject.serverux.dataimpl.HUVMsetVirtualLdev_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevsError;
import sanproject.sn2.controller.wizard.account.rsg.editvirtualmng.SJctrEditVirtualManageSetConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrEditVirtualManageSetAC
extends SJctrApplyController {
    private static final long serialVersionUID = 2142749214597769094L;
    protected List<SJctrRsgLdevInfo> applyInfo = new ArrayList<SJctrRsgLdevInfo>();
    protected List<SJctrError> resultData = new ArrayList<SJctrError>();
    private int operation = -2;
    private int rmiOperationNum = -2;
    private final int RMI_OPE_HUVM_ON = 0;
    private final int RMI_OPE_HUVM_OFF = 1;
    private final int RMI_OPE_RESERVE_ID = 2;
    private final int RMI_OPE_UNRESERVE_ID = 3;
    private final int RMI_OPE_SET_LDEV_INFO = 4;
    private final int RMI_OPE_UNSET_LDEV_INFO = 5;
    private final int RMI_OPE_RESERVE_ID_SET_LDEV_INFO = 6;
    private final int RMI_OPE_UNRESERVE_ID_UNSET_LDEV_INFO = 7;

    public void setApplyData(SJctrEditVirtualManageSetConfirmData confirmData) {
        this.applyInfo = confirmData.getEditVLdevInfoList();
        this.operation = confirmData.getOperation();
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            this.rmiOperationNum = this.getRmiOperationNum();
            ArrayList<?> setList = this.getSetList();
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!!");
            Object resultObject = supplier.applyStart(this.getLockId(), setList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!!");
            this.setApplyResult(resultObject);
            if ((this.operation == 1 || this.operation == 4) && this.resultData.size() < this.applyInfo.size()) {
                if (this.operation == 1) {
                    this.rmiOperationNum = 3;
                } else if (this.operation == 4) {
                    this.rmiOperationNum = 1;
                }
                ArrayList<?> setList2 = this.getSetList();
                SJctrLogUty.info(this.title, "applyStart", "Apply2 Start!! ");
                Object resultObject2 = supplier.applyStart(this.getLockId(), setList2);
                SJctrLogUty.info(this.title, "applyStart", "Apply2 End!!");
                this.setApplyResult(resultObject2);
            }
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<HUVMsetVirtualLdev_IN> applyList = new ArrayList<HUVMsetVirtualLdev_IN>(1);
        HUVMsetVirtualLdev_IN inputIF = new HUVMsetVirtualLdev_IN();
        ArrayList<SJmoLdevIndex> errorLdevList = new ArrayList<SJmoLdevIndex>();
        for (SJctrError errorinf : this.resultData) {
            if (!(errorinf instanceof SJctrRsgLdevsError)) continue;
            SJctrRsgLdevsError error = (SJctrRsgLdevsError)errorinf;
            SJmoLdevIndex erorrLdev = error.getLdevIndex();
            errorLdevList.add(erorrLdev);
        }
        Collections.sort(errorLdevList);
        List<HUVMsetVirtualLdev> rmiLdevList = this.getRmiLdevList(errorLdevList);
        inputIF.setOperation(this.rmiOperationNum);
        inputIF.setLdevs(rmiLdevList);
        applyList.add(inputIF);
        return applyList;
    }

    private int getRmiOperationNum() {
        int rtn = -2;
        switch (this.operation) {
            case 1: {
                rtn = 0;
                break;
            }
            case 2: {
                rtn = 1;
                break;
            }
            case 4: 
            case 8: {
                rtn = 2;
                break;
            }
            case 16: {
                rtn = 3;
                break;
            }
            case 32: {
                rtn = 4;
                break;
            }
            case 64: {
                rtn = 5;
                break;
            }
            case 128: {
                rtn = 6;
                break;
            }
            case 256: {
                rtn = 7;
                break;
            }
        }
        return rtn;
    }

    private List<HUVMsetVirtualLdev> getRmiLdevList(List<SJmoLdevIndex> errorLdevList) {
        ArrayList<HUVMsetVirtualLdev> rmiLdevList = new ArrayList<HUVMsetVirtualLdev>(this.applyInfo.size());
        for (SJctrRsgLdevInfo info : this.applyInfo) {
            int errorNumber = Collections.binarySearch(errorLdevList, info);
            if (errorNumber >= 0) continue;
            HUVMsetVirtualLdev rmiLdev = new HUVMsetVirtualLdev();
            rmiLdev.setLDEVIndex(info.getSLdkc(), info.getSCu(), info.getSLdev());
            if (this.rmiOperationNum == 2 || this.rmiOperationNum == 6) {
                RJiLDEVIndex rmiVLdev = new RJiLDEVIndex();
                rmiVLdev.setLDEVIndex(info.getVLDEV().getVirtualLdev().getSLdkc(), info.getVLDEV().getVirtualLdev().getSCu(), info.getVLDEV().getVirtualLdev().getSLdev());
                rmiLdev.setRobjVirtualLdev(rmiVLdev);
            }
            if (this.rmiOperationNum == 4 || this.rmiOperationNum == 6) {
                rmiLdev.setVEmulation(info.getVLDEV().getIVEmulation());
                rmiLdev.setVSsid(info.getVLDEV().getIVSsid());
                rmiLdev.setVLuse(info.getVLDEV().getByVLuse());
                rmiLdev.setVCvs(info.getVLDEV().isVCvs());
            }
            rmiLdevList.add(rmiLdev);
        }
        return rmiLdevList;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        List detailarr;
        super.setApplyResult(resultObject);
        int funcErc = 207;
        int moduleErc = 22;
        int delegateErc = 0;
        HUVMsetVirtualLdev_OUT errinf = null;
        SJctrError error = new SJctrError(funcErc, moduleErc, delegateErc);
        if (!(resultObject instanceof HUVMsetVirtualLdev_OUT)) {
            SJctrLogUty.error(this.title, "applyStart", "Can not cast HUVMsetVirtualLdev_OUT.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        errinf = (HUVMsetVirtualLdev_OUT)resultObject;
        if (errinf != null && null != (detailarr = errinf.getLdevs())) {
            for (HUVMsetVirtualLdev detail : detailarr) {
                int detailesult;
                if (null == detail || 0 == (detailesult = detail.getRslt())) continue;
                SJmoLdevIndex index = new SJmoLdevIndex();
                index.setSLdkc(detail.getSLDKC());
                index.setSCu(detail.getSCU());
                index.setSLdev(detail.getSLDEV());
                moduleErc = 5;
                SJctrRsgLdevsError applyError = new SJctrRsgLdevsError(funcErc, moduleErc, detailesult, index);
                this.resultData.add(applyError);
            }
        }
        if (this.resultData.size() > 0) {
            this.setError(this.resultData.get(0));
        } else {
            this.setError(error);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public boolean hasApplyResult() {
        boolean ret = false;
        if (null != this.resultData && 0 < this.resultData.size()) {
            ret = true;
        }
        return ret;
    }

    @Override
    public int getLeadTime() {
        int applySize = this.applyInfo.size();
        int leadTime = SJctrRsgUtility.getLeadTime(applySize, 1024.0, 1800.0);
        if (this.operation == 1 || this.operation == 4) {
            leadTime += leadTime;
        }
        return leadTime;
    }
}

