/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.createldev;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.cvs.createldev.SJctrCreateLdevDC;
import sanproject.sn2.controller.wizard.cvs.createldev.SJctrCreateLdevData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrLdevIdModel
extends SJctrSimpleDataModel {
    public static final String COM_NODE = "COM_NODE";
    public static final String COM_CU = "COM_CU";
    public static final String COM_LDEV = "COM_LDEV";
    public static final String COM_INT = "COM_INT";
    private static final int DEFAULT_NODE = 0;
    private static final int CU_MAX = 255;
    private static final int LDEV_MAX = 256;
    private static final int MAX_INTERVAL = 256;
    private int nodeNum = 0;
    private SJctrComboBoxDataModel cuCombo;
    private SJctrComboBoxDataModel ldevCombo;
    private SJctrComboBoxDataModel intervalCombo;
    private ArrayList<BitSet> useLdevList;

    public SJctrLdevIdModel() {
        this.setNode(SJctrComUtility.toHexString(this.nodeNum, 2, true));
        this.initCuComboBox();
        this.initLdevComboBox();
        this.initIntervalComboBox();
        this.initMediatorListener();
    }

    private void initCuComboBox() {
        this.cuCombo = new SJctrComboBoxDataModel(255);
        this.addDataModel(COM_CU, this.cuCombo);
        this.cuCombo.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrNestedListDataObject) {
                    SJctrLdevIdModel.this.fireMessageEvent(SJctrCreateLdevDC.NOTIFY_CREATE_LDEV.SELECT_CU);
                }
            }
        });
        this.cuCombo.addMessageEventListener(SJctrCreateLdevDC.NOTIFY_CREATE_LDEV.ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                String str = SJctrLdevIdModel.this.cuCombo.getSelection();
                SJctrLdevIdModel.this.logUty.putlog("doMessageAction", "CU: " + str);
                SJctrCreateLdevData data = (SJctrCreateLdevData)event.getNofifyObject();
                data.setCu(Integer.parseInt(str, 16));
                data.setNode(SJctrLdevIdModel.this.nodeNum);
                data.setFb4(1);
                data.setPg(1);
            }
        });
    }

    private void initLdevComboBox() {
        this.ldevCombo = new SJctrComboBoxDataModel(256);
        this.addDataModel(COM_LDEV, this.ldevCombo);
        this.ldevCombo.addMessageEventListener(SJctrCreateLdevDC.NOTIFY_CREATE_LDEV.SELECT_CU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                dstModel.setDirty();
            }
        });
        this.ldevCombo.addMessageEventListener(SJctrCreateLdevDC.NOTIFY_CREATE_LDEV.ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                String str = SJctrLdevIdModel.this.ldevCombo.getSelection();
                SJctrLdevIdModel.this.logUty.putlog("doMessageAction", "LDEV: " + str);
                SJctrCreateLdevData data = (SJctrCreateLdevData)event.getNofifyObject();
                data.setLdev(Integer.parseInt(str, 16));
            }
        });
    }

    private void initIntervalComboBox() {
        this.intervalCombo = new SJctrComboBoxDataModel(256);
        for (int i = 0; i < 256; ++i) {
            String str = SJctrComUtility.toHexString(i, 2, true);
            this.intervalCombo.addItem(str);
        }
        this.intervalCombo.setSelectedIndex(0);
        this.addDataModel(COM_INT, this.intervalCombo);
        this.intervalCombo.addMessageEventListener(SJctrCreateLdevDC.NOTIFY_CREATE_LDEV.ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                String str = SJctrLdevIdModel.this.intervalCombo.getSelection();
                SJctrLdevIdModel.this.logUty.putlog("doMessageAction", "Interval: " + str);
                SJctrCreateLdevData data = (SJctrCreateLdevData)event.getNofifyObject();
            }
        });
    }

    private void initMediatorListener() {
        this.addMessageEventListener(SJctrCreateLdevDC.NOTIFY_CREATE_LDEV.SELECT_CU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                String selectName = SJctrLdevIdModel.this.cuCombo.getSelection();
                int cu = Integer.parseInt(selectName, 16);
                SJctrLdevIdModel.this.makeLdevComboBox(SJctrLdevIdModel.this.nodeNum, cu);
            }
        });
    }

    public void setNode(String str) {
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetLdevDetail kind = new SJmoGetLdevDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    protected void makeDataObject() {
        List<SJmoGetLdevDetail> ldevIndexList = this.getBasicDataList(SJmoGetLdevDetail.class);
        this.makeUnusedSet(ldevIndexList);
        int makeCu = -1;
        for (int cu = 0; cu < this.useLdevList.size(); ++cu) {
            BitSet set = this.useLdevList.get(cu);
            if (set.cardinality() == 256) continue;
            if (makeCu < 0) {
                makeCu = cu;
            }
            String str = SJctrComUtility.toHexString(cu, 2, true);
            this.cuCombo.addItem(str);
        }
        this.cuCombo.setSelectedIndex(0);
        if (makeCu >= 0) {
            this.makeLdevComboBox(this.nodeNum, makeCu);
        }
    }

    private void makeLdevComboBox(int node, int cu) {
        assert (node >= 0);
        assert (cu >= 0);
        this.ldevCombo.removeAllItems();
        BitSet bs = this.useLdevList.get(cu);
        int ldev = bs.nextClearBit(0);
        while (ldev < 256) {
            String str = SJctrComUtility.toHexString(ldev, 2, true);
            this.ldevCombo.addItem(str);
            ldev = bs.nextClearBit(ldev + 1);
        }
        this.ldevCombo.setSelectedIndex(0);
    }

    private void initUseLdevSet() {
        this.useLdevList = new ArrayList(255);
        for (int cu = 0; cu < 255; ++cu) {
            this.useLdevList.add(new BitSet());
        }
    }

    private void makeUnusedSet(List<?> ldevIndexList) {
        this.initUseLdevSet();
        BitSet ldevSet = null;
        short nowCu = -1;
        int length = ldevIndexList.size();
        for (int i = 0; i < length; ++i) {
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevIndexList.get(i);
            short cu = ldevDetail.getSCu();
            if (cu != nowCu) {
                nowCu = cu;
                ldevSet = this.useLdevList.get(cu);
            }
            ldevSet.set(ldevDetail.getSLdev());
        }
    }
}

