/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.unbindslus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrUnbindLdevInfo;
import sanproject.sn2.controller.wizard.cvs.unbindslus.SJctrUnbindSLUsConfirmTableModel;
import sanproject.sn2.controller.wizard.cvs.unbindslus.SJctrUnbindSlusAC;
import sanproject.sn2.controller.wizard.cvs.unbindslus.SJctrUnbindSlusConfirmDC;
import sanproject.sn2.controller.wizard.cvs.unbindslus.SJctrUnbindSlusConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrUnbindSlusSubWizard
extends SJctrSubWizard
implements SJctrCVSMacro {
    private final String TITLE = "UNBIND_SLUS";
    private static final Class<?> CONFIRM_DC = SJctrUnbindSlusConfirmDC.class;

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetLdevDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrUnbindSlusAC ac = new SJctrUnbindSlusAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<?> selectedRowDataList = dc.getProxy().getCache("KEY_SELECT_UNBIND_LDEV");
            if (null == selectedRowDataList) {
                uc.getLogUty().putlog("constructConfirmData", "Information of SJmoLdevDetail is null.");
                SJctrError err = new SJctrError(30, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRowDataList.size() == 0) {
                uc.getLogUty().putlog("constructConfirmData", "Size of SJmoLdevDetail data list is zero.");
                SJctrError err = new SJctrError(30, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoLdevNicknameInfo> ldevNameList = SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc);
            ArrayList<SJctrUnbindLdevInfo> unbindInfo = new ArrayList<SJctrUnbindLdevInfo>();
            for (SJmoLdevDetail selectedAlu : selectedRowDataList) {
                SJctrUnbindLdevInfo rowData = new SJctrUnbindLdevInfo();
                rowData.setDetailData(selectedAlu);
                int nameIndex = Collections.binarySearch(ldevNameList, selectedAlu);
                if (nameIndex < 0) {
                    rowData.setStrLdevName("?");
                    unbindInfo.add(rowData);
                    continue;
                }
                rowData.setStrLdevName(ldevNameList.get(nameIndex).getStrNickname());
                unbindInfo.add(rowData);
            }
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(dc);
            List<SJmoPortLunInfo> portLunInfoList = SJctrRsgUtility.getSJmoPortLunDetail(dc);
            List<SJctrUnbindLdevInfo> compAluLdevList = this.checkSelectedUnbindLdev(unbindInfo, dc, uc, ldevDetailList);
            SJctrUnbindSlusConfirmData confirmData = new SJctrUnbindSlusConfirmData();
            confirmData.setUnbindAluLdevsInfo(compAluLdevList);
            confirmData.setNeedData(dc);
            confirmData.setPortLunMap(SJctrReplicationUtility.createLDEVLUPathMap(portLunInfoList, ldevDetailList));
            ArrayList<SJctrUnbindSlusConfirmData> confirmDataList = new ArrayList<SJctrUnbindSlusConfirmData>();
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrUnbindSlusConfirmData.class, confirmDataList);
            ac.setApplyData(confirmData);
            wizard.addConfirmData(ac, related);
        }
        catch (SJcException e) {
            throw SJctrCVSUtility.convCvsLogicErrorException(e, 107002);
        }
    }

    private List<SJctrUnbindLdevInfo> checkSelectedUnbindLdev(List<SJctrUnbindLdevInfo> unBindLdevList, SJctrWizardWindowDC dc, SJctrUserController uc, List<SJmoLdevDetail> ldevDetailList) {
        List<SJctrUnbindLdevInfo> compAluLdevList = new ArrayList<SJctrUnbindLdevInfo>();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(unBindLdevList.size());
        SJctrError errInfo = null;
        for (SJctrUnbindLdevInfo aluLdevInfo : unBindLdevList) {
            SJctrError err;
            SJmoLdevDetail ldevDetail = null;
            int index = Collections.binarySearch(ldevDetailList, aluLdevInfo);
            if (index >= 0) {
                ldevDetail = ldevDetailList.get(index);
            }
            if (null == ldevDetail) {
                uc.getLogUty().putlog("checkSelectedUnbindLdev", "Inherited ldev detail info is not exist.");
                err = new SJctrError(30, 22, 206265);
                throw err.createException();
            }
            if (ldevDetail.getBAlu()) continue;
            uc.getLogUty().putlog("checkSelectedUnbindLdev", "LDEV which is not an ALU attribute is contained in selected LDEV.");
            err = new SJctrError(30, 22, 206262);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(aluLdevInfo, err);
            errList.add(errData);
            if (errInfo != null) continue;
            errInfo = err;
        }
        if (errList.size() == 0) {
            HashMap<String, byte[]> aluIdMap = SJctrCVSUtility.getAluIdMap(unBindLdevList, dc);
            for (SJctrUnbindLdevInfo unBindLdev : unBindLdevList) {
                unBindLdev.setAluId(aluIdMap.get(unBindLdev.toString()));
            }
            compAluLdevList = SJctrCVSUtility.getcompAluList(unBindLdevList, dc, uc, ldevDetailList);
            if (compAluLdevList.size() == 0) {
                uc.getLogUty().putlog("checkSelectedUnbindLdev", "Unbind LDEV Data is Nothing");
                SJctrError err = new SJctrError(30, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            for (SJctrUnbindLdevInfo checkAluLdev : compAluLdevList) {
                if (checkAluLdev.getBindSluIdList().size() != 0) continue;
                uc.getLogUty().putlog("checkSelectedUnbindLdev", "LDEV to which SLU is not bind is contained in LDEV of the selected ALU attribute.");
                SJctrError err = new SJctrError(30, 22, 206264);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(checkAluLdev, err);
                errList.add(errData);
                if (errInfo != null) continue;
                errInfo = err;
            }
        }
        if (errList.size() > 0) {
            this.createError(dc, unBindLdevList, errList, errInfo);
        }
        return compAluLdevList;
    }

    @Override
    public Class<?>[] getClassList() {
        return new Class[0];
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", "UNBIND_SLUS");
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    private void createError(SJctrWizardWindowDC dc, List<SJctrUnbindLdevInfo> transInfoList, List<SJctrErrorColumnData> errList, SJctrError errInfo) {
        Collections.sort(transInfoList, new SJctrLdevIndexComparator());
        SJctrUnbindSLUsConfirmTableModel unBindErrorTable = new SJctrUnbindSLUsConfirmTableModel();
        unBindErrorTable.setPaging(false);
        unBindErrorTable.setDataController(dc);
        unBindErrorTable.setBasicDataList(transInfoList);
        unBindErrorTable.initGuidance(this.getComUtility());
        unBindErrorTable.createModelDirect();
        unBindErrorTable.divideModelData(dc.getProxy().getModelDataMap());
        unBindErrorTable.makeDataModel();
        SJctrRelatedDispDataObject rel = dc.createDialog(SJctrErrorDataController.class, null);
        SJctrErrorDataController errDc = (SJctrErrorDataController)dc.getOwner().getDataController(rel);
        errDc.setParameter(unBindErrorTable, errList);
        SJctrError err = errDc.getRepresentativeError(errList);
        SJcException exp = err.createException();
        exp.setErrDisp(rel);
        throw exp;
    }
}

