/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.com;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertUtility;

public class SJctrEditAlertValidator
implements SJctrEditAlertDef {
    private static final int MAX_IDENTIFIER_LENGTH = 63;
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[\\s\"\\\\;:,\\*\\?<>\\|/#&\\+=\\[\\]'\\{\\}\\^]");
    private static final int MAX_SYSNAME_LENGTH = 180;
    private static final Pattern SYSNAME_PATTERN = Pattern.compile("[\\\\,/;:\\*\\?\"<>\\|&%\\^]");
    private static final int MAX_CONTACT_LENGTH = 180;
    private static final Pattern CONTACT_PATTERN = Pattern.compile("[\\\\,/;:\\*\\?\"<>\\|&%\\^]");
    private static final int MAX_LOCATION_LENGTH = 180;
    private static final Pattern LOCATION_PATTERN = Pattern.compile("[\\\\,/;:\\*\\?\"<>\\|&%\\^]");
    private static final int MAX_MAIL_LENGTH = 255;
    private static final Pattern MAIL_PATTERN = Pattern.compile("[\\s\"\\(\\),:;<>\\[\\]\\\\]");
    private static final int MAX_COMMUNITY_LENGTH = 180;
    private static final Pattern COMMUNITY_PATTERN = Pattern.compile("[\\,/;:\\*\\?\"<>\\|&%\\^\\\\]");
    private static final int MAX_SMTP_ACCOUNT_LENGTH = 255;
    private static final Pattern SMTP_ACCOUNT_PATTERN = Pattern.compile("[\\\\\\s\"\\;:,\\*\\?<>\\|/#&\\+=\\[\\]'\\{\\}\\^]");
    private static final int MAX_SMTP_PASSWORD_LENGTH = 255;
    private static final Pattern SMTP_PASSWORD_PATTERN = Pattern.compile("[\\\\\\s\"\\;:,\\*\\?<>\\|/#&\\+=\\[\\]'\\{\\}\\^]");

    private SJctrEditAlertValidator() {
    }

    public static boolean validateIdentifier(String text) {
        Matcher matcher;
        if (text.length() > 63) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205037);
        }
        if ((matcher = IDENTIFIER_PATTERN.matcher(text)).find()) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205037);
        }
        return true;
    }

    public static boolean validateMailAddress(String text) {
        Matcher matcher;
        if (text.length() > 255) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205036);
        }
        if ((matcher = MAIL_PATTERN.matcher(text)).find()) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205036);
        }
        return true;
    }

    public static boolean validateSystemName(String text) {
        Matcher matcher;
        if (text.length() > 180) {
            SJctrEditAlertUtility.errorMsg(82, 22, 105001);
        }
        if ((matcher = SYSNAME_PATTERN.matcher(text)).find()) {
            SJctrEditAlertUtility.errorMsg(82, 22, 105001);
        }
        return true;
    }

    public static boolean validateLocation(String text) {
        Matcher matcher;
        if (text.length() > 180) {
            SJctrEditAlertUtility.errorMsg(82, 22, 105002);
        }
        if ((matcher = LOCATION_PATTERN.matcher(text)).find()) {
            SJctrEditAlertUtility.errorMsg(82, 22, 105002);
        }
        return true;
    }

    public static boolean validateContact(String text) {
        Matcher matcher;
        if (text.length() > 180) {
            SJctrEditAlertUtility.errorMsg(82, 22, 105003);
        }
        if ((matcher = CONTACT_PATTERN.matcher(text)).find()) {
            SJctrEditAlertUtility.errorMsg(82, 22, 105003);
        }
        return true;
    }

    public static boolean validateCommunity(String text) {
        Matcher matcher;
        if (text.length() > 180) {
            SJctrEditAlertUtility.errorMsg(3, 22, 205030);
        }
        if ((matcher = COMMUNITY_PATTERN.matcher(text)).find()) {
            SJctrEditAlertUtility.errorMsg(3, 22, 205030);
        }
        return true;
    }

    public static boolean validateSMTPAccount(String text) {
        Matcher matcher;
        if (text.length() > 255) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205038);
        }
        if ((matcher = SMTP_ACCOUNT_PATTERN.matcher(text)).find()) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205038);
        }
        return true;
    }

    public static boolean validateSMTPPassword(String text) {
        Matcher matcher;
        if (text.length() > 255) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205039);
        }
        if ((matcher = SMTP_PASSWORD_PATTERN.matcher(text)).find()) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205039);
        }
        return true;
    }
}

