/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.model;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.controller.com.SJctrIpAddrUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.settings.com.SJctrAlertDataModel;

public class SJctrAddTrapIPAddressModel
extends SJctrSimpleDataModel
implements SJctrEditAlertDef,
SJctrAlertDataModel {
    private SJctrComboBoxDataModel combo;
    private SJctrRadioButtonGroupDataModel radio;
    private List<String> addrList;

    public SJctrAddTrapIPAddressModel() {
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.radio = new SJctrRadioButtonGroupDataModel();
        this.addDataModel("COM_RADIO", this.radio);
        this.combo = new SJctrComboBoxDataModel();
        this.combo.addItem("", "");
        this.combo.setSelection("");
        this.addDataModel("COM_COMBO", this.combo);
    }

    @Override
    public void setEnableAll(boolean flag) {
        this.radio.setEnable(flag);
        this.combo.setEnable(flag);
    }

    private void initListener() {
    }

    public int getAddressType() {
        if (this.radio.isSelect("COM_IPV4")) {
            return 4;
        }
        return 6;
    }

    public String getAddressText() {
        HashMap<String, Object> item;
        String input = this.combo.getSelection();
        if ((input == null || input.length() == 0) && (item = this.combo.getItem(input = "")) != null) {
            input = (String)item.get("label");
            input = input == null ? "" : input;
        }
        return input;
    }

    public void updateComboList(List<String> list) {
        if (list != null) {
            this.addrList = list;
            Collections.sort(this.addrList);
        }
        String current = this.getAddressText();
        if (this.addrList != null) {
            this.combo.removeAllItems();
            this.combo.addItem(current, current);
            for (String listData : this.addrList) {
                this.combo.addItem(listData, listData);
            }
            this.combo.setSelection(current);
        }
    }

    public boolean chkData() {
        String text = this.getAddressText();
        if (this.radio.isSelect("COM_IPV4")) {
            new SJctrIpAddrUtility.IPv4().chkRegex(text);
        } else {
            new SJctrIpAddrUtility.IPv6().chkRegex(text);
        }
        return true;
    }

    @Override
    public void updateDataModel() {
        this.radio.setEnableListener(false);
        this.radio.add("COM_IPV4", this.getComUtility().getGuidance("IPV4"));
        this.radio.add("COM_IPV6", this.getComUtility().getGuidance("IPV6"));
        this.radio.setSelect("COM_IPV4");
        this.radio.setEnableListener(true);
    }
}

