/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.com;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyElemCon;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrGuidanceOfLangType;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLog;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.kms.common.inf.SJkmsKeyInfoInterface;
import sanproject.sn2.kms.exception.SJkmsCommunicationException;

public class SJctrEncryptionAuditLogUty
implements SJctrEncryptionKeyDef,
SJctrGuidIdDefinition {
    private static final String BACKUPKEYS_TO_FILE_KEY = "ADT_TITLE_BACKUP_FILE";
    private static final String BACKUPKEYS_TO_SERVER_KEY = "ADT_TITLE_BACKUP_SERVER";
    private static final String RESTOREKEYS_TO_FILE_KEY = "ADT_TITLE_RESTORE_FILE";
    private static final String RESTOREKEYS_TO_SERVER_KEY = "ADT_TITLE_RESTORE_SERVER";
    private static final String FORCE_RESTOREKEYS_TO_FILE_KEY = "ADT_TITLE_FORCE_RESTORE_FILE";
    private static final String FORCE_RESTOREKEYS_TO_SERVER_KEY = "ADT_TITLE_FORCE_RESTORE_SERVER";
    private static final String REGULARBACKUPKEYS_TO_SERVER_KEY = "ADT_TITLE_REGULARBACKUP_SERVER";
    private static final String BACKUPKEYS_TO_SERVER_AUTO_KEY = "ADT_TITLE_BACKUP_SERVER_AUTO";

    private SJctrEncryptionAuditLogUty() {
    }

    public static SJcAuditLogApplyElemCon putEncKeysAuditLog(EncryptionOperation operation, String sn2TaskName, SJbaseUserSession userSession, SJcException result) {
        ArrayList<SJkmsKeyInfoInterface> details = new ArrayList<SJkmsKeyInfoInterface>();
        return SJctrEncryptionAuditLogUty.putEncKeysAuditoLog(operation, sn2TaskName, details, userSession, null);
    }

    public static SJcAuditLogApplyElemCon putEncKeysAuditLog(EncryptionOperation operation, String sn2TaskName, SJctrBackRestoreAuditLog audit, SJcException result) {
        ArrayList<SJkmsKeyInfoInterface> details = new ArrayList<SJkmsKeyInfoInterface>();
        return SJctrEncryptionAuditLogUty.putEncKeysAuditoLog(operation, sn2TaskName, details, audit, null);
    }

    public static SJcAuditLogApplyElemCon putEncKeysAuditoLog(EncryptionOperation operation, String sn2TaskName, SJkmsKeyInfoInterface detail, SJctrBackRestoreAuditLog audit, SJcException exception) {
        ArrayList<SJkmsKeyInfoInterface> details = new ArrayList<SJkmsKeyInfoInterface>(1);
        details.add(detail);
        return SJctrEncryptionAuditLogUty.putEncKeysAuditoLog(operation, sn2TaskName, details, audit, exception);
    }

    public static SJcAuditLogApplyElemCon putEncKeysAuditoLog(EncryptionOperation operation, String sn2TaskName, List<SJkmsKeyInfoInterface> details, SJbaseUserSession userSession, SJcException exception) {
        SJctrBackRestoreAuditLog auditLog = new SJctrBackRestoreAuditLog(operation, exception, userSession);
        auditLog.setPrintData(details);
        SJcAuditLogApplyElemCon elemCon = auditLog.createElemCon();
        elemCon.setTaskName(sn2TaskName);
        elemCon.setOperationName(SJctrEncryptionAuditLogUty.getAuditOperationName(operation));
        SJcMessage adtMessage = null;
        String adtResult = "Success";
        if (exception != null) {
            adtResult = "Error";
            adtMessage = exception.getMsg();
        }
        elemCon.setOperationResult(adtResult);
        elemCon.setOperationErrorCode(adtMessage);
        return elemCon;
    }

    public static SJcAuditLogApplyElemCon putEncKeysAuditoLog(EncryptionOperation operation, String sn2TaskName, List<SJkmsKeyInfoInterface> details, SJctrBackRestoreAuditLog audit, SJcException exception) {
        SJctrBackRestoreAuditLog auditLog = new SJctrBackRestoreAuditLog(operation, exception, audit);
        auditLog.setPrintData(details);
        SJcAuditLogApplyElemCon elemCon = auditLog.createElemCon();
        elemCon.setTaskName(sn2TaskName);
        elemCon.setOperationName(SJctrEncryptionAuditLogUty.getAuditOperationName(operation));
        SJcMessage adtMessage = null;
        String adtResult = "Success";
        if (exception != null) {
            adtResult = "Error";
            adtMessage = exception.getMsg();
        }
        elemCon.setOperationResult(adtResult);
        elemCon.setOperationErrorCode(adtMessage);
        return elemCon;
    }

    private static String getAuditOperationName(EncryptionOperation operation) {
        SJctrGuidanceOfLangType guidance = new SJctrGuidanceOfLangType("EN");
        Map<String, String> titleGuideMap = guidance.getGuidance(new String[][]{{"COMMON", operation.getOperationGuidanceKey()}});
        String rtnKey = "COMMON-" + operation.getOperationGuidanceKey();
        return titleGuideMap.get(rtnKey);
    }

    public static class SJctrBackRestoreAuditLog
    extends SJctrEncryptionAuditLog
    implements SJctrEncryptionKeyDef {
        private final EncryptionOperation operation;
        private final SJcException exception;
        private static final long serialVersionUID = 1L;

        public SJctrBackRestoreAuditLog(EncryptionOperation operation, SJcException exception, SJbaseUserSession userSession) {
            super(userSession);
            this.operation = operation;
            this.exception = exception;
        }

        public SJctrBackRestoreAuditLog(SJbaseUserSession userSession) {
            super(userSession);
            this.operation = null;
            this.exception = null;
        }

        public SJctrBackRestoreAuditLog(EncryptionOperation operation, SJcException exception, SJctrBackRestoreAuditLog audit) {
            super(audit);
            this.operation = operation;
            this.exception = exception;
        }

        @Override
        protected String[][] getBaseKey() {
            return new String[][]{{"COMMON", "ADT_NUM_OF_KEYS"}};
        }

        @Override
        protected String[][] getDataKey() {
            String[][] rtn = new String[][]{{"COMMON", "ADT_NORMAL_END"}, {"COMMON", "ADT_ERROR"}};
            return rtn;
        }

        @Override
        protected String[][] getHeadKey() {
            return new String[][]{{"COMMON", "UUID"}, {"COMMON", "BACKUP_DATE"}, {"COMMON", "DESCRIPT"}, {"COMMON", "ADT_RESULT"}, {"COMMON", "ADT_SERVER_REPRY"}};
        }

        @Override
        protected String getNumOfName() {
            return "ADT_NUM_OF_KEYS";
        }

        @Override
        protected String getFuncName() {
            return "ADT_FC_ENC";
        }

        @Override
        protected String getOperationName() {
            return this.operation.getOperationGuidanceKey();
        }

        @Override
        protected List<List<String>> getDetailData(Object wkInfo) {
            List details = (List)wkInfo;
            ArrayList<List<String>> adtDetails = new ArrayList<List<String>>();
            for (SJkmsKeyInfoInterface kmsInfo : details) {
                ArrayList<String> adtDetail = new ArrayList<String>();
                adtDetails.add(adtDetail);
                adtDetail.add(kmsInfo.getUUID());
                if (kmsInfo.getBackupDate() != null) {
                    SimpleDateFormat sdfKeyCreateDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    adtDetail.add(new String(sdfKeyCreateDate.format(kmsInfo.getBackupDate())));
                } else {
                    adtDetail.add("-");
                }
                adtDetail.add(kmsInfo.getBackupComment());
                adtDetail.add(this.getAuditResult());
                adtDetail.add(this.getAuditServerReply());
            }
            return adtDetails;
        }

        private String getAuditResult() {
            String result = null;
            if (this.exception == null) {
                result = this.getDataGuidance("COMMON", "ADT_NORMAL_END");
            } else {
                SJcMessage msg = this.exception.getMsg();
                result = String.format("%s(%s%s-%s)", this.getDataGuidance("COMMON", "ADT_ERROR"), msg.getFunctionID(), SJctrComUtility.toPaddingZeroString(Integer.valueOf(msg.getModuleID()), 2), msg.getMsgID());
            }
            return result;
        }

        private String getAuditServerReply() {
            SJkmsCommunicationException kmsException;
            String result = "-";
            if (this.exception instanceof SJkmsCommunicationException && (kmsException = (SJkmsCommunicationException)this.exception) != null && kmsException.getKmsMsg() != null && kmsException.getKmsMsg().length > 0) {
                result = String.format("%s %s", kmsException.getKmsMsg()[0], kmsException.getKmsMsg()[1]);
            }
            return result;
        }
    }

    public static enum EncryptionOperation {
        BACKUPKEYS_TO_FILE("ADT_TITLE_BACKUP_FILE"),
        BACKUPKEYS_TO_SERVER("ADT_TITLE_BACKUP_SERVER"),
        RESTOREKEYS_TO_FILE("ADT_TITLE_RESTORE_FILE"),
        RESTOREKEYS_FROM_SERVER("ADT_TITLE_RESTORE_SERVER"),
        FORCE_RESTOREKEYS_TO_FILE("ADT_TITLE_FORCE_RESTORE_FILE"),
        FORCE_RESTOREKEYS_FROM_SERVER("ADT_TITLE_FORCE_RESTORE_SERVER"),
        REGULARBACKUPKEYS_TO_SERVER("ADT_TITLE_REGULARBACKUP_SERVER"),
        BACKUPKEYS_TO_SERVER_AUTO("ADT_TITLE_BACKUP_SERVER_AUTO");

        private String guidKey;

        private EncryptionOperation(String guidKey) {
            this.guidKey = guidKey;
        }

        public String getOperationGuidanceKey() {
            return this.guidKey;
        }
    }
}

