/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.license.com;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.PPKget1PPInfo;
import sanproject.serverux.dataimpl.PPKgetKeyDetail;
import sanproject.serverux.dataimpl.SetPPInstallChk;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPPLicenseUtility;
import sanproject.sn2.controller.wizard.license.com.SJctr1PPInfo;
import sanproject.sn2.controller.wizard.license.com.SJctrGetKeyInstallResult;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrInstall1PPCheckExecute {
    protected String keyCode = "";
    protected PPKget1PPInfo[] ppInfoArray = null;
    private List<SJctr1PPInfo> updateList = null;
    private List<SJctr1PPInfo> errorList = null;
    protected PPKget1PPInfo[] resultArray = null;
    private Map<String, Integer> befStatusMap = null;

    public SJctrInstall1PPCheckExecute(String keyCode, PPKget1PPInfo[] ppInfoArray) {
        this.keyCode = keyCode;
        this.ppInfoArray = ppInfoArray;
        this.befStatusMap = new HashMap<String, Integer>(ppInfoArray.length);
        for (int index = 0; index < ppInfoArray.length; ++index) {
            PPKget1PPInfo ppInfo = ppInfoArray[index];
            this.befStatusMap.put(ppInfo.getPPID(), ppInfo.getStatus());
        }
    }

    public void execute(SJctrDataController dc) {
        SetPPInstallChk input = this.makeInputData();
        SJctrGetKeyInstallResult kind = new SJctrGetKeyInstallResult(input);
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
        SJctrPPLicenseUtility.setAuditUserInfo(dc.getOwner());
        try {
            SJmoThroughRmiData rmiObj = (SJmoThroughRmiData)dc.getModelData(wrapper).get(0);
            PPKgetKeyDetail output = (PPKgetKeyDetail)rmiObj.getObjRmi();
            this.setResult(output);
        }
        catch (Exception exp) {
            SJctrError error = SJctrError.parseError(exp);
            throw error.createException();
        }
        finally {
            SJctrPPLicenseUtility.modifyUnLock();
        }
    }

    protected void setResult(PPKgetKeyDetail ppGetDtl) {
        PPKget1PPInfo[] ppInfoArray = ppGetDtl.getPPKget1PPInfo();
        int ppNum = ppInfoArray.length;
        this.updateList = new ArrayList<SJctr1PPInfo>(ppNum);
        this.errorList = new ArrayList<SJctr1PPInfo>(ppNum);
        for (int index = 0; index < ppNum; ++index) {
            PPKget1PPInfo ppInfo = ppInfoArray[index];
            if (ppInfo.getPreInstall() == 0) {
                int befStatus = this.befStatusMap.get(ppInfo.getPPID());
                if (ppInfo.getUpdate() == 1 || ppInfo.getStatus() != befStatus) {
                    SJctr1PPInfo updateInfo = new SJctr1PPInfo(ppInfo);
                    updateInfo.nUpdate = 0;
                    updateInfo.nErrCode = 0;
                    this.updateList.add(updateInfo);
                }
                if (ppInfo.getErrCode() != 0) {
                    SJctr1PPInfo errInfo = new SJctr1PPInfo(ppInfo);
                    this.errorList.add(errInfo);
                }
            }
            ppInfo.nUpdate = 0;
            ppInfo.nErrCode = 0;
        }
        this.resultArray = ppInfoArray;
    }

    public PPKget1PPInfo[] getResultArray() {
        return this.resultArray;
    }

    public List<SJctr1PPInfo> getUpDateList() {
        return this.updateList;
    }

    public List<SJctr1PPInfo> getErrorList() {
        return this.errorList;
    }

    private SetPPInstallChk makeInputData() {
        SetPPInstallChk ret = new SetPPInstallChk();
        ret.nAction = 1;
        ret.strKeyCode = this.keyCode;
        ret.strPPCode = "";
        ret.strRsrv = "";
        ret.nNumOf1PPInfo = this.getPPNum();
        ret.ppkget1ppinfo = this.ppInfoArray;
        return ret;
    }

    protected int getPPNum() {
        int num = 0;
        for (int index = 0; index < this.ppInfoArray.length && this.ppInfoArray[index] != null; ++index) {
            ++num;
        }
        return num;
    }
}

