/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.addiscsihosts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.addiscsihosts.SJctrAddHostsIscsiConfirmData;
import sanproject.sn2.controller.wizard.lunm.addiscsihosts.SJctrAvailableHostsIscsiTableModel;
import sanproject.sn2.controller.wizard.lunm.addiscsihosts.SJctrSelectedHostsIscsiTableModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrAddHostsTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrModelDataCheck;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupWwnTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrReplaceDataForConfirm;
import sanproject.sn2.controller.wizard.lunm.comdialog.SJctrAddNewIscsiHostsDialogDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrAddHostsIscsiDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17826369;
    public static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_REMOVE = "COM_REMOVE";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final Class KEY_CLASS_MPORTATTR = SJmoGetPortAttributeInfo.class;
    public static final Class KEY_CLASS_MPORTIT = SJmoGetPortIscsiTargetInfo.class;
    public static final Class KEY_CLASS_MPORTISCSINAME = SJmoGetPortIscsiNameInfo.class;
    public static final Class KEY_CLASS_MPORTDETL = SJmoGetPortDetail.class;
    public static final Class KEY_CLASS_RSG = SJmoGetRSGgetAllRsgs.class;
    public static final Class KEY_CLASS_PORTITTABLEKEY = SJctrPortHostGroupTableKey.class;
    public static final String KEY_CLASS_PORTITINDEX = "KEY_CLASS_PORTITINDEX";
    public static final String KEY_SELECTED_ADD_ISCSINAME = "KEY_SELECTED_ADD_ISCSINAME";
    public static final String KEY_CLASS_CONFIRM_DATA = "SJctrAddHostsIscsiConfirmData";
    public static final String TITLE = "DISP_DI3S_TITLE";
    public static final String KEY_TABLE = "COM_TABLE";
    private List<SJmoPortIscsiNameInfo> cachePortiscsiNameList = Collections.emptyList();
    public static int ADDHOST_ERR1 = 107001;
    public static int ADDHOST_ERR2 = 106501;
    public static int ADDHOST_ERR3 = 107001;
    public static int ADDHOST_ERR4 = 205140;
    public static int ADDHOST_ERR5 = 105026;
    public static int ADDHOST_ERR6 = 205141;
    public static int ADDHOST_ERR7 = 105297;
    public static int ADDHOST_ERR8 = 107002;
    List<SJmoIscsiName> availableIscsiNameList;

    public SJctrAddHostsIscsiDC() throws SJcException {
        super(17826369);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrAvailableHostsIscsiTableModel());
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrSelectedHostsIscsiTableModel());
        SJctrButtonDataModel add = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddHostsIscsiDC.this.addAction();
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_ADD, add);
        SJctrButtonDataModel remove = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddHostsIscsiDC.this.removeAction();
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_REMOVE, remove);
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean bRet = true;
        SJctrWizardWindowDC wizard = this.getWizardWindow();
        List<?> targetList = wizard.getCache(KEY_CLASS_PORTITTABLEKEY);
        if (targetList == null || targetList.size() == 0) {
            bRet = false;
            SJctrError err = new SJctrError(10, 22, ADDHOST_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        return bRet;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        this.cachePortiscsiNameList = this.getCache(KEY_CLASS_MPORTISCSINAME);
        if (this.cachePortiscsiNameList == null) {
            SJctrError err = new SJctrError(10, 22, ADDHOST_ERR8);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJctrPortHostGroupTableKey> targetList = this.getCache(KEY_CLASS_PORTITTABLEKEY);
        ArrayList<SJctrError> errlist = new ArrayList<SJctrError>(targetList.size());
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            SJctrError oneError = new SJctrError(0, 0, 0);
            errlist.add(oneError);
        }
        ret = this.checkEquipPort(targetList, errlist);
        if (ret) {
            ret = this.checkEquipPortIt(targetList, errlist);
        }
        if (ret) {
            ret = this.checkPortAttribute(targetList, errlist);
        }
        if (ret) {
            ret = this.checkRsgPortIt(targetList, errlist);
        }
        if (!ret) {
            SJctrDataController parentDC = this.getWizardWindow().getParentDC();
            SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
            ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(targetList.size());
            for (int errpos = 0; errpos < targetList.size(); ++errpos) {
                SJctrError oneError = errlist.get(errpos);
                if (oneError.getError() == 0) continue;
                SJctrErrorColumnData oneErrorColumn = new SJctrErrorColumnData(targetList.get(errpos), oneError);
                errColumnList.add(oneErrorColumn);
            }
            SJctrError errInfo = ((SJctrErrorColumnData)errColumnList.get(0)).getError();
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errColumnList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return ret;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortAttributeInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        List<?> addHostList = this.getCache(KEY_SELECTED_ADD_ISCSINAME);
        if (addHostList == null || addHostList.size() == 0) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, ADDHOST_ERR5);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> portDetailList = this.getCache(KEY_CLASS_MPORTDETL);
        List<SJctrPortHostGroupTableKey> targetIt = this.getCache(KEY_CLASS_PORTITINDEX);
        SJctrComUtility comUtil = this.getComUtility();
        SJctrPortUtility portUtil = comUtil.getPortUtility();
        portUtil.checkIscsiPortSecurityMsg(portDetailList, targetIt, this);
        return ret;
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_ADD_HOSTS.ADD_NEW_HOST, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddHostsIscsiDC.this.enterAddNewHostAction();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object notifyObj = event.getNofifyObject();
                if (notifyObj instanceof Map) {
                    Map map = (Map)notifyObj;
                    SJctrAddHostsIscsiDC.this.exitAddNewHostAction(map);
                }
            }
        });
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", TITLE);
    }

    private boolean checkEquipPort(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        boolean ret = true;
        List<?> ptIt = this.getCache(KEY_CLASS_MPORTIT);
        if (ptIt == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEquipPort", "SJmoGetPortiscsiTargetInfo Not Found in the Cache.");
            return false;
        }
        for (int index = 0; index < targetList.size(); ++index) {
            SJctrPortHostGroupTableKey onePtItKey = targetList.get(index);
            int searchRet = Collections.binarySearch(ptIt, onePtItKey.getPortIscsiTargetInfo());
            if (searchRet >= 0) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(ADDHOST_ERR2);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEquipPort", "Not Found port#=" + onePtItKey.getPortIscsiTargetInfo().getSPort());
        }
        return ret;
    }

    private boolean checkEquipPortIt(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        ArrayList<SJctrPortHostGroupTableKey> keyList;
        boolean ret = true;
        List<SJmoPortIscsiTargetInfo> cacheList = this.getCache(KEY_CLASS_MPORTIT);
        ret = SJctrModelDataCheck.checkEquipPortIT(targetList, cacheList, keyList = new ArrayList<SJctrPortHostGroupTableKey>(targetList.size()), errList);
        if (ret) {
            this.putCache(KEY_CLASS_PORTITINDEX, keyList);
        }
        return ret;
    }

    private boolean checkRsgPortIt(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        boolean ret = true;
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, ADDHOST_ERR8);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex ItIndex = new SJmoHostGroupIndex();
        for (int index = 0; index < targetList.size(); ++index) {
            SJctrPortHostGroupTableKey ptItTableKey = targetList.get(index);
            SJmoIscsiTargetInfo ItInfo = ptItTableKey.getIscsiTargetInfo();
            ItIndex.setSPort(ItInfo.getSPort());
            ItIndex.setSHostGroup(ItInfo.getSIscsiTarget());
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(ItIndex, rsgUtil);
            if (rsgFlg) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(ADDHOST_ERR7);
        }
        return ret;
    }

    private boolean checkContainsPortIt(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        boolean ret = true;
        for (int index = 0; index < targetList.size() - 1; ++index) {
            for (int point = index + 1; point < targetList.size(); ++point) {
                short port2;
                short port1 = targetList.get(index).getPortIscsiTargetInfo().getSPort();
                if (port1 != (port2 = targetList.get(point).getPortIscsiTargetInfo().getSPort())) continue;
                ret = false;
                SJctrError errElement1 = errList.get(index);
                errElement1.setFunc(10);
                errElement1.setModule(22);
                errElement1.setError(ADDHOST_ERR4);
                SJctrError errElement2 = errList.get(point);
                errElement2.setFunc(10);
                errElement2.setModule(22);
                errElement2.setError(ADDHOST_ERR4);
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkContainsPortIt", "Row#1 = " + index + ", Row#2 = " + point + " Same Port# Selected. (Port#" + port1 + ")");
            }
        }
        return ret;
    }

    private boolean checkPortAttribute(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        boolean ret = true;
        List<SJmoPortAttributeInfo> cacheList = this.getCache(KEY_CLASS_MPORTATTR);
        ret = SJctrModelDataCheck.checkPortAttribute(targetList, cacheList, errList);
        return ret;
    }

    private void addAction() {
        List<Object> selectedList;
        boolean bErrAddFlg = true;
        SJctrAvailableHostsIscsiTableModel availableTable = (SJctrAvailableHostsIscsiTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrSelectedHostsIscsiTableModel selectedTable = (SJctrSelectedHostsIscsiTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> addHostsKey = availableTable.getSelectedRowDataOrder();
        ArrayList<SJmoIscsiName> availableIscsiNameList = new ArrayList<SJmoIscsiName>(addHostsKey.size());
        for (Object availableRowData : addHostsKey) {
            SJctrAddHostsTableKey availableAddHostsData = (SJctrAddHostsTableKey)availableRowData;
            SJmoIscsiName IscsiNameList = availableAddHostsData.getIscsiNameInfo();
            availableIscsiNameList.add(IscsiNameList);
        }
        ArrayList<SJmoIscsiName> selectedIscsiNameList = new ArrayList<SJmoIscsiName>(selectedTable.getAllRowData().size());
        for (Object selectedRowData : selectedTable.getAllRowData()) {
            SJctrAddHostsTableKey selectedAddHostsData = (SJctrAddHostsTableKey)selectedRowData;
            SJmoIscsiName IscsiNameList = selectedAddHostsData.getIscsiNameInfo();
            selectedIscsiNameList.add(IscsiNameList);
        }
        ArrayList<SJctrError> errlist = new ArrayList<SJctrError>(addHostsKey.size());
        for (int errpos = 0; errpos < addHostsKey.size(); ++errpos) {
            SJctrError oneError = new SJctrError(0, 0, 0);
            errlist.add(oneError);
        }
        ArrayList<String> blockIscsiNameList = new ArrayList<String>(availableTable.getUsedIscsiName().size());
        blockIscsiNameList.addAll(availableTable.getUsedIscsiName());
        if (!SJctrModelDataCheck.checkContainsIscsiName(availableIscsiNameList, blockIscsiNameList, errlist)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add IscsiName is already used in this port!!");
            bErrAddFlg = false;
        }
        if (bErrAddFlg) {
            ArrayList<String> alreadySelectIscsiNameList = new ArrayList<String>(selectedIscsiNameList.size());
            for (SJmoIscsiName IscsiName : selectedIscsiNameList) {
                alreadySelectIscsiNameList.add(IscsiName.getStrIscsiName());
            }
            if (!SJctrModelDataCheck.checkContainsIscsiName(availableIscsiNameList, alreadySelectIscsiNameList, errlist)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add IscsiName is already selected!!");
                bErrAddFlg = false;
            }
        }
        if (bErrAddFlg) {
            ArrayList<String> blockNicknameList = new ArrayList<String>(availableTable.getUsedNickname().size());
            blockNicknameList.addAll(availableTable.getUsedNickname());
            if (!SJctrModelDataCheck.checkContainsIscsiNickname(availableIscsiNameList, blockNicknameList, errlist)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add IscsiName-Nickname is already used in this port!!");
                bErrAddFlg = false;
            }
        }
        if (bErrAddFlg) {
            ArrayList<String> alreadySelectNicknameList = new ArrayList<String>(selectedIscsiNameList.size());
            for (SJmoIscsiName IscsiName : selectedIscsiNameList) {
                alreadySelectNicknameList.add(IscsiName.getStrIscsiNickName());
            }
            if (!SJctrModelDataCheck.checkContainsIscsiNickname(availableIscsiNameList, alreadySelectNicknameList, errlist)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add IscsiName-Nickname is already selected!!");
                bErrAddFlg = false;
            }
        }
        if (bErrAddFlg && SJctrModelDataCheck.isSameHBAIscsiName(addHostsKey, errlist)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add IscsiName(IscsiName-byte) is overlapped in this operation!!");
        }
        if (bErrAddFlg && SJctrModelDataCheck.isSameIscsiNickname(addHostsKey, errlist)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add IscsiName(nickname) is overlapped in this operation!!");
        }
        ArrayList<Object> list = new ArrayList<Object>(addHostsKey.size());
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(addHostsKey.size());
        for (int errpos = 0; errpos < addHostsKey.size(); ++errpos) {
            SJctrError errElement = errlist.get(errpos);
            if (errElement.getError() == 0) {
                list.add(addHostsKey.get(errpos));
                continue;
            }
            SJctrAddHostsTableKey errKey = (SJctrAddHostsTableKey)addHostsKey.get(errpos);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(errKey, errElement);
            errColumnList.add(errColumn);
        }
        if (bErrAddFlg && this.isOverIscsiNameMax(list, selectedList = selectedTable.getAllRowData())) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "No more IscsiNames can be registered in the port.");
            SJctrError err = new SJctrError(10, 22, ADDHOST_ERR6);
            SJcException exp = err.createException();
            throw exp;
        }
        if (list.size() > 0 && bErrAddFlg) {
            availableTable.removeRowData(list);
            selectedTable.addRowDataTop(list);
            List<Object> selectedTableData = selectedTable.getAllRowData();
            this.putCache(KEY_SELECTED_ADD_ISCSINAME, selectedTableData);
        }
        if (errColumnList.size() != 0) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(availableTable, errColumnList);
            availableTable.setDirty();
            selectedTable.setDirty();
            SJctrError errInfo = errDc.getRepresentativeError(errColumnList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
    }

    private boolean isOverIscsiNameMax(List addRowList, List selectedList) {
        boolean ret = false;
        List<?> targetPortItList = this.getCache(KEY_CLASS_PORTITINDEX);
        if (targetPortItList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "isOverIscsiNameMax", "KEY_CLASS_PORTITINDEX Not Found in the Cache.");
            return true;
        }
        for (SJctrPortHostGroupTableKey portIt : targetPortItList) {
            SJmoPortIscsiTargetInfo iscsiTarget = portIt.getPortIscsiTargetInfo();
            int searchRet = Collections.binarySearch(this.cachePortiscsiNameList, iscsiTarget);
            if (searchRet < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "isOverIscsiNameMax", "Skipped Port#= " + portIt.getPortIscsiTargetInfo().getSPort());
                continue;
            }
            SJmoPortIscsiNameInfo portItNameInfo = this.cachePortiscsiNameList.get(searchRet);
            ArrayList<SJmoIscsiName> itNameList = portItNameInfo.getAlPortIscsiName();
            HashSet<String> iscsiNameSet = new HashSet<String>(itNameList.size());
            for (SJmoIscsiName itNameInfo : itNameList) {
                iscsiNameSet.add(itNameInfo.getStrIscsiName());
            }
            int addhostNum = 0;
            for (Object addData : addRowList) {
                SJctrAddHostsTableKey addHost = (SJctrAddHostsTableKey)addData;
                String iscsiName = addHost.getIscsiNameInfo().getStrIscsiName();
                if (iscsiNameSet.contains(iscsiName)) continue;
                ++addhostNum;
            }
            int selectedHostNum = 0;
            for (Object selectedData : selectedList) {
                SJctrPortHostGroupWwnTableKey selectedTableRow = (SJctrPortHostGroupWwnTableKey)selectedData;
                String iscsiName = selectedTableRow.getIscsiNameInfo().getStrIscsiName();
                if (iscsiNameSet.contains(iscsiName)) continue;
                ++selectedHostNum;
            }
            int afterIscsiNameCount = iscsiNameSet.size() + addhostNum + selectedHostNum;
            if (afterIscsiNameCount <= SJctrPortUtility.PORT_ISCSINAME_MAX) continue;
            ret = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "isOverIscsiNameMax", "Now Registered Port IscsiName Count = " + iscsiNameSet.size() + ", Try to Add IscsiName Count = " + addhostNum + " (Port#=" + iscsiTarget.getSPort() + ")");
            break;
        }
        return ret;
    }

    private void removeAction() {
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> list = selectedTable.removeSelectedRowData();
        avaliableTable.addRowDataTop(list);
        List<Object> selectedTableData = selectedTable.getAllRowData();
        this.putCache(KEY_SELECTED_ADD_ISCSINAME, selectedTableData);
    }

    private void enterAddNewHostAction() {
        SJctrAvailableHostsIscsiTableModel availableTable = (SJctrAvailableHostsIscsiTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<Object> addList = availableTable.getSelectedRowData();
        ArrayList<SJmoIscsiName> selectIscsiNameList = new ArrayList<SJmoIscsiName>(addList.size());
        for (Object rowObj : addList) {
            SJctrAddHostsTableKey rowKey = (SJctrAddHostsTableKey)rowObj;
            selectIscsiNameList.add(rowKey.getIscsiNameInfo());
        }
        HashMap map = new HashMap();
        map.put("KEY_ISCSI_DIALOG_IN", selectIscsiNameList);
        map.put("KEY_AVAILABLE_ISCSI_NAME", this.availableIscsiNameList);
        ArrayList<String> blockIscsiNameList = new ArrayList<String>(availableTable.getUsedIscsiName().size());
        blockIscsiNameList.addAll(availableTable.getUsedIscsiName());
        map.put("KEY_BLOCK_ISCSISTRING", blockIscsiNameList);
        ArrayList<String> blockNicknameList = new ArrayList<String>(availableTable.getUsedNickname().size());
        blockNicknameList.addAll(availableTable.getUsedNickname());
        map.put("KEY_BLOCK_NICKNAME", blockNicknameList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrAddNewIscsiHostsDialogDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void exitAddNewHostAction(Map<String, List<?>> carryMap) {
        SJctrAvailableHostsIscsiTableModel avaliableTable = (SJctrAvailableHostsIscsiTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<?> carryIscsiNameList = carryMap.get("KEY_ISCSI_NAME_DIALOG_OUT");
        if (carryIscsiNameList == null || carryIscsiNameList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "exitAddNewHostAction", "KEY_IscsiName_DIALOG_OUT Not Found!!");
            return;
        }
        SJmoIscsiName newIscsiName = (SJmoIscsiName)carryIscsiNameList.get(0);
        SJmoPortIscsiTargetInfo newPtItInfo = new SJmoPortIscsiTargetInfo();
        SJmoIscsiTargetInfo newItInfo = new SJmoIscsiTargetInfo();
        SJctrAddHostsTableKey hostKey = new SJctrAddHostsTableKey(newPtItInfo, newItInfo, newIscsiName, true);
        ArrayList<SJctrAddHostsTableKey> addList = new ArrayList<SJctrAddHostsTableKey>(1);
        addList.add(hostKey);
        avaliableTable.addRowDataTop(addList);
        if (this.availableIscsiNameList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "exitAddNewHostAction", "Available Table Key Not Found!! --> remake Available Table Key List.");
            this.availableIscsiNameList = new ArrayList<SJmoIscsiName>();
        }
        this.availableIscsiNameList.add(newIscsiName);
        avaliableTable.setDirty();
    }

    SJctrAddHostsIscsiConfirmData createConfirmData(List<SJctrPortHostGroupTableKey> targetPortItList, List<SJctrAddHostsTableKey> addHostList) {
        TreeSet<SJmoPortIscsiTargetInfo> portSet = new TreeSet<SJmoPortIscsiTargetInfo>();
        for (SJctrPortHostGroupTableKey key : targetPortItList) {
            portSet.add(key.getPortIscsiTargetInfo());
        }
        ArrayList<SJmoPortIndex> targetPortList = new ArrayList<SJmoPortIndex>(portSet);
        List<SJmoPortAttributeInfo> portAttributeList = this.getCache(KEY_CLASS_MPORTATTR);
        List<SJmoPortAttributeInfo> confirmPortAttrList = SJctrReplaceDataForConfirm.getConfirmPortAttrInfo(targetPortList, portAttributeList);
        List<SJmoPortDetail> portDetailList = this.getCache(KEY_CLASS_MPORTDETL);
        List<SJmoPortDetail> confirmPortDetailList = SJctrReplaceDataForConfirm.getConfirmPortDetail(targetPortList, portDetailList);
        List<SJmoPortIscsiTargetInfo> confirmPortItList = this.replaceConfirmPortItInfo(targetPortItList, addHostList);
        List<SJctrPortHostGroupTableKey> newTargetList = SJctrReplaceDataForConfirm.replaceConfirmIscsiTargetList(targetPortItList, confirmPortItList);
        SJctrAddHostsIscsiConfirmData confirmData = new SJctrAddHostsIscsiConfirmData();
        confirmData.setPortAttributeList(confirmPortAttrList);
        confirmData.setPortDetailList(confirmPortDetailList);
        confirmData.setPortItList(confirmPortItList);
        confirmData.setAddHostsInfo(addHostList);
        confirmData.setTargetPortHgList(newTargetList);
        ArrayList<SJctrAddHostsIscsiConfirmData> confirmDataList = new ArrayList<SJctrAddHostsIscsiConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(KEY_CLASS_CONFIRM_DATA, confirmDataList);
        return confirmData;
    }

    private List<SJmoPortIscsiTargetInfo> replaceConfirmPortItInfo(List<SJctrPortHostGroupTableKey> targetPortItList, List<SJctrAddHostsTableKey> addHostList) {
        List<?> portItList = this.getCache(KEY_CLASS_MPORTIT);
        TreeMap<String, SJmoPortIscsiTargetInfo> confirmPortItMap = new TreeMap<String, SJmoPortIscsiTargetInfo>();
        for (SJctrPortHostGroupTableKey ptItKey : targetPortItList) {
            int searchResult = Collections.binarySearch(portItList, ptItKey.getPortIscsiTargetInfo());
            if (searchResult < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "exitAddNewHostAction", "SJmoPortIscsiTargetInfo not found.");
                continue;
            }
            SJmoPortIscsiTargetInfo portIt = (SJmoPortIscsiTargetInfo)portItList.get(searchResult);
            SJmoPortIscsiTargetInfo createPortIt = null;
            if (confirmPortItMap.containsKey(ptItKey.getPortIscsiTargetInfo().toString())) {
                createPortIt = (SJmoPortIscsiTargetInfo)confirmPortItMap.get(ptItKey.getPortIscsiTargetInfo().toString());
            } else {
                try {
                    createPortIt = (SJmoPortIscsiTargetInfo)portIt.clone();
                }
                catch (CloneNotSupportedException e) {
                    this.getLogUty().putlog("createConfirmData", "SJmoPortIscsiTargetInfo clone fail", e, 30000);
                    continue;
                }
            }
            ArrayList<SJmoIscsiTargetInfo> itArray = createPortIt.getAlPortIscsiTarget();
            SJmoIscsiTargetInfo createTargetIt = null;
            for (SJmoIscsiTargetInfo oneModelIt : itArray) {
                if (oneModelIt.getSIscsiTarget() != ptItKey.getIscsiTargetInfo().getSIscsiTarget()) continue;
                createTargetIt = oneModelIt;
                break;
            }
            if (createTargetIt == null) {
                this.getLogUty().putlog("createConfirmData", "SJmoIscsiTargetInfo not found.", null, 20000);
                continue;
            }
            for (SJctrAddHostsTableKey addHostData : addHostList) {
                SJmoIscsiName IscsiNameInfo = new SJmoIscsiName();
                IscsiNameInfo.setStrIscsiName(addHostData.getIscsiNameInfo().getStrIscsiName());
                IscsiNameInfo.setStrIscsiNickName(addHostData.getIscsiNameInfo().getStrIscsiNickName());
                createTargetIt.getAlIscsiName().add(IscsiNameInfo);
            }
            confirmPortItMap.put(ptItKey.getPortIscsiTargetInfo().toString(), createPortIt);
        }
        ArrayList<SJmoPortIscsiTargetInfo> confirmPortItList = new ArrayList<SJmoPortIscsiTargetInfo>();
        confirmPortItList.addAll(confirmPortItMap.values());
        return confirmPortItList;
    }

    public static enum NOTIFY_ADD_HOSTS implements SJctrNotifyState
    {
        ADD_NEW_HOST;

    }
}

