/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.comdialog;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.model.data.lu.SJmoWwn;

public class SJctrAddNewHostsDialogDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 0x200A002;
    public static final String KEY_HBAWWN = "COM_HBAWWN";
    public static final String KEY_HOSTNAME = "COM_HOSTNAME";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final String DISP_HBA_WWN_MAX_CHAR = "DISP_HBA_WWN_MAX_CHAR";
    public static final String DISP_HOST_NAME_MAX_CHAR = "DISP_HOST_NAME_MAX_CHAR";
    public static final String KEY_WWN_DIALOG_IN = "KEY_WWN_DIALOG_IN";
    public static final String KEY_WWN_DIALOG_OUT = "KEY_WWN_DIALOG_OUT";
    public static final String KEY_AVAILABLE_WWN = "KEY_AVAILABLE_WWN";
    public static final String KEY_BLOCK_WWNSTRING = "KEY_BLOCK_WWNSTRING";
    public static final String KEY_BLOCK_NICKNAME = "KEY_BLOCK_NICKNAME";
    public static final int HBAWWN_CHAR_LENGTH = 16;
    public static int ADDNEWHOST_ERR1 = 105094;
    public static int ADDNEWHOST_ERR2 = 105046;
    public static int ADDNEWHOST_ERR3 = 105047;
    public static int ADDNEWHOST_ERR4 = 105048;
    public static int ADDNEWHOST_ERR5 = 105049;
    public static int ADDNEWHOST_ERR6 = 105050;
    public static int ADDNEWHOST_ERR7 = 105051;

    public SJctrAddNewHostsDialogDC() throws SJcException {
        super(0x200A002);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_HBAWWN, new SJctrTextBoxDataModel());
        this.addDataObjectModel(KEY_HOSTNAME, new SJctrTextBoxDataModel());
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrTextBoxDataModel txtHBAWWN = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HBAWWN);
        SJctrTextBoxDataModel txtHostName = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HOSTNAME);
        txtHBAWWN.setLabel(util.getGuidance("LUNM", DISP_HBA_WWN_MAX_CHAR));
        txtHostName.setLabel(util.getGuidance("LUNM", DISP_HOST_NAME_MAX_CHAR));
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        SJctrError headErr = new SJctrError(0, 0, 0);
        SJmoWwn retWwn = new SJmoWwn();
        SJctrTextBoxDataModel txtHBAWWN = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HBAWWN);
        SJctrTextBoxDataModel txtHostName = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HOSTNAME);
        String textValue = txtHostName.getValue();
        byte[] chgWwn = retWwn.getByWWN();
        ret = this.checkHexHBAWWN(txtHBAWWN, headErr, chgWwn);
        if (ret) {
            ret = this.checkHostNameLength(textValue, headErr);
        }
        if (ret && !(ret = SJctrComUtility.isUsableChar(textValue))) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "Invalid String : " + textValue);
            headErr.setFunc(10);
            headErr.setModule(22);
            headErr.setError(ADDNEWHOST_ERR4);
        }
        if (ret) {
            retWwn.setByWWN(chgWwn);
            retWwn.setStrWWNNickName(textValue);
            ret = this.checkSameWwn(retWwn, headErr);
        }
        if (ret) {
            ret = this.checkContainsWwn(retWwn, headErr);
        }
        if (ret) {
            ret = this.checkContainsHostName(retWwn, headErr);
        }
        if (!ret) {
            SJcException exp = headErr.createException();
            throw exp;
        }
        ArrayList<SJmoWwn> outList = new ArrayList<SJmoWwn>();
        outList.add(retWwn);
        this.putCache(KEY_WWN_DIALOG_OUT, outList);
        SJctrLogUty.debug(this.getClass().getSimpleName(), "checkEndData", "return = " + ret);
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        List<SJmoWwn> targetList = this.getCache(KEY_WWN_DIALOG_IN);
        if (targetList == null || targetList.size() == 0) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "checkConstructData", "No Contact Data");
        } else {
            SJmoWwn targetWwn;
            SJctrLogUty.info(this.getClass().getSimpleName(), "checkConstructData", "List Length = " + targetList.size());
            if (this.isAllSameHBAWWN(targetList)) {
                SJctrTextBoxDataModel hbaWwn = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HBAWWN);
                targetWwn = targetList.get(0);
                hbaWwn.setValue(SJctrComUtility.toWWNDisplay(targetWwn));
            }
            if (this.isAllSameHostName(targetList)) {
                SJctrTextBoxDataModel hostName = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HOSTNAME);
                targetWwn = targetList.get(0);
                hostName.setValue(targetWwn.getStrWWNNickName());
            }
        }
        return ret;
    }

    @Override
    public void restoreControlData() {
    }

    private boolean isAllSameHBAWWN(List<SJmoWwn> targetList) {
        boolean ret = true;
        SJmoWwn base = targetList.get(0);
        String baseStr = SJctrComUtility.toWWNDisplay(base);
        for (SJmoWwn check : targetList) {
            String chkStr = SJctrComUtility.toWWNDisplay(check);
            if (baseStr.equals(chkStr)) continue;
            ret = false;
            break;
        }
        SJctrLogUty.info(this.getClass().getSimpleName(), "isAllSameHBAWWN", "return = " + ret);
        return ret;
    }

    private boolean isAllSameHostName(List<SJmoWwn> targetList) {
        boolean ret = true;
        SJmoWwn base = targetList.get(0);
        String baseStr = base.getStrWWNNickName();
        for (SJmoWwn check : targetList) {
            String chkStr = check.getStrWWNNickName();
            if (baseStr.equals(chkStr)) continue;
            ret = false;
            break;
        }
        SJctrLogUty.info(this.getClass().getSimpleName(), "isAllSameHostName", "return = " + ret);
        return ret;
    }

    private boolean checkHexHBAWWN(SJctrTextBoxDataModel txtHBAWWN, SJctrError err, byte[] wwn) {
        boolean ret = true;
        String textValue = txtHBAWWN.getValue();
        if (textValue.length() != 16) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHexHBAWWN", "Text Length Error : length = " + textValue.length());
            err.setFunc(10);
            err.setModule(22);
            err.setError(ADDNEWHOST_ERR1);
            return false;
        }
        for (int div = 0; div < textValue.length(); div += 2) {
            String subStr = textValue.substring(div, div + 2);
            try {
                wwn[div / 2] = (byte)Short.parseShort(subStr, 16);
                continue;
            }
            catch (NumberFormatException e) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHexHBAWWN", "NumberFormatException : position = " + div + " charactor = " + subStr);
                err.setFunc(10);
                err.setModule(22);
                err.setError(ADDNEWHOST_ERR2);
                return false;
            }
        }
        return ret;
    }

    private boolean checkHostNameLength(String textValue, SJctrError err) {
        boolean ret = true;
        if (textValue.length() > 64) {
            err.setFunc(10);
            err.setModule(22);
            err.setError(ADDNEWHOST_ERR3);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHostNameLength", "Host Name length = " + textValue.length());
            ret = false;
        }
        return ret;
    }

    private boolean checkSameWwn(SJmoWwn retWwn, SJctrError err) {
        boolean ret = true;
        String retWwnStr = SJctrComUtility.toWWNDisplay(retWwn);
        String retNickname = retWwn.getStrWWNNickName();
        List<?> blockWwn = this.getCache(KEY_AVAILABLE_WWN);
        if (blockWwn == null) {
            blockWwn = new ArrayList();
        }
        for (int index = 0; index < blockWwn.size(); ++index) {
            SJmoWwn wwnData = (SJmoWwn)blockWwn.get(index);
            String chkWwnId = SJctrComUtility.toWWNDisplay(wwnData);
            String chkNickName = wwnData.getStrWWNNickName();
            if (!chkWwnId.equals(retWwnStr) || !chkNickName.equals(retNickname)) continue;
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(ADDNEWHOST_ERR5);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkSameWwn", "Conflict WWN = (Byte:" + retWwnStr + ") (Nickname:" + retNickname + ")");
            break;
        }
        return ret;
    }

    private boolean checkContainsWwn(SJmoWwn retWwn, SJctrError err) {
        String retWwnStr;
        boolean ret = true;
        List<?> blockWwnList = this.getCache(KEY_BLOCK_WWNSTRING);
        if (blockWwnList == null) {
            blockWwnList = new ArrayList();
        }
        if (blockWwnList.contains(retWwnStr = SJctrComUtility.toWWNDisplay(retWwn))) {
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(ADDNEWHOST_ERR6);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkContainsWwn", "Conflict WWN = " + retWwnStr);
        }
        return ret;
    }

    private boolean checkContainsHostName(SJmoWwn retWwn, SJctrError err) {
        boolean ret = true;
        String chkNickName = retWwn.getStrWWNNickName();
        if (chkNickName.length() == 0) {
            return true;
        }
        List<?> blockNickname = this.getCache(KEY_BLOCK_NICKNAME);
        if (blockNickname == null) {
            blockNickname = new ArrayList();
        }
        if (blockNickname.contains(chkNickName)) {
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(ADDNEWHOST_ERR7);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkContainsHostName", "Conflict WWN-Nickname = " + chkNickName);
        }
        return ret;
    }
}

