/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.createaltpaths;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.comparator.SJctrIscsiNameComparator;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.comparator.SJctrWwnComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsAvailablePortsTableModel;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsConfirmData;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsPortHGInfo;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsPortITInfo;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsPortLunInfo;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsSelectHG;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsSelectIT;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsSelectedPortsTableModel;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrRsgDataModel;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilHostGrp;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilIscsiTarget;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtilHostGrp;
import sanproject.sn2.modelrc.util.SJmoRscUtilIscsiTarget;

public class SJctrCreateAltPathsDC
extends SJctrWizardDataController {
    public static final String TITLE = "DISP_DI14S_TITLE";
    protected static final int DISP_ID = 0x1100141;
    public static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_REMOVE = "COM_REMOVE";
    public static final String KEY_CONBOBOX = "COM_RSGNAME";
    public static final String KEY_PTTYPE = "COM_PTTYPE";
    private String ptType = "-1";
    public static final Class<?> KEY_CLASS_SELECT_HOST_GROUP = SJctrCreateAltPathsSelectHG.class;
    public static final Class<?> KEY_CLASS_SELECT_ISCSI_TARGET = SJctrCreateAltPathsSelectIT.class;
    public static final Class<?> KEY_CLASS_HG_UTIL = SJmoGetRscUtilHostGrp.class;
    public static final Class<?> KEY_CLASS_IT_UTIL = SJmoGetRscUtilIscsiTarget.class;
    SJctrRsgDataModel rsgDataModel = null;
    private SJmoHUVMvboxIndex ldev_VBoxIndex = null;
    private Map<Short, Integer> portSelectRsgMap = Collections.emptyMap();
    private static final int FAILD_SEARCH_HG_ID = -1;
    public static int CREATEALTPATHS_ERR1 = 107001;
    public static int CREATEALTPATHS_ERR2 = 106501;
    public static int CREATEALTPATHS_ERR3 = 106502;
    public static int CREATEALTPATHS_ERR4 = 208004;
    public static int CREATEALTPATHS_ERR5 = 105052;
    public static int CREATEALTPATHS_ERR6 = 107003;
    public static int CREATEALTPATHS_ERR7 = 105297;
    public static int CREATEALTPATHS_ERR8 = 107002;
    public static int CREATEALTPATHS_ERR9 = 105298;
    public static int CREATEALTPATHS_ERR_PORT_ATTR = 105093;
    public static int CREATEALTPATHS_ERR_SysRSG_HG = 205164;
    public static int CREATEALTPATHS_ERR_vPort = 205166;
    SJmoPortIndex orginPortIndex = null;
    SJmoHostGroupInfo orginHostGroupIndex = null;
    SJmoIscsiTargetInfo orginIscsiTargetIndex = null;
    static Comparator WWN_COMPALATER = new SJctrWwnComparator();
    static Comparator WWNNAME_COMPALATER = new Comparator(){

        public int compare(Object o1, Object o2) {
            int result = 0;
            SJmoWwn wwn1 = (SJmoWwn)o1;
            SJmoWwn wwn2 = (SJmoWwn)o2;
            result = wwn1.getStrWWNNickName().compareTo(wwn2.getStrWWNNickName());
            return result;
        }
    };
    static Comparator ISCSINAME_COMPALATER = new SJctrIscsiNameComparator();
    static Comparator ISCSINICKNAME_COMPALATER = new Comparator(){

        public int compare(Object o1, Object o2) {
            int result = 0;
            SJmoIscsiName wwn1 = (SJmoIscsiName)o1;
            SJmoIscsiName wwn2 = (SJmoIscsiName)o2;
            result = wwn1.getStrIscsiNickName().compareTo(wwn2.getStrIscsiNickName());
            return result;
        }
    };

    public SJctrCreateAltPathsDC() throws SJcException {
        super(0x1100141);
        this.initDataModel();
        this.portSelectRsgMap = new HashMap<Short, Integer>(SJctrPortUtility.PORT_MAX);
    }

    @Override
    public boolean checkStartData() {
        Object portObj = null;
        SJctrCreateAltPathsSelectHG selectHostGroup = null;
        SJctrCreateAltPathsSelectIT selectIscsiTarget = null;
        SJmoIscsiTargetInfo hostObj = null;
        List<?> targetList = this.getCache(KEY_CLASS_SELECT_HOST_GROUP);
        List<?> iscsiTargetList = this.getCache(KEY_CLASS_SELECT_ISCSI_TARGET);
        if (!(targetList != null && targetList.size() != 0 || iscsiTargetList != null && iscsiTargetList.size() != 0)) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (targetList != null && targetList.size() != 0) {
            portObj = targetList.get(0);
            if (!(portObj instanceof SJctrCreateAltPathsSelectHG)) {
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
            selectHostGroup = portObj;
            if (selectHostGroup.getAlPortHostGroup().size() == 0) {
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
            hostObj = (SJmoIscsiTargetInfo)selectHostGroup.getAlPortHostGroup().get(0);
            if (!(hostObj instanceof SJmoHostGroupInfo)) {
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
            this.orginPortIndex = selectHostGroup;
            this.orginHostGroupIndex = (SJmoHostGroupInfo)((Object)hostObj);
            this.ptType = String.valueOf(2);
        } else {
            portObj = iscsiTargetList.get(0);
            if (!(portObj instanceof SJctrCreateAltPathsSelectIT) && !(portObj instanceof SJmoPortIscsiTargetInfo)) {
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
            if (portObj instanceof SJctrCreateAltPathsSelectIT) {
                selectIscsiTarget = portObj;
            } else {
                selectIscsiTarget = new SJctrCreateAltPathsSelectIT();
                selectIscsiTarget.setAlPortIscsiTarget(((SJmoPortIscsiTargetInfo)portObj).getAlPortIscsiTarget());
                selectIscsiTarget.setSPort(((SJmoPortIscsiTargetInfo)portObj).getSPort());
            }
            if (selectIscsiTarget.getAlPortIscsiTarget().size() == 0) {
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
            hostObj = selectIscsiTarget.getAlPortIscsiTarget().get(0);
            if (!(hostObj instanceof SJmoIscsiTargetInfo)) {
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
            this.orginPortIndex = selectIscsiTarget;
            this.orginIscsiTargetIndex = hostObj;
            this.ptType = String.valueOf(5);
        }
        return true;
    }

    SJmoLdevIndex createSearchKeyLdevIndex(SJmoPortLunDetail lunDetail) {
        SJmoLdevIndex result = new SJmoLdevIndex();
        result.setSLdkc(lunDetail.getSLDKC());
        result.setSCu(lunDetail.getSCU());
        result.setSLdev(lunDetail.getSLDEV());
        return result;
    }

    @Override
    public boolean checkConstructData() {
        List<?> hgUtilList;
        BitSet bsOrgHmo;
        List<SJmoRSGgetAllRsgs> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR8);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        int portIndex = Collections.binarySearch(portDetailList, this.orginPortIndex);
        if (portIndex < 0) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR2);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(portIndex);
        SJmoPortHostGroupInfo portHostGroupInfo = null;
        List<?> portHostGroupInfoList = this.getCache(SJmoGetPortHostGroupInfo.class);
        SJmoPortIscsiTargetInfo portIscsiTargetInfo = null;
        List<?> portIscsiTargetList = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        boolean bPortCosolidationHmo = false;
        if (this.orginHostGroupIndex != null) {
            int portHostGroupIndex = Collections.binarySearch(portHostGroupInfoList, this.orginPortIndex);
            if (portHostGroupIndex < 0) {
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR2);
                SJcException exp = err.createException();
                throw exp;
            }
            portHostGroupInfo = (SJmoPortHostGroupInfo)portHostGroupInfoList.get(portHostGroupIndex);
            ArrayList hostGroupList = portHostGroupInfo.getAlPortHostGroup();
            SJmoHostGroupInfo hostGroupInfo = SJctrCreateAltPathsDC.searchHostGroup(hostGroupList, this.orginHostGroupIndex);
            if (hostGroupInfo == null) {
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR3);
                SJcException exp = err.createException();
                throw exp;
            }
            bsOrgHmo = hostGroupInfo.getBtOption();
            bPortCosolidationHmo = bsOrgHmo.get(88);
        } else if (this.orginIscsiTargetIndex != null) {
            int portIscsiTargetIndex = Collections.binarySearch(portIscsiTargetList, this.orginPortIndex);
            if (portIscsiTargetIndex < 0) {
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR2);
                SJcException exp = err.createException();
                throw exp;
            }
            portIscsiTargetInfo = (SJmoPortIscsiTargetInfo)portIscsiTargetList.get(portIscsiTargetIndex);
            ArrayList<SJmoIscsiTargetInfo> itList = portIscsiTargetInfo.getAlPortIscsiTarget();
            SJmoIscsiTargetInfo itInfo = SJctrCreateAltPathsDC.searchIscsiTarget(itList, this.orginIscsiTargetIndex);
            if (itInfo == null) {
                SJctrError err = new SJctrError(10, 22, 206521);
                SJcException exp = err.createException();
                throw exp;
            }
            bsOrgHmo = itInfo.getBtOption();
            bPortCosolidationHmo = bsOrgHmo.get(88);
        }
        ArrayList<SJmoPortIndex> selectPort = new ArrayList<SJmoPortIndex>();
        selectPort.add(this.orginPortIndex);
        ArrayList validPortList = this.checkPortAttribute(selectPort);
        if (validPortList.isEmpty()) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR_PORT_ATTR);
            SJcException exp = err.createException();
            throw exp;
        }
        int errCode = 0;
        if (this.orginHostGroupIndex != null) {
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            hgIndex.setSPort(this.orginHostGroupIndex.getSPort());
            hgIndex.setSHostGroup(this.orginHostGroupIndex.getSHostGroup());
            if (!SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil)) {
                errCode = CREATEALTPATHS_ERR7;
            } else if (rsgUtil.isSelRscHgInSysRsg(hgIndex)) {
                errCode = CREATEALTPATHS_ERR_SysRSG_HG;
            } else if (SJctrPortUtility.isHnasUserPort(portDetail)) {
                errCode = CREATEALTPATHS_ERR_vPort;
            }
        } else if (this.orginIscsiTargetIndex != null) {
            SJmoHostGroupIndex itIndex = new SJmoHostGroupIndex();
            itIndex.setSPort(this.orginIscsiTargetIndex.getSPort());
            itIndex.setSHostGroup(this.orginIscsiTargetIndex.getSIscsiTarget());
            if (!SJctrPortUtility.isRsgHostGroupIndex(itIndex, rsgUtil)) {
                errCode = CREATEALTPATHS_ERR7;
            }
        }
        if (errCode != 0) {
            SJctrError err = new SJctrError(10, 22, errCode);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> portLunList = this.getCache(SJmoGetPortLunInfo.class);
        List<?> ldevGuardList = this.getCache(SJmoGetLdevGuardInfo.class);
        int portLunIndex = Collections.binarySearch(portLunList, this.orginPortIndex);
        if (portLunIndex >= 0) {
            SJmoPortLunInfo portLunInfo = (SJmoPortLunInfo)portLunList.get(portLunIndex);
            ArrayList hostGroupLunList = null;
            hostGroupLunList = this.orginHostGroupIndex != null ? portLunInfo.getAlHostGroupLun(this.orginHostGroupIndex.getSHostGroup()) : portLunInfo.getAlHostGroupLun(this.orginIscsiTargetIndex.getSIscsiTarget());
            for (Object lunDetailObj : hostGroupLunList) {
                SJmoLdevGuardInfo ldevGuardInfo;
                byte ldevGuardStatus;
                int rsgId;
                boolean rsgLdevFlg;
                SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)lunDetailObj;
                SJmoLdevIndex ldevIndex = this.createSearchKeyLdevIndex(lunDetail);
                if (this.ldev_VBoxIndex == null && !bPortCosolidationHmo) {
                    SJmoRSGInfo rsgInfo = rsgUtil.getRsgFromLdev(ldevIndex).getRsgInfo();
                    this.ldev_VBoxIndex = rsgInfo.getVboxIndex();
                }
                if (!(rsgLdevFlg = SJctrPortUtility.chkResourceGroup(rsgId = rsgUtil.getRsgId(ldevIndex), rsgUtil))) {
                    SJctrLogUty.info(this.getClass().getSimpleName(), "checkConstructData", "Extract Impossible Ldev RSG ID = " + rsgId);
                    SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR9);
                    SJcException exp = err.createException();
                    throw exp;
                }
                int ldevGuardIndex = Collections.binarySearch(ldevGuardList, ldevIndex);
                if (ldevGuardIndex < 0 || ((ldevGuardStatus = (ldevGuardInfo = (SJmoLdevGuardInfo)ldevGuardList.get(ldevGuardIndex)).getByLdevGuardStatus()) & 0xFFFFFF80) != -128 || (ldevGuardStatus & 8) != 8) continue;
                SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR4);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        if ((hgUtilList = this.getCache(KEY_CLASS_HG_UTIL)) == null || hgUtilList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR6);
            SJcException exp = err.createException();
            throw exp;
        }
        this.rsgDataModel = (SJctrRsgDataModel)this.getDataObjectModel(KEY_CONBOBOX);
        Map<String, Integer> rsgConboMap = this.getRsgConboData(rsgUtil, rsgDetailList);
        this.createRsgConboBox(rsgConboMap);
        ArrayList targetList = new ArrayList();
        this.putCache("KEY_TARGET_PORT_INFO", targetList);
        return true;
    }

    private Map<String, Integer> getRsgConboData(SJctrResourceGroupUtility rsgUtil, List<SJmoRSGgetAllRsgs> rsgDetailList) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        List<SJmoRSGgetRsg> rsgList = rsgUtil.extractRsg();
        SJctrComUtility comUtil = this.getComUtility();
        for (SJmoRSGgetRsg rsg : rsgList) {
            SJmoRSGInfo rsgInfo = rsg.getRsgInfo();
            if (SJctrRsgUtility.isSysRsg(rsgInfo)) continue;
            int rsgId = rsgInfo.getRsgId();
            String conboStr = SJctrRsgUtility.toRsgIdDisplay(comUtil, rsgInfo);
            resultMap.put(conboStr, rsgId);
        }
        return resultMap;
    }

    private void createRsgConboBox(Map<String, Integer> rsgConboMap) {
        ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(rsgConboMap.entrySet());
        Collections.sort(entries, new Comparator(){

            public int compare(Object rsgMap1, Object rsgMap2) {
                Map.Entry rsg1 = (Map.Entry)rsgMap1;
                Map.Entry rsg2 = (Map.Entry)rsgMap2;
                return ((Integer)rsg1.getValue()).compareTo((Integer)rsg2.getValue());
            }
        });
        this.rsgDataModel.addItem("Any");
        for (Map.Entry entry : entries) {
            this.rsgDataModel.addItem((String)entry.getKey());
        }
        this.rsgDataModel.setRsgMap(rsgConboMap);
        this.rsgDataModel.setSelection("Any");
    }

    @Override
    public boolean checkEndData() {
        List<?> selectedList = this.getCache("KEY_TARGET_PORT_INFO");
        if (selectedList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR5);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrComUtility comUtil = this.getComUtility();
        SJctrPortUtility portUtil = comUtil.getPortUtility();
        portUtil.checkPortSecurityMsg(selectedList, this);
        return true;
    }

    public void createAltPathsData() {
        List<SJmoRSGgetAllRsgs> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR6);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        List<?> selectedList = this.getCache("KEY_TARGET_PORT_INFO");
        List<?> portHostGroupList = this.getCache(SJmoGetPortHostGroupInfo.class);
        SJmoHostGroupInfo orginHostGroupInfo = null;
        int index = Collections.binarySearch(portHostGroupList, this.orginPortIndex);
        if (index >= 0) {
            SJmoPortHostGroupInfo orginPortHostGroupInfo = (SJmoPortHostGroupInfo)portHostGroupList.get(index);
            orginHostGroupInfo = SJctrCreateAltPathsDC.searchHostGroup(orginPortHostGroupInfo.getAlPortHostGroup(), this.orginHostGroupIndex);
        }
        ArrayList<SJctrCreateAltPathsPortHGInfo> createPortHostList = new ArrayList<SJctrCreateAltPathsPortHGInfo>(selectedList.size());
        if (orginHostGroupInfo == null || selectedList.size() == 0) {
            this.getLogUty().putlog("createAltPathsData", "Original HostGroup not found");
            this.putCache(SJctrCreateAltPathsConfirmData.class, new ArrayList());
            return;
        }
        this.resetRscUtil();
        List<?> hgUtilList = this.getCache(KEY_CLASS_HG_UTIL);
        SJmoRscUtilHostGrp rscHG = null;
        if (hgUtilList == null || hgUtilList.size() == 0) {
            this.getLogUty().putlog("createAltPathsData", "Resource Utility not found");
            this.putCache(SJctrCreateAltPathsConfirmData.class, new ArrayList());
            return;
        }
        rscHG = (SJmoRscUtilHostGrp)hgUtilList.get(0);
        ArrayList<SJmoHostGroupInfo> rscAddHGList = new ArrayList<SJmoHostGroupInfo>(selectedList.size());
        rscHG.clearRsvData();
        for (Object selectedPortObj : selectedList) {
            SJmoPortDetail selectedPort = (SJmoPortDetail)selectedPortObj;
            this.getLogUty().putlog("createAltPathsData", "port:" + selectedPort.getSPort(), null, 10000);
            SJctrCreateAltPathsPortHGInfo createPortHost = new SJctrCreateAltPathsPortHGInfo();
            createPortHost.setSPort(selectedPort.getSPort());
            SJmoHostGroupInfo createHostGroupInfo = null;
            try {
                createHostGroupInfo = (SJmoHostGroupInfo)orginHostGroupInfo.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("createAltPathsData", "HostGroupInfo clone fail", e, 40000);
                continue;
            }
            short newHostGroupID = this.getNewHostGroupID(selectedPort, rscHG, rsgUtil);
            if (newHostGroupID < 0) continue;
            this.getLogUty().putlog("createAltPathsData", "new hostGroupID:" + newHostGroupID, null, 10000);
            createHostGroupInfo.setSHostGroup(newHostGroupID);
            ArrayList<SJmoHostGroupInfo> hostGroupList = new ArrayList<SJmoHostGroupInfo>();
            hostGroupList.add(createHostGroupInfo);
            createPortHost.setAlPortHostGroup(hostGroupList);
            createHostGroupInfo.setSPort(selectedPort.getSPort());
            createHostGroupInfo.setIDataMode(2);
            rscAddHGList.add(createHostGroupInfo);
            createPortHostList.add(createPortHost);
        }
        ArrayList<ArrayList<SJmoHostGroupInfo>> addHGList = new ArrayList<ArrayList<SJmoHostGroupInfo>>();
        addHGList.add(rscAddHGList);
        rscHG.setRsvData(addHGList);
        Collections.sort(createPortHostList);
        ArrayList<SJctrCreateAltPathsPortLunInfo> createPortLunList = new ArrayList<SJctrCreateAltPathsPortLunInfo>(1);
        SJctrCreateAltPathsPortLunInfo createPortLunInfo = new SJctrCreateAltPathsPortLunInfo();
        createPortLunInfo.setSPort(this.orginPortIndex.getSPort());
        List<?> portLunList = this.getCache(SJmoGetPortLunInfo.class);
        int lunIndex = Collections.binarySearch(portLunList, this.orginPortIndex);
        if (lunIndex >= 0) {
            SJmoPortLunInfo orginPortLunInfo = null;
            orginPortLunInfo = (SJmoPortLunInfo)portLunList.get(lunIndex);
            ArrayList orginLunList = orginPortLunInfo.getAlHostGroupLun(orginHostGroupInfo.getSHostGroup());
            try {
                createPortLunInfo.setAlPortLun(orginLunList);
            }
            catch (SJmoException e) {
                this.getLogUty().putlog("createAltPathsData", "set LunDetailList", e, 40000);
            }
        }
        createPortLunList.add(createPortLunInfo);
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        ArrayList<SJmoPortDetail> confirmPortDetailList = new ArrayList<SJmoPortDetail>(createPortHostList.size());
        for (SJctrCreateAltPathsPortHGInfo createPortHost : createPortHostList) {
            int portIndex = Collections.binarySearch(portDetailList, createPortHost);
            if (portIndex < 0) continue;
            SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(portIndex);
            confirmPortDetailList.add(portDetail);
        }
        Collections.sort(confirmPortDetailList);
        List<?> portAttList = this.getCache(SJmoGetPortAttributeInfo.class);
        ArrayList<SJmoPortAttributeInfo> confirmPortAttList = new ArrayList<SJmoPortAttributeInfo>(createPortHostList.size());
        for (SJctrCreateAltPathsPortHGInfo createPortHost : createPortHostList) {
            int portIndex = Collections.binarySearch(portAttList, createPortHost);
            if (portIndex < 0) continue;
            SJmoPortAttributeInfo portAtt = (SJmoPortAttributeInfo)portAttList.get(portIndex);
            confirmPortAttList.add(portAtt);
        }
        Collections.sort(confirmPortAttList);
        List<SJmoLdevDetail> ldevDetailList = this.getCache(SJmoGetLdevDetail.class);
        List<SJmoLdevLuseInfo> luseInfoList = this.getCache(SJmoGetLdevLuseInfo.class);
        ArrayList orginLunList = createPortLunInfo.getAlPortLun();
        ArrayList<SJmoLdevDetail> confirmLdevDetailList = new ArrayList<SJmoLdevDetail>(orginLunList.size());
        for (Object lunDetailObj : orginLunList) {
            SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)lunDetailObj;
            SJmoLdevDetail ldev = new SJmoLdevDetail();
            ldev.setLdevIndex(lunDetail.getSLDKC(), lunDetail.getSCU(), lunDetail.getSLDEV());
            int ldevIndex = Collections.binarySearch(ldevDetailList, ldev);
            if (ldevIndex < 0) continue;
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(ldevIndex);
            SJmoLdevDetail createLdevDetail = null;
            try {
                createLdevDetail = (SJmoLdevDetail)ldevDetail.clone();
            }
            catch (Exception e) {
                this.getLogUty().putlog("createAltPathsData", "SJmoLdevDetail clone fail", e, 20000);
                continue;
            }
            int luPathNumber = createLdevDetail.getILUPathNumber();
            createLdevDetail.setILUPathNumber(luPathNumber += createPortHostList.size());
            confirmLdevDetailList.add(createLdevDetail);
        }
        Collections.sort(confirmLdevDetailList);
        List<?> ldevNickList = this.getCache(SJmoGetLdevNicknameInfo.class);
        orginLunList = createPortLunInfo.getAlPortLun();
        ArrayList<SJmoLdevNicknameInfo> confirmLdevNickList = new ArrayList<SJmoLdevNicknameInfo>(orginLunList.size());
        for (Object lunDetailObj : orginLunList) {
            SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)lunDetailObj;
            SJmoLdevNicknameInfo ldev = new SJmoLdevNicknameInfo();
            ldev.setLdevIndex(lunDetail.getSLDKC(), lunDetail.getSCU(), lunDetail.getSLDEV());
            int ldevIndex = Collections.binarySearch(ldevNickList, ldev);
            if (ldevIndex < 0) continue;
            SJmoLdevNicknameInfo ldevNickname = (SJmoLdevNicknameInfo)ldevNickList.get(ldevIndex);
            SJmoLdevNicknameInfo createLdevNick = null;
            try {
                createLdevNick = (SJmoLdevNicknameInfo)ldevNickname.clone();
            }
            catch (Exception e) {
                this.getLogUty().putlog("createAltPathsData", "SJmoLdevNicknameInfo clone fail", e, 20000);
                continue;
            }
            confirmLdevNickList.add(createLdevNick);
        }
        Collections.sort(confirmLdevNickList);
        List<SJctrLdevDetailLUSEInfo> confirmLdevDetailLuseList = SJctrLdevUtility.getLdevDetailLUListSEInfoList(confirmLdevDetailList, ldevDetailList, luseInfoList);
        SJctrCreateAltPathsConfirmData confirmData = new SJctrCreateAltPathsConfirmData();
        confirmData.setPortHGList(createPortHostList);
        confirmData.setPortLunList(createPortLunList);
        confirmData.setPortDetailList(confirmPortDetailList);
        confirmData.setPortAttributeList(confirmPortAttList);
        confirmData.setLdevDetailList(confirmLdevDetailLuseList);
        confirmData.setLdevNickList(confirmLdevNickList);
        confirmData.setAllRsgList(rsgDetailList);
        ArrayList<SJmoRscUtilHostGrp> rscDataList = new ArrayList<SJmoRscUtilHostGrp>();
        rscDataList.add(rscHG);
        this.putCache(KEY_CLASS_HG_UTIL, rscDataList);
        ArrayList<SJctrCreateAltPathsConfirmData> confirmDataList = new ArrayList<SJctrCreateAltPathsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrCreateAltPathsConfirmData.class, confirmDataList);
    }

    public void createAltIscsiPathsData() {
        List<SJmoRSGgetAllRsgs> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR6);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        List<?> selectedList = this.getCache("KEY_TARGET_PORT_INFO");
        if (selectedList == null || selectedList.size() == 0) {
            this.getLogUty().putlog("createAltPathsData", "Selected ports is nothing.");
            this.putCache(SJctrCreateAltPathsConfirmData.class, new ArrayList());
            return;
        }
        List<?> portIscsiTargetList = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        SJmoIscsiTargetInfo orginIscsiTargetInfo = null;
        int index = Collections.binarySearch(portIscsiTargetList, this.orginPortIndex);
        if (index >= 0) {
            SJmoPortIscsiTargetInfo orginPortIscsiTargetInfo = (SJmoPortIscsiTargetInfo)portIscsiTargetList.get(index);
            orginIscsiTargetInfo = SJctrCreateAltPathsDC.searchIscsiTarget(orginPortIscsiTargetInfo.getAlPortIscsiTarget(), this.orginIscsiTargetIndex);
        }
        if (orginIscsiTargetInfo == null) {
            this.getLogUty().putlog("createAltPathsData", "Original IscsiTarget not found.");
            this.putCache(SJctrCreateAltPathsConfirmData.class, new ArrayList());
            return;
        }
        ArrayList<SJctrCreateAltPathsPortITInfo> createPortIscsiList = new ArrayList<SJctrCreateAltPathsPortITInfo>(selectedList.size());
        this.resetRscUtil();
        List<?> itUtilList = this.getCache(KEY_CLASS_IT_UTIL);
        SJmoRscUtilIscsiTarget rscIT = null;
        if (itUtilList == null || itUtilList.size() == 0) {
            this.getLogUty().putlog("createAltPathsData", "Resource Utility not found");
            this.putCache(SJctrCreateAltPathsConfirmData.class, new ArrayList());
            return;
        }
        rscIT = (SJmoRscUtilIscsiTarget)itUtilList.get(0);
        ArrayList<SJmoIscsiTargetInfo> rscAddITList = new ArrayList<SJmoIscsiTargetInfo>(selectedList.size());
        rscIT.clearRsvData();
        for (Object selectedPortObj : selectedList) {
            SJmoPortDetail selectedPort = (SJmoPortDetail)selectedPortObj;
            this.getLogUty().putlog("createAltPathsData", "port:" + selectedPort.getSPort(), null, 10000);
            SJctrCreateAltPathsPortITInfo createPortIscsi = new SJctrCreateAltPathsPortITInfo();
            createPortIscsi.setSPort(selectedPort.getSPort());
            SJmoIscsiTargetInfo createIscsiTargetInfo = null;
            try {
                createIscsiTargetInfo = (SJmoIscsiTargetInfo)orginIscsiTargetInfo.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("createAltPathsData", "IscsiTargetInfo clone fail", e, 40000);
                continue;
            }
            short newIscsiTargetID = this.getNewIscsiTargetID(selectedPort, rscIT, rsgUtil);
            if (newIscsiTargetID < 0) continue;
            this.getLogUty().putlog("createAltPathsData", "new IscsiTargetID:" + newIscsiTargetID, null, 10000);
            createIscsiTargetInfo.setSIscsiTarget(newIscsiTargetID);
            ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = new ArrayList<SJmoIscsiTargetInfo>();
            iscsiTargetList.add(createIscsiTargetInfo);
            createPortIscsi.setAlPortIscsiTarget(iscsiTargetList);
            createIscsiTargetInfo.setSPort(selectedPort.getSPort());
            createIscsiTargetInfo.setIDataMode(2);
            rscAddITList.add(createIscsiTargetInfo);
            createPortIscsiList.add(createPortIscsi);
        }
        ArrayList<ArrayList<SJmoIscsiTargetInfo>> addITList = new ArrayList<ArrayList<SJmoIscsiTargetInfo>>();
        addITList.add(rscAddITList);
        rscIT.setRsvData(addITList);
        Collections.sort(createPortIscsiList);
        ArrayList<SJctrCreateAltPathsPortLunInfo> createPortLunList = new ArrayList<SJctrCreateAltPathsPortLunInfo>(1);
        SJctrCreateAltPathsPortLunInfo createPortLunInfo = new SJctrCreateAltPathsPortLunInfo();
        createPortLunInfo.setSPort(this.orginPortIndex.getSPort());
        List<?> portLunList = this.getCache(SJmoGetPortLunInfo.class);
        int lunIndex = Collections.binarySearch(portLunList, this.orginPortIndex);
        if (lunIndex >= 0) {
            SJmoPortLunInfo orginPortLunInfo = null;
            orginPortLunInfo = (SJmoPortLunInfo)portLunList.get(lunIndex);
            ArrayList orginLunList = orginPortLunInfo.getAlHostGroupLun(orginIscsiTargetInfo.getSIscsiTarget());
            try {
                createPortLunInfo.setAlPortLun(orginLunList);
            }
            catch (SJmoException e) {
                this.getLogUty().putlog("createAltPathsData", "set LunDetailList", e, 40000);
            }
        }
        createPortLunList.add(createPortLunInfo);
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        ArrayList<SJmoPortDetail> confirmPortDetailList = new ArrayList<SJmoPortDetail>(createPortIscsiList.size());
        for (SJctrCreateAltPathsPortITInfo createPortIscsi : createPortIscsiList) {
            int portIndex = Collections.binarySearch(portDetailList, createPortIscsi);
            if (portIndex < 0) continue;
            SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(portIndex);
            confirmPortDetailList.add(portDetail);
        }
        Collections.sort(confirmPortDetailList);
        List<?> portAttList = this.getCache(SJmoGetPortAttributeInfo.class);
        ArrayList<SJmoPortAttributeInfo> confirmPortAttList = new ArrayList<SJmoPortAttributeInfo>(createPortIscsiList.size());
        for (SJctrCreateAltPathsPortITInfo createPortIscsi : createPortIscsiList) {
            int portIndex = Collections.binarySearch(portAttList, createPortIscsi);
            if (portIndex < 0) continue;
            SJmoPortAttributeInfo portAtt = (SJmoPortAttributeInfo)portAttList.get(portIndex);
            confirmPortAttList.add(portAtt);
        }
        Collections.sort(confirmPortAttList);
        List<SJmoLdevDetail> ldevDetailList = this.getCache(SJmoGetLdevDetail.class);
        List<SJmoLdevLuseInfo> luseInfoList = this.getCache(SJmoGetLdevLuseInfo.class);
        ArrayList orginLunList = createPortLunInfo.getAlPortLun();
        ArrayList<SJmoLdevDetail> confirmLdevDetailList = new ArrayList<SJmoLdevDetail>(orginLunList.size());
        for (Object lunDetailObj : orginLunList) {
            SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)lunDetailObj;
            SJmoLdevDetail ldev = new SJmoLdevDetail();
            ldev.setLdevIndex(lunDetail.getSLDKC(), lunDetail.getSCU(), lunDetail.getSLDEV());
            int ldevIndex = Collections.binarySearch(ldevDetailList, ldev);
            if (ldevIndex < 0) continue;
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(ldevIndex);
            SJmoLdevDetail createLdevDetail = null;
            try {
                createLdevDetail = (SJmoLdevDetail)ldevDetail.clone();
            }
            catch (Exception e) {
                this.getLogUty().putlog("createAltPathsData", "SJmoLdevDetail clone fail", e, 20000);
                continue;
            }
            int luPathNumber = createLdevDetail.getILUPathNumber();
            createLdevDetail.setILUPathNumber(luPathNumber += createPortIscsiList.size());
            confirmLdevDetailList.add(createLdevDetail);
        }
        Collections.sort(confirmLdevDetailList);
        List<?> ldevNickList = this.getCache(SJmoGetLdevNicknameInfo.class);
        orginLunList = createPortLunInfo.getAlPortLun();
        ArrayList<SJmoLdevNicknameInfo> confirmLdevNickList = new ArrayList<SJmoLdevNicknameInfo>(orginLunList.size());
        for (Object lunDetailObj : orginLunList) {
            SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)lunDetailObj;
            SJmoLdevNicknameInfo ldev = new SJmoLdevNicknameInfo();
            ldev.setLdevIndex(lunDetail.getSLDKC(), lunDetail.getSCU(), lunDetail.getSLDEV());
            int ldevIndex = Collections.binarySearch(ldevNickList, ldev);
            if (ldevIndex < 0) continue;
            SJmoLdevNicknameInfo ldevNickname = (SJmoLdevNicknameInfo)ldevNickList.get(ldevIndex);
            SJmoLdevNicknameInfo createLdevNick = null;
            try {
                createLdevNick = (SJmoLdevNicknameInfo)ldevNickname.clone();
            }
            catch (Exception e) {
                this.getLogUty().putlog("createAltPathsData", "SJmoLdevNicknameInfo clone fail", e, 20000);
                continue;
            }
            confirmLdevNickList.add(createLdevNick);
        }
        Collections.sort(confirmLdevNickList);
        List<SJctrLdevDetailLUSEInfo> confirmLdevDetailLuseList = SJctrLdevUtility.getLdevDetailLUListSEInfoList(confirmLdevDetailList, ldevDetailList, luseInfoList);
        SJctrCreateAltPathsConfirmData confirmData = new SJctrCreateAltPathsConfirmData();
        confirmData.setPortITList(createPortIscsiList);
        confirmData.setPortLunList(createPortLunList);
        confirmData.setPortDetailList(confirmPortDetailList);
        confirmData.setPortAttributeList(confirmPortAttList);
        confirmData.setLdevDetailList(confirmLdevDetailLuseList);
        confirmData.setLdevNickList(confirmLdevNickList);
        confirmData.setAllRsgList(rsgDetailList);
        ArrayList<SJmoRscUtilIscsiTarget> rscDataList = new ArrayList<SJmoRscUtilIscsiTarget>();
        rscDataList.add(rscIT);
        this.putCache(KEY_CLASS_IT_UTIL, rscDataList);
        ArrayList<SJctrCreateAltPathsConfirmData> confirmDataList = new ArrayList<SJctrCreateAltPathsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrCreateAltPathsConfirmData.class, confirmDataList);
    }

    short getNewHostGroupID(SJmoPortDetail portDetail, SJmoRscUtilHostGrp rscutilhg, SJctrResourceGroupUtility rsgUtil) {
        List<?> portHostGroupList = this.getCache(SJmoGetPortHostGroupInfo.class);
        BitSet hostGroupIDSet = new BitSet(SJctrPortUtility.PORT_HOSTGROUP_MAX);
        int index = Collections.binarySearch(portHostGroupList, portDetail);
        SJmoPortHostGroupInfo portHostGroup = null;
        if (index >= 0) {
            portHostGroup = (SJmoPortHostGroupInfo)portHostGroupList.get(index);
            for (Object hostGroupInfoObj : portHostGroup.getAlPortHostGroup()) {
                SJmoHostGroupInfo hostGroupInfo = (SJmoHostGroupInfo)hostGroupInfoObj;
                hostGroupIDSet.set(hostGroupInfo.getSHostGroup());
            }
        } else {
            return -1;
        }
        int newHostGroupID = 0;
        int chkHgId = 3;
        short sPort = portDetail.getSPort();
        boolean loopFlg = false;
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        int selectRsg = -1;
        Integer getValue = this.portSelectRsgMap.get(sPort);
        if (getValue != null) {
            selectRsg = getValue;
        }
        while (!loopFlg && newHostGroupID < SJctrPortUtility.PORT_HOSTGROUP_MAX) {
            if ((newHostGroupID = (int)((short)hostGroupIDSet.nextClearBit(newHostGroupID))) >= SJctrPortUtility.PORT_HOSTGROUP_MAX) continue;
            hgIndex.setSPort(sPort);
            hgIndex.setSHostGroup((short)newHostGroupID);
            int rsgId = rsgUtil.getRsgId(hgIndex);
            if (selectRsg == -1 || rsgId == selectRsg) {
                loopFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
                chkHgId = rscutilhg.chkHostGrpID(portHostGroup.getSPort(), (short)newHostGroupID);
                if ((loopFlg &= chkHgId == 0) && this.ldev_VBoxIndex != null) {
                    SJmoHUVMvboxIndex vVoxIndex;
                    SJmoRSGgetRsg hg_rsgGetInfo = rsgUtil.getRsgFromHg(hgIndex);
                    loopFlg = hg_rsgGetInfo == null ? false : (loopFlg &= this.ldev_VBoxIndex.compareTo(vVoxIndex = hg_rsgGetInfo.getRsgInfo().getVboxIndex()) == 0);
                }
            } else {
                loopFlg = false;
            }
            if (loopFlg) continue;
            ++newHostGroupID;
        }
        if (newHostGroupID >= SJctrPortUtility.PORT_HOSTGROUP_MAX) {
            this.getLogUty().putlog("getNewHostGroupID", "Port=" + portDetail.getSPort() + " : HostGroup Limit Exceeded :" + newHostGroupID, null, 30000);
            newHostGroupID = -1;
        }
        return (short)newHostGroupID;
    }

    short getNewIscsiTargetID(SJmoPortDetail portDetail, SJmoRscUtilIscsiTarget rscUtilIt, SJctrResourceGroupUtility rsgUtil) {
        List<?> portIscsiTargetList = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        BitSet iscsiTargetIDSet = new BitSet(SJctrPortUtility.PORT_ISCSITARGET_MAX);
        int index = Collections.binarySearch(portIscsiTargetList, portDetail);
        SJmoPortIscsiTargetInfo portIscsiTarget = null;
        if (index >= 0) {
            portIscsiTarget = (SJmoPortIscsiTargetInfo)portIscsiTargetList.get(index);
            Iterator<SJmoIscsiTargetInfo> i$ = portIscsiTarget.getAlPortIscsiTarget().iterator();
            while (i$.hasNext()) {
                SJmoIscsiTargetInfo iscsiTargetInfoObj;
                SJmoIscsiTargetInfo iscsiTargetInfo = iscsiTargetInfoObj = i$.next();
                iscsiTargetIDSet.set(iscsiTargetInfo.getSIscsiTarget());
            }
        } else {
            return -1;
        }
        int newIscsiTargetID = 0;
        int chkItId = 3;
        short sPort = portDetail.getSPort();
        boolean loopFlg = true;
        SJmoIscsiTargetIndex itIndex = new SJmoIscsiTargetIndex();
        while (loopFlg && newIscsiTargetID < SJctrPortUtility.PORT_ISCSITARGET_MAX) {
            if ((newIscsiTargetID = (int)((short)iscsiTargetIDSet.nextClearBit(newIscsiTargetID))) >= SJctrPortUtility.PORT_ISCSITARGET_MAX) continue;
            itIndex.setSPort(sPort);
            itIndex.setSIscsiTarget((short)newIscsiTargetID);
            int rsgId = rsgUtil.getRsgId(itIndex);
            loopFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
            chkItId = rscUtilIt.chkIscsiTargetID(portIscsiTarget.getSPort(), (short)newIscsiTargetID);
            if (!(loopFlg &= chkItId == 0)) continue;
            ++newIscsiTargetID;
        }
        if (newIscsiTargetID >= SJctrPortUtility.PORT_ISCSITARGET_MAX) {
            this.getLogUty().putlog("getNewIscsiTargetID", "Port=" + portDetail.getSPort() + " : IscsiTarget Limit Exceeded :" + newIscsiTargetID, null, 30000);
            newIscsiTargetID = -1;
        }
        return (short)newIscsiTargetID;
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance("LUNM", TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_CONBOBOX, new SJctrRsgDataModel());
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrCreateAltPathsAvailablePortsTableModel());
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrCreateAltPathsSelectedPortsTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
        SJctrButtonDataModel add = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrCreateAltPathsDC.this.addAction();
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_ADD, add);
        SJctrButtonDataModel remove = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrCreateAltPathsDC.this.removeAction();
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_REMOVE, remove);
        this.addDataObjectModel("COM_DIRECT", new SJctrSimpleDataModel(){
            {
                this.setReceiveOnly();
            }

            @Override
            public List<SJctrGetDirectWrapper> createModelDirect() {
                List<SJctrGetDirectWrapper> directList = super.createModelDirect();
                SJctrCreateAltPathsDC dc = (SJctrCreateAltPathsDC)this.getDataController();
                List<SJctrGetDirectWrapper> dcDirectList = dc.createModelDirect();
                directList.addAll(dcDirectList);
                return directList;
            }
        });
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrDataObject mgrData = this.getManageData();
        mgrData.setData(KEY_PTTYPE, this.ptType);
    }

    private void addAction() {
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<Object> list = avaliableTable.removeSelectedRowData();
        int selectRsg = this.rsgDataModel.getSelectionRsgId();
        for (Object selData : list) {
            SJmoPortDetail portDtl = (SJmoPortDetail)selData;
            this.portSelectRsgMap.put(portDtl.getSPort(), selectRsg);
        }
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        selectedTable.addRowDataTop(list);
        List<Object> okList = list;
        List<?> targetList = this.getCache("KEY_TARGET_PORT_INFO");
        okList.addAll(targetList);
        Collections.sort(okList);
        this.putCache("KEY_TARGET_PORT_INFO", okList);
        this.updateFooter();
    }

    private void removeAction() {
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> selectlist = selectedTable.removeSelectedRowData();
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR6);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        ArrayList<SJmoPortDetail> list = new ArrayList<SJmoPortDetail>(selectlist.size());
        for (Object selectData : selectlist) {
            boolean rsgFlg = this.getRemoveHgId((SJmoPortDetail)selectData, rsgUtil);
            boolean rsgItFlg = this.getRemoveItId((SJmoPortDetail)selectData, rsgUtil);
            if (rsgFlg || rsgItFlg) {
                list.add((SJmoPortDetail)selectData);
            }
            SJmoPortDetail portDtl = (SJmoPortDetail)selectData;
            this.portSelectRsgMap.remove(portDtl.getSPort());
        }
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        avaliableTable.addRowDataTop(list);
        List<Object> delList = selectlist;
        ArrayList targetList = new ArrayList(this.getCache("KEY_TARGET_PORT_INFO"));
        Collections.sort(delList);
        for (int i = delList.size() - 1; i >= 0; --i) {
            SJmoPortDetail key = (SJmoPortDetail)delList.get(i);
            int index = Collections.binarySearch(targetList, key);
            if (index >= 0) {
                targetList.remove(index);
                continue;
            }
            this.logUty.putlog("REMOVE Action", "Not found from cache list: " + key);
        }
        this.putCache("KEY_TARGET_PORT_INFO", targetList);
        this.updateFooter();
    }

    public List<SJctrGetDirectWrapper> createModelDirect() {
        ArrayList<SJctrGetDirectWrapper> directList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevGuardInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRscUtilIscsiTarget();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        directList.add(new SJctrGetDirectWrapper(direct));
        return directList;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetRscUtilHostGrp kind = new SJmoGetRscUtilHostGrp();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    static SJmoHostGroupInfo searchHostGroup(List hostGroupList, SJmoHostGroupInfo key) {
        SJmoHostGroupInfo result = null;
        for (Object hostGroupInfoObj : hostGroupList) {
            SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)hostGroupInfoObj;
            if (hgInfo.getSHostGroup() != key.getSHostGroup()) continue;
            result = hgInfo;
            break;
        }
        return result;
    }

    static SJmoIscsiTargetInfo searchIscsiTarget(List iscsiTargetList, SJmoIscsiTargetInfo key) {
        SJmoIscsiTargetInfo result = null;
        for (Object hostGroupInfoObj : iscsiTargetList) {
            SJmoIscsiTargetInfo itInfo = (SJmoIscsiTargetInfo)hostGroupInfoObj;
            if (!itInfo.getStrIscsiTargetAlias().equals(key.getStrIscsiTargetAlias())) continue;
            result = itInfo;
            break;
        }
        return result;
    }

    ArrayList<Object> getAvailableTableData() {
        List<?> portHostGroupList = this.getCache(SJmoGetPortHostGroupInfo.class);
        if (portHostGroupList == null || portHostGroupList.size() == 0) {
            this.getLogUty().putlog("getAvailableTableData", "SJmoGetPortHostGroupInfo is empty");
            return new ArrayList<Object>();
        }
        int index = Collections.binarySearch(portHostGroupList, this.orginPortIndex);
        if (index < 0) {
            this.getLogUty().putlog("getAvailableTableData", "OriginalPort not found:Port=" + this.orginPortIndex.getSPort());
            return new ArrayList<Object>();
        }
        SJmoPortHostGroupInfo orginPortHostGroupInfo = (SJmoPortHostGroupInfo)portHostGroupList.get(index);
        SJmoHostGroupInfo orginHostGroupInfo = SJctrCreateAltPathsDC.searchHostGroup(orginPortHostGroupInfo.getAlPortHostGroup(), this.orginHostGroupIndex);
        if (orginHostGroupInfo == null) {
            this.getLogUty().putlog("getAvailableTableData", "OriginalHostGroup not found:Port=" + this.orginPortIndex.getSPort() + ",HostGroup=" + this.orginHostGroupIndex.getSHostGroup());
            return new ArrayList<Object>();
        }
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        ArrayList retList = new ArrayList(portDetailList);
        retList = this.checkPort(retList, this.orginPortIndex);
        retList = this.checkIscsiPort(retList);
        retList = this.checkPortAttribute(retList);
        retList = this.checkPortHostGroup(retList, this.orginPortIndex, orginHostGroupInfo);
        retList = this.checkPortLuPath(retList, this.orginPortIndex, orginHostGroupInfo);
        retList = this.checkSelectPort(retList);
        retList = this.checkHnasUserPort(retList);
        retList = this.checkLDEV(retList, this.orginPortIndex, orginHostGroupInfo);
        return retList;
    }

    ArrayList<Object> getAvailableIscsiTableData() {
        List<?> portIscsiTargetList = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        if (portIscsiTargetList == null || portIscsiTargetList.size() == 0) {
            this.getLogUty().putlog("getAvailableTableData", "SJmoGetPortIscsiTargetInfo is empty");
            return new ArrayList<Object>();
        }
        int index = Collections.binarySearch(portIscsiTargetList, this.orginPortIndex);
        if (index < 0) {
            this.getLogUty().putlog("getAvailableTableData", "OriginalPort not found:Port=" + this.orginPortIndex.getSPort());
            return new ArrayList<Object>();
        }
        SJmoPortIscsiTargetInfo orginPortIscsiTargetInfo = (SJmoPortIscsiTargetInfo)portIscsiTargetList.get(index);
        SJmoIscsiTargetInfo orginIscsiTargetInfo = SJctrCreateAltPathsDC.searchIscsiTarget(orginPortIscsiTargetInfo.getAlPortIscsiTarget(), this.orginIscsiTargetIndex);
        if (orginIscsiTargetInfo == null) {
            this.getLogUty().putlog("getAvailableTableData", "OriginalIscsiTarget not found:Port=" + this.orginPortIndex.getSPort() + ",IscsiTarget=" + this.orginIscsiTargetIndex.getSIscsiTarget());
            return new ArrayList<Object>();
        }
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        ArrayList retList = new ArrayList(portDetailList);
        retList = this.checkPort(retList, this.orginPortIndex);
        retList = this.checkNonIscsiPort(retList);
        retList = this.checkPortAttribute(retList);
        retList = this.checkPortIscsiTarget(retList, this.orginPortIndex, orginIscsiTargetInfo);
        SJmoHostGroupInfo hgInfo = new SJmoHostGroupInfo();
        hgInfo.setSHostGroup(orginIscsiTargetInfo.getSIscsiTarget());
        retList = this.checkPortLuPath(retList, this.orginPortIndex, hgInfo);
        retList = this.checkSelectPort(retList);
        return retList;
    }

    ArrayList checkPort(ArrayList portDetailList, SJmoPortIndex orginPortIndex) {
        ArrayList result = new ArrayList(portDetailList);
        int index = Collections.binarySearch(result, orginPortIndex);
        if (index >= 0) {
            result.remove(index);
        }
        return result;
    }

    ArrayList checkNonIscsiPort(ArrayList retList) {
        for (int index = retList.size() - 1; index >= 0; --index) {
            byte portKindNo = ((SJmoPortDetail)retList.get(index)).getByPortKindNo();
            if (portKindNo == 5) continue;
            retList.remove(index);
        }
        return retList;
    }

    ArrayList checkPortAttribute(ArrayList portDetailList) {
        ArrayList result = new ArrayList(portDetailList.size());
        List<?> portAttributeList = this.getCache(SJmoGetPortAttributeInfo.class);
        for (Object portDetailObj : portDetailList) {
            SJmoPortAttributeInfo portAttribute;
            byte portKind;
            int index = Collections.binarySearch(portAttributeList, portDetailObj);
            if (index < 0 || (portKind = (portAttribute = (SJmoPortAttributeInfo)portAttributeList.get(index)).getByPortKind()) != 3 && portKind != 4 && portKind != 9) continue;
            result.add(portDetailObj);
        }
        return result;
    }

    ArrayList checkIscsiPort(ArrayList retList) {
        for (int index = retList.size() - 1; index >= 0; --index) {
            byte portKindNo = ((SJmoPortDetail)retList.get(index)).getByPortKindNo();
            if (portKindNo != 5) continue;
            retList.remove(index);
        }
        return retList;
    }

    ArrayList checkHnasUserPort(ArrayList retList) {
        for (int index = retList.size() - 1; index >= 0; --index) {
            SJmoPortDetail portDetail = (SJmoPortDetail)retList.get(index);
            if (!SJctrPortUtility.isHnasUserPort(portDetail)) continue;
            retList.remove(index);
        }
        return retList;
    }

    ArrayList checkLDEV(ArrayList portDetailList, SJmoPortIndex orginPortIndex, SJmoHostGroupInfo orginHostGroupInfo) {
        ArrayList result = new ArrayList(portDetailList.size());
        List<?> portLunList = this.getCache(SJmoGetPortLunInfo.class);
        ArrayList orginLunList = null;
        SJmoPortLunInfo orginPortLunInfo = null;
        int lunIndex = Collections.binarySearch(portLunList, orginPortIndex);
        if (lunIndex >= 0) {
            orginPortLunInfo = (SJmoPortLunInfo)portLunList.get(lunIndex);
            short sHostGroup = orginHostGroupInfo.getSHostGroup();
            orginLunList = orginPortLunInfo.getAlHostGroupLun(sHostGroup);
        } else {
            orginLunList = new ArrayList();
        }
        boolean t10piEnable = false;
        List<?> ldevDetailList = this.getCache(SJmoGetLdevDetail.class);
        SJctrLdevIndexComparator ldevComp = new SJctrLdevIndexComparator();
        for (Object lun : orginLunList) {
            SJmoLdevDetail ldevDetail;
            boolean t10pi;
            int lunIndex2 = Collections.binarySearch(ldevDetailList, lun, ldevComp);
            if (lunIndex2 < 0 || !(t10pi = (ldevDetail = (SJmoLdevDetail)ldevDetailList.get(lunIndex2)).getBT10pi())) continue;
            t10piEnable = true;
            break;
        }
        if (t10piEnable) {
            for (Object portDetailObj : portDetailList) {
                int t10piMode = ((SJmoPortDetail)portDetailObj).getIT10Pi();
                if (t10piMode != 1) continue;
                result.add(portDetailObj);
            }
        } else {
            result = portDetailList;
        }
        return result;
    }

    ArrayList checkPortHostGroup(ArrayList portDetailList, SJmoPortIndex orginPortIndex, SJmoHostGroupInfo orginHostGroupInfo) {
        ArrayList result = new ArrayList(portDetailList.size());
        List<?> portHostGroupList = this.getCache(SJmoGetPortHostGroupInfo.class);
        ArrayList orginWwnList = new ArrayList(orginHostGroupInfo.getAlHostGroupWwn());
        Collections.sort(orginWwnList, WWN_COMPALATER);
        ArrayList orginWwnNameList = new ArrayList(orginHostGroupInfo.getAlHostGroupWwn());
        Collections.sort(orginWwnNameList, WWNNAME_COMPALATER);
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR8);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        BitSet hgIdSet = new BitSet(SJctrPortUtility.PORT_HOSTGROUP_MAX);
        for (Object portDetailObj : portDetailList) {
            ArrayList portWwnList = new ArrayList(SJctrPortUtility.PORT_WWN_MAX);
            int index = Collections.binarySearch(portHostGroupList, portDetailObj);
            if (index >= 0) {
                SJmoPortHostGroupInfo portHostGroupInfo = (SJmoPortHostGroupInfo)portHostGroupList.get(index);
                boolean equalsFlg = false;
                ArrayList hostGroupList = portHostGroupInfo.getAlPortHostGroup();
                if (hostGroupList.size() >= SJctrPortUtility.PORT_HOSTGROUP_MAX) continue;
                hgIdSet.clear();
                for (Object hostGroupInfoObj : hostGroupList) {
                    SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)hostGroupInfoObj;
                    hgIdSet.set(hgInfo.getSHostGroup());
                }
                short sHostgr = 0;
                SJmoPortDetail ptDetail = (SJmoPortDetail)portDetailObj;
                short sPort = ptDetail.getSPort();
                boolean rsgConboFlg = this.rsgDataModel.getSelectionRsgId() != -1;
                boolean loopFlg = false;
                SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
                while (sHostgr < SJctrPortUtility.PORT_HOSTGROUP_MAX) {
                    boolean sysRsgFlg;
                    if ((sHostgr = (short)((short)hgIdSet.nextClearBit(sHostgr))) >= SJctrPortUtility.PORT_HOSTGROUP_MAX) continue;
                    hgIndex.setSHostGroup(sHostgr);
                    hgIndex.setSPort(sPort);
                    int rsgId = rsgUtil.getRsgId(hgIndex);
                    boolean rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
                    if (rsgFlg && (sysRsgFlg = rsgUtil.isSelRscHgInSysRsg(hgIndex))) {
                        rsgFlg = false;
                    }
                    loopFlg = rsgFlg;
                    if (rsgConboFlg) {
                        loopFlg &= this.rsgDataModel.getSelectionRsgId() == rsgId;
                    }
                    if (this.ldev_VBoxIndex != null && loopFlg) {
                        SJmoHUVMvboxIndex vVoxIndex;
                        SJmoRSGgetRsg hg_rsgGetInfo = rsgUtil.getRsgFromHg(hgIndex);
                        loopFlg = hg_rsgGetInfo == null ? false : (loopFlg &= this.ldev_VBoxIndex.compareTo(vVoxIndex = hg_rsgGetInfo.getRsgInfo().getVboxIndex()) == 0);
                    }
                    if (loopFlg) break;
                    sHostgr = (short)(sHostgr + 1);
                }
                if (sHostgr >= SJctrPortUtility.PORT_HOSTGROUP_MAX) continue;
                for (Object hostGroupInfoObj : hostGroupList) {
                    String orginHostGroupName;
                    SJmoHostGroupInfo hostGroupInfo = (SJmoHostGroupInfo)hostGroupInfoObj;
                    String hostGroupName = hostGroupInfo.getStrHostgroupNickName();
                    if (hostGroupName.equals(orginHostGroupName = orginHostGroupInfo.getStrHostgroupNickName())) {
                        equalsFlg = true;
                        break;
                    }
                    portWwnList.addAll(hostGroupInfo.getAlHostGroupWwn());
                }
                if (equalsFlg) continue;
            }
            int portWwnSize = orginWwnList.size();
            if ((portWwnSize += portWwnList.size()) > SJctrPortUtility.PORT_WWN_MAX) continue;
            Collections.sort(portWwnList, WWN_COMPALATER);
            boolean equalsFlg = false;
            List subPortWwnList = portWwnList;
            for (Object wwnObj : orginWwnList) {
                int index2 = Collections.binarySearch(subPortWwnList, wwnObj, WWN_COMPALATER);
                if (index2 >= 0) {
                    equalsFlg = true;
                    break;
                }
                int fromIndex = -(index2 + 1);
                if (fromIndex >= subPortWwnList.size()) break;
                subPortWwnList = subPortWwnList.subList(fromIndex, subPortWwnList.size());
            }
            if (equalsFlg) continue;
            List subPortWwnNameList = new ArrayList(portWwnList);
            Collections.sort(subPortWwnNameList, WWNNAME_COMPALATER);
            boolean nameEqualsFlg = false;
            for (Object wwnObj : orginWwnNameList) {
                SJmoWwn wwn = (SJmoWwn)wwnObj;
                if (wwn.getStrWWNNickName().equals("")) continue;
                int index3 = Collections.binarySearch(subPortWwnNameList, wwnObj, WWNNAME_COMPALATER);
                if (index3 >= 0) {
                    nameEqualsFlg = true;
                    break;
                }
                int fromIndex = -(index3 + 1);
                if (fromIndex >= subPortWwnNameList.size()) break;
                subPortWwnNameList = subPortWwnNameList.subList(fromIndex, subPortWwnNameList.size());
            }
            if (nameEqualsFlg) continue;
            result.add(portDetailObj);
        }
        return result;
    }

    ArrayList checkPortIscsiTarget(ArrayList portDetailList, SJmoPortIndex orginPortIndex, SJmoIscsiTargetInfo orginIscsiTargetInfo) {
        ArrayList result = new ArrayList(portDetailList.size());
        List<?> portIscsiTargetList = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        ArrayList<SJmoIscsiName> orginIscsiNameList = new ArrayList<SJmoIscsiName>(orginIscsiTargetInfo.getAlIscsiName());
        Collections.sort(orginIscsiNameList, ISCSINAME_COMPALATER);
        ArrayList<SJmoIscsiName> orginIscsiNickNameList = new ArrayList<SJmoIscsiName>(orginIscsiTargetInfo.getAlIscsiName());
        Collections.sort(orginIscsiNickNameList, ISCSINICKNAME_COMPALATER);
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, CREATEALTPATHS_ERR8);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        BitSet itIdSet = new BitSet(SJctrPortUtility.PORT_ISCSITARGET_MAX);
        for (Object portDetailObj : portDetailList) {
            boolean bl;
            ArrayList<SJmoIscsiName> portIscsiNameList = new ArrayList<SJmoIscsiName>(SJctrPortUtility.PORT_ISCSINAME_MAX);
            int index = Collections.binarySearch(portIscsiTargetList, portDetailObj);
            if (index >= 0) {
                short s;
                SJmoPortIscsiTargetInfo portIscsiTargetInfo = (SJmoPortIscsiTargetInfo)portIscsiTargetList.get(index);
                boolean equalsFlg = false;
                ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = portIscsiTargetInfo.getAlPortIscsiTarget();
                if (iscsiTargetList.size() >= SJctrPortUtility.PORT_ISCSITARGET_MAX) continue;
                itIdSet.clear();
                for (Object e : iscsiTargetList) {
                    SJmoIscsiTargetInfo sJmoIscsiTargetInfo = (SJmoIscsiTargetInfo)e;
                    itIdSet.set(sJmoIscsiTargetInfo.getSIscsiTarget());
                }
                boolean bl2 = false;
                SJmoPortDetail sJmoPortDetail = (SJmoPortDetail)portDetailObj;
                short s2 = sJmoPortDetail.getSPort();
                boolean rsgConboFlg = this.rsgDataModel.getSelectionRsgId() != -1;
                boolean loopFlg = false;
                SJmoHostGroupIndex itIndex = new SJmoHostGroupIndex();
                while (s < SJctrPortUtility.PORT_ISCSITARGET_MAX) {
                    if ((s = (short)itIdSet.nextClearBit(s)) >= SJctrPortUtility.PORT_ISCSITARGET_MAX) continue;
                    itIndex.setSHostGroup(s);
                    itIndex.setSPort(s2);
                    int rsgId = rsgUtil.getRsgId(itIndex);
                    loopFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
                    if (rsgConboFlg) {
                        loopFlg &= this.rsgDataModel.getSelectionRsgId() == rsgId;
                    }
                    if (loopFlg) break;
                    s = (short)(s + 1);
                }
                if (s >= SJctrPortUtility.PORT_ISCSITARGET_MAX) continue;
                for (Object e : iscsiTargetList) {
                    String orginIscsiTargetAlias;
                    SJmoIscsiTargetInfo iscsiTargetInfo = (SJmoIscsiTargetInfo)e;
                    String iscsiTargetAlias = iscsiTargetInfo.getStrIscsiTargetAlias();
                    if (iscsiTargetAlias.equals(orginIscsiTargetAlias = orginIscsiTargetInfo.getStrIscsiTargetAlias())) {
                        equalsFlg = true;
                        break;
                    }
                    portIscsiNameList.addAll(iscsiTargetInfo.getAlIscsiName());
                }
                if (equalsFlg) continue;
            }
            int portIscsiNameSize = orginIscsiNameList.size();
            if ((portIscsiNameSize += portIscsiNameList.size()) > SJctrPortUtility.PORT_ISCSINAME_MAX) continue;
            Collections.sort(portIscsiNameList, ISCSINAME_COMPALATER);
            boolean equalsFlg = false;
            List<SJmoIscsiName> subPortIscsiNameList = portIscsiNameList;
            for (Object e : orginIscsiNameList) {
                int n = Collections.binarySearch(subPortIscsiNameList, e, ISCSINAME_COMPALATER);
                if (n >= 0) {
                    equalsFlg = true;
                    break;
                }
                int n2 = -(n + 1);
                if (n2 >= subPortIscsiNameList.size()) break;
                subPortIscsiNameList = subPortIscsiNameList.subList(n2, subPortIscsiNameList.size());
            }
            if (equalsFlg) continue;
            List subPortIscsiNickNameList = new ArrayList(portIscsiNameList);
            Collections.sort(subPortIscsiNickNameList, ISCSINICKNAME_COMPALATER);
            boolean bl3 = false;
            for (Object e : orginIscsiNickNameList) {
                SJmoIscsiName iscsiName = (SJmoIscsiName)e;
                if (iscsiName.getStrIscsiNickName().equals("")) continue;
                int index3 = Collections.binarySearch(subPortIscsiNickNameList, e, ISCSINICKNAME_COMPALATER);
                if (index3 >= 0) {
                    bl = true;
                    break;
                }
                int fromIndex = -(index3 + 1);
                if (fromIndex >= subPortIscsiNickNameList.size()) break;
                subPortIscsiNickNameList = subPortIscsiNickNameList.subList(fromIndex, subPortIscsiNickNameList.size());
            }
            if (bl) continue;
            result.add(portDetailObj);
        }
        return result;
    }

    ArrayList checkPortLuPath(ArrayList portDetailList, SJmoPortIndex orginPortIndex, SJmoHostGroupInfo orginHostGroupInfo) {
        ArrayList result = new ArrayList(portDetailList.size());
        List<?> portLunList = this.getCache(SJmoGetPortLunInfo.class);
        ArrayList orginLunList = null;
        SJmoPortLunInfo orginPortLunInfo = null;
        int lunIndex = Collections.binarySearch(portLunList, orginPortIndex);
        if (lunIndex >= 0) {
            orginPortLunInfo = (SJmoPortLunInfo)portLunList.get(lunIndex);
            short sHostGroup = orginHostGroupInfo.getSHostGroup();
            orginLunList = orginPortLunInfo.getAlHostGroupLun(sHostGroup);
        } else {
            orginLunList = new ArrayList();
        }
        for (Object portDetailObj : portDetailList) {
            ArrayList lunList = null;
            int index = Collections.binarySearch(portLunList, portDetailObj);
            if (index >= 0) {
                SJmoPortLunInfo portLunInfo = (SJmoPortLunInfo)portLunList.get(index);
                lunList = portLunInfo.getAlPortLun();
            } else {
                lunList = new ArrayList();
            }
            int lunSize = lunList.size();
            if ((lunSize += orginLunList.size()) > SJctrPortUtility.PORT_LUN_MAX) continue;
            result.add(portDetailObj);
        }
        return result;
    }

    ArrayList checkSelectPort(ArrayList portDetailList) {
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> selectList = selectedTable.getAllRowData();
        if (selectList != null || selectList.size() != 0) {
            for (Object selectData : selectList) {
                int lunIndex = Collections.binarySearch(portDetailList, selectData);
                if (lunIndex < 0) continue;
                portDetailList.remove(lunIndex);
            }
        }
        return portDetailList;
    }

    boolean getRemoveHgId(SJmoPortDetail portDetail, SJctrResourceGroupUtility rsgUtil) {
        boolean anyFlg;
        boolean result = false;
        List<?> portHostGroupList = this.getCache(SJmoGetPortHostGroupInfo.class);
        BitSet hostGroupIDSet = new BitSet(SJctrPortUtility.PORT_HOSTGROUP_MAX);
        int index = Collections.binarySearch(portHostGroupList, portDetail);
        SJmoPortHostGroupInfo portHostGroup = null;
        if (index >= 0) {
            portHostGroup = (SJmoPortHostGroupInfo)portHostGroupList.get(index);
            for (Object hostGroupInfoObj : portHostGroup.getAlPortHostGroup()) {
                SJmoHostGroupInfo hostGroupInfo = (SJmoHostGroupInfo)hostGroupInfoObj;
                hostGroupIDSet.set(hostGroupInfo.getSHostGroup());
            }
        } else {
            return result;
        }
        int newHostGroupID = 0;
        int chkHgId = 3;
        short sPort = portDetail.getSPort();
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        int rsgConboData = this.rsgDataModel.getSelectionRsgId();
        boolean bl = anyFlg = rsgConboData != -1;
        while (!result && newHostGroupID < SJctrPortUtility.PORT_HOSTGROUP_MAX) {
            if ((newHostGroupID = (int)((short)hostGroupIDSet.nextClearBit(newHostGroupID))) >= SJctrPortUtility.PORT_HOSTGROUP_MAX) continue;
            hgIndex.setSPort(sPort);
            hgIndex.setSHostGroup((short)newHostGroupID);
            int rsgId = rsgUtil.getRsgId(hgIndex);
            result = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
            if (this.ldev_VBoxIndex != null && result) {
                SJmoHUVMvboxIndex vVoxIndex;
                SJmoRSGgetRsg hg_rsgGetInfo = rsgUtil.getRsgFromHg(hgIndex);
                result = hg_rsgGetInfo == null ? false : (result &= this.ldev_VBoxIndex.compareTo(vVoxIndex = hg_rsgGetInfo.getRsgInfo().getVboxIndex()) == 0);
            }
            if (anyFlg) {
                result &= rsgId == rsgConboData;
            }
            if (result) continue;
            ++newHostGroupID;
        }
        return result;
    }

    boolean getRemoveItId(SJmoPortDetail portDetail, SJctrResourceGroupUtility rsgUtil) {
        boolean anyFlg;
        boolean result = false;
        List<?> portIscsiTargetList = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        BitSet iscsiTargetIDSet = new BitSet(SJctrPortUtility.PORT_ISCSITARGET_MAX);
        int index = Collections.binarySearch(portIscsiTargetList, portDetail);
        SJmoPortIscsiTargetInfo portIscsiTarget = null;
        if (index >= 0) {
            portIscsiTarget = (SJmoPortIscsiTargetInfo)portIscsiTargetList.get(index);
            for (SJmoIscsiTargetInfo iscsiTargetInfoObj : portIscsiTarget.getAlPortIscsiTarget()) {
                iscsiTargetIDSet.set(iscsiTargetInfoObj.getSIscsiTarget());
            }
        } else {
            return result;
        }
        int newIscsiTargetID = 0;
        int chkItId = 3;
        short sPort = portDetail.getSPort();
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        int rsgConboData = this.rsgDataModel.getSelectionRsgId();
        boolean bl = anyFlg = rsgConboData != -1;
        while (!result && newIscsiTargetID < SJctrPortUtility.PORT_ISCSITARGET_MAX) {
            if ((newIscsiTargetID = (int)((short)iscsiTargetIDSet.nextClearBit(newIscsiTargetID))) >= SJctrPortUtility.PORT_ISCSITARGET_MAX) continue;
            hgIndex.setSPort(sPort);
            hgIndex.setSHostGroup((short)newIscsiTargetID);
            int rsgId = rsgUtil.getRsgId(hgIndex);
            result = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
            if (this.ldev_VBoxIndex != null && result) {
                SJmoHUVMvboxIndex vVoxIndex;
                SJmoRSGgetRsg hg_rsgGetInfo = rsgUtil.getRsgFromHg(hgIndex);
                result = hg_rsgGetInfo == null ? false : (result &= this.ldev_VBoxIndex.compareTo(vVoxIndex = hg_rsgGetInfo.getRsgInfo().getVboxIndex()) == 0);
            }
            if (anyFlg) {
                result &= rsgId == rsgConboData;
            }
            if (result) continue;
            ++newIscsiTargetID;
        }
        return result;
    }
}

