/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.delhg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHGIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.delhg.SJctrDelHGAC;
import sanproject.sn2.controller.wizard.lunm.delhg.SJctrDelHGConfirmDC;
import sanproject.sn2.controller.wizard.lunm.delhg.SJctrDelHGConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrDelHGSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "DELETE_HG";
    private static final Class<?> CONFIRM_DC = SJctrDelHGConfirmDC.class;
    public static final String KEY_TABLE = "COM_TABLE";
    private List<SJctrPortHostGroupTableKey> targetTblKeyList = null;
    private List<SJmoPortDetail> targetPortDtlList = null;
    private List<SJmoPortAttributeInfo> targetPortAtrList = null;
    public static int DELHG_ERR1 = 107001;
    public static int DELHG_ERR2 = 106501;
    public static int DELHG_ERR3 = 106502;
    public static int DELHG_ERR4 = 108016;
    public static int DELHG_ERR5 = 105297;
    public static int DELHG_ERR6 = 105298;
    public static int DELHG_ERR_SysRSG_HG = 205164;

    @Override
    public SJctrError checkInitParam(Object param) {
        return null;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        SJctrUserController uc = wizard.getOwner();
        List<SJctrPortHGIndex> targetList = wizard.getCache("SELECTDELHG");
        if (targetList == null) {
            SJctrError err = new SJctrError(10, 22, DELHG_ERR1);
            SJcException sJcException = err.createException();
            throw sJcException;
        }
        if (targetList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, DELHG_ERR1);
            SJcException sJcException = err.createException();
            throw sJcException;
        }
        for (Object obj : targetList) {
            if (obj instanceof SJctrPortHGIndex) continue;
            SJctrError err = new SJctrError(10, 22, DELHG_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoRSGgetAllRsgs> rsgDetailList = wizard.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError sJctrError = new SJctrError(10, 22, DELHG_ERR1);
            SJcException exp = sJctrError.createException();
            throw exp;
        }
        SJctrResourceGroupUtility sJctrResourceGroupUtility = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        List<?> portLunList = wizard.getCache(SJmoGetPortLunInfo.class);
        if (portLunList == null) {
            SJctrError err = new SJctrError(10, 22, DELHG_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        List<SJctrPortHGIndex> targetPortHGIndexList = targetList;
        boolean result = true;
        SJctrDataController parentDC = wizard.getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        SJctrError errInfo = null;
        List<Object> selectedRowList = parentTbl.getSelectedRowData();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(targetPortHGIndexList.size());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        int portKind = -1;
        this.targetPortAtrList = this.getTargetPortAttribute(targetPortHGIndexList, wizard);
        for (SJctrPortHGIndex ptHgIndex : targetPortHGIndexList) {
            portKind = -1;
            portIndex.setSPort(ptHgIndex.getPort());
            int search = Collections.binarySearch(this.targetPortAtrList, portIndex);
            if (search >= 0) {
                SJmoPortAttributeInfo ptAttrInfo = this.targetPortAtrList.get(search);
                portKind = ptAttrInfo.getByPortKind();
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getBasicDataList", "SJmoPortAttributeInfo not found.");
            }
            if (portKind == 5) continue;
            hgIndex.setSPort(ptHgIndex.getPort());
            hgIndex.setSHostGroup(ptHgIndex.getHostGroup());
            boolean rsgHgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, sJctrResourceGroupUtility);
            if (!rsgHgFlg) {
                result = false;
                SJctrError err = new SJctrError(10, 22, DELHG_ERR5);
                if (errInfo == null) {
                    errInfo = err;
                }
                SJctrPortHostGroupTableKey errKey = this.getErrKeyData(selectedRowList, ptHgIndex);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(errKey, err);
                errList.add(errData);
                continue;
            }
            boolean sysRsgFlg = sJctrResourceGroupUtility.isSelRscHgInSysRsg(hgIndex);
            if (sysRsgFlg) {
                result = false;
                SJctrError err = new SJctrError(10, 22, DELHG_ERR_SysRSG_HG);
                if (errInfo == null) {
                    errInfo = err;
                }
                SJctrPortHostGroupTableKey errKey = this.getErrKeyData(selectedRowList, ptHgIndex);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(errKey, err);
                errList.add(errData);
                continue;
            }
            int index = Collections.binarySearch(portLunList, portIndex);
            if (index < 0) continue;
            SJmoPortLunInfo portLunInfo = (SJmoPortLunInfo)portLunList.get(index);
            ArrayList pathDtlList = portLunInfo.getAlHostGroupLun(ptHgIndex.getHostGroup());
            for (SJmoPortLunDetail pathDtl : pathDtlList) {
                ldevIndex.setLdevIndex(pathDtl.getSLDKC(), pathDtl.getSCU(), pathDtl.getSLDEV());
                int rsgId = sJctrResourceGroupUtility.getRsgId(ldevIndex);
                boolean rsgLdevFlg = SJctrPortUtility.chkResourceGroup(rsgId, sJctrResourceGroupUtility);
                if (rsgLdevFlg) continue;
                SJctrLogUty.info(this.getClass().getSimpleName(), "constructConfirmData", "Extract Impossible Ldev RSG ID = " + rsgId);
                result = false;
                SJctrError err = new SJctrError(10, 22, DELHG_ERR6);
                if (errInfo == null) {
                    errInfo = err;
                }
                SJctrPortHostGroupTableKey errKey = this.getErrKeyData(selectedRowList, ptHgIndex);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(errKey, err);
                errList.add(errData);
            }
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = wizard.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)wizard.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        this.checkDelHGData(targetPortHGIndexList, wizard);
        this.targetPortDtlList = this.getTargetPortDtl(targetPortHGIndexList, wizard);
        this.targetPortAtrList = this.getTargetPortAttribute(targetPortHGIndexList, wizard);
        SJctrDelHGConfirmData confirmData = new SJctrDelHGConfirmData();
        confirmData.setPortHGList(this.targetTblKeyList);
        confirmData.setPortDetailList(this.targetPortDtlList);
        confirmData.setPortAttributeList(this.targetPortAtrList);
        confirmData.setAllRsgList(rsgDetailList);
        ArrayList<SJctrDelHGConfirmData> confirmDataList = new ArrayList<SJctrDelHGConfirmData>();
        confirmDataList.add(confirmData);
        wizard.putCache(SJctrDelHGConfirmData.class, confirmDataList);
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrDelHGAC ac = new SJctrDelHGAC();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        confirmData = (SJctrDelHGConfirmData)confirmDataList.get(0);
        List<SJctrPortHostGroupTableKey> portHGTblKeyList = confirmData.getPortHGTblKeyList();
        ac.setApplyList(portHGTblKeyList);
        wizard.addConfirmData(ac, related);
    }

    private List<SJmoPortDetail> getTargetPortDtl(List<SJctrPortHGIndex> portHGIndexList, SJctrWizardWindowDC wizard) {
        ArrayList<SJmoPortDetail> retList = new ArrayList<SJmoPortDetail>(portHGIndexList.size());
        List<?> portDtlList = wizard.getCache(SJmoGetPortDetail.class);
        HashSet<SJmoPortDetail> portDtlSet = new HashSet<SJmoPortDetail>(portHGIndexList.size());
        for (SJctrPortHGIndex ptHG : portHGIndexList) {
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(ptHG.getPort());
            int index = Collections.binarySearch(portDtlList, portIndex);
            if (index < 0) continue;
            portDtlSet.add((SJmoPortDetail)portDtlList.get(index));
        }
        retList.addAll(portDtlSet);
        Collections.sort(retList);
        return retList;
    }

    private List<SJmoPortAttributeInfo> getTargetPortAttribute(List<SJctrPortHGIndex> portHGIndexList, SJctrWizardWindowDC wizard) {
        ArrayList<SJmoPortAttributeInfo> retList = new ArrayList<SJmoPortAttributeInfo>(portHGIndexList.size());
        List<?> portAtrList = wizard.getCache(SJmoGetPortAttributeInfo.class);
        HashSet<SJmoPortAttributeInfo> portDtlSet = new HashSet<SJmoPortAttributeInfo>(portHGIndexList.size());
        for (SJctrPortHGIndex ptHG : portHGIndexList) {
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(ptHG.getPort());
            int index = Collections.binarySearch(portAtrList, portIndex);
            if (index < 0) continue;
            portDtlSet.add((SJmoPortAttributeInfo)portAtrList.get(index));
        }
        retList.addAll(portDtlSet);
        Collections.sort(retList);
        return retList;
    }

    private boolean checkDelHGData(List<SJctrPortHGIndex> portHGIndexList, SJctrWizardWindowDC wizard) {
        int index;
        SJmoPortIndex portIndex;
        boolean result = true;
        SJctrError errInfo = null;
        SJctrDataController parentDC = wizard.getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = parentTbl.getSelectedRowData();
        this.targetTblKeyList = new ArrayList<SJctrPortHostGroupTableKey>(portHGIndexList.size());
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(portHGIndexList.size());
        List<?> portHGList = wizard.getCache(SJmoGetPortHostGroupInfo.class);
        List<?> portLunList = wizard.getCache(SJmoGetPortLunInfo.class);
        List<?> ldevGDList = wizard.getCache(SJmoGetLdevGuardInfo.class);
        if (result) {
            for (SJctrPortHGIndex ptHG : portHGIndexList) {
                portIndex = new SJmoPortIndex();
                portIndex.setSPort(ptHG.getPort());
                index = Collections.binarySearch(portHGList, portIndex);
                if (index < 0) {
                    result = false;
                    SJctrError err = new SJctrError(10, 22, DELHG_ERR2);
                    if (errInfo == null) {
                        errInfo = err;
                    }
                    SJctrPortHostGroupTableKey errKey = this.getErrKeyData(selectedRowList, ptHG);
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(errKey, err);
                    errList.add(errData);
                    continue;
                }
                SJmoPortHostGroupInfo portHGInfo = (SJmoPortHostGroupInfo)portHGList.get(index);
                ArrayList hgList = portHGInfo.getAlPortHostGroup();
                boolean hgEquip = false;
                for (SJmoHostGroupInfo hgInfo : hgList) {
                    if (ptHG.getHostGroup() != hgInfo.getSHostGroup()) continue;
                    hgEquip = true;
                    SJctrPortHostGroupTableKey tblKey = new SJctrPortHostGroupTableKey(portHGInfo, hgInfo);
                    this.targetTblKeyList.add(tblKey);
                    break;
                }
                if (hgEquip) continue;
                result = false;
                SJctrError err = new SJctrError(10, 22, DELHG_ERR3);
                if (errInfo == null) {
                    errInfo = err;
                }
                SJctrPortHostGroupTableKey errKey = this.getErrKeyData(selectedRowList, ptHG);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(errKey, err);
                errList.add(errData);
            }
        }
        if (result) {
            block2: for (SJctrPortHGIndex ptHG : portHGIndexList) {
                SJmoPortLunInfo portLunInfo;
                ArrayList pathDtlList;
                portIndex = new SJmoPortIndex();
                portIndex.setSPort(ptHG.getPort());
                index = Collections.binarySearch(portLunList, portIndex);
                if (index < 0 || (pathDtlList = (portLunInfo = (SJmoPortLunInfo)portLunList.get(index)).getAlHostGroupLun(ptHG.getHostGroup())).size() == 0) continue;
                for (SJmoPortLunDetail pathDtl : pathDtlList) {
                    SJmoLdevGuardInfo ldevGDInfo;
                    SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                    ldevIndex.setLdevIndex(pathDtl.getSLDKC(), pathDtl.getSCU(), pathDtl.getSLDEV());
                    int guardIndex = Collections.binarySearch(ldevGDList, ldevIndex);
                    if (guardIndex < 0 || ((ldevGDInfo = (SJmoLdevGuardInfo)ldevGDList.get(guardIndex)).getByLdevGuardStatus() & 8) != 8) continue;
                    result = false;
                    SJctrError err = new SJctrError(10, 22, DELHG_ERR4);
                    if (errInfo == null) {
                        errInfo = err;
                    }
                    SJctrPortHostGroupTableKey errKey = this.getErrKeyData(selectedRowList, ptHG);
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(errKey, err);
                    errList.add(errData);
                    continue block2;
                }
            }
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = wizard.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)wizard.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return result;
    }

    private SJctrPortHostGroupTableKey getErrKeyData(List selectRowDataList, SJctrPortHGIndex ptHGIndex) {
        SJctrPortHostGroupTableKey retData = null;
        for (Object selectRow : selectRowDataList) {
            SJctrPortHostGroupTableKey tblkey = (SJctrPortHostGroupTableKey)selectRow;
            SJctrPortHGIndex portHg = new SJctrPortHGIndex();
            portHg.setIndex(tblkey.getPortHostGroupInfo().getSPort(), tblkey.getHostGroupInfo().getSHostGroup());
            if (ptHGIndex.compareTo(portHg) != 0) continue;
            retData = tblkey;
            break;
        }
        return retData;
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public short[] getRequireRoll() {
        return null;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortHostGroupInfo();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevGuardInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

