/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import sanproject.serverux.dataimpl.SetHostMode;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets.SJctrEditIscsiTargetsConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets.SJctrKeyValueSetterForEditIscsiTargets;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJctrEditIscsiTargetsAC
extends SJctrApplyController
implements SJmoKeyValueDefine_IF {
    private static final long serialVersionUID = 9098965777010049011L;
    private List<SJmoIscsiTargetInfo> editIscsiTargetList = new ArrayList<SJmoIscsiTargetInfo>();
    private Set<String> editParamKeySet = new HashSet<String>();
    private Map<String, SJctrIscsiOperationError> errorMap = new TreeMap<String, SJctrIscsiOperationError>();
    protected SJctrError representativeError = null;
    protected List<SJctrError> resultData = null;
    private static final int LUNM_BASE_TIME = 30;
    private static final int CHECK_TIME = 5;
    private static final double COEFFICIENT = 0.003;

    public void setApplyData(SJctrEditIscsiTargetsConfirmData confirmData) {
        this.editIscsiTargetList = confirmData.getIscsiTargetList();
        this.editParamKeySet = confirmData.getEditParamKeySet();
    }

    @Override
    public ArrayList<?> getSetList() {
        return new ArrayList(1);
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        try {
            Object resultObject;
            ArrayList<Object> applyList;
            if (this.editParamKeySet.contains("COM_ISCSI_TARGET_ALIAS_TITLE") || this.editParamKeySet.contains("COM_ISCSI_TARGET_NAME_TITLE") || this.editParamKeySet.contains("COM_CHAP_AUTH_TITLE") || this.editParamKeySet.contains("COM_AUTH_MODE_TITLE")) {
                applyList = this.createEditTargetApplyList(supplier);
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateiScsiTarget)");
                resultObject = supplier.applyStart(this.getLockId(), applyList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateiScsiTarget)");
                this.setErrorMapForSanResponse(resultObject);
            }
            if (this.editParamKeySet.contains("COM_HOST_MODE_TITLE")) {
                applyList = this.createEditHostModeApplyList();
                try {
                    SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (SetHostMode)");
                    supplier.applyStart(this.getLockId(), applyList);
                    SJctrLogUty.info(this.title, "applyStart", "Apply End!! (SetHostMode)");
                }
                catch (Exception e) {
                    SJctrLogUty.info(this.title, "applyStart", "Error occurred. (SetHostMode)", e);
                    SJctrError error = SJctrError.parseError(e);
                    if (this.representativeError == null) {
                        this.representativeError = error;
                    }
                    for (SJmoIscsiTargetInfo iscsiTgInfo : this.editIscsiTargetList) {
                        SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(error.getFunc(), error.getModule(), error.getMsg(), iscsiTgInfo);
                        if (this.errorMap.containsKey(iscsiTgInfo)) continue;
                        this.errorMap.put(iscsiTgInfo.toString(), iscsiError);
                    }
                }
            }
            if (this.editParamKeySet.contains("COM_USER_NAME_TITLE") || this.editParamKeySet.contains("COM_SECRET_TITLE")) {
                applyList = this.createEditTargetChapUserApplyList(supplier);
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateiScsiTargetUsers)");
                resultObject = supplier.applyStart(this.getLockId(), applyList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateiScsiTargetUsers)");
                this.setErrorMapForSanResponse(resultObject);
            }
            this.setApplyResult();
        }
        catch (SJcException se) {
            SJctrLogUty.error(this.title, "applyStart", "SJcException occurred. " + se.getMessage());
            SJctrError error = SJctrError.parseError(se);
            this.setError(error);
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "applyStart", "The Key-Value interfacd error occurred. " + sdEx.getMessage());
            SJctrError error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    private ArrayList<SanRequest> createEditTargetApplyList(SJdsSupplierAgent supplier) throws Exception {
        SanRequest request = supplier.newRequest("LUNMupdateiScsiTarget");
        SJctrKeyValueSetterForEditIscsiTargets paramSetter = new SJctrKeyValueSetterForEditIscsiTargets(this.editParamKeySet){

            @Override
            protected void setIscsiTargetSubParam(SanObject setIscsiTgObj, Object iscsiTgInfo) throws SanDataException {
                if (this.isEditTgAlias()) {
                    setIscsiTgObj.putString("Alias", ((SJmoIscsiTargetInfo)iscsiTgInfo).getStrIscsiTargetAlias());
                }
                if (this.isEditTgName()) {
                    setIscsiTgObj.putString("Name", ((SJmoIscsiTargetInfo)iscsiTgInfo).getStrIscsiTargetName());
                }
                if (this.isEditChapAuth()) {
                    setIscsiTgObj.putInt("UserAuthSwitch", ((SJmoIscsiTargetInfo)iscsiTgInfo).getiUserAuthentSwitch());
                }
                if (this.isEditAuthMode()) {
                    setIscsiTgObj.putInt("AuthMode", ((SJmoIscsiTargetInfo)iscsiTgInfo).getiAuthentMode());
                }
            }
        };
        paramSetter.setRequestParam(request, this.editIscsiTargetList);
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        applyList.add(request);
        return applyList;
    }

    private ArrayList<SetHostMode> createEditHostModeApplyList() {
        ArrayList<SetHostMode> setHostModeList = new ArrayList<SetHostMode>();
        for (SJmoIscsiTargetInfo iscsiTgInfo : this.editIscsiTargetList) {
            SetHostMode hostModeInfo = new SetHostMode();
            hostModeInfo.setSPort(iscsiTgInfo.getSPort());
            hostModeInfo.setSHostgroupID(iscsiTgInfo.getSIscsiTarget());
            hostModeInfo.setByHostMode((byte)iscsiTgInfo.getIHostMode());
            hostModeInfo.setBtOption(iscsiTgInfo.getBtOption());
            setHostModeList.add(hostModeInfo);
        }
        return setHostModeList;
    }

    private ArrayList<SanRequest> createEditTargetChapUserApplyList(SJdsSupplierAgent supplier) throws Exception {
        SanRequest request = supplier.newRequest("LUNMupdateiScsiTargetUsers");
        SJctrKeyValueSetterForEditIscsiTargets paramSetter = new SJctrKeyValueSetterForEditIscsiTargets(this.editParamKeySet){

            @Override
            protected void setIscsiTargetSubParam(SanObject setIscsiTgObj, Object iscsiTgInfo) throws SanDataException {
                setIscsiTgObj.putString("UserId", ((SJmoIscsiTargetInfo)iscsiTgInfo).getStrTargetUserName());
                if (this.isEditTgSecret()) {
                    setIscsiTgObj.putString("Secret", ((SJmoIscsiTargetInfo)iscsiTgInfo).getStrTargetSecret());
                }
            }
        };
        paramSetter.setRequestParam(request, this.editIscsiTargetList);
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        applyList.add(request);
        return applyList;
    }

    protected void setErrorMapForSanResponse(Object resultObject) throws SanDataException {
        SanList iScsiPortList;
        SanObject repErrorInfo;
        int[] errMsgId;
        if (!(resultObject instanceof SanResponse)) {
            SJcException error = SJctrIscsiUtility.makeException(107001);
            throw error;
        }
        SanResponse responseData = (SanResponse)resultObject;
        if (this.representativeError == null && 0 != (errMsgId = (repErrorInfo = responseData.getObj("ErrorInfo")).getIntArray("MessageId"))[1]) {
            this.representativeError = new SJctrIscsiOperationError(errMsgId);
        }
        if (null == (iScsiPortList = responseData.getList("iScsiPorts"))) {
            SJctrLogUty.info(this.title, "setErrorMapForSanResponse", "iScsiPortList is null.");
        } else {
            for (SanObject iScsiPort : iScsiPortList) {
                SanList iScsiTargetList = iScsiPort.getList("iScsiTargets");
                for (SanObject iScsiTarget : iScsiTargetList) {
                    SanObject errInfo = iScsiTarget.getObj("ErrorInfo");
                    int[] errMsgId2 = errInfo.getIntArray("MessageId");
                    if (0 == errMsgId2[1]) continue;
                    SJmoIscsiTargetIndex index = new SJmoIscsiTargetIndex();
                    index.setSPort((short)iScsiPort.getInt("Id"));
                    index.setSIscsiTarget((short)iScsiTarget.getInt("Id"));
                    String errorTg = index.toString();
                    if (this.errorMap.containsKey(errorTg)) continue;
                    SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(errMsgId2, index);
                    this.errorMap.put(errorTg, iscsiError);
                }
            }
        }
    }

    protected void setApplyResult() {
        super.setApplyResult(null);
        if (this.representativeError != null) {
            this.setError(this.representativeError);
        } else {
            this.setError(SJctrIscsiUtility.makeError(0));
        }
        if (this.errorMap.size() > 0) {
            this.resultData = new ArrayList<SJctrIscsiOperationError>(this.errorMap.values());
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }

    @Override
    public int getLeadTime() {
        int counter = 0;
        if (this.editParamKeySet.contains("COM_ISCSI_TARGET_ALIAS_TITLE") || this.editParamKeySet.contains("COM_ISCSI_TARGET_NAME_TITLE") || this.editParamKeySet.contains("COM_CHAP_AUTH_TITLE") || this.editParamKeySet.contains("COM_AUTH_MODE_TITLE")) {
            counter += this.editIscsiTargetList.size();
        }
        if (this.editParamKeySet.contains("COM_USER_NAME_TITLE") || this.editParamKeySet.contains("COM_SECRET_TITLE")) {
            counter += this.editIscsiTargetList.size();
        }
        int leadTime = SJctrIscsiUtility.getLeadTime(counter, 1.0, 3200.0);
        if (this.editParamKeySet.contains("COM_HOST_MODE_TITLE")) {
            leadTime = (int)((double)leadTime + (30.0 + (double)this.editIscsiTargetList.size() * 0.003 + 5.0));
        }
        return leadTime;
    }
}

