/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.mapluns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.common.Robj_interface_RJiResourceName;
import sanproject.common.Robj_interface_RJiSetResourceNameResult;
import sanproject.serverux.dataimpl.RJiRESOURCEsetName_IN;
import sanproject.serverux.dataimpl.RJiRESOURCEsetName_OUT;
import sanproject.serverux.dataimpl.RJiResourceName;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.data.SJmoMacroMgr;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrMapLunsLdevNicknameAC
extends SJctrApplyController {
    private static final double COEFFICIENT = 5.6;
    private static double BOUNDARY = 2048.0;
    public static final String KEY_LUN_MAX_PORT = "LUN_MAX_PORT";
    static final int RESULT_NORMAL = 0;
    static final int RESULT_REPRESENT_ERROR = 106039;
    static final int RESULT_INVALID_DATA = 107001;
    static final int FUNC_SN = 10;
    static final int MODULE_SN = 22;
    static final int FUNC_CVS = 30;
    static final int MODULE_HIC = 5;
    static final int RSC_TYPE_LDEV_NICKNAME = 1;
    private static final int SEND_NUM = 1;
    List<SJctrError> resultData = null;
    private List<SJmoLdevNicknameInfo> NicknameList = Collections.emptyList();

    public SJctrMapLunsLdevNicknameAC() {
        this.changeMacro();
    }

    private void changeMacro() {
        SJmoModelMgr modelMgr = (SJmoModelMgr)SJcSingletonManagerUty.getInstance(SJmoModelMgr.class);
        if (modelMgr == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "changeMacro", "Getting Model manager failed.");
            return;
        }
        SJmoMacroMgr macroMgr = modelMgr.getMacroMgr();
        if (macroMgr == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "changeMacro", "Getting Macro manager failed.");
            return;
        }
        Object obj = null;
        try {
            obj = macroMgr.getMacroObj(KEY_LUN_MAX_PORT);
            if (obj != null) {
                BOUNDARY = ((Long)obj).doubleValue();
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "changeMacro", "Getting Macro \"LUN_MAX_PORT\" failed.");
            }
        }
        catch (ClassCastException e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "changeMacro", "Getting Macro failed from Class Cast Exception.");
        }
    }

    @Override
    public int getLeadTime() {
        ArrayList<?> applylist = this.getSetList();
        double ldevcnt = (double)applylist.size() / BOUNDARY;
        ldevcnt = Math.ceil(ldevcnt);
        double leadtime = ldevcnt * 5.6;
        leadtime = Math.ceil(leadtime);
        return (int)leadtime;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<RJiRESOURCEsetName_IN> retRscList = new ArrayList<RJiRESOURCEsetName_IN>();
        Robj_interface_RJiResourceName[] rsc = new RJiResourceName[this.NicknameList.size()];
        int index = 0;
        for (SJmoLdevNicknameInfo nicknameInfo : this.NicknameList) {
            RJiResourceName rscName = new RJiResourceName();
            rscName.setName(nicknameInfo.getStrNickname());
            rscName.setNumber(nicknameInfo.getIndex());
            rscName.setType(1);
            rsc[index] = rscName;
            ++index;
        }
        RJiRESOURCEsetName_IN inList = new RJiRESOURCEsetName_IN();
        inList.setResourceName(rsc);
        retRscList.add(inList);
        return retRscList;
    }

    public void setApplyData(List<SJmoLdevNicknameInfo> nickList) {
        this.NicknameList = nickList;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        SJctrError result = new SJctrError(10, 22, 0);
        if (resultObject == null) {
            result.setError(107001);
        } else if (resultObject instanceof RJiRESOURCEsetName_OUT) {
            RJiRESOURCEsetName_OUT rscOut = (RJiRESOURCEsetName_OUT)resultObject;
            Robj_interface_RJiSetResourceNameResult[] nameResult = rscOut.getResult();
            HashSet<Integer> mix = new HashSet<Integer>();
            this.resultData = new ArrayList<SJctrError>(nameResult.length);
            for (int cnt = 0; cnt < nameResult.length; ++cnt) {
                int[] err = nameResult[cnt].getError();
                SJctrError detailResult = new SJctrError(30, 5, err[1]);
                int erc = err[1];
                if (erc != 0) {
                    mix.add(erc);
                    result = detailResult;
                }
                this.resultData.add(detailResult);
            }
            if (mix.size() > 1) {
                result = new SJctrError(10, 22, 106039);
            }
        } else {
            result.setError(107001);
        }
        super.setError(result);
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    protected int getMaxSend() {
        return 1;
    }
}

