/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.addtoports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrMonPortWWNComparator;
import sanproject.sn2.controller.com.comparator.SJctrMonitorAvailablePortsInfoComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.addtoports.SJctrAddToPortsConfirmData;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorAvailablePortsInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorAvailablePortsTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorPortWWNInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorWWNsTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPPCALLPortWWNInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortWwnInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortWwnInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.monitor.SJmoPPCALLPortWWNInfo;

public class SJctrAddToPortsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101071;
    private static final String[] DISP_TITLE = SJctrOptionMonitorGuidance.ADD_TO_PORTS;
    private static final String KEY_HBA_WWN_INF = "COM_HBA_WWN_INF";
    private static final String KEY_WWN_NAME_INF = "COM_WWN_NAME_INF";
    private static final String KEY_TABLE_PORTS = "COM_TABLE_PORTS";
    private static final String KEY_TABLE_MON_WWN = "COM_TABLE_MON_WWN";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_DELETE = "COM_DELETE";
    private static final SJctrMonitorAvailablePortsInfoComparator AVA_PORT_COMP = new SJctrMonitorAvailablePortsInfoComparator();
    protected static final SJctrMonPortWWNComparator PORT_WWN_COMP = new SJctrMonPortWWNComparator();

    public SJctrAddToPortsDC() throws SJcException {
        super(0x1101071);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPPCALLPortWWNInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortWwnInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_PORTS, new SJctrMonitorAvailablePortsTableModel());
        SJctrMonitorWWNsTableModel wwnTable = new SJctrMonitorWWNsTableModel();
        wwnTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_MON_WWN, wwnTable);
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAddToPortsDC.this.fireMessageEvent(ADD_TO_PORTS_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel deleteButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DELETE, deleteButton);
        deleteButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAddToPortsDC.this.fireMessageEvent(ADD_TO_PORTS_MSG.SELECT_DELETE);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(ADD_TO_PORTS_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddToPortsDC.this.addMonWwnsAction(event, dstModel);
                SJctrAddToPortsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addMessageEventListener(ADD_TO_PORTS_MSG.SELECT_DELETE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddToPortsDC.this.deleteMonWwnsAction(event, dstModel);
                SJctrAddToPortsDC.this.setFinishChangeCheck(true);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache(SJctrMonitorPortWWNInfo.class);
        if (null == viewDataList) {
            this.logUty.putlog("checkConstructData", "Inherited list data is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkConstructData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrMonitorPortWWNInfo viewData = (SJctrMonitorPortWWNInfo)viewDataList.get(0);
        if (null == viewData) {
            this.logUty.putlog("checkConstructData", "Information of selected WWN is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoPPCALLPortWWNInfo> monWwnInfos = SJctrOptionMonitorUtility.getPPCALLPortWWNInfo(this);
            List<SJmoPortWwnInfo> loginWwnInfos = SJctrOptionMonitorUtility.getSJmoPortWwnInfo(this);
            List<SJmoPortHostGroupInfo> lunmWwnInfos = SJctrOptionMonitorUtility.getSJmoPortHostGroupInfo(this);
            List<SJmoPortDetail> portDetails = SJctrOptionMonitorUtility.getSJmoPortDetail(this);
            int monitoredWwnCount = SJctrOptionMonitorUtility.getMonitoringWWNCount(monWwnInfos, portDetails);
            if (monitoredWwnCount >= 2048) {
                SJctrError err = new SJctrError(51, 22, 105229);
                SJcException exp = err.createException();
                throw exp;
            }
            List<?> viewDataList = this.getProxy().getCache(SJctrMonitorPortWWNInfo.class);
            SJctrMonitorPortWWNInfo viewData = (SJctrMonitorPortWWNInfo)viewDataList.get(0);
            SJmoWwn selectedWwnInfo = viewData.getWwn();
            String selectedHbaWwnStr = SJctrComUtility.toWWNDisplay(selectedWwnInfo);
            String selectedWwnNameStr = selectedWwnInfo.getStrWWNNickName();
            SJctrDataObject dataObj = this.getManageData();
            dataObj.setData(KEY_HBA_WWN_INF, selectedHbaWwnStr);
            dataObj.setData(KEY_WWN_NAME_INF, selectedWwnNameStr);
            List<SJctrMonitorAvailablePortsInfo> portList = SJctrOptionMonitorUtility.fillterAvailableMonPorts(monWwnInfos, loginWwnInfos, lunmWwnInfos, portDetails);
            block2: for (SJmoPPCALLPortWWNInfo monPortWwnInfo : monWwnInfos) {
                ArrayList<SJmoWwn> monWwnList = monPortWwnInfo.getWwns();
                for (SJmoWwn monWwn : monWwnList) {
                    if (!SJctrComUtility.toWWNDisplay(monWwn).equalsIgnoreCase(selectedHbaWwnStr)) continue;
                    int portIndex = monPortWwnInfo.getIndex();
                    for (SJctrMonitorAvailablePortsInfo portAvailInfo : portList) {
                        if (portAvailInfo.getPortDetail().getIndex() != portIndex) continue;
                        portList.remove(portAvailInfo);
                        continue block2;
                    }
                    continue block2;
                }
            }
            if (0 == portList.size()) {
                SJctrError err = new SJctrError(51, 22, 105108);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrMonitorAvailablePortsTableModel availablePortsTable = (SJctrMonitorAvailablePortsTableModel)this.getDataObjectModel(KEY_TABLE_PORTS);
            Collections.sort(portList, AVA_PORT_COMP);
            availablePortsTable.setBasicDataList(portList);
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        SJctrAddToPortsConfirmData confirmData = new SJctrAddToPortsConfirmData();
        SJctrMonitorWWNsTableModel selectedWwnTable = (SJctrMonitorWWNsTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWN);
        List<Object> selectedList = selectedWwnTable.getAllRowData();
        Collections.sort(selectedList, PORT_WWN_COMP);
        confirmData.setMonitorWwns(selectedList);
        ArrayList<SJctrAddToPortsConfirmData> confirmDataList = new ArrayList<SJctrAddToPortsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrAddToPortsConfirmData.class, confirmDataList);
        this.setFinishChangeCheck(false);
        return true;
    }

    private void addMonWwnsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrError err;
            List<SJmoPPCALLPortWWNInfo> monWwnInfos = SJctrOptionMonitorUtility.getPPCALLPortWWNInfo(this);
            List<SJmoPortDetail> portDetails = SJctrOptionMonitorUtility.getSJmoPortDetail(this);
            List<?> viewDataList = this.getProxy().getCache(SJctrMonitorPortWWNInfo.class);
            SJctrMonitorPortWWNInfo viewData = (SJctrMonitorPortWWNInfo)viewDataList.get(0);
            SJmoWwn selectedWwnInfo = viewData.getWwn();
            String selectedHbaWwnStr = SJctrComUtility.toWWNDisplay(selectedWwnInfo);
            String selectedWwnNameStr = selectedWwnInfo.getStrWWNNickName();
            SJctrMonitorAvailablePortsTableModel availablePortsTable = (SJctrMonitorAvailablePortsTableModel)this.getDataObjectModel(KEY_TABLE_PORTS);
            List<Object> addData = availablePortsTable.getSelectedRowDataOrder();
            SJctrMonitorWWNsTableModel selectedWwnTable = (SJctrMonitorWWNsTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWN);
            List<Object> selectedList = selectedWwnTable.getAllRowData();
            ArrayList<SJctrMonitorPortWWNInfo> addList = new ArrayList<SJctrMonitorPortWWNInfo>();
            SJmoWwn wwnInfo = new SJmoWwn();
            wwnInfo.setByWWN(SJctrComUtility.toByteFromString(selectedHbaWwnStr));
            wwnInfo.setStrWWNNickName(selectedWwnNameStr);
            for (SJctrMonitorAvailablePortsInfo sJctrMonitorAvailablePortsInfo : addData) {
                SJctrMonitorPortWWNInfo monPortWwnInfo = new SJctrMonitorPortWWNInfo(wwnInfo, sJctrMonitorAvailablePortsInfo.getPortDetail());
                addList.add(monPortWwnInfo);
            }
            if (SJctrOptionMonitorUtility.isDuplicationHBAWWNAddTo(selectedHbaWwnStr, addList, selectedList, monWwnInfos, portDetails)) {
                err = new SJctrError(51, 22, 105103);
                SJcException sJcException = err.createException();
                throw sJcException;
            }
            if (SJctrOptionMonitorUtility.isOverMonitoringWWNsMaxAddNew(addList, selectedList, monWwnInfos, portDetails)) {
                err = new SJctrError(51, 22, 105115);
                SJcException sJcException = err.createException();
                throw sJcException;
            }
            List<SJctrMonitorPortWWNInfo> overPorts = SJctrOptionMonitorUtility.getOverMonitoringWWNsMaxPortsAddNew(addList, selectedList, monWwnInfos, portDetails);
            if (0 < overPorts.size()) {
                SJctrMonitorWWNsTableModel sJctrMonitorWWNsTableModel = new SJctrMonitorWWNsTableModel();
                sJctrMonitorWWNsTableModel.initGuidance(this.getComUtility());
                sJctrMonitorWWNsTableModel.setPaging(false);
                sJctrMonitorWWNsTableModel.addRowData(overPorts);
                SJctrRelatedDispDataObject related = this.createDialog(SJctrErrorDataController.class, null);
                SJctrErrorDataController errorDialog = (SJctrErrorDataController)this.getOwner().getDataController(related);
                errorDialog.setParameter(sJctrMonitorWWNsTableModel);
                SJctrError error = new SJctrError(51, 22, 105116);
                SJcException exp2 = error.createException();
                exp2.setErrDisp(related);
                throw exp2;
            }
            selectedWwnTable.addRowData(addList, 0);
            List<Object> list = selectedWwnTable.getFilterData(addList);
            selectedWwnTable.setRowSelectionList(list);
            selectedWwnTable.setCurrentPage(Integer.toString(1));
            selectedWwnTable.setVScrollReset(true);
            selectedWwnTable.setSortColumn(null, Boolean.TRUE);
            this.updateFooter();
            selectedWwnTable.setDirty();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107004);
        }
    }

    private void deleteMonWwnsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrMonitorWWNsTableModel selectedWwnTable = (SJctrMonitorWWNsTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWN);
        selectedWwnTable.removeSelectedRowData();
        this.updateFooter();
        selectedWwnTable.setDirty();
    }

    private void setFinishChangeCheck(boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    public static enum ADD_TO_PORTS_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_DELETE;

    }
}

