/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.editmoncus;

import java.util.Collections;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.comparator.SJctrCUIndexComparator;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorCUInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorCUsTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.editmoncus.SJctrParityGroupPropertySummaryModel;
import sanproject.sn2.controller.wizard.monitor.optmon.editmoncus.SJctrSelectByParityGroupsPGDetailData;
import sanproject.sn2.model.data.volume.SJmoPgDetail;

public class SJctrParityGroupPropertyDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595446;
    private static final String[] DISP_TITLE = SJctrOptionMonitorGuidance.AG_PROPERTY;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_TABLE_CUS = "COM_TABLE_CUS";
    private static final SJctrCUIndexComparator CU_COMP = new SJctrCUIndexComparator();

    public SJctrParityGroupPropertyDC() throws SJcException {
        super(33595446);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrParityGroupPropertySummaryModel());
        SJctrMonitorCUsTableModel propertyTable = new SJctrMonitorCUsTableModel();
        propertyTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_CUS, propertyTable);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getCache(SJctrSelectByParityGroupsPGDetailData.class);
        if (null == viewDataList) {
            this.logUty.putlog("checkConstructData", "List of view data is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (viewDataList.size() == 0) {
            this.logUty.putlog("checkConstructData", "Size of view data list is zero.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrSelectByParityGroupsPGDetailData viewData = (SJctrSelectByParityGroupsPGDetailData)viewDataList.get(0);
        if (null == viewData) {
            this.logUty.putlog("checkConstructData", "View data is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        List<?> viewDataList = this.getCache(SJctrSelectByParityGroupsPGDetailData.class);
        SJctrSelectByParityGroupsPGDetailData viewData = (SJctrSelectByParityGroupsPGDetailData)viewDataList.get(0);
        SJctrParityGroupPropertySummaryModel summary = (SJctrParityGroupPropertySummaryModel)this.getDataObjectModel(KEY_SUMMARY);
        SJmoPgDetail pgDetail = viewData.getPgDetailInfo();
        SJctrLdevUtility ldevUtil = this.getComUtility().getLdevUtility();
        summary.setParityGroupID(ldevUtil.toArrayGroupDisplay(pgDetail));
        List<SJctrMonitorCUInfo> pgCuSList = viewData.getCusInfo();
        SJctrMonitorCUsTableModel cusTable = (SJctrMonitorCUsTableModel)this.getDataObjectModel(KEY_TABLE_CUS);
        Collections.sort(pgCuSList, CU_COMP);
        cusTable.setBasicDataList(pgCuSList);
        return true;
    }
}

