/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.graph;

import java.util.Date;
import sanproject.serverux.data.MonMonitoringInfoLDKC;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrMonitorPerformanceUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrSelectDispTermInfo;

public class SJctrDispTermDataModel
extends SJctrSimpleDataModel {
    private int monDataType = 0;
    protected String specifiedStart = "";
    protected String specifiedEnd = "";
    public static final String KEY_SET_TERM_INFO = "COM_SET_TERM_INFO";
    public static final String KEY_TERM_SEL = "COM_TERM_SEL";
    public static final String KEY_START_DATE = "COM_START_DATE";
    public static final String KEY_END_DATE = "COM_END_DATE";
    public static final String KEY_OLD_SET_TERM = "COM_OLD_SET_TERM";
    public static final String KEY_NEW_SET_TERM = "COM_NEW_SET_TERM";
    public static final String KEY_INTERVAL = "COM_INTERVAL";
    protected static final String KEY_UPDATE_DATE = "COM_UPDATE_DATE";
    protected static final int LONG_INTERVAL = 15;
    protected static final int LONG_DEFAULT_PROT_COUNT = 96;
    protected static final int SHORT_DEFAULT_PROT_COUNT = 89;

    public SJctrDispTermDataModel() {
        this.initDataModel();
        this.initListener();
    }

    public void setMonDataType(int monDataType) {
        this.monDataType = monDataType;
    }

    protected void initDataModel() {
    }

    protected void initListener() {
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrDataObject data;
                SJctrDataObject wkInfo;
                if (setObject instanceof SJctrDataObject && (wkInfo = (SJctrDataObject)(data = (SJctrDataObject)setObject).getData(SJctrDispTermDataModel.KEY_SET_TERM_INFO)) != null) {
                    SJctrDataObject termInfo = (SJctrDataObject)((SJctrDataObject)SJctrDispTermDataModel.this.getManageData()).getData(SJctrDispTermDataModel.KEY_SET_TERM_INFO);
                    termInfo.setData(SJctrDispTermDataModel.KEY_START_DATE, wkInfo.getData(SJctrDispTermDataModel.KEY_START_DATE));
                    termInfo.setData(SJctrDispTermDataModel.KEY_END_DATE, wkInfo.getData(SJctrDispTermDataModel.KEY_END_DATE));
                }
            }
        });
    }

    public void constructDataModel(MonMonitoringInfoLDKC monitoringInfo) {
        SJctrDataObject termInfo = new SJctrDataObject();
        ((SJctrDataObject)this.getManageData()).setData(KEY_SET_TERM_INFO, termInfo);
        String interval = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.INTERVAL2);
        if (monitoringInfo.isStatus()) {
            interval = interval + " " + String.valueOf(monitoringInfo.getInterval() / 60);
            interval = interval + " " + SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.MIN);
        } else {
            interval = interval + " " + SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.BAR);
        }
        termInfo.setData(KEY_INTERVAL, interval);
        this.setDefaultTerm(monitoringInfo);
    }

    public void initUpdateFlg() {
        ((SJctrDataObject)this.getManageData()).setData(KEY_UPDATE_DATE, new Boolean(false));
    }

    public void setDefaultTerm(MonMonitoringInfoLDKC monitoringInfo) {
        Date startDate = null;
        Date endDate = null;
        long setStartTime = 0L;
        long setEndTime = 0L;
        long sTime = 0L;
        long eTime = 0L;
        int interval = 0;
        if (this.getMonDataType() == 1) {
            startDate = monitoringInfo.getLongRangeInfo().getStartDate();
            endDate = monitoringInfo.getLongRangeInfo().getEndDate();
            interval = 15;
        } else if (monitoringInfo.getShortRangeInfo().isExist()) {
            startDate = monitoringInfo.getShortRangeInfo().getStartDate();
            endDate = monitoringInfo.getShortRangeInfo().getEndDate();
            interval = monitoringInfo.getShortRangeInfo().getInterval();
        }
        if (startDate != null) {
            sTime = startDate.getTime();
        }
        if (endDate != null) {
            eTime = endDate.getTime();
        }
        if (this.specifiedStart.length() != 0 && this.specifiedEnd.length() != 0) {
            try {
                long specifiedStartTime = SJctrMonitorPerformanceUtility.getStringToDate(this.specifiedStart, this.logUty).getTime();
                long specifiedEndTime = SJctrMonitorPerformanceUtility.getStringToDate(this.specifiedEnd, this.logUty).getTime();
                if (sTime <= specifiedStartTime && specifiedEndTime <= eTime) {
                    setStartTime = specifiedStartTime;
                    setEndTime = specifiedEndTime;
                }
            }
            catch (SJcException e) {
                this.logUty.putlog("setDefaultTerm", "ParseException:" + e.getMessage());
            }
        }
        if (setStartTime == 0L || setEndTime == 0L) {
            if (this.getMonDataType() == 1) {
                setStartTime = eTime - (long)(interval * 60 * 1000 * 96);
            } else if (monitoringInfo.getShortRangeInfo().isExist()) {
                setStartTime = eTime - (long)(interval * 1000 * 89);
            }
            if (setStartTime < sTime) {
                setStartTime = sTime;
            }
            setEndTime = eTime;
        }
        SJctrDataObject termInfo = (SJctrDataObject)((SJctrDataObject)this.getManageData()).getData(KEY_SET_TERM_INFO);
        String work = "";
        if (setStartTime != 0L) {
            work = SJctrMonitorPerformanceUtility.getDateToString(new Date(setStartTime));
        }
        termInfo.setData(KEY_START_DATE, work);
        work = "";
        if (setEndTime != 0L) {
            work = SJctrMonitorPerformanceUtility.getDateToString(new Date(setEndTime));
        }
        termInfo.setData(KEY_END_DATE, work);
        work = "";
        if (sTime != 0L) {
            work = SJctrMonitorPerformanceUtility.getDateToString(new Date(sTime));
        }
        termInfo.setData(KEY_OLD_SET_TERM, work);
        work = "";
        if (eTime != 0L) {
            work = SJctrMonitorPerformanceUtility.getDateToString(new Date(eTime));
        }
        termInfo.setData(KEY_NEW_SET_TERM, work);
        ((SJctrDataObject)this.getManageData()).setData(KEY_UPDATE_DATE, new Boolean(true));
        this.setDirty();
    }

    public int getMonDataType() {
        return this.monDataType;
    }

    public SJctrSelectDispTermInfo getSelectDispTermInfo() {
        SJctrSelectDispTermInfo dispTermInfo = new SJctrSelectDispTermInfo();
        dispTermInfo.setMonDataType(this.getMonDataType());
        dispTermInfo.setSelectTerm(true);
        SJctrDataObject termInfo = (SJctrDataObject)((SJctrDataObject)this.getManageData()).getData(KEY_SET_TERM_INFO);
        if (termInfo == null) {
            this.logUty.putlog("getSelectDispTermInfo", "termInfo = null");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        String startDate = (String)termInfo.getData(KEY_START_DATE);
        dispTermInfo.setStartDateTerm(startDate);
        String endDate = (String)termInfo.getData(KEY_END_DATE);
        dispTermInfo.setEndDateTerm(endDate);
        String newSetTerm = (String)termInfo.getData(KEY_NEW_SET_TERM);
        dispTermInfo.setEnableNewDate(newSetTerm);
        String oldSetTerm = (String)termInfo.getData(KEY_OLD_SET_TERM);
        dispTermInfo.setEnableOldDate(oldSetTerm);
        return dispTermInfo;
    }

    public String getSpecifiedStart() {
        return this.specifiedStart;
    }

    public void setSpecifiedStart(String specifiedStart) {
        this.specifiedStart = specifiedStart;
    }

    public String getSpecifiedEnd() {
        return this.specifiedEnd;
    }

    public void setSpecifiedEnd(String specifiedEnd) {
        this.specifiedEnd = specifiedEnd;
    }
}

