/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.graph.param;

import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.arg.monitor.ArgPortAbility;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.data.PPCPortAbility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrMonitorPerformanceUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrPlotDataInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrSelectedObjectInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.param.SJctrGetPlotParam;
import sanproject.sn2.model.data.device.SJmoPortDetail;

public class SJctrGetFiberPortTargetPlotParam
extends SJctrGetPlotParam {
    private static final int SET_RMI_PORT_ATTR_TARGET = 1;

    @Override
    public void getModelData() {
        MonitorInfoCollection monitorInfo = this.getDataInf(this.getPortPlotParamArgs());
        PPCPortAbility[] ppc = (PPCPortAbility[])monitorInfo.get();
        if (ppc == null) {
            this.logUty.putlog("getModelData", "PPCPortAbility is null");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        for (int cnt = 0; cnt < this.rowDatas.size(); ++cnt) {
            SJctrPlotDataInfo protData = (SJctrPlotDataInfo)this.rowDatas.get(cnt);
            SJctrSelectedObjectInfo rowData = protData.getRowData();
            SJmoPortDetail portDetail = (SJmoPortDetail)rowData.getRowObject();
            short port = portDetail.getSPort();
            for (int ppcCnt = 0; ppcCnt < ppc.length; ++ppcCnt) {
                String protStr;
                int id = ppc[ppcCnt].getPortID();
                if (port != id) continue;
                List<String> protDatas = protData.getPlotDatas();
                if (rowData.getMonData1().compareTo(SJctrMonitorPerformanceUtility.KEY_THROUGHPUT) == 0) {
                    long[] avrIOPer = ppc[ppcCnt].getAvrIOPerSec();
                    this.chkPerformData(rowData.getObject(), rowData.getMonitorData(), rowData.getObjectName(), avrIOPer);
                    for (long data : avrIOPer) {
                        protData.setMaxData(data);
                        String protStr2 = this.convStr(data);
                        protDatas.add(protStr2);
                    }
                    continue;
                }
                if (rowData.getMonData1().compareTo(SJctrMonitorPerformanceUtility.KEY_DATATRANS) == 0) {
                    long[] avrTrans = ppc[ppcCnt].getAvrTransRate();
                    this.chkPerformData(rowData.getObject(), rowData.getMonitorData(), rowData.getObjectName(), avrTrans);
                    for (long data : avrTrans) {
                        double trans = this.perKiloByte(data);
                        protData.setMaxData(trans);
                        protStr = this.convStr(trans);
                        protDatas.add(protStr);
                    }
                    continue;
                }
                if (rowData.getMonData1().compareTo(SJctrMonitorPerformanceUtility.KEY_RESPONSETIME) == 0) {
                    long[] response = ppc[ppcCnt].getResponseTime();
                    this.chkPerformData(rowData.getObject(), rowData.getMonitorData(), rowData.getObjectName(), response);
                    for (long data : response) {
                        data = this.responseFix(data);
                        double respo = this.perKilo(data);
                        protData.setMaxData(respo);
                        protStr = this.convStr(respo);
                        protDatas.add(protStr);
                    }
                    continue;
                }
                this.logUty.putlog("getModelData", "monData1 N/A");
                SJctrError error = new SJctrError(51, 22, 107001);
                throw error.createException();
            }
        }
    }

    protected Object[] getPortPlotParamArgs() {
        List<SJmoPortDetail> workList = this.createParams();
        int[] ports = this.createPortParams(workList);
        ArgPortAbility param = new ArgPortAbility();
        param.setDataKind(1);
        param.setStartTime(this.startDate);
        param.setEndTime(this.endDate);
        param.setPortID(ports);
        param.setPortAttr(1);
        this.logUty.putlog("getPortPlotParamArgs", this.getClass().getSimpleName() + " setParam[start=" + SJctrMonitorPerformanceUtility.getDateToString(this.startDate) + ",end=" + SJctrMonitorPerformanceUtility.getDateToString(this.endDate) + "]");
        Object[] args = new Object[]{param};
        return args;
    }

    protected List<SJmoPortDetail> createParams() {
        ArrayList<SJmoPortDetail> workList = new ArrayList<SJmoPortDetail>();
        for (SJctrPlotDataInfo plotData : this.rowDatas) {
            SJctrSelectedObjectInfo rowData = plotData.getRowData();
            SJmoPortDetail portDetail = (SJmoPortDetail)rowData.getRowObject();
            boolean same = false;
            for (SJmoPortDetail work : workList) {
                if (work.compareTo(portDetail) != 0) continue;
                same = true;
                break;
            }
            if (same) continue;
            workList.add(portDetail);
        }
        return workList;
    }

    protected int[] createPortParams(List<SJmoPortDetail> workList) {
        int[] ports = new int[workList.size()];
        int index = 0;
        for (SJmoPortDetail work : workList) {
            short workPort = work.getSPort();
            ports[index] = workPort;
            ++index;
        }
        return ports;
    }
}

