/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.deletepools;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolError;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;

public class SJctrDeletePoolsFptVolAC
extends SJctrApplyController {
    private ArrayList<SJmoPoolDetail> PoolDtlList = null;
    protected List<SJctrError> resultData = null;
    private static int ERR_DELETEPOOL_ONLY = 205216;

    public void setApplyList(ArrayList<SJmoPoolDetail> PoolDtlList) {
        this.PoolDtlList = new ArrayList<SJmoPoolDetail>(PoolDtlList);
        Collections.sort(this.PoolDtlList);
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>();
        applyList.add(this.getFptDelData());
        return applyList;
    }

    private SanRequest getFptDelData() {
        SanRequest rtn = this.newRequest("VVOLupdatePoolDeduplication");
        try {
            rtn.putBoolean("Deduplication", false);
            SanList poolList = rtn.newList("Pools");
            for (SJmoPoolDetail pool : this.PoolDtlList) {
                if (!pool.isPoolDedup()) continue;
                SanObject wkPool = poolList.addObj();
                wkPool.putInt("Id", pool.getPoolId());
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        return rtn;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        SJctrLogUty.info(this.title, "setApplyResult", "START");
        super.setApplyResult(resultObject);
        this.resultData = new ArrayList<SJctrError>();
        if (resultObject instanceof SanResponse) {
            this.setErrData((SanResponse)resultObject);
        }
        SJctrLogUty.info(this.title, "setApplyResult", resultObject.toString());
    }

    private void setErrData(SanResponse kvResponse) {
        SJctrLogUty.info(this.title, "setErrData", "START");
        try {
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(kvResponse);
            if (!errorInfo.hasLowerNodeError()) {
                if (errorInfo.isOverAll()) {
                    this.setError(errorInfo.createError());
                    return;
                }
                return;
            }
            SJctrError error = errorInfo.createError();
            this.setError(error);
            SanList kvResultPools = kvResponse.getList("Pools");
            this.resultData = this.getFptError(kvResultPools);
        }
        catch (SanDataException ex) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        SJctrLogUty.info(this.title, "setErrData", "END");
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public int getLeadTime() {
        int iDedupliSize = 0;
        for (SJmoPoolDetail pool : this.PoolDtlList) {
            if (!pool.isPoolDedup()) continue;
            ++iDedupliSize;
        }
        int iLeadTime = (iDedupliSize / 256 + 1) * 40;
        return iLeadTime;
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = true;
        if (this.resultData == null || this.resultData.size() == 0) {
            rtn = false;
        }
        return rtn;
    }

    private List<SJctrError> getFptError(SanList kvResultPools) {
        ArrayList<SJctrError> rtn = new ArrayList<SJctrError>();
        try {
            for (int iCnt = 0; iCnt < kvResultPools.size(); ++iCnt) {
                SanObject sanObject = kvResultPools.getObj(iCnt);
                SJctrKeyValueErrorInfo poolErr = new SJctrKeyValueErrorInfo(sanObject.getObj("ErrorInfo"));
                if (poolErr.getErrorCode() == 0) continue;
                SJctrError wkPoolErr = poolErr.createError();
                SJctrPoolError poolIndexErr = new SJctrPoolError(wkPoolErr.getFunc(), wkPoolErr.getModule(), wkPoolErr.getMsg());
                SJmoPoolIndex poolIdx = new SJmoPoolIndex();
                poolIdx.setPoolId(sanObject.getInt("Id"));
                poolIndexErr.setkeyData(poolIdx);
                poolIndexErr.setStrAssignTableKey("COM_TABLE");
                rtn.add(poolIndexErr);
            }
            for (SJmoPoolDetail sJmoPoolDetail : this.PoolDtlList) {
                boolean bErr = false;
                for (int i = 0; i < rtn.size(); ++i) {
                    SJctrPoolError poolErr = (SJctrPoolError)rtn.get(i);
                    SJmoPoolIndex poolIndex = (SJmoPoolIndex)poolErr.getkeyData();
                    if (sJmoPoolDetail.getPoolId() != poolIndex.getPoolId()) continue;
                    bErr = true;
                    break;
                }
                if (bErr) continue;
                SJctrPoolError poolIndexErr = new SJctrPoolError(31, 22, ERR_DELETEPOOL_ONLY);
                poolIndexErr.setkeyData(sJmoPoolDetail);
                poolIndexErr.setStrAssignTableKey("COM_TABLE");
                rtn.add(poolIndexErr);
            }
        }
        catch (SanDataException ex) {
            SJctrError sJctrError = new SJctrError(33, 5, 1049);
            this.setError(sJctrError);
        }
        return rtn;
    }

    public boolean chkDeduplication() {
        boolean rtn = false;
        for (SJmoPoolDetail pool : this.PoolDtlList) {
            if (!pool.isPoolDedup()) continue;
            rtn = true;
            break;
        }
        return rtn;
    }
}

