/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.monitorpools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.pool.monitorpools.SJctrMonitorPoolsAC;
import sanproject.sn2.controller.wizard.pool.monitorpools.SJctrMonitorPoolsConfirmDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.group.SJmoPbTSMMonitorOperationInfo;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolSummary;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;

public class SJctrMonitorPoolsSubWizard
extends SJctrSubWizard {
    private static final Class<?> CONFIRM_DC = SJctrMonitorPoolsConfirmDC.class;
    public static final String KEY_CLASS_DISPID = "KEY_CLASS_DISPID";
    public static final String KEY_CLASS_POOL_INDEX = "KEY_CLASS_POOL_INDEX";
    private List<SJmoPoolDetail> m_SelPoolList = null;

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", "MONITOR_PL");
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            this.checkStartData(wizard);
            this.checkConstructData(wizard);
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrMonitorPoolsAC ac = new SJctrMonitorPoolsAC();
            ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>((ArrayList)wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
            ac.setApplyList(poolDtlList);
            wizard.addConfirmData(ac, related);
        }
        catch (SJcException ctrExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructConfirmData", "catch SJcException", ctrExp);
            throw ctrExp;
        }
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> retSet = new HashSet<SJctrGetDirectWrapper>();
        try {
            SJctrGetDirectWrapper getDirectWrpPoolDetail = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
            retSet.add(getDirectWrpPoolDetail);
            SJctrGetDirectWrapper getDirectWrpPoolName = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
            retSet.add(getDirectWrpPoolName);
            SJctrGetDirectWrapper getDirectWrpMonInfo = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_MONOPRATION_INFO);
            retSet.add(getDirectWrpMonInfo);
            SJctrGetDirectWrapper getDirectWrpPoolSummary = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY);
            retSet.add(getDirectWrpPoolSummary);
            SJctrGetDirectWrapper getDrctWrpTiPairPVolInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_TIPAIR_PVOL_STATUS);
            retSet.add(getDrctWrpTiPairPVolInf);
        }
        catch (SJcException ctrExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getModelDirect", "catch SJcException", ctrExp);
            throw ctrExp;
        }
        return retSet;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) throws SJcException {
        SJctrGetDirectWrapper getDrctWrap = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList search = new ArrayList();
            SJmoGetDirect getDrct = new SJmoGetDirect(kind, range, search);
            getDrctWrap = new SJctrGetDirectWrapper(getDrct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch InstantiationException", insExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch IllegalAccessException", illExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return getDrctWrap;
    }

    public boolean checkStartData(SJctrWizardWindowDC wizard) {
        boolean bRetChk = true;
        ArrayList setPoolList = new ArrayList(wizard.getCache(KEY_CLASS_POOL_INDEX));
        if (null == setPoolList || 0 == setPoolList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "selPoolList or selPoolVolList is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107008);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        this.m_SelPoolList = setPoolList;
        return bRetChk;
    }

    public boolean checkConstructData(SJctrWizardWindowDC wizard) {
        boolean bRetChk = true;
        ArrayList<SJmoPoolDetail> shkPoolDtlLst = new ArrayList<SJmoPoolDetail>();
        ArrayList shkmonInfoLst = new ArrayList();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
        SJcException ctrExp = null;
        ArrayList poolDtlLst = new ArrayList(wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        ArrayList<SJmoPbTSMMonitorOperationInfo> monInfoLst = new ArrayList<SJmoPbTSMMonitorOperationInfo>(wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_MONOPRATION_INFO));
        ArrayList<SJmoPoolSummary> poolSummaryList = new ArrayList<SJmoPoolSummary>(wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY));
        Collections.sort(this.m_SelPoolList);
        Collections.sort(poolDtlLst);
        if (null != poolDtlLst && 0 != poolDtlLst.size()) {
            for (int iSelPoolCnt = 0; iSelPoolCnt < this.m_SelPoolList.size(); ++iSelPoolCnt) {
                SJmoPoolDetail poolDtl = this.m_SelPoolList.get(iSelPoolCnt);
                int iPoolDtlIdx = Collections.binarySearch(poolDtlLst, poolDtl);
                if (0 <= iPoolDtlIdx) {
                    try {
                        SJmoPoolDetail shkPoolDtl = (SJmoPoolDetail)((SJmoPoolDetail)poolDtlLst.get(iPoolDtlIdx)).clone();
                        shkPoolDtlLst.add(shkPoolDtl);
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Object.clone() is failed");
                        bRetChk = false;
                        SJctrError ctrErr = new SJctrError(31, 22, 107007);
                        ctrExp = ctrErr.createException();
                        throw ctrExp;
                    }
                }
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolDetail is not found");
                bRetChk = false;
                SJctrError ctrErr = new SJctrError(31, 22, 107023);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            bRetChk = this.checkMonitorPools(shkPoolDtlLst, monInfoLst, poolSummaryList, errList, wizard);
            if (!bRetChk) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "checkMonitorPool is Error");
                ctrExp = this.makeErrInfTableSP(wizard, errList);
                throw ctrExp;
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolDetail is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        wizard.putCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, shkPoolDtlLst);
        return bRetChk;
    }

    private boolean checkMonitorPools(List<SJmoPoolDetail> poolDetailList, List<SJmoPbTSMMonitorOperationInfo> monInfoList, List<SJmoPoolSummary> poolSummaryList, List<SJctrErrorColumnData> errList, SJctrWizardWindowDC wizard) {
        String strFuncName = "checkMonitorPools";
        boolean bRet = true;
        long poolStatus = 0L;
        ArrayList<SJmoPbTSMMonitorOperationInfo> selMonInfList = new ArrayList<SJmoPbTSMMonitorOperationInfo>();
        SJcException ctrExp = null;
        if (null == poolSummaryList || 0 == poolSummaryList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkMonitorPools", "poolSummaryList is null or size 0");
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        SJmoPoolSummary poolSummary = poolSummaryList.get(0);
        for (int i = 0; i < poolDetailList.size(); ++i) {
            SJctrError ctrErr;
            SJmoPoolDetail poolDtl = poolDetailList.get(i);
            poolStatus = poolDtl.getPoolStatus();
            if (2 != poolDtl.getPoolKind() && 3 != poolDtl.getPoolKind()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "Poolkind is not DP or MFDP. - Pool ID :" + poolDtl.getPoolId());
                SJctrError ctrErr2 = new SJctrError(31, 22, 106033);
                ctrExp = ctrErr2.createException();
                throw ctrExp;
            }
            int iMsgID = this.checkPoolStatus(poolStatus);
            if (iMsgID != 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "poolStatus is not Normal. - Pool ID :" + poolDtl.getPoolId());
                bRet = false;
                ctrErr = new SJctrError(31, 22, iMsgID);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            if ((0x80 & poolDtl.getITierControlInfo()) != 128 && !poolSummary.chkBPoolControl(0x40000000)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "System Option Monitoring Mode is OFF. - iPoolControl: " + poolSummary.getIPoolControl());
                ctrErr = new SJctrError(31, 22, 206140);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            this.checkLicense(poolDtl, wizard);
            if ((0x40 & poolDtl.getITierControlInfo()) == 64) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "Tiercheck(Auto) is false. - Pool ID :" + poolDtl.getPoolId() + " - TierControlInfo :" + poolDtl.getITierControlInfo());
                bRet = false;
                ctrErr = new SJctrError(31, 22, 106095);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            List<SJmoTiPvolStatus> tiPVolStatusList = wizard.getCache(SJctrPoolUtility.KEY_CLASS_TIPAIR_PVOL_STATUS);
            this.checkTIPairExistsInPool(poolDtl, tiPVolStatusList);
            int iPoolMonInfIdx = Collections.binarySearch(monInfoList, poolDtl);
            if (0 > iPoolMonInfIdx) continue;
            SJmoPbTSMMonitorOperationInfo poolmonInf = monInfoList.get(iPoolMonInfIdx);
            selMonInfList.add(poolmonInf);
        }
        if (this.checkMonitoringPools(selMonInfList)) {
            bRet = false;
        }
        return bRet;
    }

    private int checkPoolStatus(long poolStatus) {
        int iErrorCode = 0;
        if (poolStatus == 4101L) {
            return iErrorCode;
        }
        long lPoolStatusValue = poolStatus & 0xFFFFL;
        if (lPoolStatusValue == 4096L) {
            iErrorCode = 106025;
        } else if (lPoolStatusValue == 4097L) {
            iErrorCode = 106024;
        }
        return iErrorCode;
    }

    public boolean checkMonitoringPools(List<SJmoPbTSMMonitorOperationInfo> poolMonOperation) {
        String strFuncName = "checkMonitoringPools";
        SJcException ctrExp = null;
        boolean flg = false;
        if (null == poolMonOperation || poolMonOperation.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkMonitoringPools", "SJmoPbTSMMonitorOperationInfo is null or size 0");
            SJctrError ctrErr = new SJctrError(31, 22, 106099);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        for (int i = 0; i < poolMonOperation.size(); ++i) {
            SJmoPbTSMMonitorOperationInfo iPoolMonOperation = poolMonOperation.get(i);
            if (null == iPoolMonOperation) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "retList(" + i + ")" + "is null :");
                flg = false;
                SJctrError ctrErr = new SJctrError(31, 22, 106099);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            if (0L != iPoolMonOperation.getLErrorCode()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "poolMonOperation is not Normal. - Pool ID :" + iPoolMonOperation.getPoolId() + ", ErrorCode : " + iPoolMonOperation.getLErrorCode());
                flg = false;
                SJctrError ctrErr = new SJctrError(31, 22, 106096);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            if (1 == iPoolMonOperation.getSPerformanceMonitorState()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "This pool is Monitoring. - Pool ID :" + iPoolMonOperation.getPoolId());
                flg = true;
                SJctrError ctrErr = new SJctrError(31, 22, 106097);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            if (0 != iPoolMonOperation.getSPerformanceMonitorState() || 1 != iPoolMonOperation.getSMonitorSideState()) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "This pool is calculating. - Pool ID :" + iPoolMonOperation.getPoolId());
            flg = true;
            SJctrError ctrErr = new SJctrError(31, 22, 106098);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return flg;
    }

    private SJcException makeErrInfTableSP(SJctrWizardWindowDC wizard, List<SJctrErrorColumnData> errList) {
        SJctrRelatedDispDataObject relDisp = wizard.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController userCtr = wizard.getOwner();
        SJctrDataController beginDC = wizard.getParentDC();
        SJcException ctrExp = SJctrPoolUtility.makeErrInfTable(relDisp, userCtr, beginDC, errList);
        return ctrExp;
    }

    private void checkLicense(SJmoPoolDetail poolDetail, SJctrWizardWindowDC wizard) {
        String strFuncName = "checkLicense";
        SJctrLicenseContainer lcnsCtnr = wizard.getOwner().getAuthorizeContainer().getLisenceContainer();
        if (poolDetail.getEmulationType() == 0) {
            if ((poolDetail.getITierControlInfo() & 0x80) == 128) {
                if (!lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_HDTPM)) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "License is unavailable[Dynamic Tiering]");
                    SJctrPoolUtility.SJctrErrorDialog(106078);
                }
            } else if (!lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_DP)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "License is unavailable[Dynamic Provisioing]");
                SJctrPoolUtility.SJctrErrorDialog(106078);
            }
        } else if (poolDetail.getEmulationType() == 1) {
            if ((poolDetail.getITierControlInfo() & 0x80) == 128) {
                if (!lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_MFDT)) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "License is unavailable[Dynamic Tiering Mainframe]");
                    SJctrPoolUtility.SJctrErrorDialog(106078);
                }
            } else if (!lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_DPFM)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "License is unavailable[Dynamic Provisioing Mainframe]");
                SJctrPoolUtility.SJctrErrorDialog(106078);
            }
        }
    }

    private void checkTIPairExistsInPool(SJmoPoolDetail poolDtl, List<SJmoTiPvolStatus> tiPVolStatusList) {
        String strFuncName = "checkTIPairExistsInPool";
        SJctrPoolUtility poolUtil = this.getComUtility().getPoolUtility();
        if (poolUtil.checkTIPairExistsInPool(poolDtl, tiPVolStatusList)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), strFuncName, "TI pair exists in DP pool. - Pool ID :" + poolDtl.getPoolId());
            SJctrPoolUtility.SJctrErrorDialog(206331);
        }
    }
}

