/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.restorepools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolTaskVersion;
import sanproject.sn2.controller.wizard.pool.restorepools.SJctrRestorePoolsAC;
import sanproject.sn2.controller.wizard.pool.restorepools.SJctrRestorePoolsConfirmDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrRestorePoolsSubWizard
extends SJctrSubWizard {
    private static final Class<?> CONFIRM_DC = SJctrRestorePoolsConfirmDC.class;
    private List<SJmoPoolDetail> m_SelPoolList = null;

    @Override
    public SJctrError checkInitParam(Object param) {
        return null;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        this.checkStartData(wizard);
        this.checkConstructData(wizard);
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrRestorePoolsAC ac = new SJctrRestorePoolsAC();
        ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>(wizard.getCache("KEY_POOL_RECOVER"));
        ac.setApplyList(poolDtlList);
        wizard.addConfirmData(ac, related);
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public short[] getRequireRoll() {
        short[] sRoll = new short[1];
        return sRoll;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", "RESTORE_PL");
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> retSet = new HashSet<SJctrGetDirectWrapper>();
        SJctrGetDirectWrapper getDrctWpPoolVolDtil = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        retSet.add(getDrctWpPoolVolDtil);
        SJctrGetDirectWrapper getDrctWrpPoolNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        retSet.add(getDrctWrpPoolNameInf);
        return retSet;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) throws SJcException {
        SJctrGetDirectWrapper getDrctWrap = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList search = new ArrayList();
            SJmoGetDirect getDrct = new SJmoGetDirect(kind, range, search);
            getDrctWrap = new SJctrGetDirectWrapper(getDrct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch InstantiationException", insExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch IllegalAccessException", illExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return getDrctWrap;
    }

    public boolean checkStartData(SJctrWizardWindowDC wizard) {
        boolean bRetChk = true;
        List<?> setpoolList = wizard.getCache("KEY_CLASS_POOL_INDEX");
        if (null == setpoolList || 0 == setpoolList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "Select Pool(PoolVol) is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107008);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        this.m_SelPoolList = setpoolList;
        return bRetChk;
    }

    public boolean checkConstructData(SJctrWizardWindowDC wizard) {
        SJctrCapacityUtility.UNIT unitDefaultUnitSelect;
        boolean bRetChk = true;
        SJctrPoolTaskVersion poolTaskVersionInfo = new SJctrPoolTaskVersion(1);
        ArrayList<SJctrPoolTaskVersion> versionList = new ArrayList<SJctrPoolTaskVersion>();
        versionList.add(poolTaskVersionInfo);
        wizard.putCache(SJctrPoolUtility.KEY_CLASS_POOL_TASK_VERSION.getName(), versionList);
        ArrayList<Object> shkPoolDtlLst = new ArrayList();
        shkPoolDtlLst = new ArrayList(wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        if (null == shkPoolDtlLst || 0 == shkPoolDtlLst.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Select Pool(PoolVol) is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        bRetChk = this.checkPoolrestore(wizard, shkPoolDtlLst);
        boolean bMFFlg = false;
        boolean bOpenFlg = false;
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        for (int iCnt = 0; !(iCnt >= this.m_SelPoolList.size() || bOpenFlg && bMFFlg); ++iCnt) {
            SJmoPoolDetail poolDetail = this.m_SelPoolList.get(iCnt);
            if (SJctrPoolUtility.isOpenPool(poolDetail)) {
                bOpenFlg = true;
                continue;
            }
            if (!SJctrPoolUtility.isMainframePool(poolDetail)) continue;
            bMFFlg = true;
        }
        if (!bOpenFlg && bMFFlg && !(unitDefaultUnitSelect = SJctrCapacityUtility.UNIT.valueOf(this.getUnitSelect())).equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
            this.setUnitSelect(util.getUnitString(SJctrCapacityUtility.UNIT.CYL));
            String key = SJctrConfirmDataController.getConfirmUnitKey(this.getConfirmClass());
            ArrayList<String> list = new ArrayList<String>();
            list.add(util.getUnitString(SJctrCapacityUtility.UNIT.CYL));
            wizard.getProxy().putCache(key, list);
        }
        return bRetChk;
    }

    public boolean checkPoolrestore(SJctrWizardWindowDC wizard, List<SJmoPoolDetail> getpoolList) {
        boolean bRetChk = true;
        int iErrorCode = 107007;
        SJctrError errorData = null;
        SJctrError repErrorData = null;
        SJctrErrorColumnData errorColumn = null;
        ArrayList<SJctrErrorColumnData> errorColumnList = new ArrayList<SJctrErrorColumnData>();
        SJctrDataController beginDC = null;
        SJctrTableDataModel begintable = null;
        SJctrRelatedDispDataObject errObj = null;
        SJctrErrorDataController errDC = null;
        SJcException exception = null;
        ArrayList<SJmoPoolDetail> restoreOKPoolDtlLst = new ArrayList<SJmoPoolDetail>();
        ArrayList restoreNGPoolDtlLst = new ArrayList();
        Collections.sort(getpoolList);
        for (int iIndex = 0; iIndex < this.m_SelPoolList.size(); ++iIndex) {
            SJmoPoolDetail setpooldtl = this.m_SelPoolList.get(iIndex);
            int ipoolpojition = Collections.binarySearch(getpoolList, setpooldtl);
            if (ipoolpojition >= 0) {
                SJmoPoolDetail getpool = getpoolList.get(ipoolpojition);
                long ipoolStatus = getpool.getPoolStatus();
                if (ipoolStatus == 4097L) {
                    restoreOKPoolDtlLst.add(getpool);
                    continue;
                }
                iErrorCode = this.getErrorCode(ipoolStatus);
                errorData = new SJctrError(31, 22, iErrorCode);
                errorColumn = new SJctrErrorColumnData(getpool, errorData);
                errorColumnList.add(errorColumn);
                bRetChk = false;
                continue;
            }
            SJctrError ctrErr = new SJctrError(31, 22, 107023);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        if (!bRetChk) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPoolrestore", "Select Pool(PoolVol) is restor NG");
            SJctrRelatedDispDataObject relDisp = wizard.createDialog(SJctrErrorDataController.class, null);
            SJctrUserController userCtr = wizard.getOwner();
            beginDC = wizard.getParentDC();
            begintable = (SJctrTableDataModel)beginDC.getDataObjectModel("COM_TABLE");
            errObj = wizard.createDialog(SJctrErrorDataController.class, null);
            errDC = (SJctrErrorDataController)wizard.getOwner().getDataController(errObj);
            errDC.setParameter(begintable, errorColumnList);
            repErrorData = errDC.getRepresentativeError(errorColumnList, 5);
            exception = repErrorData.createException();
            exception.setErrDisp(errObj);
            throw exception;
        }
        wizard.putCache("KEY_POOL_RECOVER", restoreOKPoolDtlLst);
        return bRetChk;
    }

    private int getErrorCode(long lPoolStatus) {
        int iErrorCode = 107007;
        boolean iCnt = false;
        long lPoolStatusValue = 0L;
        lPoolStatusValue = lPoolStatus & 0xFFFFL;
        if (lPoolStatusValue == 4096L) {
            iErrorCode = 106062;
        } else if (lPoolStatusValue == 4097L) {
            if ((lPoolStatus & 0x10000L) != 0L) {
                iErrorCode = 106026;
            }
        } else {
            iErrorCode = lPoolStatusValue == 4098L ? 106063 : 106064;
        }
        return iErrorCode;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }
}

