/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.shrinkpool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.comparator.SJctrPoolIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolError;
import sanproject.sn2.controller.wizard.pool.com.SJctrWarnPGTableDataModel;
import sanproject.sn2.controller.wizard.pool.shrinkpool.SJctrShrinkPoolResultTableModel;
import sanproject.sn2.controller.wizard.pool.shrinkpool.SJctrShrinkPoolSubWizard;
import sanproject.sn2.controller.wizard.pool.shrinkpool.SJctrShrinkPoolVolumesTableModel;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrShrinkPoolConfirmDC
extends SJctrConfirmDataController {
    public static final int DISP_ID = 17870960;
    public static final String KEY_TABLE_SHRINKRSLT = "COM_TABLE_SHRINKRSLT";
    public static final String KEY_TABLE_POOLVOLUMES = "COM_TABLE_POOLVOLUMES";
    public static final String KEY_CLASS_POOL_INDEX = "KEY_CLASS_POOL_INDEX";
    public static final String KEY_CLASS_POOLVOL_INDEX = "KEY_CLASS_POOLVOL_INDEX";
    public static final String KEY_DISP_START = "COM_DISP_START";
    boolean bWizard = false;

    public SJctrShrinkPoolConfirmDC() {
        super(17870960);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrButtonDataModel btn = new SJctrButtonDataModel();
        btn.setReceiveOnly();
        this.addDataObjectModel(KEY_DISP_START, btn);
        btn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (SJctrShrinkPoolConfirmDC.this.bWizard) {
                    SJctrShrinkPoolConfirmDC.this.chkWarnDialog();
                }
            }
        });
        this.addDataObjectModel(KEY_TABLE_SHRINKRSLT, new SJctrShrinkPoolResultTableModel());
        this.addDataObjectModel(KEY_TABLE_POOLVOLUMES, new SJctrShrinkPoolVolumesTableModel());
    }

    private void chkWarnDialog() {
        List<?> poolDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDtlList.get(0);
        List<SJmoPoolVolDetail> poolVolDtlList = this.getCache(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_POOLVOLDETAIL_LIST);
        List<SJmoLdevDetail> ldevDtlList = this.getCache(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_LDEV_DETAIL_LIST);
        List<SJmoVdevDetail> vdevDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        List<SJmoPgScatteredInfo> pgScatteredInfoList = this.getCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        if (!SJctrPoolUtility.hasNF2KPGPoolVol(poolDtl, poolVolDtlList, ldevDtlList)) {
            return;
        }
        List<?> pgPoolVolMapList = this.getCache("KEY_PG_POOLVOLMAP");
        if (pgPoolVolMapList == null || pgPoolVolMapList.isEmpty()) {
            return;
        }
        Map pgPoolVolMap = (Map)pgPoolVolMapList.get(0);
        ArrayList pgDtlList = new ArrayList(pgPoolVolMap.keySet());
        Collections.sort(pgDtlList);
        ArrayList<SJctrErrorColumnData> errcolmnDataList = new ArrayList<SJctrErrorColumnData>(pgDtlList.size());
        for (SJmoPgDetail pgDtl : pgDtlList) {
            if (!SJctrPoolUtility.checkNF2KPG(pgDtl)) continue;
            List poolVolInfoList = (List)pgPoolVolMap.get(pgDtl);
            List<SJmoVdevDetail> scVdevDtl = SJctrPoolUtility.getScatteredVdevDtlList(pgDtl, vdevDtlList, pgScatteredInfoList);
            if (SJctrPoolUtility.checkPGExpantionRate(poolDtl, scVdevDtl, poolVolInfoList)) continue;
            SJctrError err = new SJctrError(31, 22, 209017);
            SJctrErrorColumnData errcolumn = new SJctrErrorColumnData(pgDtl, err);
            errcolmnDataList.add(errcolumn);
        }
        if (!errcolmnDataList.isEmpty()) {
            this.makeWarnDialog(errcolmnDataList);
        }
    }

    private void makeWarnDialog(List<SJctrErrorColumnData> errcolmnDataList) {
        String strFuncID = Integer.toString(31);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(209016);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrUserController uc = this.getOwner();
        SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
        ArrayList<Comparable> primaryKeyList = new ArrayList<Comparable>(errcolmnDataList.size());
        for (SJctrErrorColumnData errcolumn : errcolmnDataList) {
            primaryKeyList.add(errcolumn.getKeyObj());
        }
        SJctrWarnPGTableDataModel table = new SJctrWarnPGTableDataModel();
        table.setPrimaryKeyData(primaryKeyList);
        List<?> poolDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        table.setBasicData(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, poolDtlList);
        List<?> pgPoolVolMapList = this.getCache("KEY_PG_POOLVOLMAP");
        table.setBasicData(SJctrPoolUtility.KEY_PG_POOLVOL, pgPoolVolMapList);
        List<?> vdevDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        table.setBasicData(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL, vdevDtlList);
        List<?> pgScatteredInfoList = this.getCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        table.setBasicData(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF, pgScatteredInfoList);
        table.setDataController(this);
        table.initGuidance(this.getOwner().getComUtility());
        table.makeDataModel();
        msgDC.setErrColumnTableParam(table.getTableTitle(), table.getAlignRightColumnList(), table, errcolmnDataList);
        this.addUpdateDisp(related);
    }

    @Override
    public boolean checkStartData() {
        boolean bRetChk = true;
        ArrayList confDataPoolDtl = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        ArrayList confDataPoolVolDtl = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        ArrayList confDataLdevDtl = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        List<?> confDataOrgPoolVolDtl = this.getCache(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_POOLVOLDETAIL_LIST);
        if (null == confDataPoolDtl || 0 == confDataPoolDtl.size() || null == confDataPoolVolDtl || 0 == confDataPoolVolDtl.size() || null == confDataLdevDtl || 0 == confDataLdevDtl.size() || null == confDataOrgPoolVolDtl || 0 == confDataOrgPoolVolDtl.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "CacheData is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return bRetChk;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        this.bWizard = true;
        HashMap mapKey = new HashMap();
        ArrayList confDataPoolDtl = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        mapKey.put(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL.getName(), confDataPoolDtl);
        ArrayList confDataPoolVolDtl = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        mapKey.put(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL.getName(), confDataPoolVolDtl);
        ArrayList confDataLdevDtl = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        mapKey.put(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL.getName(), confDataLdevDtl);
        ArrayList confDataPoolNameInf = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO));
        mapKey.put(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO.getName(), confDataPoolNameInf);
        ArrayList confDataLdevNameInf = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO));
        mapKey.put(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO.getName(), confDataLdevNameInf);
        List<?> confOrgDataPoolVolDtl = this.getCache(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_POOLVOLDETAIL_LIST);
        mapKey.put(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_POOLVOLDETAIL_LIST.getName(), confOrgDataPoolVolDtl);
        List<?> confOrgLdevInfo = this.getCache(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_LDEV_DETAIL_LIST);
        mapKey.put(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_LDEV_DETAIL_LIST.getName(), confOrgLdevInfo);
        List<?> confDataVdevDtl = this.getCache(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        mapKey.put(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL.getName(), confDataVdevDtl);
        List<?> confDataPgDtl = this.getCache(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        mapKey.put(SJctrPoolUtility.KEY_CLASS_PG_DETAIL.getName(), confDataPgDtl);
        List<?> confDataScPgInfo = this.getCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        if (confDataScPgInfo == null) {
            confDataScPgInfo = new ArrayList();
        }
        mapKey.put(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF.getName(), confDataScPgInfo);
        return mapKey;
    }

    @Override
    public void getConfirmWithStatus(List<Object> errDtlList) {
        ArrayList poolVolList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        ArrayList poolDtlList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        ArrayList poolNameInfList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO));
        ArrayList ldevNameInfList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO));
        ArrayList poolVolInfList = new ArrayList(this.getCacheModelData(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_POOLVOLDETAIL_LIST));
        ArrayList orgLdevInfList = new ArrayList(this.getCacheModelData(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_LDEV_DETAIL_LIST));
        ArrayList vdevDtlList = new ArrayList(this.getCacheModelData(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL));
        ArrayList pgDtlList = new ArrayList(this.getCacheModelData(SJctrPoolUtility.KEY_CLASS_PG_DETAIL));
        SJctrShrinkPoolResultTableModel rstShrinkTbl = (SJctrShrinkPoolResultTableModel)this.getDataObjectModel(KEY_TABLE_SHRINKRSLT);
        SJctrShrinkPoolVolumesTableModel rstPoolVolTbl = (SJctrShrinkPoolVolumesTableModel)this.getDataObjectModel(KEY_TABLE_POOLVOLUMES);
        rstShrinkTbl.setBasicData(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, poolDtlList);
        rstShrinkTbl.setBasicData(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO, poolNameInfList);
        rstShrinkTbl.setBasicData(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_POOLVOLDETAIL_LIST, poolVolInfList);
        rstShrinkTbl.setBasicData(SJctrShrinkPoolSubWizard.KEY_CLASS_ORG_LDEV_DETAIL_LIST, orgLdevInfList);
        rstShrinkTbl.setBasicData(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL, vdevDtlList);
        rstShrinkTbl.setBasicData(SJctrPoolUtility.KEY_CLASS_PG_DETAIL, pgDtlList);
        rstPoolVolTbl.setBasicData(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL, poolVolList);
        rstPoolVolTbl.setBasicData(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO, ldevNameInfList);
        rstShrinkTbl.makeDataModel();
        rstPoolVolTbl.makeDataModel();
        ArrayList<SJctrErrorColumnData> shrinkErrList = new ArrayList<SJctrErrorColumnData>();
        ArrayList<SJctrErrorColumnData> poolVolErrList = new ArrayList<SJctrErrorColumnData>();
        List poolErrList = (List)errDtlList.get(0);
        for (int iCnt = 0; iCnt < poolErrList.size(); ++iCnt) {
            ArrayList errList = new ArrayList((List)poolErrList.get(iCnt));
            for (int iErrCnt = 0; iErrCnt < errList.size(); ++iErrCnt) {
                SJctrPoolError poolErr = (SJctrPoolError)errList.get(iErrCnt);
                Comparable keyObj = (Comparable)poolErr.getkeyData();
                SJctrErrorColumnData errClm = new SJctrErrorColumnData(keyObj, poolErr);
                if (poolErr.getStrAssignTableKey().equals(KEY_TABLE_SHRINKRSLT)) {
                    shrinkErrList.add(errClm);
                    continue;
                }
                if (!poolErr.getStrAssignTableKey().equals(KEY_TABLE_POOLVOLUMES)) continue;
                poolVolErrList.add(errClm);
            }
        }
        Collections.sort(shrinkErrList, new SJctrPoolIndexComparator());
        Collections.sort(poolVolErrList, new SJctrLdevIndexComparator());
        SJctrErrorTableModel rstShrinkErrTbl = new SJctrErrorTableModel();
        SJctrErrorTableModel rstPoolVolErrTbl = new SJctrErrorTableModel();
        rstPoolVolErrTbl.setOpenVolumeFlg(rstPoolVolTbl.hasOpenVolume());
        rstPoolVolErrTbl.setMainframeVolumeFlg(rstPoolVolTbl.hasMainframeVolume());
        rstPoolVolErrTbl.setDpVolumeFlg(rstPoolVolTbl.hasDpVolume());
        this.addDataObjectModel(KEY_TABLE_SHRINKRSLT, rstShrinkErrTbl);
        this.addDataObjectModel(KEY_TABLE_POOLVOLUMES, rstPoolVolErrTbl);
        rstShrinkErrTbl.initialize(rstShrinkTbl, shrinkErrList, new SJctrPoolIndexComparator());
        rstPoolVolErrTbl.initialize(rstPoolVolTbl, poolVolErrList, new SJctrLdevIndexComparator());
    }

    private List<?> getCacheModelData(Class<?> key) {
        List<Object> getData = this.getCache(key);
        if (getData == null) {
            getData = Collections.emptyList();
        }
        return getData;
    }
}

