/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.shrinkpool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.pool.shrinkpool.SJctrShrinkPoolAC;
import sanproject.sn2.controller.wizard.pool.shrinkpool.SJctrShrinkPoolConfirmDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.group.SJmoSnapshotVvolRelationByPool;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrShrinkPoolSubWizard
extends SJctrSubWizard {
    private static final Class<?> CONFIRM_DC = SJctrShrinkPoolConfirmDC.class;
    public static final String KEY_CLASS_DISPID = "KEY_CLASS_DISPID";
    public static final String KEY_CLASS_POOL_INDEX = "KEY_CLASS_POOL_INDEX";
    public static final String KEY_CLASS_POOLVOL_INDEX = "KEY_CLASS_POOLVOL_INDEX";
    private List<SJmoPoolDetail> m_SelPoolList = null;
    private List<SJmoPoolVolInfo> m_SelPoolVolList = null;
    private List<SJmoLdevDetail> allLdevDetailList = null;
    private List<SJmoVdevDetail> vdevDetailList = null;
    private List<SJmoPgDetail> pgDetailList = null;
    private List<SJmoPoolVolDetail> orgPoolVolDtlList = null;
    private static final long[] spPoolStatusList = new long[]{4101L, 2147487750L, 1073745926L, 3221229574L, 2684358662L};
    private static final Class<?> KEY_CLASS_VVOL_RERATION_BY_POOL = SJctrGetPoolVVolRerationInfo.class;
    public static final Class<?> KEY_CLASS_ORG_POOLVOLDETAIL_LIST = SJctrGetOrgPoolVolInfoList.class;
    public static final Class<?> KEY_CLASS_ORG_LDEV_DETAIL_LIST = SJctrGetOrgLdevDetailList.class;
    public static final String KEY_PG_POOLVOLMAP = "KEY_PG_POOLVOLMAP";

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", "SHRINK_PL");
    }

    @Override
    public SJctrError checkInitParam(Object param) {
        SJctrError ctrErr = new SJctrError(0, 0, 0);
        return ctrErr;
    }

    @Override
    public short[] getRequireRoll() {
        short[] sRoll = new short[1];
        return sRoll;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        this.checkStartData(wizard);
        this.checkConstructData(wizard);
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrShrinkPoolAC ac = new SJctrShrinkPoolAC();
        ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>((ArrayList)wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        ArrayList poolVolDtlList = new ArrayList((ArrayList)wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        ArrayList poolVvolrelation = new ArrayList();
        poolVvolrelation = (ArrayList)wizard.getCache(KEY_CLASS_VVOL_RERATION_BY_POOL);
        SJmoPoolVolDetail poolVolDtl = (SJmoPoolVolDetail)poolVolDtlList.get(0);
        ArrayList poolVolInfList = poolVolDtl.getAlPoolInfo();
        ac.setApplyList(poolDtlList, poolVolInfList, poolVvolrelation);
        wizard.addConfirmData(ac, related);
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> retSet = new HashSet<SJctrGetDirectWrapper>();
        SJctrGetDirectWrapper getDrctWrpPoolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        retSet.add(getDrctWrpPoolDtl);
        SJctrGetDirectWrapper getDrctWrpPoolVolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        retSet.add(getDrctWrpPoolVolDtl);
        SJctrGetDirectWrapper getDrctWrpLdevDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        retSet.add(getDrctWrpLdevDtl);
        SJctrGetDirectWrapper getDrctWrpPoolNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        retSet.add(getDrctWrpPoolNameInf);
        SJctrGetDirectWrapper getDrctWrpLdevNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO);
        retSet.add(getDrctWrpLdevNameInf);
        SJctrGetDirectWrapper getDrctHDPRelationByPool = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        retSet.add(getDrctHDPRelationByPool);
        SJctrGetDirectWrapper getDrctSSVvolRelationByPool = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_SNAPSHOT_RELATION_POOLINFO);
        retSet.add(getDrctSSVvolRelationByPool);
        SJctrGetDirectWrapper getDrctWrpVdevDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        retSet.add(getDrctWrpVdevDtl);
        SJctrGetDirectWrapper getDrctWrpPgDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        retSet.add(getDrctWrpPgDtl);
        SJctrGetDirectWrapper getDrctWrpScPg = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        retSet.add(getDrctWrpScPg);
        return retSet;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) throws SJcException {
        SJctrGetDirectWrapper getDrctWrap = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList search = new ArrayList();
            SJmoGetDirect getDrct = new SJmoGetDirect(kind, range, search);
            getDrctWrap = new SJctrGetDirectWrapper(getDrct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch InstantiationException", insExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch IllegalAccessException", illExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return getDrctWrap;
    }

    public boolean checkStartData(SJctrWizardWindowDC wizard) {
        boolean bRetChk = true;
        ArrayList selPoolList = new ArrayList(wizard.getCache(KEY_CLASS_POOL_INDEX));
        ArrayList selPoolVolList = new ArrayList(wizard.getCache(KEY_CLASS_POOLVOL_INDEX));
        if (null == selPoolList || 0 == selPoolList.size() || null == selPoolVolList || 0 == selPoolVolList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "selPoolList or selPoolVolList is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107008);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        this.m_SelPoolList = selPoolList;
        this.m_SelPoolVolList = selPoolVolList;
        return bRetChk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkConstructData(SJctrWizardWindowDC wizard) {
        boolean bRetChk = true;
        ArrayList<SJmoPoolDetail> shkPoolDtlLst = new ArrayList<SJmoPoolDetail>();
        ArrayList<SJmoPoolVolDetail> shkPoolVolDtlLst = new ArrayList<SJmoPoolVolDetail>();
        ArrayList<SJmoPoolVolInfo> shkPoolVolInfLst = new ArrayList<SJmoPoolVolInfo>();
        ArrayList<SJmoLdevDetail> shkLdevDtlLst = new ArrayList<SJmoLdevDetail>();
        ArrayList<SJmoLocalReplicationPairVolInfo> VVolInfolist = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        ArrayList<SJmoPoolVolInfo> poolVolInfoNonSelectList = new ArrayList<SJmoPoolVolInfo>(1024);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
        SJcException ctrExp = null;
        ArrayList poolDtlLst = new ArrayList(wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        ArrayList<SJmoPoolVolDetail> poolVolDtlLst = new ArrayList<SJmoPoolVolDetail>(wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        ArrayList ldevDtlLst = new ArrayList(wizard.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        ArrayList HDPRelationlistList = new ArrayList(wizard.getCache(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL));
        ArrayList SSRelationlistList = new ArrayList(wizard.getCache(SJctrPoolUtility.KEY_CLASS_SNAPSHOT_RELATION_POOLINFO));
        ArrayList<SJmoVdevDetail> vdevDtlLst = new ArrayList<SJmoVdevDetail>((ArrayList)wizard.getCache(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL));
        ArrayList<SJmoPgDetail> pgDtlLst = new ArrayList<SJmoPgDetail>((ArrayList)wizard.getCache(SJctrPoolUtility.KEY_CLASS_PG_DETAIL));
        List<SJmoPgScatteredInfo> scPgList = wizard.getCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        if (null == poolDtlLst || 0 == poolDtlLst.size() || null == poolVolDtlLst || 0 == poolVolDtlLst.size() || null == ldevDtlLst || 0 == ldevDtlLst.size() || null == vdevDtlLst || 0 == vdevDtlLst.size() || null == pgDtlLst || 0 == pgDtlLst.size() || null == scPgList) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolDetail or PoolVolInfo or LdevDetail is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        this.allLdevDetailList = ldevDtlLst;
        this.vdevDetailList = vdevDtlLst;
        this.pgDetailList = pgDtlLst;
        this.orgPoolVolDtlList = new ArrayList<SJmoPoolVolDetail>();
        List pgPoolVolMapList = Collections.emptyList();
        int iSelPoolCnt = 0;
        while (true) {
            ArrayList poolVolInfLst;
            SJmoPoolVolDetail shkPoolVolDtl;
            block24: {
                SJctrCapacityUtility.UNIT unitDefaultUnitSelect;
                if (iSelPoolCnt < this.m_SelPoolList.size()) {
                    SJmoPoolDetail poolDtl = this.m_SelPoolList.get(iSelPoolCnt);
                    int iPoolDtlIdx = Collections.binarySearch(poolDtlLst, poolDtl);
                    int iPoolVolDtlIdx = Collections.binarySearch(poolVolDtlLst, poolDtl);
                    if (0 <= iPoolDtlIdx && 0 <= iPoolVolDtlIdx) {
                        try {
                            SJmoPoolIndex poolIndex = new SJmoPoolIndex();
                            poolIndex.setPoolId(poolDtl.getIndex());
                            SJmoPoolDetail shkPoolDtl = (SJmoPoolDetail)((SJmoPoolDetail)poolDtlLst.get(iPoolDtlIdx)).clone();
                            shkPoolDtlLst.add(shkPoolDtl);
                            byte poolType = shkPoolDtl.getPoolKind();
                            switch (poolType) {
                                case 2: {
                                    if (HDPRelationlistList == null || HDPRelationlistList.isEmpty()) {
                                        SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "HDPRelationlistList is null or empty");
                                        bRetChk = false;
                                        SJctrError ctrErr = new SJctrError(31, 22, 107007);
                                        ctrExp = ctrErr.createException();
                                        throw ctrExp;
                                    }
                                    int dpIndex = Collections.binarySearch(HDPRelationlistList, poolIndex);
                                    if (dpIndex < 0) break;
                                    SJmoHDPRelationByPool hddbypool = (SJmoHDPRelationByPool)HDPRelationlistList.get(dpIndex);
                                    VVolInfolist = hddbypool.getAlDPVOLInfo();
                                    break;
                                }
                                case 8: {
                                    if (SSRelationlistList == null || SSRelationlistList.isEmpty()) {
                                        SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SSRelationlistList is null or empty");
                                        bRetChk = false;
                                        SJctrError ctrErr = new SJctrError(31, 22, 107007);
                                        ctrExp = ctrErr.createException();
                                        throw ctrExp;
                                    }
                                    int tiIndex = Collections.binarySearch(SSRelationlistList, poolIndex);
                                    if (tiIndex < 0) break;
                                    SJmoSnapshotVvolRelationByPool ssByPool = (SJmoSnapshotVvolRelationByPool)SSRelationlistList.get(tiIndex);
                                    VVolInfolist = ssByPool.getAlSnapshotVvolInfo();
                                    break;
                                }
                            }
                            SJmoPoolVolDetail poolVolDtl = (SJmoPoolVolDetail)poolVolDtlLst.get(iPoolVolDtlIdx);
                            this.orgPoolVolDtlList.add(poolVolDtl);
                            shkPoolVolDtl = (SJmoPoolVolDetail)poolVolDtl.clone();
                            poolVolInfLst = shkPoolVolDtl.getAlPoolInfo();
                            for (SJmoPoolVolInfo poolVolInfo : poolVolInfLst) {
                                poolVolInfoNonSelectList.add(poolVolInfo);
                            }
                            Map<SJmoPgDetail, List<SJmoPoolVolInfo>> pgPoolVolMap = SJctrPoolUtility.makePGPoolVolMap(shkPoolDtl, poolVolDtlLst, this.allLdevDetailList, this.pgDetailList, scPgList);
                            pgPoolVolMapList = new ArrayList();
                            pgPoolVolMapList.add(pgPoolVolMap);
                            if (null == poolVolInfLst || 0 == poolVolInfLst.size()) {
                                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolVolDetail is null or size 0");
                                bRetChk = false;
                                SJctrError ctrErr = new SJctrError(31, 22, 107007);
                                ctrExp = ctrErr.createException();
                                throw ctrExp;
                            }
                            break block24;
                        }
                        catch (CloneNotSupportedException e) {
                            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Object.clone() is failed");
                            bRetChk = false;
                            SJctrError ctrErr = new SJctrError(31, 22, 107007);
                            ctrExp = ctrErr.createException();
                            throw ctrExp;
                        }
                    }
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolDetail or PoolVolDetail is not found");
                    bRetChk = false;
                    SJctrError ctrErr = new SJctrError(31, 22, 107023);
                    ctrExp = ctrErr.createException();
                    throw ctrExp;
                }
                SJmoPoolVolDetail shkPoolVolDtl2 = (SJmoPoolVolDetail)poolVolDtlLst.get(0);
                ArrayList poolVolInfLst2 = shkPoolVolDtl2.getAlPoolInfo();
                if (bRetChk) {
                    bRetChk = this.checkShrinkPool(shkPoolDtlLst, shkPoolVolInfLst, poolVolInfoNonSelectList, shkLdevDtlLst, wizard, errList);
                    if (!bRetChk) {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "checkShrinkPool is Error");
                        ctrExp = this.makeErrInfTableSP(wizard, errList);
                        throw ctrExp;
                    }
                    wizard.putCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, shkPoolDtlLst);
                    wizard.putCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL, shkPoolVolDtlLst);
                    wizard.putCache(KEY_CLASS_ORG_POOLVOLDETAIL_LIST, this.orgPoolVolDtlList);
                    wizard.putCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL, shkLdevDtlLst);
                    wizard.putCache(KEY_CLASS_ORG_LDEV_DETAIL_LIST, this.allLdevDetailList);
                    wizard.putCache(KEY_CLASS_VVOL_RERATION_BY_POOL, VVolInfolist);
                    wizard.putCache(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL, this.vdevDetailList);
                    wizard.putCache(KEY_PG_POOLVOLMAP, pgPoolVolMapList);
                    wizard.putCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF, scPgList);
                } else {
                    bRetChk = this.checkShrinkPool(shkPoolDtlLst, shkPoolVolInfLst, poolVolInfoNonSelectList, shkLdevDtlLst, wizard, errList);
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "checkShrinkPool is Error");
                    ctrExp = this.makeErrInfTableSP(wizard, errList);
                    throw ctrExp;
                }
                SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
                SJmoLdevDetail ldevDtl = shkLdevDtlLst.get(0);
                if (SJctrLdevUtility.isMFVolume(ldevDtl) && !(unitDefaultUnitSelect = SJctrCapacityUtility.UNIT.valueOf(this.getUnitSelect())).equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
                    this.setUnitSelect(util.getUnitString(SJctrCapacityUtility.UNIT.CYL));
                    String key = SJctrConfirmDataController.getConfirmUnitKey(this.getConfirmClass());
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(util.getUnitString(SJctrCapacityUtility.UNIT.CYL));
                    wizard.getProxy().putCache(key, list);
                }
                return bRetChk;
            }
            for (int iSelPoolVolCnt = 0; iSelPoolVolCnt < this.m_SelPoolVolList.size(); ++iSelPoolVolCnt) {
                SJmoPoolVolInfo poolVolInf = this.m_SelPoolVolList.get(iSelPoolVolCnt);
                int iPoolVolInfIdx = Collections.binarySearch(poolVolInfLst, poolVolInf);
                int iLdevDtlIdx = Collections.binarySearch(ldevDtlLst, poolVolInf);
                if (0 <= iPoolVolInfIdx && 0 <= iLdevDtlIdx) {
                    SJmoPoolVolInfo shkPoolVolInfOrg = (SJmoPoolVolInfo)poolVolInfLst.get(iPoolVolInfIdx);
                    SJmoPoolVolInfo shkPoolVolInf = (SJmoPoolVolInfo)shkPoolVolInfOrg.clone();
                    shkPoolVolInfLst.add(shkPoolVolInf);
                    poolVolInfoNonSelectList.remove(shkPoolVolInfOrg);
                    SJmoLdevDetail shkLdevDtl = (SJmoLdevDetail)((SJmoLdevDetail)ldevDtlLst.get(iLdevDtlIdx)).clone();
                    shkLdevDtlLst.add(shkLdevDtl);
                    continue;
                }
                bRetChk = false;
                SJmoLdevIndex ldevIdx = new SJmoLdevIndex();
                ldevIdx.setLdevIndex(poolVolInf.getSLdkc(), poolVolInf.getSCu(), poolVolInf.getSLdev());
                SJctrPoolUtility.makeErrList(errList, ldevIdx, 31, 22, 107023);
            }
            shkPoolVolDtl.setAlPoolInfo(shkPoolVolInfLst);
            shkPoolVolDtlLst.add(shkPoolVolDtl);
            ++iSelPoolCnt;
        }
    }

    private boolean checkShrinkPool(List<SJmoPoolDetail> poolDetailList, List<SJmoPoolVolInfo> poolVolInfList, List<SJmoPoolVolInfo> poolVolInfoNonSelectList, List<SJmoLdevDetail> ldevDetailList, SJctrWizardWindowDC wizard, List<SJctrErrorColumnData> errList) throws SJcException {
        boolean directMappingFlg;
        boolean bRet = true;
        long lPoolStatus = 0L;
        int iCnt = 0;
        boolean bResult = false;
        SJcException ctrExp = null;
        int iVolCnt = 0;
        SJmoPoolDetail poolDtl = poolDetailList.get(0);
        lPoolStatus = poolDtl.getPoolStatus();
        long lPoolVolPagesSelAll = 0L;
        for (iVolCnt = 0; iVolCnt < poolVolInfList.size(); ++iVolCnt) {
            SJmoPoolVolInfo poolVolInf = poolVolInfList.get(iVolCnt);
            long lPoolVolPages = poolVolInf.getLPoolVolPages();
            if (poolVolInf.isHeadPoolVol()) {
                lPoolVolPages += 100L;
            }
            lPoolVolPagesSelAll += lPoolVolPages;
        }
        SJmoPoolVolInfo chkPoolVolInf = new SJmoPoolVolInfo();
        chkPoolVolInf.setLPoolVolPages(lPoolVolPagesSelAll);
        ArrayList<SJmoPoolVolInfo> chkPoolVolInfList = new ArrayList<SJmoPoolVolInfo>();
        chkPoolVolInfList.add(chkPoolVolInf);
        for (iCnt = 0; iCnt < spPoolStatusList.length; ++iCnt) {
            if (spPoolStatusList[iCnt] != lPoolStatus) continue;
            bResult = true;
            break;
        }
        if (!bResult) {
            bRet = false;
            int iMsgID = this.getPoolStatusErrorCode(lPoolStatus);
            SJctrError ctrErr = new SJctrError(31, 22, iMsgID);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        SJctrPoolUtility poolUtl = wizard.getOwner().getComUtility().getPoolUtility();
        boolean bl = directMappingFlg = 0L != (poolDtl.getLPoolOptionFlag() & 0x20000000L);
        if (directMappingFlg) {
            poolUtl.dMPoolShrinkCheck(poolVolInfList, poolVolInfoNonSelectList, this.allLdevDetailList);
        } else {
            List<SJmoPoolVolInfo> thresholdCheckList = poolUtl.checkShrinkableFromThreshold(poolDtl, chkPoolVolInfList);
            if (thresholdCheckList.isEmpty()) {
                bRet = false;
                SJctrError ctrErr = new SJctrError(31, 22, 106034);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            ArrayList<SJmoPoolVolInfo> targetAllPoolVolInfoList = new ArrayList<SJmoPoolVolInfo>();
            targetAllPoolVolInfoList.addAll(poolVolInfList);
            targetAllPoolVolInfoList.addAll(poolVolInfoNonSelectList);
            Collections.sort(targetAllPoolVolInfoList);
            if (!poolUtl.checkShrinkableFromActualUsedToShrinkPool(poolDtl, poolVolInfList, targetAllPoolVolInfoList, this.allLdevDetailList, this.vdevDetailList, this.pgDetailList)) {
                bRet = false;
                SJctrError ctrErr = new SJctrError(31, 22, 206293);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            if (poolDtl.getPoolKind() != 8) {
                List<SJmoLdevDetail> nonSelectSSDList;
                boolean hrtFlg;
                List<SJmoPoolVolInfo> subscriptionCheckList = poolUtl.checkShrinkableFromSubscription(poolDtl, chkPoolVolInfList);
                if (subscriptionCheckList.isEmpty()) {
                    bRet = false;
                    SJctrError ctrErr = new SJctrError(31, 22, 106042);
                    ctrExp = ctrErr.createException();
                    throw ctrExp;
                }
                boolean bl2 = hrtFlg = 144 == (poolDtl.getITierControlInfo() & 0x90);
                if (poolDtl.getPoolKind() == 2 && hrtFlg && (nonSelectSSDList = poolUtl.serchSSDVol(poolVolInfoNonSelectList, this.allLdevDetailList)).isEmpty()) {
                    bRet = false;
                    SJctrError ctrErr = new SJctrError(31, 22, SJctrPoolUtility.ERR_HRT_SHRINK_NO_SSD);
                    ctrExp = ctrErr.createException();
                    throw ctrExp;
                }
            }
        }
        for (iVolCnt = 0; iVolCnt < poolVolInfList.size(); ++iVolCnt) {
            SJmoPoolVolInfo poolVolInf = poolVolInfList.get(iVolCnt);
            if (0L == poolVolInf.getLLDEVStatus() || 0x80000000L == poolVolInf.getLLDEVStatus()) continue;
            bRet = false;
            SJmoLdevIndex ldevIdx = new SJmoLdevIndex();
            ldevIdx.setLdevIndex(poolVolInf.getSLdkc(), poolVolInf.getSCu(), poolVolInf.getSLdev());
            SJctrPoolUtility.makeErrList(errList, ldevIdx, 31, 22, 106036);
            poolVolInfList.remove(iVolCnt);
            ldevDetailList.remove(iVolCnt);
            --iVolCnt;
        }
        return bRet;
    }

    private int getPoolStatusErrorCode(long lPoolStatus) {
        int iErrorCode = 107007;
        long lPoolStatusValue = 0L;
        lPoolStatusValue = lPoolStatus & 0xFFFFL;
        if ((lPoolStatus & 0x800000L) != 0L) {
            iErrorCode = 106028;
        }
        if (lPoolStatus == 4098L) {
            iErrorCode = 106034;
        }
        if ((lPoolStatus & 0x40000000L) != 0L && (lPoolStatus & 0x80000000L) != 0L || (lPoolStatus & 0x20000000L) != 0L && (lPoolStatus & 0x80000000L) != 0L) {
            iErrorCode = 106034;
        }
        if ((lPoolStatus & 0x10000L) != 0L) {
            iErrorCode = 106026;
        }
        if (lPoolStatusValue == 4096L) {
            iErrorCode = 106025;
        } else if (lPoolStatusValue == 4097L) {
            iErrorCode = 106024;
        } else if (lPoolStatusValue == 4098L) {
            iErrorCode = 106034;
        }
        SJctrLogUty.warn(this.getClass().getSimpleName(), "getErrorCode", "Pool Status Error:" + lPoolStatus);
        return iErrorCode;
    }

    private SJcException makeErrInfTableSP(SJctrWizardWindowDC wizard, List<SJctrErrorColumnData> errList) {
        SJctrRelatedDispDataObject relDisp = wizard.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController userCtr = wizard.getOwner();
        SJctrDataController beginDC = wizard.getParentDC();
        SJcException ctrExp = SJctrPoolUtility.makeErrInfTable(relDisp, userCtr, beginDC, errList);
        return ctrExp;
    }

    private static class SJctrGetOrgLdevDetailList {
        private SJctrGetOrgLdevDetailList() {
        }
    }

    private static class SJctrGetOrgPoolVolInfoList {
        private SJctrGetOrgPoolVolInfoList() {
        }
    }

    private static class SJctrGetPoolVVolRerationInfo {
        private SJctrGetPoolVVolRerationInfo() {
        }
    }
}

