/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrPairLUPathTableKeyInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrSVolIscsiTargetNameColumnFromPairLUPathTableKeyInfo
extends SJctrColumn {
    public SJctrSVolIscsiTargetNameColumnFromPairLUPathTableKeyInfo(String key) {
        super(key);
        this.setPartsId("ISCSI_TARGET_NAME");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortIscsiTargetInfo.class);
        list.add(SJmoGetPortDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoIscsiTargetInfo> retList = new ArrayList<SJmoIscsiTargetInfo>();
        SJctrPairLUPathTableKeyInfo pairLUPathInfo = (SJctrPairLUPathTableKeyInfo)index;
        SJmoPortLunDetail luPathInfo = pairLUPathInfo.getLUPathInfo();
        if (luPathInfo == null) {
            return retList;
        }
        List<?> portDetailList = modelData.get(SJmoGetPortDetail.class);
        int portDetailIndex = Collections.binarySearch(portDetailList, luPathInfo);
        if (portDetailIndex < 0) {
            return retList;
        }
        SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(portDetailIndex);
        if (!SJctrPortUtility.isIscsiPort(portDetail)) {
            return retList;
        }
        SJmoIscsiTargetInfo targetIscsiTarget = null;
        List<?> portIscsiTargetList = modelData.get(SJmoGetPortIscsiTargetInfo.class);
        int portIndex = Collections.binarySearch(portIscsiTargetList, luPathInfo);
        if (portIndex >= 0) {
            SJmoPortIscsiTargetInfo portIscsiTargetInfo = (SJmoPortIscsiTargetInfo)portIscsiTargetList.get(portIndex);
            ArrayList<SJmoIscsiTargetInfo> iscsiTargetInfoList = portIscsiTargetInfo.getAlPortIscsiTarget();
            for (SJmoIscsiTargetInfo iscsiTargetInfo : iscsiTargetInfoList) {
                if (iscsiTargetInfo.getSIscsiTarget() != luPathInfo.getSHostGroup()) continue;
                targetIscsiTarget = iscsiTargetInfo;
                break;
            }
        }
        retList.add(targetIscsiTarget);
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "-";
        if (!dataList.isEmpty()) {
            SJmoIscsiTargetInfo iscsiInfo = (SJmoIscsiTargetInfo)dataList.get(0);
            ret = iscsiInfo != null ? iscsiInfo.getStrIscsiTargetName() : "?";
        }
        return ret;
    }
}

