/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrCreateTIPairInfo
implements Serializable,
Comparable<SJctrCreateTIPairInfo> {
    private static final long serialVersionUID = 3119436308202594907L;
    private SJmoLdevIndex pVolIndex = new SJmoLdevIndex();
    private SJmoPortLunDetail pVolPathInfo = null;
    private SJmoPortLunDetail sVolPathInfo = null;
    private SJmoLdevIndex sVolIndex = null;
    private SJmoSnapshotSetInfo snapshotGrpInfo = null;
    private SJmoPoolNameInfo poolNameInfo = null;
    private short muNum = (short)-1;
    private short pairStatus = (short)-1;
    private Date snapshotDate = null;
    private String indexKey = "";
    private boolean replace = false;
    private boolean bCascade = false;
    private boolean bClone = false;
    private SJmoLdevIndex rootLdev = null;

    public SJctrCreateTIPairInfo(SJmoPortLunDetail pVolPathInfo, SJmoLdevIndex ldevIndex, SJmoSnapshotSetInfo snapshotGrpInfo, SJmoPoolNameInfo poolNameInfo, short muNum, boolean bCas, boolean bClone, SJmoLdevIndex rootVol) {
        if (pVolPathInfo != null) {
            this.pVolPathInfo = pVolPathInfo;
        } else {
            SJmoPortLunDetail lundt = new SJmoPortLunDetail();
            lundt.setSLDKC(ldevIndex.getSLdkc());
            lundt.setSCU(ldevIndex.getSCu());
            lundt.setSLDEV(ldevIndex.getSLdev());
            this.pVolPathInfo = lundt;
        }
        this.pVolIndex = ldevIndex;
        this.snapshotGrpInfo = snapshotGrpInfo;
        this.poolNameInfo = poolNameInfo;
        this.muNum = muNum;
        this.bCascade = bCas;
        this.bClone = bClone;
        this.rootLdev = rootVol;
    }

    public SJctrCreateTIPairInfo(SJmoPortLunDetail pVolPathInfo, SJmoLdevIndex pVolIndex, SJmoLdevIndex sVolIndex, SJmoSnapshotSetInfo snapshotGrpInfo, SJmoPoolNameInfo poolNameInfo, short muNum, short pairStatus, Date snapshotDate, boolean bCascade, boolean bClone, SJmoLdevIndex rootVol) {
        this(pVolPathInfo, pVolIndex, snapshotGrpInfo, poolNameInfo, muNum, bCascade, bClone, rootVol);
        this.setSVolIndex(sVolIndex);
        this.pairStatus = pairStatus;
        this.snapshotDate = snapshotDate;
    }

    public SJctrCreateTIPairInfo() {
    }

    public SJmoPortLunDetail getPVolLuPathInfo() {
        return this.pVolPathInfo;
    }

    public SJmoPortLunDetail getSVolLuPathInfo() {
        return this.sVolPathInfo;
    }

    public SJmoSnapshotSetInfo getSnapshotGroupInfo() {
        return this.snapshotGrpInfo;
    }

    public SJmoPoolNameInfo getPoolNameInfo() {
        return this.poolNameInfo;
    }

    public short getMuNum() {
        return this.muNum;
    }

    public void setSVolLuPathInfo(SJmoPortLunDetail sVolPathInfo) {
        if (sVolPathInfo != null) {
            this.sVolPathInfo = sVolPathInfo;
        } else if (this.sVolIndex != null) {
            SJmoPortLunDetail lundt = new SJmoPortLunDetail();
            lundt.setSLDKC(this.sVolIndex.getSLdkc());
            lundt.setSCU(this.sVolIndex.getSCu());
            lundt.setSLDEV(this.sVolIndex.getSLdev());
            this.sVolPathInfo = lundt;
        }
        this.setSVolLuPathInfo(sVolPathInfo, false);
    }

    public void setSVolLuPathInfo(SJmoPortLunDetail sVolPathInfo, boolean replace) {
        if (sVolPathInfo != null) {
            this.sVolPathInfo = sVolPathInfo;
        } else if (this.sVolIndex != null) {
            SJmoPortLunDetail lundt = new SJmoPortLunDetail();
            lundt.setSLDKC(this.sVolIndex.getSLdkc());
            lundt.setSCU(this.sVolIndex.getSCu());
            lundt.setSLDEV(this.sVolIndex.getSLdev());
            this.sVolPathInfo = lundt;
        }
        this.replace = replace;
    }

    public short getPairStatus() {
        return this.pairStatus;
    }

    public Date getSnapshotDate() {
        return this.snapshotDate;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean isBCascade() {
        return this.bCascade;
    }

    public void setBCascade(boolean cascade) {
        this.bCascade = cascade;
    }

    public boolean isBClone() {
        return this.bClone;
    }

    public void setBClone(boolean clone) {
        this.bClone = clone;
    }

    public SJmoLdevIndex getPVolIndex() {
        if (this.pVolIndex == null && this.pVolPathInfo != null) {
            this.pVolIndex = new SJmoLdevIndex();
            this.pVolIndex.setLdevIndex(this.pVolPathInfo.getSLDKC(), this.pVolPathInfo.getSCU(), this.pVolPathInfo.getSLDEV());
        }
        return this.pVolIndex;
    }

    public void setPVolIndex(SJmoLdevIndex volIndex) {
        this.pVolIndex = volIndex;
    }

    public SJmoLdevIndex getSVolIndex() {
        if (this.sVolIndex == null && this.sVolPathInfo != null) {
            this.sVolIndex = new SJmoLdevIndex();
            this.sVolIndex.setLdevIndex(this.sVolPathInfo.getSLDKC(), this.sVolPathInfo.getSCU(), this.sVolPathInfo.getSLDEV());
        }
        return this.sVolIndex;
    }

    public void setSVolIndex(SJmoLdevIndex volIndex) {
        this.sVolIndex = volIndex;
    }

    public void setSVolIndex(SJmoLdevIndex volIndex, boolean rep) {
        this.sVolIndex = volIndex;
        this.replace = rep;
    }

    public SJmoLdevIndex getRootLdev() {
        return this.rootLdev;
    }

    public void setRootLdev(SJmoLdevIndex volIndex) {
        this.rootLdev = volIndex;
    }

    public SJmoPortLunDetail clearSVolLuPathInfo() {
        SJmoPortLunDetail ret = null;
        if (this.sVolPathInfo != null && this.sVolPathInfo.getSPort() != -1) {
            ret = this.sVolPathInfo;
        }
        this.sVolPathInfo = null;
        this.sVolIndex = null;
        this.replace = false;
        return ret;
    }

    @Override
    public int compareTo(SJctrCreateTIPairInfo obj) {
        SJmoLdevIndex ldevIndex = obj.getPVolIndex();
        int ret = this.pVolIndex.getSLdkc() - ldevIndex.getSLdkc();
        if (ret != 0) {
            return ret;
        }
        ret = this.pVolIndex.getSCu() - ldevIndex.getSCu();
        if (ret != 0) {
            return ret;
        }
        ret = this.pVolIndex.getSLdev() - ldevIndex.getSLdev();
        if (ret != 0) {
            return ret;
        }
        ret = this.muNum - obj.getMuNum();
        return ret;
    }

    public String toString() {
        return this.getIndexKey();
    }

    public String getIndexKey() {
        if (this.indexKey.length() == 0) {
            int ldevKey = this.pVolIndex.getIndex();
            this.indexKey = SJctrComUtility.toHexString(ldevKey, 6, true) + SJctrComUtility.toHexString(this.muNum, 4, true);
        }
        return this.indexKey;
    }

    public static Comparator<Object> CreatePVolComparator() {
        Comparator<Object> pVolComp = new Comparator<Object>(){
            private SJmoLdevIndex ldev1 = new SJmoLdevIndex();
            private SJmoLdevIndex ldev2 = new SJmoLdevIndex();

            @Override
            public int compare(Object o1, Object o2) {
                SJmoLdevIndex compLdev1 = this.getCompLdev(this.ldev1, o1);
                SJmoLdevIndex compLdev2 = this.getCompLdev(this.ldev2, o2);
                return compLdev1.compareTo(compLdev2);
            }

            private SJmoLdevIndex getCompLdev(SJmoLdevIndex ldevindex, Object obj) {
                if (obj instanceof SJmoLdevIndex) {
                    return (SJmoLdevIndex)obj;
                }
                SJctrCreateTIPairInfo createPairInfo = (SJctrCreateTIPairInfo)obj;
                SJmoLdevIndex pvolIndex = createPairInfo.getPVolIndex();
                ldevindex.setLdevIndex(pvolIndex.getSLdkc(), pvolIndex.getSCu(), pvolIndex.getSLdev());
                return ldevindex;
            }
        };
        return pVolComp;
    }

    public static Comparator<Object> CreatePVoMuComparator() {
        Comparator<Object> pVolComp = new Comparator<Object>(){
            private SJmoTiPvolMu pvolMu1 = SJctrCreateTIPairUtility.createTiPVolMuInfo();
            private SJmoTiPvolMu pvolMu2 = SJctrCreateTIPairUtility.createTiPVolMuInfo();

            @Override
            public int compare(Object o1, Object o2) {
                SJmoTiPvolMu compPVolMu2;
                SJmoTiPvolMu compPVolMu1 = this.getCompPVolMu(this.pvolMu1, o1);
                int ret = compPVolMu1.compareTo(compPVolMu2 = this.getCompPVolMu(this.pvolMu2, o2));
                if (ret == 0) {
                    ret = compPVolMu1.getMu() - compPVolMu2.getMu();
                }
                return ret;
            }

            private SJmoTiPvolMu getCompPVolMu(SJmoTiPvolMu pvolMu, Object obj) {
                if (obj instanceof SJmoTiPvolMu) {
                    return (SJmoTiPvolMu)obj;
                }
                SJctrCreateTIPairInfo createPairInfo = (SJctrCreateTIPairInfo)obj;
                SJmoLdevIndex pvolIndex = createPairInfo.getPVolIndex();
                pvolMu.setLdevIndex(pvolIndex.getSLdkc(), pvolIndex.getSCu(), pvolIndex.getSLdev());
                pvolMu.setMu(createPairInfo.getMuNum());
                return pvolMu;
            }
        };
        return pVolComp;
    }
}

