/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.dataimpl.MRCFgetSnapshotSetName;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.comparator.replication.SJctrTiSnapshotPair_SnapshotGroupComparator;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrSnapshotGroupInfo;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetIndex;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPair;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.manager.SJmoSnapshotSetInfoMgr;

public class SJctrSnapshotGroupInfoMgr {
    private SJmoSnapshotSetInfoMgr moSnapshotGrpInfoMgr = null;
    private Map<Integer, SJmoSnapshotSetInfo> newSnapshotGrpMap = Collections.emptyMap();
    private Map<Integer, Integer> snapshotDataNumMap = Collections.emptyMap();
    private Set<String> snapshotGroupNameSet = Collections.emptySet();
    private final int NEWID_OFFSET = 2048;
    private BitSet newIDBitSet = new BitSet(2048);
    public static final int SNAPSHOTGROUP_INITNUM_LEN_MAX = 9;

    public SJctrSnapshotGroupInfoMgr(SJmoSnapshotSetInfoMgr moSnapshotGrpInfoMgr, SJmoTiSnapshotPairList tissPairList) {
        this.moSnapshotGrpInfoMgr = moSnapshotGrpInfoMgr;
        this.initSnapshotGroupInfoMgr(tissPairList);
    }

    private void initSnapshotGroupInfoMgr(SJmoTiSnapshotPairList tissPairList) {
        this.newSnapshotGrpMap = new HashMap<Integer, SJmoSnapshotSetInfo>(2048);
        this.snapshotDataNumMap = new HashMap<Integer, Integer>(2048);
        this.snapshotGroupNameSet = new HashSet<String>(2048);
        SJmoSnapshotSetInfo[] snapshotGrpArray = this.moSnapshotGrpInfoMgr.getSnapshotSetInfoList();
        SJctrTiSnapshotPair_SnapshotGroupComparator ssPair_Cmp = new SJctrTiSnapshotPair_SnapshotGroupComparator();
        SJmoTiSnapshotPair[] tiSSPairArray = tissPairList.getSnapshotPair();
        for (SJmoSnapshotSetInfo snapshotGrp : snapshotGrpArray) {
            if (snapshotGrp == null) continue;
            int ssDataNum = 0;
            int id = snapshotGrp.getIndex();
            int index = Arrays.binarySearch(tiSSPairArray, id, ssPair_Cmp);
            if (index < 0) continue;
            SJmoTiSnapshotPair tiSSPairInfo = tiSSPairArray[index];
            SJmoTiPvolMu[] pVolMuArray = tiSSPairInfo.getPvolMu();
            ssDataNum = pVolMuArray.length;
            this.snapshotDataNumMap.put(id, ssDataNum);
            String name = snapshotGrp.getStrSnapshotSetName();
            this.snapshotGroupNameSet.add(name);
        }
    }

    public List<SJmoSnapshotSetInfo> getAllSnapshotGroupInfo() {
        SJmoSnapshotSetInfo[] ssGrpArray = this.moSnapshotGrpInfoMgr.getSnapshotSetInfoList();
        ArrayList<SJmoSnapshotSetInfo> retList = new ArrayList<SJmoSnapshotSetInfo>(ssGrpArray.length + this.newSnapshotGrpMap.size());
        for (SJmoSnapshotSetInfo ssGrp : ssGrpArray) {
            if (ssGrp == null) continue;
            retList.add(ssGrp);
        }
        retList.addAll(this.newSnapshotGrpMap.values());
        Collections.sort(retList);
        return retList;
    }

    public int getSnapshotDataNum(SJmoSnapshotSetIndex snapshotIndex) {
        return this.getSnapshotDataNum(snapshotIndex.getIndex());
    }

    public int getSnapshotDataNum(int id) {
        int num = 0;
        Integer value = this.snapshotDataNumMap.get(id);
        if (value != null) {
            num = value;
        }
        return num;
    }

    public SJmoSnapshotSetInfo getSnapshotGroupInfo(int id) {
        SJmoSnapshotSetInfo ret = null;
        ret = this.chkNewSnapshotGroup(id) ? this.newSnapshotGrpMap.get(id) : this.moSnapshotGrpInfoMgr.getSnapshotSetInfo(id);
        return ret;
    }

    public List<SJmoSnapshotSetInfo> getNewSnapshotGroupInfo(int grpNum, String preFix, String initNum, byte ssConfType, boolean[] skipName) {
        boolean skipFlg = false;
        ArrayList<String> nameList = new ArrayList<String>(grpNum);
        int existNum = this.snapshotGroupNameSet.size();
        if (2048 < existNum + grpNum) {
            SJctrCreateTIPairUtility.createError(106166);
        }
        if (initNum.isEmpty()) {
            if (!this.chkUnusedName(preFix)) {
                SJctrCreateTIPairUtility.createError(105475);
            }
            nameList.add(preFix);
        } else {
            int setNumber = Integer.valueOf(initNum);
            int numberLen = initNum.length();
            while (nameList.size() < grpNum) {
                String strNum = SJctrComUtility.toDecString(setNumber);
                if (9 < strNum.length()) {
                    SJctrCreateTIPairUtility.createError(205186);
                }
                String number = SJctrComUtility.toPaddingZeroString(setNumber, numberLen);
                StringBuffer buf = new StringBuffer();
                buf.append(preFix);
                buf.append(number);
                String grpName = buf.toString();
                if (32 < grpName.length()) {
                    SJctrCreateTIPairUtility.createError(205186);
                }
                if (this.chkUnusedName(grpName)) {
                    nameList.add(grpName);
                } else {
                    skipFlg = true;
                }
                ++setNumber;
            }
        }
        skipName[0] = skipFlg;
        return this.createSnapshotGroupInfo(nameList);
    }

    private List<SJmoSnapshotSetInfo> createSnapshotGroupInfo(List<String> nameList) {
        ArrayList<SJmoSnapshotSetInfo> retList = new ArrayList<SJmoSnapshotSetInfo>(nameList.size());
        int startIndex = 0;
        for (String name : nameList) {
            MRCFgetSnapshotSetName nameInfo = new MRCFgetSnapshotSetName();
            SJctrSnapshotGroupInfo snapshotGroupInfo = new SJctrSnapshotGroupInfo(nameInfo);
            int newId = this.getNewID(startIndex);
            snapshotGroupInfo.setISnapshotSetId(newId);
            snapshotGroupInfo.setStrSnapshotSetName(name);
            retList.add(snapshotGroupInfo);
            startIndex = this.getBitIndex(newId) + 1;
        }
        return retList;
    }

    public void addSnapshotData(List<SJmoSnapshotSetInfo> ssGrpInfoList, int addNum) {
        for (SJmoSnapshotSetInfo ssGrpInfo : ssGrpInfoList) {
            this.addSnapshotData(ssGrpInfo, addNum);
        }
    }

    public void addSnapshotData(SJmoSnapshotSetInfo ssGrpInfo, int addNum) {
        int ssDatanum = 0;
        int id = ssGrpInfo.getIndex();
        Integer value = this.snapshotDataNumMap.get(id);
        if (value != null) {
            ssDatanum = value;
        } else if (this.chkNewSnapshotGroup(id)) {
            this.setNewID(id);
            this.newSnapshotGrpMap.put(id, ssGrpInfo);
            String ssGrpName = ssGrpInfo.getStrSnapshotSetName();
            this.snapshotGroupNameSet.add(ssGrpName);
        }
        this.snapshotDataNumMap.put(id, ssDatanum += addNum);
    }

    public SJmoSnapshotSetInfo removeSnapshotData(SJmoSnapshotSetInfo ssGrpInfo, int remNum) {
        SJmoSnapshotSetInfo removeData = null;
        int ssDatanum = 0;
        int id = ssGrpInfo.getIndex();
        Integer value = this.snapshotDataNumMap.get(id);
        if (value == null) {
            return removeData;
        }
        ssDatanum = value;
        if ((ssDatanum -= remNum) <= 0) {
            if (this.chkNewSnapshotGroup(id)) {
                removeData = this.newSnapshotGrpMap.remove(id);
                this.snapshotDataNumMap.remove(id);
                String ssGrpName = ssGrpInfo.getStrSnapshotSetName();
                this.snapshotGroupNameSet.remove(ssGrpName);
                this.resetNewID(id);
            }
        } else {
            this.snapshotDataNumMap.put(id, ssDatanum);
        }
        return removeData;
    }

    public int getSnapshotGroupNum() {
        return this.snapshotDataNumMap.size();
    }

    private boolean chkUnusedName(String name) {
        return !this.snapshotGroupNameSet.contains(name);
    }

    private int getNewID(int startIndex) {
        int newId = -1;
        int index = this.newIDBitSet.nextClearBit(startIndex);
        newId = 2048 + index;
        return newId;
    }

    private void setNewID(int id) {
        int index = this.getBitIndex(id);
        this.newIDBitSet.set(index);
    }

    private void resetNewID(int id) {
        int index = this.getBitIndex(id);
        this.newIDBitSet.clear(index);
    }

    private int getBitIndex(int id) {
        int index = id - 2048;
        if (index < 0 || 2048 <= index) {
            SJctrCreateTIPairUtility.createError(107004);
        }
        return index;
    }

    public boolean chkNewSnapshotGroup(int id) {
        return 2048 <= id;
    }
}

