/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.selectpvol;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrSelObjRdoDataModel
extends SJctrRadioButtonGroupDataModel {
    private boolean reserve = false;
    private List<SJmoPortDetail> portDtlList = Collections.emptyList();
    private SJctrItemSelectListener itemSelectListener = null;

    public SJctrSelObjRdoDataModel() {
        this.add("COM_FIBRE");
        this.add("COM_ISCSI");
        this.add("COM_HNAS_USER");
        this.setEnable("COM_FIBRE", false);
        this.setEnable("COM_ISCSI", false);
        this.setEnable("COM_HNAS_USER", false);
    }

    public void initSelObjRdo(List<SJmoPortDetail> portDtlList, List<SJmoPortLunDetail> availableList, boolean hasHFB) {
        this.portDtlList = portDtlList;
        this.updateSelObjRdo(availableList, hasHFB);
    }

    public void updateSelObjRdo(List<SJmoPortLunDetail> availableList, boolean hasHFB) {
        HashSet<Short> portSet = new HashSet<Short>(availableList.size());
        for (SJmoPortLunDetail luPathInfo : availableList) {
            if (!portSet.add(luPathInfo.getSPort())) continue;
            this.chkPortKind(luPathInfo);
        }
        if (!hasHFB) {
            this.setVisible("COM_HNAS_USER", false);
        }
        this.setDefaultSelection();
    }

    private void chkPortKind(SJmoPortLunDetail luPathInfo) {
        int index = Collections.binarySearch(this.portDtlList, luPathInfo);
        if (index < 0) {
            return;
        }
        SJmoPortDetail portDtl = this.portDtlList.get(index);
        if (SJctrPortUtility.isFibrePort(portDtl) || SJctrPortUtility.isFcoePort(portDtl)) {
            if (!this.isEnable("COM_FIBRE")) {
                this.setEnable("COM_FIBRE", true);
            }
        } else if (SJctrPortUtility.isIscsiPort(portDtl)) {
            if (!this.isEnable("COM_ISCSI")) {
                this.setEnable("COM_ISCSI", true);
            }
        } else if (portDtl.getByPortKindNo() == 7 && !this.isEnable("COM_HNAS_USER")) {
            this.setEnable("COM_HNAS_USER", true);
        }
    }

    public String setDefaultSelection() {
        String selection = null;
        if (this.isEnable("COM_FIBRE")) {
            selection = "COM_FIBRE";
        } else if (this.isEnable("COM_ISCSI")) {
            selection = "COM_ISCSI";
        } else if (this.isEnable("COM_HNAS_USER")) {
            selection = "COM_HNAS_USER";
        }
        this.setSelect(selection);
        this.setDirty();
        return selection;
    }

    public void setReserve(boolean flg) {
        this.reserve = flg;
    }

    public void initListener() {
        if (this.itemSelectListener != null) {
            return;
        }
        this.itemSelectListener = new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (SJctrSelObjRdoDataModel.this.reserve) {
                    return;
                }
                if (event.isSelect()) {
                    SJctrSelObjRdoDataModel.this.fireMessageEvent(CHGSELOBJ_MSG.CHG_SELOBJ);
                }
            }
        };
        this.addItemSelectListener(this.itemSelectListener);
    }

    public static enum CHGSELOBJ_MSG implements SJctrNotifyState
    {
        CHG_SELOBJ;

    }
}

