/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.editlocalreplicaopt;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.local.editlocalreplicaopt.SJctrEditLocalReplicaOptConfirmData;
import sanproject.sn2.controller.wizard.replication.local.editlocalreplicaopt.SJctrEditLocalReplicaOptTableModel;
import sanproject.sn2.controller.wizard.replication.local.editlocalreplicaopt.SJctrLocalReplicationOptionDataModel;
import sanproject.sn2.controller.wizard.replication.local.editlocalreplicaopt.SJctrLocalReplicationOptionInfo;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationOptionInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationOptionInfo;

public class SJctrEditLocalReplicaOptDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17830737;
    private static final String DISP_TITLE = "EDIT_LOCAL_REPLICA_OPTIONS";
    private static final String KEY_TABLE_SI_QS = "COM_TABLE_SI_QS";
    private static final String KEY_ENABLE_SI_QS = "COM_BTN_ENABLE_SI_QS";
    private static final String KEY_DISABLE_SI_QS = "COM_BTN_DISABLE_SI_QS";
    private static final String KEY_TABLE_SIMF_FCV2 = "COM_TABLE_SIMF_FCV2";
    private static final String KEY_ENABLE_SIMF_FCV2 = "COM_BTN_ENABLE_SIMF_FCV2";
    private static final String KEY_DISABLE_SIMF_FCV2 = "COM_BTN_DISABLE_SIMF_FCV2";
    private static final String[] OPT_NAME_SI_QS = SJctrReplicationDataMacro.GUID_OPTION_NAME_SI_QS;
    private static final String[] OPT_NAME_SIMF_FCV2 = SJctrReplicationDataMacro.GUID_OPTION_NAME_SIMF_FCV2;
    private static final String RESERVE = "Reserve";
    private static final String KEY_SYS_TYPE = "COM_SYS_TYPE";

    public SJctrEditLocalReplicaOptDC() {
        super(17830737);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SYS_TYPE, new SJctrLocalReplicationOptionDataModel());
        this.addDataObjectModel(KEY_TABLE_SI_QS, new SJctrEditLocalReplicaOptTableModel());
        SJctrButtonDataModel enableBtnSIQS = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ENABLE_SI_QS, enableBtnSIQS);
        enableBtnSIQS.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditLocalReplicaOptDC.this.fireMessageEvent(EDIT_LOCAL_REPLICA_OPTIONS_MSG.SELECT_ENABLE_SI_QS);
            }
        });
        SJctrButtonDataModel disableBtnSIQS = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DISABLE_SI_QS, disableBtnSIQS);
        disableBtnSIQS.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditLocalReplicaOptDC.this.fireMessageEvent(EDIT_LOCAL_REPLICA_OPTIONS_MSG.SELECT_DISABLE_SI_QS);
            }
        });
        this.addDataObjectModel(KEY_TABLE_SIMF_FCV2, new SJctrEditLocalReplicaOptTableModel());
        SJctrButtonDataModel enableBtnSIMFFCV2 = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ENABLE_SIMF_FCV2, enableBtnSIMFFCV2);
        enableBtnSIMFFCV2.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditLocalReplicaOptDC.this.fireMessageEvent(EDIT_LOCAL_REPLICA_OPTIONS_MSG.SELECT_ENABLE_SIMF_FCV2);
            }
        });
        SJctrButtonDataModel disableBtnSIMFFCV2 = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DISABLE_SIMF_FCV2, disableBtnSIMFFCV2);
        disableBtnSIMFFCV2.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditLocalReplicaOptDC.this.fireMessageEvent(EDIT_LOCAL_REPLICA_OPTIONS_MSG.SELECT_DISABLE_SIMF_FCV2);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetLocalReplicationOptionInfo kind = new SJmoGetLocalReplicationOptionInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_LOCAL_REPLICA_OPTIONS_MSG.CHANGED_RADIO, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(EDIT_LOCAL_REPLICA_OPTIONS_MSG.SELECT_ENABLE_SI_QS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditLocalReplicaOptDC.this.changeStatus(event, dstModel, SJctrEditLocalReplicaOptDC.KEY_TABLE_SI_QS, true);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(EDIT_LOCAL_REPLICA_OPTIONS_MSG.SELECT_DISABLE_SI_QS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditLocalReplicaOptDC.this.changeStatus(event, dstModel, SJctrEditLocalReplicaOptDC.KEY_TABLE_SI_QS, false);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(EDIT_LOCAL_REPLICA_OPTIONS_MSG.SELECT_ENABLE_SIMF_FCV2, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditLocalReplicaOptDC.this.changeStatus(event, dstModel, SJctrEditLocalReplicaOptDC.KEY_TABLE_SIMF_FCV2, true);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(EDIT_LOCAL_REPLICA_OPTIONS_MSG.SELECT_DISABLE_SIMF_FCV2, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditLocalReplicaOptDC.this.changeStatus(event, dstModel, SJctrEditLocalReplicaOptDC.KEY_TABLE_SIMF_FCV2, false);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    private void changeStatus(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel, String tblKey, boolean status) {
        SJctrEditLocalReplicaOptTableModel tableData = (SJctrEditLocalReplicaOptTableModel)this.getDataObjectModel(tblKey);
        List<Object> selectData = tableData.getSelectedRowData();
        for (Object info : selectData) {
            ((SJctrLocalReplicationOptionInfo)info).setOptStatus(status);
        }
        tableData.doRefresh();
        tableData.addRowSelectionList(selectData);
        this.updateFooter();
    }

    @Override
    public boolean checkConstructData() {
        List<?> optInfoList = this.getCache(SJmoGetLocalReplicationOptionInfo.class);
        if (null == optInfoList) {
            this.logUty.putlog("checkConstructData", "Information of Local Replication Option List is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == optInfoList.size()) {
            this.logUty.putlog("checkConstructData", "Size of Local Replication Option List is zero.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoLocalReplicationOptionInfo optInfo = (SJmoLocalReplicationOptionInfo)optInfoList.get(0);
        if (null == optInfo) {
            this.logUty.putlog("checkConstructData", "Information of Local Replication Option is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJctrLocalReplicationOptionInfo> optExistSIQS = this.getOptExist(optInfo, KEY_TABLE_SI_QS);
        List<SJctrLocalReplicationOptionInfo> optExistSIMFFCv2 = this.getOptExist(optInfo, KEY_TABLE_SIMF_FCV2);
        SJctrEditLocalReplicaOptTableModel tableDataSIQS = (SJctrEditLocalReplicaOptTableModel)this.getDataObjectModel(KEY_TABLE_SI_QS);
        tableDataSIQS.setBasicDataList(optExistSIQS);
        SJctrEditLocalReplicaOptTableModel tableDataSIMFFCv2 = (SJctrEditLocalReplicaOptTableModel)this.getDataObjectModel(KEY_TABLE_SIMF_FCV2);
        tableDataSIMFFCv2.setBasicDataList(optExistSIMFFCv2);
        return true;
    }

    private List<SJctrLocalReplicationOptionInfo> getOptExist(SJmoLocalReplicationOptionInfo optInfo, String key) {
        ArrayList<SJctrLocalReplicationOptionInfo> OptTblList = new ArrayList<SJctrLocalReplicationOptionInfo>();
        for (int index = 0; index < 32; ++index) {
            boolean status = false;
            String optName = "?";
            if (key.equals(KEY_TABLE_SI_QS)) {
                if (optInfo.isSiOptionFlg(index) && optInfo.isSiOptionBit(index)) {
                    status = true;
                }
                if (index < OPT_NAME_SI_QS.length) {
                    optName = this.getComUtility().getGuidance(OPT_NAME_SI_QS[index]);
                }
            } else if (key.equals(KEY_TABLE_SIMF_FCV2)) {
                if (optInfo.isSiMfOptionFlg(index) && optInfo.isSiMfOptionBit(index)) {
                    status = true;
                }
                if (index < OPT_NAME_SIMF_FCV2.length) {
                    optName = this.getComUtility().getGuidance(OPT_NAME_SIMF_FCV2[index]);
                }
            }
            if (optName.equals(RESERVE)) {
                optName = optName + SJctrComUtility.toPaddingZeroString(index + 1, 2);
            }
            SJctrLocalReplicationOptionInfo info = new SJctrLocalReplicationOptionInfo(index, optName, status);
            OptTblList.add(info);
        }
        return OptTblList;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrEditLocalReplicaOptConfirmData confirmData = new SJctrEditLocalReplicaOptConfirmData();
            SJctrLocalReplicationOptionDataModel sysType = (SJctrLocalReplicationOptionDataModel)this.getDataObjectModel(KEY_SYS_TYPE);
            SJctrRadioButtonGroupDataModel sysTypeRadio = (SJctrRadioButtonGroupDataModel)sysType.getDataModel("COM_SYSTEM_TYPE");
            if (sysTypeRadio.isSelect("COM_OPEN")) {
                SJctrEditLocalReplicaOptTableModel tableSIQS = (SJctrEditLocalReplicaOptTableModel)this.getDataObjectModel(KEY_TABLE_SI_QS);
                List<Object> allRowData = tableSIQS.getAllRowData();
                confirmData.setOptionListSIQS(allRowData);
            } else if (sysTypeRadio.isSelect("COM_MAINFRAME")) {
                SJctrEditLocalReplicaOptTableModel tableSIMFFCv2 = (SJctrEditLocalReplicaOptTableModel)this.getDataObjectModel(KEY_TABLE_SIMF_FCV2);
                List<Object> allRowData = tableSIMFFCv2.getAllRowData();
                confirmData.setOptionListSIMFFCv2(allRowData);
            } else {
                this.logUty.putlog("checkEndData", "Systemtype radioboton is not selected .");
                SJctrError err = new SJctrError(209, 22, 107003);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList<SJctrEditLocalReplicaOptConfirmData> confirmDataList = new ArrayList<SJctrEditLocalReplicaOptConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditLocalReplicaOptConfirmData.class, confirmDataList);
            SJctrReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    public static enum EDIT_LOCAL_REPLICA_OPTIONS_MSG implements SJctrNotifyState
    {
        SELECT_ENABLE_SI_QS,
        SELECT_DISABLE_SI_QS,
        SELECT_ENABLE_SIMF_FCV2,
        SELECT_DISABLE_SIMF_FCV2,
        CHANGED_RADIO;

    }
}

