/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.splitpairs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrLocalPairInfoComparator;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.local.splitpairs.SJctrSplitPairsConfirmData;
import sanproject.sn2.controller.wizard.replication.local.splitpairs.SJctrSplitPairsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotSetInfoMgr;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrSplitPairsDC
extends SJctrWizardDataController {
    protected static final int DISP_ID = 0x1101311;
    private static final String DISP_TITLE = "SPLIT_PAIR";
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_SPLITTYPE_COMBO = "COM_SPLITTYPE";
    private static final String KEY_COPYPACE_COMBO = "COM_COPYPACE";

    public SJctrSplitPairsDC() {
        super(0x1101311);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrSplitPairsTableModel());
        SJctrComboBoxDataModel comboObjSp = new SJctrComboBoxDataModel();
        comboObjSp.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSplitPairsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addDataObjectModel(KEY_SPLITTYPE_COMBO, comboObjSp);
        SJctrComboBoxDataModel comboObjCp = new SJctrComboBoxDataModel();
        comboObjCp.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSplitPairsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addDataObjectModel(KEY_COPYPACE_COMBO, comboObjCp);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetLocalReplicationPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSnapshotSetInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void setFinishChangeCheck(boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_SVOL");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoLocalReplicationPairVolInfoMgr allPairInfo = SJctrReplicationUtility.getSJmoLocalReplicationPairVolInfoMgr(this);
            List<SJmoLocalReplicationPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_SVOL");
            SJctrReplicationUtility.chkCacheLReplicaDetailData(this);
            List<SJmoLocalReplicationPairVolInfo> pairExist = this.checkPairExisting(viewData, allPairInfo);
            int copytype = this.checkCopyTypeForLocalPairVol(pairExist);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
            int checkSimfPair = -1;
            if (copytype == 0) {
                checkSimfPair = SJctrReplicationUtility.checkSimfPairMixFiconAndNormal(pairExist, ldevDetailList);
            }
            SJctrReplicationUtility.checkPpLicenseForLocalPairVolList(this.getOwner(), copytype);
            this.checkPairAbleSplit(pairExist, allPairInfo, copytype);
            this.checkPairStatus(pairExist, allPairInfo, copytype);
            Collections.sort(pairExist, new SJctrLocalPairInfoComparator());
            this.setAvailableTableData(pairExist);
            SJctrComboBoxDataModel comboObjSp = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_SPLITTYPE_COMBO);
            this.createSplitTypeComboBox(comboObjSp, copytype, checkSimfPair);
            SJctrComboBoxDataModel comboObjCp = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYPACE_COMBO);
            this.createCopyPaceComboBox(comboObjCp, copytype, pairExist.get(0).isBClone());
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLocalReplicationLogicErrorException(e, 107002);
        }
        return true;
    }

    protected void checkPairAbleSplit(List<SJmoLocalReplicationPairVolInfo> pairExist, SJmoLocalReplicationPairVolInfoMgr allPairInfo, int copytype) {
    }

    protected List<SJmoLocalReplicationPairVolInfo> checkPairExisting(List<SJmoLocalReplicationPairVolInfo> selectedPairs, SJmoLocalReplicationPairVolInfoMgr allPairInfo) throws SJcException {
        return SJctrReplicationUtility.checkAndGetExistPairVolInfo(selectedPairs, allPairInfo);
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrSplitPairsConfirmData confirmData = new SJctrSplitPairsConfirmData();
            SJctrComboBoxDataModel selectedSplitTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_SPLITTYPE_COMBO);
            String strSplitType = selectedSplitTypeCombo.getSelection();
            SJctrComboBoxDataModel selectedCopyPaceCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYPACE_COMBO);
            String strCopyPace = selectedCopyPaceCombo.getSelection();
            SJctrSplitPairsTableModel selectedPairsTable = (SJctrSplitPairsTableModel)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedList = selectedPairsTable.getAllRowData();
            int copytype = SJctrReplicationUtility.checkCopyTypeForLocalPairVol((SJmoLocalReplicationPairVolInfo)selectedList.get(0));
            confirmData.setCopytype((short)copytype);
            short copypace = this.comvCopyPace(strCopyPace, copytype);
            for (SJmoLocalReplicationPairVolInfo sJmoLocalReplicationPairVolInfo : selectedList) {
                sJmoLocalReplicationPairVolInfo.setSCopyPace(copypace);
            }
            confirmData.setCopypace(copypace);
            confirmData.setSplittype(this.comvSplitType(strSplitType));
            confirmData.setPairsInfo(selectedList);
            confirmData.setNeedData(this);
            ArrayList<SJctrSplitPairsConfirmData> confirmDataList = new ArrayList<SJctrSplitPairsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrSplitPairsConfirmData.class, confirmDataList);
            this.setFinishChangeCheck(false);
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void createSplitTypeComboBox(SJctrComboBoxDataModel comboObj, int copytype, int checkSimfPair) {
        if (null == comboObj) {
            this.logUty.putlog("createSplitTypeComboBox", "ComboBox object is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == copytype || 1 == copytype) {
            if (4 == checkSimfPair) {
                comboObj.addItem("MIGRATION", this.getComUtility().getGuidance("MIGRATION"));
                comboObj.setSelection("MIGRATION");
            } else {
                comboObj.addItem("QUICK_SPLIT", this.getComUtility().getGuidance("QUICK_SPLIT"));
                comboObj.addItem("STEADY_SPLIT", this.getComUtility().getGuidance("STEADY_SPLIT"));
                comboObj.setSelection("QUICK_SPLIT");
            }
            comboObj.setEnable(true);
        } else if (2 == copytype || 3 == copytype) {
            comboObj.addItem("STEADY_SPLIT", this.getComUtility().getGuidance("STEADY_SPLIT"));
            comboObj.setSelection("STEADY_SPLIT");
            comboObj.setEnable(true);
        } else {
            this.logUty.putlog("createSplitTypeComboBox", "Copy Type is invalid.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private void createCopyPaceComboBox(SJctrComboBoxDataModel comboObj, int copytype, boolean cloneFlg) {
        if (null == comboObj) {
            this.logUty.putlog("createCopyPaceComboBox", "ComboBox object is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == copytype || 1 == copytype) {
            comboObj.addItem("FASTER_CP", this.getComUtility().getGuidance("FASTER_CP"));
            comboObj.addItem("MEDIUM_CP", this.getComUtility().getGuidance("MEDIUM_CP"));
            comboObj.addItem("LOWER_CP", this.getComUtility().getGuidance("LOWER_CP"));
            comboObj.setSelection("MEDIUM_CP");
            comboObj.setEnable(true);
        } else if (2 == copytype) {
            comboObj.addItem("BAR", this.getComUtility().getGuidance("BAR"));
            comboObj.setSelection("BAR");
            comboObj.setEnable(false);
        } else if (3 == copytype) {
            if (cloneFlg) {
                comboObj.addItem("FASTER_CP", this.getComUtility().getGuidance("FASTER_CP"));
                comboObj.addItem("MEDIUM_CP", this.getComUtility().getGuidance("MEDIUM_CP"));
                comboObj.addItem("LOWER_CP", this.getComUtility().getGuidance("LOWER_CP"));
                comboObj.setSelection("MEDIUM_CP");
                comboObj.setEnable(true);
            } else {
                comboObj.addItem("BAR", this.getComUtility().getGuidance("BAR"));
                comboObj.setSelection("BAR");
                comboObj.setEnable(false);
            }
        } else {
            this.logUty.putlog("createCopyPaceComboBox", "Copy Type is invalid.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private short comvSplitType(String strsplit) {
        int rtnsplit = -1;
        if (null != strsplit) {
            if (strsplit.equals("QUICK_SPLIT")) {
                rtnsplit = 240;
            } else if (strsplit.equals("STEADY_SPLIT")) {
                rtnsplit = 0;
            } else if (strsplit.equals("MIGRATION")) {
                rtnsplit = -1;
            }
        }
        return (short)rtnsplit;
    }

    private short comvCopyPace(String strcopypace, int copytype) {
        int rtncopy = -1;
        if (null != strcopypace) {
            if (0 == copytype || 1 == copytype) {
                if (strcopypace.equals("MEDIUM_CP")) {
                    rtncopy = 0;
                } else if (strcopypace.equals("LOWER_CP")) {
                    rtncopy = 1;
                } else if (strcopypace.equals("FASTER_CP")) {
                    rtncopy = 2;
                }
            } else if (copytype == 3) {
                rtncopy = strcopypace.equals("LOWER_CP") ? 1 : (strcopypace.equals("MEDIUM_CP") ? 2 : (strcopypace.equals("FASTER_CP") ? 3 : 0));
            }
        }
        return (short)rtncopy;
    }

    private void setAvailableTableData(List<SJmoLocalReplicationPairVolInfo> pairInfo) {
        SJctrSplitPairsTableModel splitTable = (SJctrSplitPairsTableModel)this.getDataObjectModel(KEY_TABLE);
        splitTable.setBasicDataList(pairInfo);
    }

    private int checkCopyTypeForLocalPairVol(List<SJmoLocalReplicationPairVolInfo> pairExist) {
        if (null == pairExist) {
            this.logUty.putlog("checkCopyTypeForLocalPairVol", "Pair info is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        int copytype = SJctrReplicationUtility.checkCopyTypeForLocalPairVolList(pairExist);
        if (-1 == copytype) {
            this.logUty.putlog("checkCopyTypeForLocalPairVol", "Selected pair is mix.");
            SJctrError err = new SJctrError(209, 22, 106114);
            SJcException exp = err.createException();
            throw exp;
        }
        return copytype;
    }

    protected void checkPairStatus(List<SJmoLocalReplicationPairVolInfo> pairExist, SJmoLocalReplicationPairVolInfoMgr allPairVolInfo, int copytype) {
        if (null == pairExist || null == allPairVolInfo) {
            this.logUty.putlog("checkPairStatus", "Pair info is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrReplicationUtility.checkLocalPairVolStatus(pairExist, allPairVolInfo, SJctrReplicationDataMacro.SPLIT_PAIR_STATUS_PASS, copytype);
    }
}

