/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.createpairs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.comparator.SJctrTrueCopyPairInfoPriorityComparator;
import sanproject.sn2.controller.com.comparator.SJctrUniversalReplicatorPairInfoPriorityComparator;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationError;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.SJctrCreatePairsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrGetUniversalReplicatorPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateTcPairsConfirmTable;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateTcPairsSelectedTableModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateUrPairsConfirmTable;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateUrPairsSelectedTableModel;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;

public class SJctrCreatePairsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 16797967;
    private int copyType = -1;

    public SJctrCreatePairsConfirmDC() throws SJcException {
        super(16797967);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrCreateTcPairsConfirmTable confirmTcTable = new SJctrCreateTcPairsConfirmTable();
        confirmTcTable.setPaging(false);
        this.addDataObjectModel("COM_TABLE_SELECTED_CONF_TC", confirmTcTable);
        SJctrCreateUrPairsConfirmTable confirmUrTable = new SJctrCreateUrPairsConfirmTable();
        confirmUrTable.setPaging(false);
        this.addDataObjectModel("COM_TABLE_SELECTED_CONF_UR", confirmUrTable);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrCreatePairsConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrCreatePairsConfirmData.class);
        if (null == confirmDataList) {
            this.logUty.putlog("checkStartData", "Confirmation data list is null.");
            SJctrError err = new SJctrError(210, 22, 107005);
            throw err.createException();
        }
        if (0 == confirmDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of confirmation data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107005);
            throw err.createException();
        }
        confirmData = (SJctrCreatePairsConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            SJctrError err = new SJctrError(210, 22, 107005);
            throw err.createException();
        }
        return ret;
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        List<?> confirmDataList = this.getCache(SJctrCreatePairsConfirmData.class);
        SJctrCreatePairsConfirmData confirmData = (SJctrCreatePairsConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        super.makeDataObjectModel(keyList);
    }

    @Override
    public boolean checkConstructData() {
        SJctrCreatePairsConfirmData confirmData = (SJctrCreatePairsConfirmData)this.getProxy().getCache(SJctrCreatePairsConfirmData.class).get(0);
        this.copyType = confirmData.getCopyType();
        SJctrTableDataModel confirmTcTable = (SJctrTableDataModel)this.getDataObjectModel(this.getTableKey());
        if (confirmTcTable instanceof SJctrCreateTcPairsSelectedTableModel) {
            ((SJctrCreateTcPairsSelectedTableModel)confirmTcTable).setCopyType(this.copyType);
            ((SJctrCreateTcPairsSelectedTableModel)confirmTcTable).setBasicDataList(confirmData.getPairInfo());
            if (confirmTcTable instanceof SJctrCreateUrPairsSelectedTableModel) {
                ((SJctrCreateUrPairsSelectedTableModel)confirmTcTable).setReplicationPairVolInfoList(confirmData.getNeedDataMap().get(SJctrGetUniversalReplicatorPairVolInfo.class.getName()));
            }
        }
        this.getManageData().setData("COM_COPY_TYPE", String.valueOf(this.copyType));
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrCreatePairsConfirmData.class);
        retMap.put(SJctrCreatePairsConfirmData.class.getName(), confirmDataList);
        return retMap;
    }

    @Override
    public void getConfirmWithStatus(List<Object> result) throws SJcException {
        SJctrCreatePairsConfirmData confirmData = (SJctrCreatePairsConfirmData)this.getProxy().getCache(SJctrCreatePairsConfirmData.class).get(0);
        this.copyType = confirmData.getCopyType();
        SJctrCreateTcPairsSelectedTableModel confirmTable = (SJctrCreateTcPairsSelectedTableModel)this.getDataObjectModel(this.getTableKey());
        confirmTable.setCopyType(this.copyType);
        confirmTable.setBasicDataMap(confirmData.getNeedDataMap());
        confirmTable.setBasicDataList(confirmData.getPairInfo());
        if (this.copyType == 2 || this.copyType == 3) {
            ((SJctrCreateUrPairsSelectedTableModel)confirmTable).setReplicationPairVolInfoList(confirmData.getNeedDataMap().get(SJctrGetUniversalReplicatorPairVolInfo.class.getName()));
        }
        confirmTable.makeDataModel();
        List tempList = (List)result.get(0);
        List errorList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errorList.size());
        List<?> rowDataList = this.getRowDataList(confirmData, this.copyType);
        for (SJctrRcOperationError error : errorList) {
            SJmoReplicationPairVolInfo pairInfo = (SJmoReplicationPairVolInfo)rowDataList.get(error.getIndex());
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(pairInfo, error);
            errColumnList.add(errColumn);
        }
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(this.getTableKey(), errTable);
        errTable.initialize(confirmTable, errColumnList, new SJctrErrorColumnDataComparator());
    }

    private List<?> getRowDataList(SJctrCreatePairsConfirmData confirmData, int copyType) {
        List<SJmoReplicationPairVolInfo> rowDataList = null;
        if (copyType == 0 || copyType == 1) {
            rowDataList = this.getTrueCopyRowDataList(confirmData);
        } else if (copyType == 2 || copyType == 3) {
            rowDataList = this.getUniversalReplicatorRowDataList(confirmData);
        } else {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return rowDataList;
    }

    private List<SJmoTrueCopyPairVolInfo> getTrueCopyRowDataList(SJctrCreatePairsConfirmData confirmData) {
        ArrayList<SJmoTrueCopyPairVolInfo> rowDataList = new ArrayList<SJmoTrueCopyPairVolInfo>();
        for (SJmoReplicationPairVolInfo sJmoReplicationPairVolInfo : confirmData.getPairInfo()) {
            try {
                rowDataList.add((SJmoTrueCopyPairVolInfo)sJmoReplicationPairVolInfo.clone());
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("getTrueCopyRowDataList", "Information of SJmoTrueCopyPairVolInfo cannot clone.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
        }
        Collections.sort(rowDataList, new SJctrTrueCopyPairInfoPriorityComparator());
        return rowDataList;
    }

    private List<SJmoUniversalReplicatorPairVolInfo> getUniversalReplicatorRowDataList(SJctrCreatePairsConfirmData confirmData) {
        ArrayList<SJmoUniversalReplicatorPairVolInfo> rowDataList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        for (SJmoReplicationPairVolInfo sJmoReplicationPairVolInfo : confirmData.getPairInfo()) {
            try {
                rowDataList.add((SJmoUniversalReplicatorPairVolInfo)sJmoReplicationPairVolInfo.clone());
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("getUniversalReplicatorRowDataList", "Information of SJmoUniversalReplicatorPairVolInfo cannot clone.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
        }
        Collections.sort(rowDataList, new SJctrUniversalReplicatorPairInfoPriorityComparator());
        return rowDataList;
    }

    private String getTableKey() {
        String tableKey = "";
        switch (this.copyType) {
            case 0: 
            case 1: {
                tableKey = "COM_TABLE_SELECTED_CONF_TC";
                break;
            }
            case 2: 
            case 3: {
                tableKey = "COM_TABLE_SELECTED_CONF_UR";
                break;
            }
        }
        return tableKey;
    }
}

