/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.edittcpairopts;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.RMCPChange1PairOption;
import sanproject.serverux.dataimpl.RMCPChangePairOption;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationTcPairBaseAC;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.edittcpairopts.SJctrEditTcPairOptionsConfirmData;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;

public class SJctrEditTcPairOptionsAC
extends SJctrOperationTcPairBaseAC {
    private static final long serialVersionUID = -5432279617965832293L;
    private Map<Integer, List<SJmoPortLunDetail>> portLunMap = null;
    private static final int CFW_INVALID_COPY_TYPE = 0;

    void setApplyData(SJctrEditTcPairOptionsConfirmData confirmData) {
        this.applyInfo = confirmData.getPairInfoList();
        this.copyType = confirmData.getCopyType();
        this.portLunMap = confirmData.getLUPathMap();
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<RMCPChangePairOption> applyList = null;
        ArrayList<RMCPChangePairOption> applyData = new ArrayList<RMCPChangePairOption>(1);
        RMCPChange1PairOption[] changePairList = new RMCPChange1PairOption[this.applyInfo.size()];
        for (int i = 0; i < this.applyInfo.size(); ++i) {
            SJmoTrueCopyPairVolInfo pairInfo = (SJmoTrueCopyPairVolInfo)this.applyInfo.get(i);
            RMCPChange1PairOption change1pair = new RMCPChange1PairOption();
            SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(pairInfo);
            change1pair.CUNo = localVol.getSCu();
            change1pair.LDEVNo = localVol.getSLdev();
            change1pair.LDKC = localVol.getSLdkc();
            change1pair.PLU = SJctrRemoteReplicationUtility.getLocalRMCPHorcLU(localVol, this.copyType, this.portLunMap);
            change1pair.Option = this.setPairOption(pairInfo.getBehaviorBitSet());
            changePairList[i] = change1pair;
        }
        RMCPChangePairOption changePair = new RMCPChangePairOption();
        changePair.Change1PairOption = changePairList;
        changePair.NumofPair = changePairList.length;
        applyData.add(changePair);
        applyList = applyData;
        return applyList;
    }

    private int setPairOption(BitSet behaviorBitSet) {
        int ret = 0;
        ret = behaviorBitSet.get(1) ? (ret |= 2) : (ret |= 0);
        ret |= this.getFenceLevelValue(behaviorBitSet);
        ret |= 0;
        ret |= 0;
        if (this.copyType == 1) {
            ret |= 0;
            ret |= 0x80;
        } else if (this.copyType == 0) {
            ret |= this.getCFWValue(behaviorBitSet);
            ret |= 0;
        }
        return ret;
    }

    private int getFenceLevelValue(BitSet behaviorBitSet) {
        int ret = 0;
        BitSet fenceBitSet = behaviorBitSet.get(2, 5);
        if (fenceBitSet.equals(SJctrRemoteReplicationDataMacro.bsNever)) {
            ret = 0;
        } else if (fenceBitSet.equals(SJctrRemoteReplicationDataMacro.bsSVolData)) {
            ret = 4;
        } else if (fenceBitSet.equals(SJctrRemoteReplicationDataMacro.bsSVolStatus)) {
            ret = 8;
        }
        return ret;
    }

    private int getCFWValue(BitSet behaviorBitSet) {
        int ret = 0;
        ret = behaviorBitSet.get(0) ? 1 : 0;
        return ret;
    }
}

