/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resyncmirrors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.replication.remote.resyncmirrors.SJctrResyncMirrorsAC;
import sanproject.sn2.controller.wizard.replication.remote.resyncmirrors.SJctrResyncMirrorsConfirmDC;
import sanproject.sn2.controller.wizard.replication.remote.resyncmirrors.SJctrResyncMirrorsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.replication.SJmoMirrorIndex;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationLuPath;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrResyncMirrorsSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "RESYNC_MIRROR";
    private static final Class<?> CONFIRM_DC = SJctrResyncMirrorsConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrResyncMirrorsAC applyCntl = new SJctrResyncMirrorsAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<SJmoMirrorIndex> mirrorIndexList = dc.getProxy().getCache("KEY_SELECTED_MIRROR");
            if (null == mirrorIndexList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == mirrorIndexList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoUniversalReplicatorJnlGrpMgr allJnlInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(dc);
            SJmoUniversalReplicatorPairVolInfoMgr allURPairMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(dc);
            List<SJmoUniversalReplicatorJnlGrpMirror> mirrorExist = SJctrRemoteReplicationUtility.checkAndGetExistMirrorInfo(mirrorIndexList, allJnlInfo);
            SJctrRemoteReplicationUtility.checkMirrorTypicalVolRs(dc, mirrorExist);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForMirror(mirrorExist, allJnlInfo);
            if (copytype == -1) {
                dc.getLogUty().putlog("constructConfirmData", "Copy type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206010);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrRemoteReplicationUtility.checkPpLicenseForURList(uc, copytype);
            boolean attribute = SJctrRemoteReplicationUtility.checkMirrorAttributeMaster(mirrorExist, true);
            if (!attribute) {
                if (13314 == dc.getTopWindow().getDisplayID()) {
                    dc.getLogUty().putlog("constructConfirmData", "Contained invalid mirror attribute.(ErrorLevel5)");
                    SJctrError err = new SJctrError(210, 22, 206067);
                    SJcException exp = err.createException();
                    throw exp;
                }
                dc.getLogUty().putlog("constructConfirmData", "Contained invalid mirror attribute.(ErrorLevel4)");
                SJctrError err = new SJctrError(210, 22, 206006);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoUniversalReplicatorPairVolInfo> allPairList = this.getAllPairsBelongToMirror(mirrorExist, allURPairMgr);
            boolean isPvolDuplicate = SJctrRemoteReplicationUtility.isLocalVolDuplicateForUrPair(allPairList);
            if (isPvolDuplicate) {
                if (13314 == dc.getTopWindow().getDisplayID()) {
                    dc.getLogUty().putlog("constructConfirmData", "Selected Local Volume of Multi Mirror Used.");
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206287);
                }
                dc.getLogUty().putlog("constructConfirmData", "Selected Mirror of Multi Mirror Used.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206288);
            }
            boolean st = SJctrRemoteReplicationUtility.checkResyncMirrorStatus(mirrorExist);
            if (!st) {
                if (13314 == dc.getTopWindow().getDisplayID()) {
                    dc.getLogUty().putlog("constructConfirmData", "Contained invaid Mirror Status.(ErrorLevel5)");
                    SJctrError err = new SJctrError(210, 22, 206050);
                    SJcException exp = err.createException();
                    throw exp;
                }
                dc.getLogUty().putlog("constructConfirmData", "Contained invaid Mirror Status.(ErrorLevel4)");
                SJctrError err = new SJctrError(210, 22, 206015);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoUniversalReplicatorPairVolInfo> pairList = this.getPairsBelongToMirror(mirrorExist, allURPairMgr, dc);
            SJctrResyncMirrorsConfirmData confirmData = new SJctrResyncMirrorsConfirmData();
            ArrayList<SJctrResyncMirrorsConfirmData> confirmDataList = new ArrayList<SJctrResyncMirrorsConfirmData>();
            confirmData.setMirrorsInfo(mirrorExist);
            confirmData.setCopyType(copytype);
            confirmData.setNeedData(dc);
            confirmData.setPairList(pairList);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrResyncMirrorsConfirmData.class, confirmDataList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107002);
        }
    }

    private List<SJmoUniversalReplicatorPairVolInfo> getAllPairsBelongToMirror(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorExist, SJmoUniversalReplicatorPairVolInfoMgr pairMgr) {
        ArrayList<SJmoUniversalReplicatorPairVolInfo> pairList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        List<? extends SJmoReplicationPairVolInfo> urpairList = SJctrRemoteReplicationUtility.getRemoteCopyPairVolInfoList(pairMgr.getPairVolInfoList());
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorExist) {
            int mirrorId = mirrorInfo.getMirrorId();
            int jnlId = mirrorInfo.getIJnlGroupId();
            for (SJmoUniversalReplicatorPairVolInfo sJmoUniversalReplicatorPairVolInfo : urpairList) {
                if (sJmoUniversalReplicatorPairVolInfo.getMirrorId() != mirrorId || sJmoUniversalReplicatorPairVolInfo.getMJnlGrpId() != jnlId) continue;
                pairList.add(sJmoUniversalReplicatorPairVolInfo);
            }
        }
        return pairList;
    }

    private List<SJmoUniversalReplicatorPairVolInfo> getPairsBelongToMirror(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorExist, SJmoUniversalReplicatorPairVolInfoMgr pairMgr, SJctrWizardWindowDC dc) {
        ArrayList<SJmoUniversalReplicatorPairVolInfo> pairList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        block0: for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorExist) {
            SJmoRemoteReplicationLuPath pVolInfo = mirrorInfo.getPDataVol();
            SJmoReplicationPairVolInfo localPairVolInfo = pairMgr.getPairVolInfo(pVolInfo);
            if (localPairVolInfo == null) {
                dc.getLogUty().putlog("getPairsBelongToMirror", "Local pair volume info is null.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList<? extends SJmoLdevIndex> remoteVolList = localPairVolInfo.getAlSVolIndex();
            if (remoteVolList == null || remoteVolList.size() == 0) {
                dc.getLogUty().putlog("getPairsBelongToMirror", "Remote pair volume info is invalid.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException sJcException = err.createException();
                throw sJcException;
            }
            for (SJmoUniversalReplicatorPairVolInfo sJmoUniversalReplicatorPairVolInfo : remoteVolList) {
                if (mirrorInfo.getIJnlGroupId() != sJmoUniversalReplicatorPairVolInfo.getMJnlGrpId() || mirrorInfo.getIMirrorId() != sJmoUniversalReplicatorPairVolInfo.getMirrorId() || mirrorInfo.getSDataVol().getIndex() != sJmoUniversalReplicatorPairVolInfo.getIndex()) continue;
                pairList.add(sJmoUniversalReplicatorPairVolInfo);
                continue block0;
            }
        }
        if (mirrorExist.size() != pairList.size()) {
            dc.getLogUty().putlog("getPairsBelongToMirror", "Number of pairs and the number of different Mirror.");
            SJctrError err = new SJctrError(210, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        return pairList;
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }
}

