/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairprops;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.dataimpl.RMCPget1PairDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrTextLabelDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetLDEVLUPathInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrGetRmcp1PairDetailList;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrTcViewPairPropertiesDetailDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrTcViewPairPropertiesPropertiesDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.connector.kind.SJmoGetTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrTcViewPairPropertiesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664520;
    private Map<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>> ldevLunMap = new HashMap<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>>();
    private List<SJmoTrueCopyPairVolInfo> tcPairList = new ArrayList<SJmoTrueCopyPairVolInfo>();
    private int currentIndex = -1;

    public SJctrTcViewPairPropertiesDC() {
        super(34664520);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_PAIR_PROPERTIES_INF", new SJctrTcViewPairPropertiesPropertiesDataModel());
        this.addDataObjectModel("COM_PAIR_DETAIL_INF", new SJctrTcViewPairPropertiesDetailDataModel());
        this.addDataObjectModel("COM_PAGE_NUM", new SJctrTextLabelDataModel());
        Set<SJctrFooterDataModel.Button> footerButton = Collections.unmodifiableSet(EnumSet.of(SJctrFooterDataModel.Button.BACK, SJctrFooterDataModel.Button.NEXT, SJctrFooterDataModel.Button.CLOSE));
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(footerButton));
    }

    private void initListener() {
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.BACK, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTcViewPairPropertiesDC.this.backAction();
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.NEXT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTcViewPairPropertiesDC.this.nextAction();
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetTrueCopyPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        List<?> infoList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == infoList) {
            this.logUty.putlog("checkStartData", "Information of data list is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (infoList.isEmpty()) {
            this.logUty.putlog("checkStartData", "Size of data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJcException exp;
            SJctrError err;
            SJmoTrueCopyPairVolInfoMgr pairMgr = SJctrRemoteReplicationUtility.getSJmoTrueCopyPairVolInfoMgr(this);
            SJctrReplicationUtility.getSJmoLdevDetail(this);
            SJctrReplicationUtility.getSJmoLdevNicknameInfo(this);
            SJctrReplicationUtility.getSJmoClprInfo(this);
            SJctrReplicationUtility.getSJmoLdevLuseInfo(this);
            List<SJmoPortLunInfo> modelPtLun = SJctrReplicationUtility.getSJmoPortLunInfo(this);
            SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            this.ldevLunMap = SJctrPortUtility.getPortLunMapFromLdevDetail(modelPtLun);
            ArrayList<Map<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>>> ldevLunMapList = new ArrayList<Map<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>>>(1);
            ldevLunMapList.add(this.ldevLunMap);
            this.getProxy().putCache(SJctrGetLDEVLUPathInfo.class, ldevLunMapList);
            List<SJmoTrueCopyPairVolInfo> selectedPairList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            this.tcPairList = SJctrRemoteReplicationUtility.getExistTcPairVolInfo(selectedPairList, pairMgr);
            if (this.tcPairList.isEmpty()) {
                SJctrError err2 = new SJctrError(210, 22, 206502);
                SJcException exp2 = err2.createException();
                throw exp2;
            }
            List<RMCPget1PairDetail> rmiPairDetail = SJctrRemoteReplicationUtility.getRMCPget1PairDetailList(this, this.tcPairList);
            for (RMCPget1PairDetail pairdetail : rmiPairDetail) {
                this.logUty.putlog("checkConstructData### RMCPget1PairDetail Info ###", "PairDetail.PLDKC=" + pairdetail.PLDKC + ":PairDetail.PCUNo=" + pairdetail.PCUNo + ":PairDetail.PVolNo=" + pairdetail.PVolNo + ":PairDetail.SLDKC=" + pairdetail.SLDKC + ":PairDetail.SCUNo=" + pairdetail.SCUNo + ":PairDetail.SVolNo=" + pairdetail.SVolNo + ":PairDetail.VolumeType=" + pairdetail.VolumeType + ":PairDetail.PairStatus=" + pairdetail.PairStatus + ":PairDetail.PairOption.Behavior=" + pairdetail.PairOption.Behavior);
            }
            this.removeInvalidStatusPair(rmiPairDetail);
            if (rmiPairDetail.isEmpty()) {
                this.logUty.putlog("checkConstructData", "All Pair Information is Invalid.");
                err = new SJctrError(210, 22, 206502);
                exp = err.createException();
                throw exp;
            }
            this.removeDisapearPairInfo(rmiPairDetail);
            if (this.tcPairList.isEmpty()) {
                this.logUty.putlog("checkConstructData", "All pairs is invalid.");
                err = new SJctrError(210, 22, 206502);
                exp = err.createException();
                throw exp;
            }
            boolean warnFlg = selectedPairList.size() != this.tcPairList.size();
            this.getManageData().setData("COM_WARN_INFO_FLG", warnFlg);
            this.getProxy().putCache(SJctrGetRmcp1PairDetailList.class, rmiPairDetail);
            this.updateModelPairInfo(rmiPairDetail);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private void removeDisapearPairInfo(List<RMCPget1PairDetail> rmiPairList) {
        List<SJmoPortLunInfo> modelPtLun = SJctrReplicationUtility.getSJmoPortLunInfo(this);
        this.ldevLunMap = SJctrPortUtility.getPortLunMapFromLdevDetail(modelPtLun);
        Iterator<SJmoTrueCopyPairVolInfo> ite = this.tcPairList.iterator();
        while (ite.hasNext()) {
            SJmoTrueCopyPairVolInfo tcPair = ite.next();
            RMCPget1PairDetail rmiPair = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(rmiPairList, tcPair);
            if (null != rmiPair) continue;
            ite.remove();
        }
    }

    private void removeInvalidStatusPair(List<RMCPget1PairDetail> rmiPairList) {
        Iterator<RMCPget1PairDetail> ite = rmiPairList.iterator();
        while (ite.hasNext()) {
            RMCPget1PairDetail rmiPair = ite.next();
            if (this.checkViewPairPropTcStatus(rmiPair.PairStatus)) continue;
            ite.remove();
        }
    }

    private boolean checkViewPairPropTcStatus(int pairStatus) {
        boolean rtn = SJctrRemoteReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_PAIR_PROP_TC_TCMF.contains(pairStatus);
        return rtn;
    }

    @Override
    public void makeDataModel() {
        try {
            super.makeDataModel();
            this.currentIndex = 0;
            this.refDataModel();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
    }

    private void refDataModel() {
        if (0 <= this.currentIndex && this.currentIndex < this.tcPairList.size()) {
            SJmoTrueCopyPairVolInfo tcPair = this.tcPairList.get(this.currentIndex);
            SJctrTcViewPairPropertiesPropertiesDataModel prop = (SJctrTcViewPairPropertiesPropertiesDataModel)this.getDataObjectModel("COM_PAIR_PROPERTIES_INF");
            prop.makeProperties(tcPair, this);
            SJctrTcViewPairPropertiesDetailDataModel detail = (SJctrTcViewPairPropertiesDetailDataModel)this.getDataObjectModel("COM_PAIR_DETAIL_INF");
            detail.makeSummary(tcPair);
            this.makePageLabel();
        }
        this.setDirtyAll();
    }

    private void makePageLabel() {
        String pageLabelString = String.valueOf(this.currentIndex + 1) + " / " + this.tcPairList.size();
        SJctrTextLabelDataModel pageLabel = (SJctrTextLabelDataModel)this.getDataObjectModel("COM_PAGE_NUM");
        pageLabel.setLabel(pageLabelString);
    }

    private void backAction() {
        if (0 < this.currentIndex) {
            --this.currentIndex;
        }
        this.refDataModel();
        this.updateFooter();
    }

    private void nextAction() {
        if (this.currentIndex < this.tcPairList.size() - 1) {
            ++this.currentIndex;
        }
        this.refDataModel();
        this.updateFooter();
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        footer.setEnableButton(SJctrFooterDataModel.Button.BACK, 0 < this.currentIndex && this.currentIndex < this.tcPairList.size());
        footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, 0 <= this.currentIndex && this.currentIndex < this.tcPairList.size() - 1);
    }

    private void updateModelPairInfo(List<RMCPget1PairDetail> rmiPairList) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        int BEHAVIOR_MASK = 1;
        for (SJmoTrueCopyPairVolInfo remoteVol : this.tcPairList) {
            RMCPget1PairDetail rmiPair = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(rmiPairList, remoteVol);
            if (null == rmiPair) continue;
            remoteVol.setIPairStatus(rmiPair.PairStatus);
            remoteVol.setStrPairSN(rmiPair.SN);
            remoteVol.setIPairSSID(rmiPair.SSID);
            remoteVol.setICUFree(rmiPair.CUFree);
            remoteVol.setIPairRCUID(rmiPair.PairRCUID);
            remoteVol.setIPairControllerID(rmiPair.PairControllerID);
            remoteVol.setIPriority(rmiPair.Priority);
            remoteVol.setITracks(rmiPair.CopyPace);
            remoteVol.setICtgId(rmiPair.CTGNo);
            try {
                remoteVol.setDaPairCreateTime(df.parse(rmiPair.PairCreateTime));
            }
            catch (ParseException e) {
                this.logUty.putlog("updateModelPairInfo", "Parse error occured. PairCreateTime: " + rmiPair.PairCreateTime);
            }
            try {
                remoteVol.setDaPairRenewTime(df.parse(rmiPair.PairRenewTime));
            }
            catch (ParseException e) {
                this.logUty.putlog("updateModelPairInfo", "Parse error occured. PairRenewTime: " + rmiPair.PairRenewTime);
            }
            long copyTime = SJctrRemoteReplicationUtility.getCopyTimeNumber(rmiPair.PairCopyTime);
            remoteVol.setLPairCopyTime(copyTime);
            remoteVol.setILockID(rmiPair.iLockID);
            remoteVol.setISSWS(rmiPair.iSSWS);
            remoteVol.setILockStatus(rmiPair.iLockStatus);
            BitSet behaviorBitSet = remoteVol.getBehaviorBitSet();
            for (int i = 0; i < behaviorBitSet.size(); ++i) {
                behaviorBitSet.set(i, (rmiPair.PairOption.Behavior >> i & BEHAVIOR_MASK) == 1);
            }
            remoteVol.setStrHostPairStatus(rmiPair.sHostPairStatus);
            remoteVol.setIFormatinfo(rmiPair.Formatinfo);
            remoteVol.setIQueu(rmiPair.CopyQueu);
        }
    }
}

