/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sanproject.serverux.dataimpl.RMCPget1PairSummary;
import sanproject.serverux.dataimpl.RMCPgetPair;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrTrueCopyPairInfoComparator;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.com.SJctrViewPairSyncrateInfoMsgFlagData;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrViewPairSyncRateTcTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrViewPairSyncRateTcTcmfInfo;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoTrueCopyPairVolInfoMgr;

public class SJctrViewPairSyncRateTcDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 35319861;
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_TABLE_VIEW_INFO = "COM_TABLE_VIEW_INFO";
    private static final String KEY_TABLE_TC = "COM_TABLE_TC";
    private static final String KEY_REFRESH = "COM_REFRESH";
    private static final String KEY_VIEWMSG = "COM_VIEWMSG";

    public SJctrViewPairSyncRateTcDC() {
        super(35319861);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrViewPairSyncRateTcTableDataModel viewPairSyncRateTableModel = new SJctrViewPairSyncRateTcTableDataModel();
        this.addDataObjectModel(KEY_TABLE, viewPairSyncRateTableModel);
        SJctrButtonDataModel refreshButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REFRESH, refreshButton);
        refreshButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrViewPairSyncRateTcDC.this.fireMessageEvent(SYNC_RATE_MSG.SELECT_REFRESH);
            }
        });
        this.addDataObjectModel(KEY_VIEWMSG, new SJctrViewPairSyncrateInfoMsgFlagData());
        this.getManageData().setData(KEY_TABLE_VIEW_INFO, KEY_TABLE_TC);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        this.addMessageEventListener(SYNC_RATE_MSG.SELECT_REFRESH, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrViewPairSyncRateTcDC.this.refreshTableAction(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> inheritedList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == inheritedList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == inheritedList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        try {
            List<?> inheritedList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            List<?> tcPairInfoMgrList = SJctrRemoteReplicationUtility.getSpecifiedModelInfoMgrNotUsedCache(this, new SJmoGetTrueCopyPairVolInfoMgr());
            SJctrViewPairSyncrateInfoMsgFlagData informationFlagModel = (SJctrViewPairSyncrateInfoMsgFlagData)this.getDataObjectModel(KEY_VIEWMSG);
            List<SJctrViewPairSyncRateTcTcmfInfo> rmiDataList = this.createConstructData(inheritedList, (SJmoTrueCopyPairVolInfoMgr)tcPairInfoMgrList.get(0), informationFlagModel);
            SJctrViewPairSyncRateTcTableDataModel pairTable = (SJctrViewPairSyncRateTcTableDataModel)this.getDataObjectModel(KEY_TABLE);
            pairTable.setBasicDataList(rmiDataList);
            pairTable.setInfoLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevDetail()));
            pairTable.setInfoLdevNickname(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevNicknameInfo()));
            pairTable.setInfoClpr(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetClprInfo()));
            pairTable.setInfoVirtualDkc(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualDkc()));
            pairTable.setInfoVirtualLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualLdev()));
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107002);
        }
        return ret;
    }

    public void refreshTableAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrViewPairSyncRateTcTableDataModel pairTable = (SJctrViewPairSyncRateTcTableDataModel)this.getDataObjectModel(KEY_TABLE);
            List<Object> inheritedList = pairTable.getAllRowData();
            List<?> tcPairInfoMgrList = SJctrRemoteReplicationUtility.getSpecifiedModelInfoMgrNotUsedCache(this, new SJmoGetTrueCopyPairVolInfoMgr());
            SJctrViewPairSyncrateInfoMsgFlagData informationFlagModel = (SJctrViewPairSyncrateInfoMsgFlagData)this.getDataObjectModel(KEY_VIEWMSG);
            List<SJctrViewPairSyncRateTcTcmfInfo> rmiDataList = this.createConstructData(inheritedList, (SJmoTrueCopyPairVolInfoMgr)tcPairInfoMgrList.get(0), informationFlagModel);
            pairTable.setBasicDataList(rmiDataList);
            pairTable.setInfoLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevDetail()));
            pairTable.setInfoLdevNickname(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevNicknameInfo()));
            pairTable.setInfoClpr(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetClprInfo()));
            pairTable.setInfoVirtualDkc(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualDkc()));
            pairTable.setInfoVirtualLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualLdev()));
            List<Object> selectData = pairTable.getSelectedRowData();
            pairTable.doRefresh();
            pairTable.addRowSelectionList(selectData);
            informationFlagModel.setDirty();
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107004);
        }
    }

    private List<SJctrViewPairSyncRateTcTcmfInfo> createConstructData(List<?> inheritedList, SJmoTrueCopyPairVolInfoMgr tcPairInfoMgr, SJctrViewPairSyncrateInfoMsgFlagData informationFlagModel) {
        ArrayList<SJctrViewPairSyncRateTcTcmfInfo> rmiDataList = new ArrayList();
        List<SJmoTrueCopyPairVolInfo> checkPairList = SJctrRemoteReplicationUtility.getExistTcPairVolInfo(inheritedList, tcPairInfoMgr);
        if (checkPairList.isEmpty()) {
            this.logUty.putlog("createConstructData", "Size of checkPairList is zero.");
            SJctrError err = new SJctrError(210, 22, 206502);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoTrueCopyPairVolInfo> tcPairList = new ArrayList<SJmoTrueCopyPairVolInfo>();
        ArrayList<SJmoTrueCopyPairVolInfo> tcmfPairList = new ArrayList<SJmoTrueCopyPairVolInfo>();
        this.setPairListSeparateTcTcmf(tcPairList, tcmfPairList, checkPairList);
        RMCPgetPair tcSyncInfo = null;
        RMCPgetPair tcmfSyncInfo = null;
        if (!tcPairList.isEmpty()) {
            SJmoThroughRmiData tcRmiData = SJctrRemoteReplicationUtility.getRMCPgetPairModelDirect(this, tcPairList, 1);
            tcSyncInfo = (RMCPgetPair)tcRmiData.getObjRmi();
        }
        if (!tcmfPairList.isEmpty()) {
            SJmoThroughRmiData tcmfRmiData = SJctrRemoteReplicationUtility.getRMCPgetPairModelDirect(this, tcmfPairList, 0);
            tcmfSyncInfo = (RMCPgetPair)tcmfRmiData.getObjRmi();
        }
        if (tcSyncInfo == null && tcmfSyncInfo == null) {
            this.logUty.putlog("createConstructData", "tcSyncInfo and tcmfSyncInfo is null.");
            SJctrError err = new SJctrError(210, 22, 206502);
            SJcException exp = err.createException();
            throw exp;
        }
        RMCPget1PairSummary[] tcPairSummaryInfo = null;
        RMCPget1PairSummary[] tcmfPairSummaryInfo = null;
        if (tcSyncInfo != null) {
            tcPairSummaryInfo = (RMCPget1PairSummary[])tcSyncInfo.get_PairSummary();
        }
        if (tcmfSyncInfo != null) {
            tcmfPairSummaryInfo = (RMCPget1PairSummary[])tcmfSyncInfo.get_PairSummary();
        }
        rmiDataList = this.makeDataList(tcPairSummaryInfo, tcmfPairSummaryInfo, checkPairList);
        this.removeInvalidStatusPair(rmiDataList);
        Collections.sort(rmiDataList, new SJctrTrueCopyPairInfoComparator());
        if (0 == rmiDataList.size()) {
            this.logUty.putlog("createConstructData", "Size of local replication pair list is zero.");
            SJctrError err = new SJctrError(210, 22, 206502);
            SJcException exp = err.createException();
            throw exp;
        }
        if (rmiDataList.size() < inheritedList.size()) {
            informationFlagModel.setInformationFlag(1);
        } else {
            informationFlagModel.setInformationFlag(0);
        }
        return rmiDataList;
    }

    private List<SJctrViewPairSyncRateTcTcmfInfo> makeDataList(RMCPget1PairSummary[] tcPairDetail, RMCPget1PairSummary[] tcmfPairDetail, List<SJmoTrueCopyPairVolInfo> checkPairList) {
        if (null == tcPairDetail && tcmfPairDetail == null) {
            this.logUty.putlog("makeDataList", "Parameter is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJctrViewPairSyncRateTcTcmfInfo> rtnList = new ArrayList<SJctrViewPairSyncRateTcTcmfInfo>();
        this.setViewPairSyncRateTcTcmfInfo(rtnList, tcPairDetail, 1, checkPairList);
        this.setViewPairSyncRateTcTcmfInfo(rtnList, tcmfPairDetail, 0, checkPairList);
        return rtnList;
    }

    private void setPairListSeparateTcTcmf(List<SJmoTrueCopyPairVolInfo> tcPairList, List<SJmoTrueCopyPairVolInfo> tcmfPairList, List<SJmoTrueCopyPairVolInfo> checkPairList) {
        for (SJmoTrueCopyPairVolInfo pairInfo : checkPairList) {
            if (SJctrRemoteReplicationUtility.isOpen(pairInfo)) {
                tcPairList.add(pairInfo);
                continue;
            }
            if (!SJctrRemoteReplicationUtility.isMainframe(pairInfo)) continue;
            tcmfPairList.add(pairInfo);
        }
    }

    private void setViewPairSyncRateTcTcmfInfo(List<SJctrViewPairSyncRateTcTcmfInfo> pairInfoList, RMCPget1PairSummary[] pairDetailArray, int copytype, List<SJmoTrueCopyPairVolInfo> checkPairList) {
        ArrayList<SJctrViewPairSyncRateTcTcmfInfo> syncPairList = new ArrayList<SJctrViewPairSyncRateTcTcmfInfo>();
        if (pairDetailArray != null) {
            for (int i = 0; i < pairDetailArray.length; ++i) {
                RMCPget1PairSummary pairDetail = pairDetailArray[i];
                if (null == pairDetail) continue;
                SJctrViewPairSyncRateTcTcmfInfo basicData = new SJctrViewPairSyncRateTcTcmfInfo(pairDetail);
                basicData.setQueu(pairDetail.Queu);
                basicData.setSyncRate(pairDetail.getCopyProgress());
                basicData.setSyncRateSupported(pairDetail.Type);
                basicData.setIPairVolPos(SJctrRemoteReplicationUtility.getPairVolPosInfoFromPairSummaryTCTCMF(copytype, pairDetail));
                SJctrLogUty.info(SJctrViewPairSyncRateTcDC.class.getSimpleName(), "setViewPairSyncRateTcTcmfInfo", "PairDetailType = " + pairDetail.getType() + ", CopyType = " + copytype + ", PairStatus = " + pairDetail.getPairStatus() + ", QueueState = " + pairDetail.Queu + ", SynchronousRate = " + pairDetail.getCopyProgress() + ", SyncRateSupported = " + basicData.isSyncRateSupported());
                SJmoReplicationPairVolInfo localVolIndex = new SJmoReplicationPairVolInfo();
                localVolIndex.setLdevIndex(pairDetail.getSLDKC(), pairDetail.getSCU(), pairDetail.getSLDEV());
                if (SJctrRemoteReplicationUtility.isPvol(basicData)) {
                    ArrayList<SJmoReplicationPairVolInfo> alSVolIndex = new ArrayList<SJmoReplicationPairVolInfo>(1);
                    alSVolIndex.add(localVolIndex);
                    basicData.setAlSVolIndex(alSVolIndex);
                } else if (SJctrRemoteReplicationUtility.isSvol(basicData)) {
                    basicData.setPVolIndex(localVolIndex);
                } else {
                    this.logUty.putlog("setrViewPairSyncRateTcTcmfInfo", "Pair position is invalid.");
                    SJctrError err = new SJctrError(210, 22, 107001);
                    SJcException exp = err.createException();
                    throw exp;
                }
                syncPairList.add(basicData);
            }
        }
        Collections.sort(syncPairList);
        for (SJmoTrueCopyPairVolInfo selectedPair : checkPairList) {
            int index = Collections.binarySearch(syncPairList, selectedPair);
            if (index < 0) continue;
            pairInfoList.add((SJctrViewPairSyncRateTcTcmfInfo)syncPairList.get(index));
        }
    }

    private void removeInvalidStatusPair(List<SJctrViewPairSyncRateTcTcmfInfo> rmiPairList) {
        Iterator<SJctrViewPairSyncRateTcTcmfInfo> ite = rmiPairList.iterator();
        while (ite.hasNext()) {
            SJctrViewPairSyncRateTcTcmfInfo rmiPair = ite.next();
            if (this.checkViewPairSyncRateTcStatus(rmiPair.getIPairStatus())) continue;
            ite.remove();
        }
    }

    private boolean checkViewPairSyncRateTcStatus(int pairStatus) {
        boolean rtn = SJctrRemoteReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_PAIR_SYNC_RATE_TC_TCMF.contains(pairStatus);
        return rtn;
    }

    public static enum SYNC_RATE_MSG implements SJctrNotifyState
    {
        SELECT_REFRESH;

    }
}

