/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.addextvols;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.ownership.com.SJctrOwnerShipUtility;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoAllDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoMPBladeInfo;

public class SJctrMpBladeIdDataModel
extends SJctrComboBoxDataModel {
    protected String autoLabel = "";
    private int FIXED_MP_DISABLE = 1;
    private int FIXED_MP_ENABLE = 0;

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        String name = SJctrComUtility.toDecString(255);
        this.autoLabel = util.getGuidance("AUTO");
        this.addItem(name, this.autoLabel);
    }

    @Override
    protected void makeDataObject() {
        boolean autoMp = false;
        SJctrComUtility util = this.getDataController().getOwner().getComUtility();
        SJctrWizardDataController dc = (SJctrWizardDataController)this.getDataController();
        List<?> ownerAllDkcInfos = dc.getCache(SJmoGetAllDKCInfo.class);
        for (SJmoAllDKCInfo allDkcInfo : ownerAllDkcInfos) {
            ArrayList<SJmoDKCInfo> dkcInfos = allDkcInfo.getDKCInfo();
            for (SJmoDKCInfo dkcInfo : dkcInfos) {
                ArrayList<SJmoMPBladeInfo> mpBladeInfos = dkcInfo.getMPBladeInfo();
                for (SJmoMPBladeInfo mpBladeInfo : mpBladeInfos) {
                    if (mpBladeInfo.getFixedMpStat() == this.FIXED_MP_DISABLE) {
                        autoMp = true;
                    }
                    String name = SJctrComUtility.toDecString(mpBladeInfo.getMpBladeId());
                    String label = SJctrOwnerShipUtility.toMpBladeIdDisplay(util, mpBladeInfo.getMpBladeId());
                    this.addItem(name, label);
                }
            }
        }
        if (!autoMp) {
            this.removeItem(SJctrComUtility.toDecString(255));
        }
        this.setSelectedIndex(0);
    }

    public short getSelectMpBladeId() {
        String name = this.getSelection();
        return Short.parseShort(name);
    }
}

