/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.column;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrSSIDColumnFromLdevIndex
extends SJctrColumn {
    protected Map<String, Integer> numberMap = null;

    public SJctrSSIDColumnFromLdevIndex(String key) {
        super(key);
        this.setPartsId("SSID");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetSsidDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Integer ssid = null;
        SJmoLdevIndex ldev = (SJmoLdevIndex)index;
        List<?> ssidDtlList = modelData.get(SJmoGetSsidDetail.class);
        ssid = SJctrCVSUtility.getSSID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), ssidDtlList);
        list.add(ssid);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        Integer ssid = (Integer)dataList.get(0);
        if (ssid != null) {
            ret = SJctrComUtility.toHexString(ssid, 4, true);
            if (this.numberMap == null) {
                this.numberMap = new HashMap<String, Integer>(this.getTable().getRowCount());
            }
            this.numberMap.put(ret, ssid);
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        String strNum = this.getString(dat);
        if (strNum.length() != 0) {
            num = this.numberMap.get(strNum);
        }
        return num;
    }
}

