/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrLdevNickNameManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    private List<SJmoLdevNicknameInfo> newLdevNameInfoList;

    public SJctrLdevNickNameManager() {
        this.initField();
    }

    private void initField() {
        this.newLdevNameInfoList = null;
    }

    public List<SJmoLdevNicknameInfo> getLdevNameInfoList() {
        return this.newLdevNameInfoList;
    }

    public SJmoLdevNicknameInfo getLdevNameInfo(SJmoLdevIndex ldev) {
        SJmoLdevNicknameInfo ldevNameInfo = null;
        int search = Collections.binarySearch(this.newLdevNameInfoList, ldev);
        if (search >= 0) {
            ldevNameInfo = this.newLdevNameInfoList.get(search);
        }
        return ldevNameInfo;
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
        this.newLdevNameInfoList = new ArrayList<SJmoLdevNicknameInfo>();
    }

    public SJmoLdevNicknameInfo setLdevNameInfo(SJmoLdevIndex ldev, String name) {
        return this.setLdevNameInfo(ldev, name, true);
    }

    public SJmoLdevNicknameInfo setLdevNameInfo(SJmoLdevIndex ldev, String name, boolean change) {
        SJmoLdevNicknameInfo ldevNameInfo = this.getLdevNameInfo(ldev);
        if (ldevNameInfo != null) {
            if (change) {
                ldevNameInfo.setStrNickname(name);
            }
        } else {
            ldevNameInfo = new SJmoLdevNicknameInfo();
            ldevNameInfo.setLdevIndex(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev());
            ldevNameInfo.setStrNickname(name);
            this.newLdevNameInfoList.add(ldevNameInfo);
            Collections.sort(this.newLdevNameInfoList);
        }
        return ldevNameInfo;
    }

    public boolean changeLdevNameInfo(SJmoLdevIndex befldev, SJmoLdevIndex aftldev) {
        SJmoLdevNicknameInfo befLdevNameInfo = this.getLdevNameInfo(befldev);
        if (befLdevNameInfo == null) {
            return false;
        }
        String name = befLdevNameInfo.getStrNickname();
        if (this.getLdevNameInfo(aftldev) != null) {
            return false;
        }
        this.removeLdev(befLdevNameInfo);
        this.setLdevNameInfo(aftldev, name);
        return true;
    }

    public SJmoLdevIndex removeLdev(SJmoLdevIndex ldev) {
        SJmoLdevIndex delLdev = null;
        int search = Collections.binarySearch(this.newLdevNameInfoList, ldev);
        if (search >= 0) {
            delLdev = this.newLdevNameInfoList.remove(search);
        }
        return delLdev;
    }

    public List<SJmoLdevIndex> removeLdev(List<SJmoLdevIndex> ldevList) {
        ArrayList<SJmoLdevIndex> delLdevList = new ArrayList<SJmoLdevIndex>(ldevList.size());
        for (SJmoLdevIndex ldev : ldevList) {
            SJmoLdevIndex delLdev = this.removeLdev(ldev);
            if (delLdev == null) continue;
            delLdevList.add(delLdev);
        }
        return delLdevList;
    }
}

