/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDPhysicalPath;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPhysicalPathInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPhysicalPathInfoMgr;

public class SJctrPhysicalPathManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    private SJmoExdPhysicalPathInfoMgr exdPhysicalPathManager;
    private Map<Integer, SJmoExdPhysicalPathInfo> discoveryPhysicalPathMap;

    public SJctrPhysicalPathManager() {
        this.initField();
    }

    private void initField() {
        this.exdPhysicalPathManager = null;
        this.discoveryPhysicalPathMap = new HashMap<Integer, SJmoExdPhysicalPathInfo>();
    }

    private SJmoExdPhysicalPathInfoMgr getExdPhysicalPathManager() {
        return this.exdPhysicalPathManager;
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetExdPhysicalPathInfoMgr kind = new SJmoGetExdPhysicalPathInfoMgr();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
        List<?> getList = models.get(SJmoGetExdPhysicalPathInfoMgr.class.getName());
        if (getList != null && getList.size() > 0) {
            this.exdPhysicalPathManager = (SJmoExdPhysicalPathInfoMgr)getList.get(0);
        }
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
    }

    public SJmoExdPhysicalPathInfo getPhysicalPathInfo(int physicalPathId) {
        SJmoExdPhysicalPathInfo retInfo = null;
        if (physicalPathId >= 0) {
            SJmoExdPhysicalPathInfoMgr physicalPathManager = this.getExdPhysicalPathManager();
            if (physicalPathManager != null) {
                retInfo = physicalPathManager.getExdPhysicalPathInfo(physicalPathId);
            }
        } else {
            retInfo = this.discoveryPhysicalPathMap.get(physicalPathId);
        }
        return retInfo;
    }

    public List<SJmoExdPhysicalPathInfo> getPhysicalPathListOfInitiatorPortId(int portId) {
        ArrayList retList = Collections.emptyList();
        SJmoExdPhysicalPathInfoMgr physicalPathManager = this.getExdPhysicalPathManager();
        if (physicalPathManager != null) {
            retList = physicalPathManager.getAlPhysicalPathInfoOfInitiatorPortId(portId);
        }
        return retList;
    }

    public List<SJmoExdPhysicalPathInfo> getPhysicalPathListOfTargetPortId(int wwnId) {
        ArrayList retList = Collections.emptyList();
        SJmoExdPhysicalPathInfoMgr physicalPathManager = this.getExdPhysicalPathManager();
        if (physicalPathManager != null) {
            retList = physicalPathManager.getAlPhysicalPathInfoOfTargetPortId(wwnId);
        }
        return retList;
    }

    public List<SJmoExdPhysicalPathInfo> getPhysicalPathList() {
        ArrayList retList = Collections.emptyList();
        SJmoExdPhysicalPathInfoMgr physicalPathManager = this.getExdPhysicalPathManager();
        if (physicalPathManager != null) {
            retList = physicalPathManager.getAlExdPhysicalPathInfo();
        }
        return retList;
    }

    public List<SJmoExdPhysicalPathInfo> getUnmapPhysicalPathList() {
        ArrayList<SJmoExdPhysicalPathInfo> retList = new ArrayList<SJmoExdPhysicalPathInfo>(this.discoveryPhysicalPathMap.values());
        return retList;
    }

    public List<SJmoExdPhysicalPathInfo> getUnmapPhysicalPathListOfTargetPortId(int wwnId) {
        ArrayList<SJmoExdPhysicalPathInfo> retList = new ArrayList<SJmoExdPhysicalPathInfo>(this.discoveryPhysicalPathMap.size());
        for (SJmoExdPhysicalPathInfo physicalpath : this.discoveryPhysicalPathMap.values()) {
            if (physicalpath.getRmiExdPhysicalPathInfo().referTargetPortId() != wwnId) continue;
            retList.add(physicalpath);
        }
        return retList;
    }

    public SJmoExdPhysicalPathInfo createDiscoveryPhysicalPathInfo(EXDPhysicalPath exdPhysicalPath) {
        SJmoExdPhysicalPathInfo ret = null;
        if (exdPhysicalPath.isConfigured()) {
            int id = exdPhysicalPath.getId();
            SJmoExdPhysicalPathInfo physicalPath = this.getPhysicalPathInfo(id);
            if (physicalPath != null && this.equalsEXDPhysicalPath(exdPhysicalPath, physicalPath.getRmiExdPhysicalPathInfo())) {
                ret = physicalPath;
            }
        } else {
            for (SJmoExdPhysicalPathInfo info : this.discoveryPhysicalPathMap.values()) {
                if (!this.equalsEXDPhysicalPath(exdPhysicalPath, info.getRmiExdPhysicalPathInfo())) continue;
                ret = info;
                break;
            }
            if (ret == null) {
                List<SJmoExdPhysicalPathInfo> configerList = this.getPhysicalPathList();
                for (SJmoExdPhysicalPathInfo configer : configerList) {
                    if (!this.equalsEXDPhysicalPath(exdPhysicalPath, configer.getRmiExdPhysicalPathInfo())) continue;
                    return ret;
                }
                int id = -2 - this.discoveryPhysicalPathMap.size();
                exdPhysicalPath.setId(id);
                ret = new SJmoExdPhysicalPathInfo(exdPhysicalPath);
                this.discoveryPhysicalPathMap.put(id, ret);
            }
        }
        return ret;
    }

    private boolean equalsEXDPhysicalPath(EXDPhysicalPath o1, EXDPhysicalPath o2) {
        if (o1.referInitiatorPortId() != o2.referInitiatorPortId()) {
            return false;
        }
        return o1.referTargetPortId() == o2.referTargetPortId();
    }
}

