/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.recnctextpaths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetPathInfoIpAddressComparator;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.uvm.discnctextpaths.SJctrByiSCSITargetDataMode;
import sanproject.sn2.controller.wizard.uvm.discnctextpaths.SJctrMainteExtPathsConfirmData;
import sanproject.sn2.controller.wizard.uvm.discnctextpaths.SJctrMainteExtiSCSIPathsConfirmData;
import sanproject.sn2.controller.wizard.uvm.recnctextpaths.SJctrRecnctExtPathsDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPhysicalPathInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;

public class SJctrRecnctExtiSCSIPathsDC
extends SJctrRecnctExtPathsDC {
    private static final int DISP_ID = 17834097;
    private List<SJmoPortIscsiTargetPathInfo> ptiSCSITargetPathInfoList = Collections.emptyList();
    private SJctrIscsiTargetPathInfoIpAddressComparator ipaddtrssComp = new SJctrIscsiTargetPathInfoIpAddressComparator();
    public static int RECNCTEXTPATHS_UNUSABLE_RSGPORT_EXTPORT = 205153;
    public static int RECNCTEXTPATHS_UNUSABLE_RSGPG_EXTPORT = 205154;

    public SJctrRecnctExtiSCSIPathsDC() {
        super(17834097);
    }

    @Override
    protected void initDataModel() {
        SJctrByiSCSITargetDataMode byiSCSITargetDataModel = new SJctrByiSCSITargetDataMode();
        this.addDataObjectModel("COM_RECONNECTINFO", byiSCSITargetDataModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    protected void checkModelData() {
        super.checkModelData();
        this.ptiSCSITargetPathInfoList = this.getCache(SJmoGetPortIscsiTargetPathInfo.class);
        if (this.ptiSCSITargetPathInfoList == null) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTPATHS_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetPortIscsiTargetPathInfo kind = new SJmoGetPortIscsiTargetPathInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    protected List<SJmoExdPhysicalPathInfo> getTargetPhysicalPathList() {
        List<Object> targetPhysicalPathInfoList = Collections.emptyList();
        SJctrByiSCSITargetDataMode byiSCSITargetDataModel = (SJctrByiSCSITargetDataMode)this.getDataObjectModel("COM_RECONNECTINFO");
        targetPhysicalPathInfoList = byiSCSITargetDataModel.isSelectByPorts() ? this.getPhysicalPathInfoByPorts(this.exdPhysicalPathList) : this.getPhysicalPathInfoByExtStrgPort(this.exdPhysicalPathList);
        SJmoExdPathGroupInfoMgr pathGrpMgr = (SJmoExdPathGroupInfoMgr)this.exdPathGrpMgrList.get(0);
        ArrayList pathGrpList = pathGrpMgr.getAlExdPathGroupInfo();
        for (SJmoExdPhysicalPathInfo sJmoExdPhysicalPathInfo : targetPhysicalPathInfoList) {
            if (!this.isUsablePhysicalPathAtPort(sJmoExdPhysicalPathInfo, this.rsgUtil)) {
                SJctrError errInfo = new SJctrError(6, 22, RESULT_NORMAL);
                if (byiSCSITargetDataModel.isSelectByPorts()) {
                    errInfo.setError(RECNCTEXTPATHS_UNUSABLE_RSGPORT_PATH2);
                } else {
                    errInfo.setError(RECNCTEXTPATHS_UNUSABLE_RSGPORT_EXTPORT);
                }
                SJcException exp = errInfo.createException();
                throw exp;
            }
            if (this.isUsablePhysicalPathAtExtVol(sJmoExdPhysicalPathInfo, this.exdVolMgr, pathGrpList, this.rsgUtil)) continue;
            SJctrError errInfo = new SJctrError(6, 22, RESULT_NORMAL);
            if (byiSCSITargetDataModel.isSelectByPorts()) {
                errInfo.setError(RECNCTEXTPATHS_UNUSABLE_RSGPG_PATH2);
            } else {
                errInfo.setError(RECNCTEXTPATHS_UNUSABLE_RSGPG_EXTPORT);
            }
            SJcException exp = errInfo.createException();
            throw exp;
        }
        return targetPhysicalPathInfoList;
    }

    @Override
    protected void createConfirmData(List<SJmoExdPhysicalPathInfo> targetPhysicalPathInfoList) {
        SJctrMainteExtiSCSIPathsConfirmData confirmData = new SJctrMainteExtiSCSIPathsConfirmData();
        confirmData.setExdPhysicalPathInfo(targetPhysicalPathInfoList);
        confirmData.setExdSubsystemInfoMgr(this.exdSubsystemMgrList);
        confirmData.setExdProfileInfoMgr(this.exdProfileMgrList);
        confirmData.setExdTargetPortInfoMgr(this.exdTargetPortMgrList);
        ArrayList<SJmoPortDetail> confirmPortDtlList = new ArrayList<SJmoPortDetail>(targetPhysicalPathInfoList.size());
        ArrayList<SJmoPortIscsiTargetPathInfo> confirmPtiSCSITargetPathInfoList = new ArrayList<SJmoPortIscsiTargetPathInfo>(targetPhysicalPathInfoList.size());
        HashSet<Short> portSet = new HashSet<Short>(targetPhysicalPathInfoList.size());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        for (SJmoExdPhysicalPathInfo targetPhysicalPathInfo : targetPhysicalPathInfoList) {
            int searchPtiSCSIPathlIndex;
            short portId = (short)targetPhysicalPathInfo.getRmiExdPhysicalPathInfo().referInitiatorPortId();
            if (!portSet.add(portId)) continue;
            portIndex.setSPort(portId);
            int searchPtDtlIndex = Collections.binarySearch(this.portDetailList, portIndex);
            if (searchPtDtlIndex >= 0) {
                confirmPortDtlList.add((SJmoPortDetail)this.portDetailList.get(searchPtDtlIndex));
            }
            if ((searchPtiSCSIPathlIndex = Collections.binarySearch(this.ptiSCSITargetPathInfoList, portIndex)) < 0) continue;
            confirmPtiSCSITargetPathInfoList.add(this.ptiSCSITargetPathInfoList.get(searchPtiSCSIPathlIndex));
        }
        Collections.sort(confirmPortDtlList);
        Collections.sort(confirmPtiSCSITargetPathInfoList);
        confirmData.setPortDetail(confirmPortDtlList);
        confirmData.setPortiSCSITargetPathInfo(confirmPtiSCSITargetPathInfoList);
        ArrayList<SJctrMainteExtiSCSIPathsConfirmData> confirmDataList = new ArrayList<SJctrMainteExtiSCSIPathsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrMainteExtPathsConfirmData.class, confirmDataList);
    }

    protected List<SJmoExdPhysicalPathInfo> getPhysicalPathInfoByExtStrgPort(List<SJmoExdPhysicalPathInfo> physicalPathinfoList) {
        ArrayList<SJmoExdPhysicalPathInfo> retList = new ArrayList<SJmoExdPhysicalPathInfo>();
        HashSet<Integer> targetPathIndexSet = new HashSet<Integer>();
        SJmoExdTargetPortInfoMgr exdTargetPortMgr = (SJmoExdTargetPortInfoMgr)this.exdTargetPortMgrList.get(0);
        for (SJmoExdPhysicalPathInfo physicalPathInfo : physicalPathinfoList) {
            SJmoIscsiTargetPathInfo iTPathInfo = SJctrExtUtility.getiSCSITargetPathInfo(physicalPathInfo, this.ptiSCSITargetPathInfoList, exdTargetPortMgr);
            if (iTPathInfo == null || !targetPathIndexSet.add(iTPathInfo.getITargetPathIndex())) continue;
            for (SJmoPortIscsiTargetPathInfo ptiSCSITargetPathInfo : this.ptiSCSITargetPathInfoList) {
                for (SJmoIscsiTargetPathInfo chkITPathInfo : ptiSCSITargetPathInfo.getAlPortIscsiTargetPath()) {
                    if (this.ipaddtrssComp.compare(iTPathInfo, chkITPathInfo) != 0) continue;
                    targetPathIndexSet.add(chkITPathInfo.getITargetPathIndex());
                }
            }
        }
        SJmoExdPhysicalPathInfoMgr physicalPathMgr = (SJmoExdPhysicalPathInfoMgr)this.exdPhysicalPathMgrList.get(0);
        for (Object obj : physicalPathMgr.getAlExdPhysicalPathInfo()) {
            SJmoExdPhysicalPathInfo physicalPathInfo = (SJmoExdPhysicalPathInfo)obj;
            int iTPathIndex = SJctrExtUtility.getIscsiTargetPathIndex(physicalPathInfo, exdTargetPortMgr);
            if (iTPathIndex < 0 || !targetPathIndexSet.contains(iTPathIndex)) continue;
            retList.add(physicalPathInfo);
        }
        return retList;
    }
}

