/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.recnctextvols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDPGOperation;
import sanproject.serverux.dataimpl.EXDsetReconnectVolume_IN;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.uvm.discnctextvols.SJctrMainteExtVolsConfirmData;
import sanproject.sn2.controller.wizard.uvm.recnctextvols.SJctrMainteExtVolsAC;
import sanproject.sn2.controller.wizard.uvm.recnctextvols.SJctrRecnctExtSubSystemConfirmDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdProfileInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdSubsystemInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdVolumeInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrRecnctExtSubSystemSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "RECNCT_SUBSYSTEM";
    private static final Class<?> CONFIRM_DC = SJctrRecnctExtSubSystemConfirmDC.class;
    public static String RECNCT_EXT_SUBSYSTEM_DATA = "RECNCT_EXT_SUBSYSTEM_DATA";
    public static final String KEY_TABLE = "COM_TABLE";
    public static int RECNCTEXTSUBSYSTEM_NOT_FOUND_PARAM = 107001;
    public static int RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL = 107018;
    public static int RECNCTEXTSUBSYSTEM_NOT_EQUIP_EXTVOL = 106529;
    public static int RECNCTEXTSUBSYSTEM_NOT_EQUIP_VPG = 106530;
    public static int RECNCTEXTSUBSYSTEM_NOT_EQUIP_LDEV = 106532;
    public static int RECNCTEXTSUBSYSTEM_UNUSABLE_RSGPG = 105269;
    public static int RECNCTEXTSUBSYSTEM_UNUSABLE_RSGLDEV = 105270;
    public static int RECNCTEXTSUBSYSTEM_UNMATCE_CONFIG = 106086;

    @Override
    public SJctrError checkInitParam(Object param) {
        return null;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        SJctrUserController uc = wizard.getOwner();
        List<?> targetList = wizard.getCache(RECNCT_EXT_SUBSYSTEM_DATA);
        if (targetList == null) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_PARAM);
            SJcException exp = err.createException();
            throw exp;
        }
        for (Object targetObj : targetList) {
            if (targetObj instanceof SJmoExdSubsystemInfo) continue;
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_PARAM);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> targetSubsystemList = targetList;
        Collections.sort(targetSubsystemList);
        List<SJmoExdSubsystemInfoMgr> extSubsystemInfoMgrList = wizard.getCache(SJmoGetExdSubsystemInfoMgr.class);
        if (extSubsystemInfoMgrList == null || extSubsystemInfoMgrList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoExdSubsystemInfoMgr extSubsystemInfoMgr = (SJmoExdSubsystemInfoMgr)extSubsystemInfoMgrList.get(0);
        if (extSubsystemInfoMgr.getAlExdSubsystemInfo().size() == 0) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoExdProfileInfoMgr> extProfileInfoMgrList = wizard.getCache(SJmoGetExdProfileInfoMgr.class);
        if (extProfileInfoMgrList == null || extProfileInfoMgrList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoExdProfileInfoMgr extProfileInfoMgr = (SJmoExdProfileInfoMgr)extProfileInfoMgrList.get(0);
        if (extProfileInfoMgr.getAlExdProfileInfo().size() == 0) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> extPathGrpMgrList = wizard.getCache(SJmoGetExdPathGroupInfoMgr.class);
        if (extSubsystemInfoMgrList == null || extSubsystemInfoMgrList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoExdPathGroupInfoMgr extPathGrpMgr = (SJmoExdPathGroupInfoMgr)extPathGrpMgrList.get(0);
        List<?> extVolInfoMgrList = wizard.getCache(SJmoGetExdVolumeInfoMgr.class);
        if (extVolInfoMgrList == null || extVolInfoMgrList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoExdVolumeInfoMgr extVolInfoMgr = (SJmoExdVolumeInfoMgr)extVolInfoMgrList.get(0);
        List<SJmoExDVirtualPgInfo> exdVpgInfoList = wizard.getCache(SJmoGetExDVirtualPgInfo.class);
        if (exdVpgInfoList == null) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoExDVirtualPgInfo exdVpgInfo = (SJmoExDVirtualPgInfo)exdVpgInfoList.get(0);
        ArrayList exdPgInfoList = exdVpgInfo.getAlVpgForExd();
        Collections.sort(exdPgInfoList);
        if (extVolInfoMgr.getAlExdVolumeInfoOnPathGroup().size() == 0) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> rsgInfoList = wizard.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgInfoList == null || rsgInfoList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)rsgInfoList.get(0);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, rsgInfo);
        List<SJmoLdevDetail> ldevDtlList = wizard.getCache(SJmoGetLdevDetail.class);
        if (ldevDtlList == null) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrExtUtility exdUtil = uc.getComUtility().getExtUtility();
        ArrayList<SJmoExdVolumeInfo> targetVolumeList = new ArrayList<SJmoExdVolumeInfo>(SJctrExtUtility.SUBSYSTEM_MAPVOL_MAX * targetSubsystemList.size());
        SJctrDataController parentDC = wizard.getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(targetSubsystemList.size());
        for (SJmoExdSubsystemInfo subsystem : targetSubsystemList) {
            boolean chkResult = true;
            int subsystemId = subsystem.getRmiExdSubsystemInfo().getId();
            SJmoExdSubsystemInfo subsystemInfo = extSubsystemInfoMgr.getExdSubsystemInfo(subsystemId);
            if (subsystemInfo == null) {
                SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_UNMATCE_CONFIG);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList pathGrpInfoList = extPathGrpMgr.getAlPathGroupInfoOfSubsystemId(subsystemId);
            for (SJmoExdPathGroupInfo pathGrp : pathGrpInfoList) {
                int pathGroupId = pathGrp.getRmiExdPathGroupInfo().getPathGroupID();
                SJmoExdVolumeInfoOnPathGroup onPathGroupInfo = extVolInfoMgr.getExdVolumeInfoOnPathGroup(pathGroupId);
                ArrayList volumeInfoList = onPathGroupInfo.getAlExdVolumeInfo();
                for (SJmoExdVolumeInfo exdVolume : volumeInfoList) {
                    EXDExternalVolume volume = exdVolume.getRmiExdVolumeInfo();
                    SJmoExDPgInfo exdPgInfo = new SJmoExDPgInfo();
                    exdPgInfo.setFB4(volume.getIFB4());
                    exdPgInfo.setPG(volume.getIPG());
                    exdPgInfo.setIPathGroupId(volume.referPathGroupID());
                    SJmoExdVolumeInfo exdVolumeInfo = extVolInfoMgr.getExdVolumeInfoOfVpgId(exdPgInfo);
                    if (exdVolumeInfo == null) {
                        SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_EQUIP_EXTVOL);
                        SJctrErrorColumnData errData = new SJctrErrorColumnData(subsystem, err);
                        errList.add(errData);
                        chkResult = false;
                        break;
                    }
                    ArrayList<SJmoExDPgInfo> pgIndexList = new ArrayList<SJmoExDPgInfo>();
                    pgIndexList.add(exdPgInfo);
                    List<SJmoPgIndex> unUsablePGList = rsgUtil.extractImpossiblePg(pgIndexList);
                    if (unUsablePGList.size() != 0) {
                        SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_UNUSABLE_RSGPG);
                        SJctrErrorColumnData errData = new SJctrErrorColumnData(subsystem, err);
                        errList.add(errData);
                        chkResult = false;
                        break;
                    }
                    List<SJmoLdevDetail> pgLdevList = exdUtil.getLdevDetailinPG(exdPgInfo, ldevDtlList);
                    List<SJmoLdevIndex> unUsableLdevList = rsgUtil.extractImpossibleLdev(pgLdevList);
                    if (unUsableLdevList.size() == 0) continue;
                    SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_UNUSABLE_RSGLDEV);
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(subsystem, err);
                    errList.add(errData);
                    chkResult = false;
                    break;
                }
                if (!chkResult) break;
                targetVolumeList.addAll(volumeInfoList);
            }
            if (chkResult) continue;
        }
        if (errList.size() != 0) {
            SJctrRelatedDispDataObject rel = wizard.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)wizard.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList, 5);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        if (exdVpgInfoList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> ldevNameInfoList = wizard.getCache(SJmoGetLdevNicknameInfo.class);
        if (ldevNameInfoList == null) {
            SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoLdevNicknameInfo> topLdevNameList = new ArrayList<SJmoLdevNicknameInfo>(targetVolumeList.size());
        for (SJmoExdVolumeInfo exdVolume : targetVolumeList) {
            EXDExternalVolume volume = exdVolume.getRmiExdVolumeInfo();
            SJmoPgIndex pgIndex = new SJmoPgIndex();
            pgIndex.setFB4(volume.getIFB4());
            pgIndex.setPG(volume.getIPG());
            int getIndex = Collections.binarySearch(exdPgInfoList, pgIndex);
            if (getIndex < 0) {
                SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_EQUIP_VPG);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoExDPgInfo exdPGInfo = (SJmoExDPgInfo)exdPgInfoList.get(getIndex);
            if (exdPGInfo.getSNumOfLdev() <= 0) continue;
            SJmoLdevIndex startLdevIndex = exdPGInfo.getStartLdevId();
            int nameIndex = Collections.binarySearch(ldevNameInfoList, startLdevIndex);
            if (nameIndex < 0) {
                SJctrError err = new SJctrError(6, 22, RECNCTEXTSUBSYSTEM_NOT_EQUIP_LDEV);
                SJcException exp = err.createException();
                throw exp;
            }
            topLdevNameList.add((SJmoLdevNicknameInfo)ldevNameInfoList.get(nameIndex));
        }
        Collections.sort(topLdevNameList);
        SJctrMainteExtVolsConfirmData extVolsConfirmData = new SJctrMainteExtVolsConfirmData();
        extVolsConfirmData.setExdVolumeInfo(targetVolumeList);
        extVolsConfirmData.setExdSubsystemInfoMgr(extSubsystemInfoMgrList);
        extVolsConfirmData.setExdProfileInfoMgr(extProfileInfoMgrList);
        extVolsConfirmData.setExDVirtualPgInfo(exdVpgInfoList);
        extVolsConfirmData.setLdevNameInfo(topLdevNameList);
        ArrayList<SJctrMainteExtVolsConfirmData> confirmDataList = new ArrayList<SJctrMainteExtVolsConfirmData>();
        confirmDataList.add(extVolsConfirmData);
        wizard.putCache(SJctrMainteExtVolsConfirmData.class, confirmDataList);
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrMainteExtVolsAC ac = new SJctrMainteExtVolsAC();
        ArrayList<EXDsetReconnectVolume_IN> setPgOperationList = new ArrayList<EXDsetReconnectVolume_IN>(1);
        EXDsetReconnectVolume_IN setPgOperation = new EXDsetReconnectVolume_IN();
        setPgOperation.setOption(0);
        for (SJmoExdVolumeInfo exdVolume : targetVolumeList) {
            EXDPGOperation pg = new EXDPGOperation();
            pg.setIFB4(exdVolume.getRmiExdVolumeInfo().getIFB4());
            pg.setIPG(exdVolume.getRmiExdVolumeInfo().getIPG());
            setPgOperation.setPG(pg);
        }
        setPgOperationList.add(setPgOperation);
        ac.setApplyList(setPgOperationList, targetVolumeList.size());
        wizard.addConfirmData(ac, related);
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public short[] getRequireRoll() {
        return null;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetExdSubsystemInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdProfileInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPathGroupInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdVolumeInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExDVirtualPgInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

