/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.volumemigration.deletemigrationplans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.common.Robj_interface_HIHsmManualPlanProgress2_OUT;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrVolumeMigrationUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVMBasicData;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVolumeMigrationConfirmData;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVolumeMigrationMacro;
import sanproject.sn2.controller.wizard.volumemigration.deletemigrationplans.SJctrDeleteMigrationPlansAC;
import sanproject.sn2.controller.wizard.volumemigration.migrationplans.SJctrMigrationPlanInfo;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrDeleteMigrationPlansSubWizard
extends SJctrSubWizard {
    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        this.checkStartData(wizard);
        this.checkConstructData(wizard);
        List<?> confirmDataList = wizard.getCache("KEY_MIGPLAN_CONFIRMDATA");
        SJctrVolumeMigrationConfirmData confirmData = (SJctrVolumeMigrationConfirmData)confirmDataList.get(0);
        for (SJmoGetKind_IF getKind : SJctrVolumeMigrationMacro.getDelMigPlansModelKindList) {
            SJmoGetDirect sJmoGetDirect = new SJmoGetDirect(getKind, null, null);
            SJctrGetDirectWrapper getMdlDirectWrp = new SJctrGetDirectWrapper(sJmoGetDirect);
            confirmData.setConfirmData(getMdlDirectWrp.getCacheKey(), wizard.getCache(getMdlDirectWrp.getCacheKey()));
        }
        List<? extends SJctrVMBasicData> planDataList = confirmData.getVMBasicData();
        ArrayList<SJctrMigrationPlanInfo> cancelPlanList = new ArrayList<SJctrMigrationPlanInfo>();
        ArrayList<SJctrMigrationPlanInfo> deletePlanList = new ArrayList<SJctrMigrationPlanInfo>();
        block5: for (SJctrMigrationPlanInfo sJctrMigrationPlanInfo : planDataList) {
            int iStatus = sJctrMigrationPlanInfo.getIStatus();
            switch (iStatus) {
                case 3: {
                    cancelPlanList.add(sJctrMigrationPlanInfo);
                    continue block5;
                }
                case 1: 
                case 2: 
                case 4: {
                    deletePlanList.add(sJctrMigrationPlanInfo);
                    continue block5;
                }
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructConfirmData", "iStatus = " + String.valueOf(iStatus) + "  LogicError");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJctrDeleteMigrationPlansAC delMigAC = new SJctrDeleteMigrationPlansAC();
        delMigAC.setApplyList(cancelPlanList, deletePlanList);
        SJctrUserController sJctrUserController = wizard.getOwner();
        SJctrRelatedDispDataObject confirmRelated = sJctrUserController.getRelatedDispData(SJctrVolumeMigrationMacro.CLASS_DELMIGPLAN_CONFIRMDC);
        wizard.addConfirmData(delMigAC, confirmRelated);
    }

    @Override
    public Class<?>[] getClassList() {
        return new Class[0];
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", "DELETE_MIGRATION_PLANS");
    }

    @Override
    public Class<?> getConfirmClass() {
        return SJctrVolumeMigrationMacro.CLASS_DELMIGPLAN_CONFIRMDC;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> mdlDirectSet = new HashSet<SJctrGetDirectWrapper>();
        for (SJmoGetKind_IF getKind : SJctrVolumeMigrationMacro.getDelMigPlansModelKindList) {
            SJmoGetDirect getMdlDirect = new SJmoGetDirect(getKind, null, null);
            SJctrGetDirectWrapper getMdlDirectWrp = new SJctrGetDirectWrapper(getMdlDirect);
            mdlDirectSet.add(getMdlDirectWrp);
        }
        SJctrGetDirectWrapper getRmiInWrapper = SJctrVolumeMigrationUtility.createMigPlanGetInputHUVM();
        mdlDirectSet.add(getRmiInWrapper);
        return mdlDirectSet;
    }

    private void checkStartData(SJctrWizardWindowDC wizDC) {
        List<?> transDataList = wizDC.getCache("KEY_MIGPLAN_CONFIRMDATA");
        if (transDataList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "MigrationPlan List null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (transDataList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "MigrationPlan List size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJctrVolumeMigrationConfirmData confirmData = (SJctrVolumeMigrationConfirmData)transDataList.get(0);
        if (confirmData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "Confirm Data null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
    }

    private void checkConstructData(SJctrWizardWindowDC wizDC) {
        SJctrResourceGroupUtility rsgUtil;
        List<SJmoLdevIndex> availableLdevList;
        SJctrSystemParamContainer sysInfo = wizDC.getOwner().getAuthorizeContainer().getSystemParamContainer();
        List<?> delMigPlanDataList = wizDC.getCache("KEY_MIGPLAN_CONFIRMDATA");
        SJctrVolumeMigrationConfirmData delMigConfirmData = (SJctrVolumeMigrationConfirmData)delMigPlanDataList.get(0);
        List<? extends SJctrVMBasicData> planDataList = delMigConfirmData.getVMBasicData();
        List<?> rsgInfoList = wizDC.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_RSG_GETALLRSG);
        if (rsgInfoList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "RsgInfo List null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (rsgInfoList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "RsgInfo List size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJmoRSGgetAllRsgs rsgData = (SJmoRSGgetAllRsgs)rsgInfoList.get(0);
        if (rsgData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "RsgInfo Data null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        List<?> migPlansList = wizDC.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_GET_RMI_MIGPLAN_DATA_HUVM);
        if (migPlansList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "MigrationPlan List null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (migPlansList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "MigrationPlan List size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJmoThroughRmiData rmiData = (SJmoThroughRmiData)migPlansList.get(0);
        Robj_interface_HIHsmManualPlanProgress2_OUT rmiPlanData = (Robj_interface_HIHsmManualPlanProgress2_OUT)rmiData.getObjRmi();
        if (rmiPlanData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "MigrationPlan RMI Data null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (!SJctrVolumeMigrationUtility.chkMigrationSetNum(planDataList.size())) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Set Num Over");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206090);
        }
        List<SJctrMigrationPlanInfo> planList = SJctrVolumeMigrationUtility.makePlanDataList(rmiPlanData);
        List<SJctrErrorColumnData> errList = this.makeErrMigPlanList(planDataList, planList, sysInfo, availableLdevList = SJctrVolumeMigrationUtility.getAvailableRsgLdevList(rsgUtil = SJctrVolumeMigrationUtility.makeRsgUtil(wizDC, rsgData)), wizDC);
        if (errList.size() > 0) {
            SJctrRelatedDispDataObject relDisp = wizDC.createDialog(SJctrErrorDataController.class, null);
            SJctrUserController userCtr = wizDC.getOwner();
            SJctrDataController beginDC = wizDC.getParentDC();
            SJctrTableDataModel tableModel = (SJctrTableDataModel)beginDC.getDataObjectModel("COM_TABLE");
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "NG Data Exist.");
            throw SJctrVolumeMigrationUtility.makeErrInfTable(relDisp, userCtr, tableModel, errList);
        }
    }

    private List<SJctrErrorColumnData> makeErrMigPlanList(List<SJctrMigrationPlanInfo> planDataList, List<SJctrMigrationPlanInfo> chkPlanDataList, SJctrSystemParamContainer sysInfo, List<SJmoLdevIndex> availableLdevList, SJctrWizardWindowDC wizDC) {
        ArrayList<SJctrErrorColumnData> errColList = new ArrayList<SJctrErrorColumnData>();
        ArrayList<SJctrMigrationPlanInfo> okPlanList = new ArrayList<SJctrMigrationPlanInfo>();
        for (SJctrMigrationPlanInfo vmPlanData : planDataList) {
            SJctrErrorColumnData errColData;
            int iPoint = Collections.binarySearch(chkPlanDataList, vmPlanData);
            if (iPoint < 0) {
                SJctrErrorColumnData errColData2 = SJctrVolumeMigrationUtility.makeVMCtrlErrColumnData(206093, vmPlanData);
                errColList.add(errColData2);
                continue;
            }
            SJctrMigrationPlanInfo chkPlanData = chkPlanDataList.get(iPoint);
            if (!sysInfo.isLocalHost() && chkPlanData.getIOwner() != 0) {
                errColData = SJctrVolumeMigrationUtility.makeVMCtrlErrColumnData(206089, vmPlanData);
                errColList.add(errColData);
                continue;
            }
            if (!SJctrVolumeMigrationUtility.chkLdevRsgGrp(chkPlanData.getSourceLdevIndex(), availableLdevList)) {
                errColData = SJctrVolumeMigrationUtility.makeVMCtrlErrColumnData(206091, vmPlanData);
                errColList.add(errColData);
                continue;
            }
            if (!SJctrVolumeMigrationUtility.chkLdevRsgGrp(chkPlanData.getTargetLdevIndex(), availableLdevList)) {
                errColData = SJctrVolumeMigrationUtility.makeVMCtrlErrColumnData(206092, vmPlanData);
                errColList.add(errColData);
                continue;
            }
            okPlanList.add(chkPlanData);
        }
        List<?> confirmDataList = wizDC.getCache("KEY_MIGPLAN_CONFIRMDATA");
        SJctrVolumeMigrationConfirmData confirmData = (SJctrVolumeMigrationConfirmData)confirmDataList.get(0);
        confirmData.setVMBasicData(okPlanList);
        return errColList;
    }
}

