/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.deleteclpr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.column.vpm.SJctrClprColumDiffInterface;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.vpm.deleteclpr.SJctrDeleteClprAC;
import sanproject.sn2.controller.wizard.vpm.deleteclpr.SJctrDeleteClprConfirmDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.data.system.SJmoClprInfo;

public class SJctrDeleteClprSubWizard
extends SJctrSubWizard
implements SJctrClprColumDiffInterface {
    public static final String TITLE = "DELETE_CLPRS";
    private static final Class<?> CONFIRM_DC = SJctrDeleteClprConfirmDC.class;
    public static final String KEY_GET_SELECTED_CLPRINFO = "KEY_GET_SELECTED_CLPRINFO";
    public static final String KEY_GET_DEFAULT_CLPRINFO = "KEY_GET_DEFAULT_CLPRINFO";
    public static final String KEY_GET_BASE_CLPRINFO = "KEY_GET_BASE_CLPRINFO";

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetClprInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        ArrayList<SJmoClprInfo> delClprList;
        SJctrUserController uc = wizard.getOwner();
        if (uc == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructConfirmData", "Contradiction extraction");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        if ((delClprList = new ArrayList<SJmoClprInfo>(wizard.getCache("KEY_SELECT_CLPR_INDEX"))) == null || delClprList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructConfirmData", "Invalid value for delClprList");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        List<?> clprInfoList = wizard.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO);
        List<?> pgDtlList = wizard.getCache(SJctrVpmUtility.KEY_CLASS_PG_DETAIL);
        List<?> ldevDtlList = wizard.getCache(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL);
        if (clprInfoList == null || clprInfoList.size() == 0 || pgDtlList == null || ldevDtlList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructConfirmData", "Argument abnormality");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        Collections.sort(delClprList);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
        for (SJmoClprInfo delClprInfo : delClprList) {
            int iSearch = Collections.binarySearch(clprInfoList, delClprInfo);
            if (iSearch >= 0) continue;
            SJctrVpmUtility.makeErrorList(errList, delClprInfo, 107001);
        }
        if (!errList.isEmpty()) {
            this.makeErrorTable(wizard.createDialog(SJctrErrorDataController.class, null), uc, errList, wizard);
        }
        if (((SJmoClprInfo)delClprList.get(0)).getSClpr() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructConfirmData", "contamination for CLPR:00");
            SJctrVpmUtility.makeErrorList(errList, (Comparable)delClprList.get(0), 106003);
        }
        if (!errList.isEmpty()) {
            this.makeErrorTable(wizard.createDialog(SJctrErrorDataController.class, null), uc, errList, wizard);
        }
        for (SJmoClprInfo delClprInfo : delClprList) {
            if (delClprInfo.getDiskAddressList().size() == 0) continue;
            SJctrVpmUtility.makeErrorList(errList, delClprInfo, 106004);
        }
        if (!errList.isEmpty()) {
            this.makeErrorTable(wizard.createDialog(SJctrErrorDataController.class, null), uc, errList, wizard);
        }
        SJmoClprInfo beforDefClprInfo = (SJmoClprInfo)clprInfoList.get(0);
        SJmoClprInfo afterDefClprInfo = null;
        try {
            afterDefClprInfo = (SJmoClprInfo)beforDefClprInfo.clone();
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructConfirmData", "CloneNotSupportedException for CLPR:00");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        for (SJmoClprInfo delClprInfo : delClprList) {
            afterDefClprInfo.setICacheCapacity(afterDefClprInfo.getICacheCapacity() + delClprInfo.getICacheCapacity());
            afterDefClprInfo.setIDCRCapacity(afterDefClprInfo.getIDCRCapacity() + delClprInfo.getIDCRCapacity());
            afterDefClprInfo.setIDCRExtentLimit(afterDefClprInfo.getIDCRExtentLimit() + delClprInfo.getIDCRExtentLimit());
            afterDefClprInfo.getDiskAddressList().addAll(delClprInfo.getDiskAddressList());
        }
        Collections.sort(afterDefClprInfo.getDiskAddressList());
        ArrayList<SJmoClprInfo> putDiffList = new ArrayList<SJmoClprInfo>();
        putDiffList.add(afterDefClprInfo);
        wizard.putCache(KEY_CLASS_DIFF_CLPR_INFO_LIST, putDiffList);
        ArrayList<SJmoClprInfo> putDefList = new ArrayList<SJmoClprInfo>();
        putDefList.add(beforDefClprInfo);
        wizard.putCache(KEY_GET_DEFAULT_CLPRINFO, putDefList);
        wizard.putCache(KEY_GET_SELECTED_CLPRINFO, delClprList);
        SJctrDeleteClprAC ac = new SJctrDeleteClprAC();
        ac.setApplyList(delClprList);
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        wizard.addConfirmData(ac, related);
    }

    public void makeErrorTable(SJctrRelatedDispDataObject relDisp, SJctrUserController uc, List<SJctrErrorColumnData> errList, SJctrWizardWindowDC wizard) {
        SJctrErrorDataController errDc = (SJctrErrorDataController)uc.getDataController(relDisp);
        errDc.setParameter(wizard.getParentDC().getDataObjectModel("COM_TABLE"), errList);
        SJctrError representErrorInfo = errDc.getRepresentativeError(errList);
        SJcException exp = representErrorInfo.createException();
        exp.setErrDisp(relDisp);
        throw exp;
    }
}

