/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec;

import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.httpcli.com.SJhtclDef;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.com.SJhtclRelocationLogUty;
import sanproject.sn2.httpcli.exec.SJhtclExecBase;
import sanproject.sn2.httpcli.exec.com.SJhtclRelocationLogRMIUtility;

public class SJhtclRelocationLogDelete
extends SJhtclExecBase {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclRelocationLogDelete.class.getSimpleName();

    public SJhtclRelocationLogDelete(SJbaseUserSessionInterface session, Map requestMap) {
        super(session, requestMap);
    }

    @Override
    protected boolean checkParameters() {
        boolean bResult = false;
        String strLogName = SJhtclParameterUty.getStrFromMap(this.requestMap, "logname");
        if (strLogName != null && strLogName.length() > 0) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected boolean checkRole() {
        boolean bResult = false;
        SJcRoleResourceContainer resourceContainer = this.session.getRoleResourceInfo();
        if (resourceContainer.checkAuthority(32)) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected boolean checkPP() {
        boolean bResult = false;
        if (this.isEnablePP(SJctrLicenseContainer.PPID_SN)) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected HashMap<String, Object> executeCommand() {
        String LOG_SUBTITLE = "executeCommand";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Start.");
        HashMap<String, Object> responseMap = new HashMap();
        try {
            HashMap<String, Date> logInfMap = null;
            try {
                List<String> strFileList = SJhtclRelocationLogUty.getRelocationLogFileList();
                logInfMap = SJhtclRelocationLogUty.makeRelocationLogInfo(strFileList);
                if (logInfMap.size() == 0) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Relocation log is nothing");
                    responseMap = SJhtclHttpCliUty.getErrorMapCmd("107020");
                    return responseMap;
                }
            }
            catch (FileNotFoundException ex) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "DirectoryNotFound. directoryPath:" + ex.getMessage());
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107020");
                return responseMap;
            }
            String strLogName = SJhtclParameterUty.getStrFromMap(this.requestMap, "logname");
            if (32 < strLogName.trim().length()) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "LOGNAME_MAX_SIZE_ERROR");
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107021");
                return responseMap;
            }
            for (String strCheck : SJhtclDef.ReportCheckList) {
                if (strLogName.indexOf(strCheck) < 0) continue;
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "LOGNAME_INPUT_CHECK_ERROR");
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107022");
                return responseMap;
            }
            HashMap<String, Date> delTargetMap = new HashMap<String, Date>();
            if ("LatestLog".equals(strLogName)) {
                List<Map.Entry<String, Date>> entries = SJhtclRelocationLogUty.sortRelocationLogAtCreateTimeDesc(logInfMap);
                strLogName = entries.get(0).getKey();
                delTargetMap.put(strLogName, logInfMap.get(strLogName));
            } else {
                if (!logInfMap.containsKey(strLogName)) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Not found relocation log.");
                    responseMap = SJhtclHttpCliUty.getErrorMapCmd("107019");
                    return responseMap;
                }
                delTargetMap.put(strLogName, logInfMap.get(strLogName));
            }
            SJhtclRelocationLogRMIUtility.removeRelocationLog(strLogName);
            String strResult = SJhtclRelocationLogUty.createResponseContents(delTargetMap, this.session);
            responseMap.put("ResponseKeyType", "TXT");
            responseMap.put("Text", strResult);
        }
        catch (SJcException ex) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Catch SJceException ex:" + ex);
            responseMap = SJhtclHttpCliUty.getErrorMap(ex.getMsg());
            return responseMap;
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "End.");
        return responseMap;
    }
}

