/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.ProtocolVersion;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterDiscoverVersions
extends Converter {
    private static final String module = "ConverterDiscoverVersions";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ki.getInputInfo().getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(1);
        }
        tReq.addValue(this.getRequestHeader(rhc, 1));
        TTLVStructure tBI = new TTLVStructure(15);
        tReq.addValue(tBI);
        tBI.addValue(new TTLVEnumeration(92, 30));
        TTLVStructure tRP = new TTLVStructure(121);
        tBI.addValue(tRP);
        ArrayList<ProtocolVersion> al = ki.getInputInfo().getProtocolVersionList();
        for (int i = 0; i < al.size(); ++i) {
            ProtocolVersion k = al.get(i);
            tBI.addValue(new TTLVInteger(106, k.getMajor()));
            tBI.addValue(new TTLVInteger(107, k.getMinor()));
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        OutputInfo oi = new OutputInfo();
        this.checkValue(resvTTLV, (byte)15, (byte)1, 1);
        TTLVStructure tRP = this.checkBatchItem((TTLVStructure)resvTTLV.getValueList((byte)15).get(0), oi);
        ArrayList<ProtocolVersion> result = new ArrayList<ProtocolVersion>();
        if (tRP != null && tRP.getValueSize((byte)105) > 0) {
            ArrayList<TTLV> al = tRP.getValueList((byte)105);
            for (int i = 0; i < al.size(); ++i) {
                if (al.get(i).getType() != 1) {
                    STD_LOGGER.info(module, method, " - check Type of Protocol Version", " - invalid");
                    throw new ResponseException();
                }
                TTLVStructure tPV = (TTLVStructure)al.get(i);
                this.checkValue(tPV, (byte)106, (byte)2, 1);
                TTLVInteger tiMajor = (TTLVInteger)tPV.getValueList((byte)106).get(0);
                this.checkValue(tPV, (byte)107, (byte)2, 1);
                TTLVInteger tiMinor = (TTLVInteger)tPV.getValueList((byte)107).get(0);
                result.add(new ProtocolVersion(tiMajor.getValue(), tiMinor.getValue()));
            }
            oi.setProtocolVersionList(result);
        }
        oiList.add(oi);
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

