/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.ttlv;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class TTLVDateTime
extends TTLV {
    private static final String module = "TTLVDateTime";
    protected byte[] value;

    public TTLVDateTime(byte tag) {
        super(tag);
    }

    public TTLVDateTime(byte[] data, int pos) {
        super(data, pos);
        System.arraycopy(data, pos + 8, this.value, 0, this.value.length);
    }

    public TTLVDateTime(byte tag, String date) {
        super(tag);
        try {
            this.setValue(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TTLVDateTime(byte tag, long date) {
        super(tag);
        try {
            this.setValue(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void init() {
        String method = "init";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.length = 8;
        this.value = new byte[8];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = 0;
        }
    }

    @Override
    public byte getType() {
        String method = "getType";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return 9;
    }

    @Override
    public void makeSendData(byte[] data, int pos) {
        String method = "makeSendData";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.makeTTL(data, pos);
        System.arraycopy(this.value, 0, data, pos + 8, this.value.length);
    }

    public void setValue(String newValue) throws RequestCommandException {
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
        try {
            TTLVDateTime.convertByte(sdf.parse(newValue).getTime() / 1000L, this.value);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new RequestCommandException();
        }
    }

    public void setValue(long newValue) throws RequestCommandException {
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        TTLVDateTime.convertByte(newValue, this.value);
    }

    public long getValue() {
        String method = "getValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return TTLVDateTime.convertLongInteger(this.value);
    }
}

